package pl.gov.mpips.zbc.v20090722;

import java.math.BigDecimal;
import java.util.Set;

import com.google.common.collect.ImmutableSet;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W32Validator implements SimpleValidator<SwiadczenieSprawozdawcze> {
	private static final Set<String> POBYT = ImmutableSet.of("214010", "214020", "214x30");
	
	public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
		String kodSwiadczenia = target.getKodSwiadczenia();
		if (kodSwiadczenia == null) return;
		//
		if (POBYT.contains(kodSwiadczenia)) {
			BigDecimal kosztUtrzymania = target.getKosztUtrzymania();
			if (kosztUtrzymania == null) {
				errors.rejectValue("kosztUtrzymania", "W32", "Podanie kosztu utrzymania jest wymagane ze względu na kod świadczenia");
			}
		}
	}
}
