package pl.gov.mpips.zbc.v20200306;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W05aValidator implements SimpleValidator<SytuacjaOsoby> {
	private static final ImmutableSetMultimap<String, String> STANY_CYWILNE = ImmutableSetMultimap.<String, String>builder()
		.putAll("15", ImmutableList.of("03", "11"))
		.putAll("16", ImmutableList.of("04", "12"))
		.build();
	
	@Override
	public void validate(SytuacjaOsoby target, BasicErrors errors) {
		String kodPokrewienstwaZGlowaRodziny = target.getKodPokrewienstwaZGlowaRodziny();
		String kodStanuCywilnego = target.getKodStanuCywilnego();
		if (STANY_CYWILNE.containsKey(kodPokrewienstwaZGlowaRodziny) && !STANY_CYWILNE.get(kodPokrewienstwaZGlowaRodziny).contains(kodStanuCywilnego)) {
			errors.rejectValue("kodStanuCywilnego", "W05a", "Wartość kodu stanu cywilnego jest niezgodna z kodem pokrewieństwa z głową rodziny");
		}
	}
}
