package pl.gov.mpips.zbc.v20200306;

import java.util.List;
import java.util.Objects;

import com.google.common.collect.ImmutableSet;

import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.CzlonekRodziny;
import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze.Problemy;
import pl.gov.mpips.zbc.v20200306.narzedzia.Listy;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.ComplexValidator;

public class W12Validator implements ComplexValidator<Problemy, SwiadczenieSprawozdawcze> {
	private static final ImmutableSet<String> DOPUSZCZALNY_BRAK_OSOB_NIEPELNOSPRAWNYCH_W_SKLADZIE = ImmutableSet.of(
		// formularz kwalifikacyjny do przyznania pomocy na podstawie art. 29 ust. 2 ustawy
		// o pomocy obywatelom Ukrainy w związku z konfliktem zbrojnym na terytorium tego państwa
		"18"
	);
	
	@Override
	public void validate(Problemy target, SwiadczenieSprawozdawcze context, BasicErrors errors) {
		if (dopuszczalnyBrakOsobNiepelnosprawnychWSkladzie(context)) {
			return;
		}
		List<String> kody = Listy.kody(target);
		for (int i = 0; i < kody.size(); i++) {
			if (wskazanoNiepelnosprawnosc(kody.get(i)) && brakOsobNiepelnosprawnychWSkladzie(context)) {
				errors.rejectValue("kod" + (i + 1), "W12", "Wskazano problem niepełnosprawności mimo braku w składzie rodziny osób niepełnosprawnych");
			}
		}
	}
	
	private boolean wskazanoNiepelnosprawnosc(String kod) {
		return Objects.equals(kod, "060");
	}
	
	private boolean brakOsobNiepelnosprawnychWSkladzie(SwiadczenieSprawozdawcze context) {
		List<CzlonekRodziny> czlonkowieRodziny = context.getCzlonkowieRodziny();
		return czlonkowieRodziny != null && czlonkowieRodziny.stream()
			.filter(Objects::nonNull)
			.map(CzlonekRodziny::getSytuacjaOsoby)
			.filter(Objects::nonNull)
			.map(SytuacjaOsoby::getCzyNiepelnosprawny)
			.filter(Objects::nonNull)
			.noneMatch(Boolean.TRUE::equals);
	}
	
	private boolean dopuszczalnyBrakOsobNiepelnosprawnychWSkladzie(SwiadczenieSprawozdawcze context) {
		SytuacjaRodziny sytuacjaRodziny = context.getSytuacjaRodziny();
		if (sytuacjaRodziny == null) return false;
		String kodRodzajuOpisuSytuacji = sytuacjaRodziny.getKodRodzajuOpisuSytuacji();
		if (kodRodzajuOpisuSytuacji == null) return false;
		return DOPUSZCZALNY_BRAK_OSOB_NIEPELNOSPRAWNYCH_W_SKLADZIE.contains(kodRodzajuOpisuSytuacji);
	}
}
