package pl.gov.mpips.zbc.v20200306;

import com.google.common.base.Strings;

import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W28Validator implements SimpleValidator<SwiadczenieSprawozdawcze> {
	private static final String SKIEROWANIE_DO_OSRODKA_WSPARCIA = "212000";
	
	public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
		String kodSwiadczenia = target.getKodSwiadczenia();
		if (kodSwiadczenia == null) return;
		//
		if (kodSwiadczenia.equals(SKIEROWANIE_DO_OSRODKA_WSPARCIA)) {
			String kodRodzajuOsrodkaWsparcia = target.getKodRodzajuOsrodkaWsparcia();
			if (Strings.isNullOrEmpty(kodRodzajuOsrodkaWsparcia)) {
				errors.rejectValue("kodRodzajuOsrodkaWsparcia", "W28", "Określenie rodzaju ośrodka wsparcia jest wymagane ze względu na kod świadczenia");
			}
		}
	}
}
