package pl.topteam.pomost.integracja.zbc.v20090722.adaptery;

import static com.google.common.base.Preconditions.checkArgument;

import java.io.Serializable;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;

import com.google.common.collect.Lists;

import pl.gov.mpips.zbc.v20090722.ObjectFactory;
import pl.gov.mpips.zbc.v20090722.SwiadczenieSprawozdawcze.PrzyslugujeZa;

public final class PrzyslugujeZaAdapter extends XmlAdapter<PrzyslugujeZa, List<YearMonth>> {
	private final ObjectFactory fabryka = new ObjectFactory();
	
	@Override
	public List<YearMonth> unmarshal(PrzyslugujeZa v) throws Exception {
		if (v == null) return null;
		if (v.getRokAndMiesiac() == null) return null;
		if (v.getRokAndMiesiac().isEmpty()) return null;
		//
		List<YearMonth> przyslugujeZa = new ArrayList<>();
		Lists.partition(v.getRokAndMiesiac(), 2).stream()
			.map(this::deserializuj)
			.forEach(przyslugujeZa::add);
		return przyslugujeZa;
	}
	
	@Override
	public PrzyslugujeZa marshal(List<YearMonth> v) throws Exception {
		if (v == null) return null;
		if (v.isEmpty()) return null;
		//
		PrzyslugujeZa przyslugujeZa = new PrzyslugujeZa();
		v.stream()
			.flatMap(this::serializuj)
			.forEach(przyslugujeZa.getRokAndMiesiac()::add);
		return przyslugujeZa;
	}
	
	@SuppressWarnings("unchecked")
	private YearMonth deserializuj(List<JAXBElement<? extends Serializable>> partycja) {
		checkArgument(partycja.size() == 2);
		JAXBElement<Year> rok = (JAXBElement<Year>) partycja.get(0);
		JAXBElement<Month> miesiac = (JAXBElement<Month>) partycja.get(1);
		return YearMonth.of(
			rok.getValue().getValue(),
			miesiac.getValue()
		);
	}
	
	private Stream<JAXBElement<? extends Serializable>> serializuj(YearMonth yearMonth) {
		return Stream.of(
			fabryka.createSwiadczenieSprawozdawczePrzyslugujeZaRok(Year.of(yearMonth.getYear())),
			fabryka.createSwiadczenieSprawozdawczePrzyslugujeZaMiesiac(yearMonth.getMonth())
		);
	}
}
