/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20090722;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.Set;
import pl.gov.mpips.zbc.v20090722.SytuacjaOsoby;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W03Validator
implements SimpleValidator<SytuacjaOsoby.Dochody> {
    private static final Set<String> DOCHOD_ZEROWY = ImmutableSet.of((Object)"22", (Object)"33");
    private static final Set<String> DOCHOD_NIEZEROWY = ImmutableSet.of((Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object)"6", (Object[])new String[]{"7", "8", "9", "10", "11", "12", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "99"});

    @Override
    public void validate(SytuacjaOsoby.Dochody target, BasicErrors errors) {
        this.validate(target.getZrodlo1(), target.getKwotaMiesiecznie1(), 1, errors);
        this.validate(target.getZrodlo2(), target.getKwotaMiesiecznie2(), 2, errors);
        this.validate(target.getZrodlo3(), target.getKwotaMiesiecznie3(), 3, errors);
        this.validate(target.getZrodlo4(), target.getKwotaMiesiecznie4(), 4, errors);
    }

    private void validate(String zrodlo, BigDecimal kwota, int numer, BasicErrors bledy) {
        this.validateA(zrodlo, kwota, numer, bledy);
        this.validateB(zrodlo, kwota, numer, bledy);
        this.validateC(zrodlo, kwota, numer, bledy);
    }

    private void validateA(String zrodlo, BigDecimal kwota, int numer, BasicErrors bledy) {
        boolean wymaganeZrodlo = kwota != null && kwota.signum() != 0;
        boolean brakZrodla = Strings.isNullOrEmpty((String)zrodlo);
        if (wymaganeZrodlo && brakZrodla) {
            bledy.rejectValue("zrodlo" + numer, "W03", "Podanie kodu \u017ar\u00f3d\u0142a dochodu jest wymagane, je\u015bli doch\u00f3d jest niezerowy");
        }
    }

    private void validateB(String zrodlo, BigDecimal kwota, int numer, BasicErrors bledy) {
        boolean brakLubZerowyDochod;
        boolean wymaganyDochodNiezerowy = DOCHOD_NIEZEROWY.contains(zrodlo);
        boolean bl = brakLubZerowyDochod = kwota == null || kwota.signum() == 0;
        if (wymaganyDochodNiezerowy && brakLubZerowyDochod) {
            bledy.rejectValue("zrodlo" + numer, "W03", "Doch\u00f3d musi by\u0107 niezerowy dla wybranego kodu \u017ar\u00f3d\u0142a dochodu");
        }
    }

    private void validateC(String zrodlo, BigDecimal kwota, int numer, BasicErrors bledy) {
        boolean brakLubNiezerowyDochod;
        boolean wymaganyDochodZerowy = DOCHOD_ZEROWY.contains(zrodlo);
        boolean bl = brakLubNiezerowyDochod = kwota == null || kwota.signum() != 0;
        if (wymaganyDochodZerowy && brakLubNiezerowyDochod) {
            bledy.rejectValue("zrodlo" + numer, "W03", "Doch\u00f3d musi by\u0107 zerowy dla wybranego kodu \u017ar\u00f3d\u0142a dochodu");
        }
    }
}

