/*
 * Decompiled with CFR 0.152.
 */
package pl.gov.mpips.zbc.v20200306;

import java.util.List;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import pl.gov.mpips.zbc.v20200306.SwiadczenieSprawozdawcze;
import pl.gov.mpips.zbc.v20200306.SytuacjaRodziny;
import pl.topteam.pomost.integracja.zbc.BasicErrors;
import pl.topteam.pomost.integracja.zbc.SimpleValidator;

public class W09Validator
implements SimpleValidator<SwiadczenieSprawozdawcze> {
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> MEZCZYZNA = this.plec("1");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> KOBIETA = this.plec("2");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> KAWALER = this.stanCywilny("01");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> PANNA = this.stanCywilny("02");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> ZONATY = this.stanCywilny("03");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> ZAMEZNA = this.stanCywilny("04");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> KONKUBENT = this.stanCywilny("09");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> KONKUBINA = this.stanCywilny("10");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> MAZ = this.stopienPokrewienstwa("15");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> ZONA = this.stopienPokrewienstwa("16");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> SYN = this.stopienPokrewienstwa("03");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> CORKA = this.stopienPokrewienstwa("04");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> DZIECKO_OBCE = this.stopienPokrewienstwa("24");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> POKREWIENSTWO_NIEOKRESLONE = this.stopienPokrewienstwa("98");
    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> BRAK_POKREWIENSTWA = this.stopienPokrewienstwa("99");

    @Override
    public void validate(SwiadczenieSprawozdawcze target, BasicErrors errors) {
        SytuacjaRodziny sytuacjaRodziny;
        String kodSkladuRodziny;
        if (this.weryfikowalne(target) && !this.predykat(kodSkladuRodziny = (sytuacjaRodziny = target.getSytuacjaRodziny()).getKodSkladuRodziny()).test(target)) {
            errors.rejectValue("sytuacjaRodziny.kodSkladuRodziny", "W09", "Warto\u015b\u0107 kodu sk\u0142adu rodziny jest niezgodna ze sk\u0142adem rodziny");
        }
    }

    private boolean weryfikowalne(SwiadczenieSprawozdawcze swiadczenieSprawozdawcze) {
        List<SwiadczenieSprawozdawcze.CzlonekRodziny> czlonkowieRodziny = swiadczenieSprawozdawcze.getCzlonkowieRodziny();
        if (czlonkowieRodziny == null) {
            return false;
        }
        SytuacjaRodziny sytuacjaRodziny = swiadczenieSprawozdawcze.getSytuacjaRodziny();
        if (sytuacjaRodziny == null) {
            return false;
        }
        String kodSkladuRodziny = sytuacjaRodziny.getKodSkladuRodziny();
        if (kodSkladuRodziny == null) {
            return false;
        }
        if (sytuacjaRodziny.getWielkosc() == null) {
            return false;
        }
        if (czlonkowieRodziny.size() != sytuacjaRodziny.getWielkosc().intValue()) {
            return false;
        }
        return !czlonkowieRodziny.stream().map(SwiadczenieSprawozdawcze.CzlonekRodziny::getSytuacjaOsoby).anyMatch(Objects::isNull);
    }

    private Predicate<SwiadczenieSprawozdawcze> predykat(String kodSkladuRodziny) {
        switch (kodSkladuRodziny) {
            case "110": {
                return this.malzenstwo(d -> d == 0);
            }
            case "121": {
                return this.malzenstwo(d -> d == 1);
            }
            case "122": {
                return this.malzenstwo(d -> d == 2);
            }
            case "123": {
                return this.malzenstwo(d -> d == 3);
            }
            case "124": {
                return this.malzenstwo(d -> d == 4);
            }
            case "125": {
                return this.malzenstwo(d -> d == 5);
            }
            case "126": {
                return this.malzenstwo(d -> d == 6);
            }
            case "127": {
                return this.malzenstwo(d -> d >= 7);
            }
            case "131": {
                return this.samotnaMatka(d -> d == 1);
            }
            case "132": {
                return this.samotnaMatka(d -> d == 2);
            }
            case "133": {
                return this.samotnaMatka(d -> d == 3);
            }
            case "134": {
                return this.samotnaMatka(d -> d >= 4);
            }
            case "135": {
                return this.samotnyOjciec(d -> d == 1);
            }
            case "136": {
                return this.samotnyOjciec(d -> d == 2);
            }
            case "137": {
                return this.samotnyOjciec(d -> d == 3);
            }
            case "138": {
                return this.samotnyOjciec(d -> d >= 4);
            }
            case "140": {
                return this.konkubinat(d -> d == 0);
            }
            case "151": {
                return this.konkubinat(d -> d == 1);
            }
            case "152": {
                return this.konkubinat(d -> d == 2);
            }
            case "153": {
                return this.konkubinat(d -> d == 3);
            }
            case "154": {
                return this.konkubinat(d -> d == 4);
            }
            case "155": {
                return this.konkubinat(d -> d == 5);
            }
            case "156": {
                return this.konkubinat(d -> d == 6);
            }
            case "157": {
                return this.konkubinat(d -> d >= 7);
            }
            case "211": {
                return this.wielorodzinne(2);
            }
            case "219": {
                return this.konkubinat(d -> d >= 1);
            }
            case "221": {
                return this.wielorodzinne(3);
            }
            case "229": {
                return this.konkubinat(d -> d >= 2);
            }
            case "230": {
                return this.wielorodzinne(4);
            }
            case "310": {
                return this.dowolnySklad(o -> o == 1);
            }
            case "320": {
                return this.dowolnySklad(o -> o >= 2).and(this.malzenstwo(d -> d == 0).negate()).and(this.konkubinat(d -> d == 0).negate());
            }
        }
        return this.dowolnySklad(o -> o >= 1);
    }

    private Predicate<SwiadczenieSprawozdawcze> malzenstwo(IntPredicate liczbaDzieci) {
        Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> _ojciec = this.ZONATY.and(this.MEZCZYZNA).and(this.POKREWIENSTWO_NIEOKRESLONE.or(this.MAZ));
        Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> _matka = this.ZAMEZNA.and(this.KOBIETA).and(this.POKREWIENSTWO_NIEOKRESLONE.or(this.ZONA));
        return this.rodzice(_ojciec, _matka, liczbaDzieci);
    }

    private Predicate<SwiadczenieSprawozdawcze> konkubinat(IntPredicate liczbaDzieci) {
        Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> _ojciec = this.KONKUBENT.and(this.MEZCZYZNA).and(this.POKREWIENSTWO_NIEOKRESLONE.or(this.BRAK_POKREWIENSTWA));
        Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> _matka = this.KONKUBINA.and(this.KOBIETA).and(this.POKREWIENSTWO_NIEOKRESLONE.or(this.BRAK_POKREWIENSTWA));
        return this.rodzice(_ojciec, _matka, liczbaDzieci);
    }

    private Predicate<SwiadczenieSprawozdawcze> samotnaMatka(IntPredicate liczbaDzieci) {
        return this.rodzic(this.KOBIETA.and(this.POKREWIENSTWO_NIEOKRESLONE), liczbaDzieci);
    }

    private Predicate<SwiadczenieSprawozdawcze> samotnyOjciec(IntPredicate liczbaDzieci) {
        return this.rodzic(this.MEZCZYZNA.and(this.POKREWIENSTWO_NIEOKRESLONE), liczbaDzieci);
    }

    private Predicate<SwiadczenieSprawozdawcze> samotnyRodzic(IntPredicate liczbaDzieci) {
        return this.rodzic(this.POKREWIENSTWO_NIEOKRESLONE, liczbaDzieci);
    }

    private Predicate<SwiadczenieSprawozdawcze> wielorodzinne(int r) {
        assert (r >= 2);
        return this.samotnyRodzic(d -> d >= Math.max(r - 1, 1)).or(this.malzenstwo(d -> d >= Math.max(r - 1, 1))).or(this.konkubinat(d -> d >= Math.max(r - 2, 1)));
    }

    private Predicate<SwiadczenieSprawozdawcze> rodzice(Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> _rodzic1, Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> _rodzic2, IntPredicate liczbaDzieci) {
        return swiadczenieSprawozdawcze -> {
            List<SwiadczenieSprawozdawcze.CzlonekRodziny> czlonkowieRodziny = swiadczenieSprawozdawcze.getCzlonkowieRodziny();
            int glowa = (int)czlonkowieRodziny.stream().filter(this.POKREWIENSTWO_NIEOKRESLONE).count();
            if (glowa != 1) {
                return false;
            }
            int rodzic1 = (int)czlonkowieRodziny.stream().filter(_rodzic1).count();
            if (rodzic1 != 1) {
                return false;
            }
            int rodzic2 = (int)czlonkowieRodziny.stream().filter(_rodzic2).count();
            if (rodzic2 != 1) {
                return false;
            }
            int dzieci = this.dzieci(czlonkowieRodziny);
            if (rodzic1 + rodzic2 + dzieci != czlonkowieRodziny.size()) {
                return false;
            }
            return liczbaDzieci.test(dzieci);
        };
    }

    private Predicate<SwiadczenieSprawozdawcze> rodzic(Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> _rodzic, IntPredicate liczbaDzieci) {
        return swiadczenieSprawozdawcze -> {
            List<SwiadczenieSprawozdawcze.CzlonekRodziny> czlonkowieRodziny = swiadczenieSprawozdawcze.getCzlonkowieRodziny();
            int glowa = (int)czlonkowieRodziny.stream().filter(this.POKREWIENSTWO_NIEOKRESLONE).count();
            if (glowa != 1) {
                return false;
            }
            int rodzic = (int)czlonkowieRodziny.stream().filter(_rodzic).count();
            if (rodzic != 1) {
                return false;
            }
            int dzieci = this.dzieci(czlonkowieRodziny);
            if (rodzic + dzieci != czlonkowieRodziny.size()) {
                return false;
            }
            return liczbaDzieci.test(dzieci);
        };
    }

    private Predicate<SwiadczenieSprawozdawcze> dowolnySklad(IntPredicate liczbaOsob) {
        return swiadczenieSprawozdawcze -> {
            int liczbaCzlonkow = swiadczenieSprawozdawcze.getCzlonkowieRodziny().size();
            return liczbaOsob.test(liczbaCzlonkow);
        };
    }

    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> plec(String kod) {
        return czlonekRodziny -> kod.equals(czlonekRodziny.getKodPlci());
    }

    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> stanCywilny(String kod) {
        return czlonekRodziny -> kod.equals(czlonekRodziny.getSytuacjaOsoby().getKodStanuCywilnego());
    }

    private Predicate<SwiadczenieSprawozdawcze.CzlonekRodziny> stopienPokrewienstwa(String kod) {
        return czlonekRodziny -> kod.equals(czlonekRodziny.getSytuacjaOsoby().getKodPokrewienstwaZGlowaRodziny());
    }

    private int dzieci(List<SwiadczenieSprawozdawcze.CzlonekRodziny> czlonkowieRodziny) {
        int synowie = (int)czlonkowieRodziny.stream().filter(this.MEZCZYZNA.and(this.KAWALER).and(this.SYN)).count();
        int corki = (int)czlonkowieRodziny.stream().filter(this.KOBIETA.and(this.PANNA).and(this.CORKA)).count();
        int obce = (int)czlonkowieRodziny.stream().filter(this.KAWALER.or(this.PANNA).and(this.DZIECKO_OBCE)).count();
        return synowie + corki + obce;
    }
}

