package pl.zus.pue.ok_wud;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import com.google.common.base.Preconditions;

public class TypDokumentuAdapter extends XmlAdapter<String, TypDokumentu> {
	@Override
	public TypDokumentu unmarshal(String v) throws Exception {
		return v == null ? null : Preconditions.checkNotNull(TypDokumentu.BY_KOD.get(v), "Nie znaleziono wartości '" + v + "'!");
	}

	@Override
	public String marshal(TypDokumentu v) throws Exception {
		return v == null ? null : v.getKod();
	}
}
