
package pl.gov.mpips.xsd.csizs.cbb.typy.v2;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for RodzajObiektuType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="RodzajObiektuType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="OSOBA"/>
 *     &lt;enumeration value="DANE_KONTAKTOWE"/>
 *     &lt;enumeration value="KONTRAKT"/>
 *     &lt;enumeration value="WNIOSEK"/>
 *     &lt;enumeration value="DECYZJA"/>
 *     &lt;enumeration value="SWIADCZENIE"/>
 *     &lt;enumeration value="DOKUMENT_TOZSAMOSCI"/>
 *     &lt;enumeration value="RODZINA"/>
 *     &lt;enumeration value="PIECZA_ZASTEPCZA"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "RodzajObiektuType")
@XmlEnum
public enum RodzajObiektuType {


    /**
     * Obiekt Osoby w CBB
     * 
     */
    OSOBA,

    /**
     * Obiekt Danych kontaktowych Osoby w CBB
     * 
     */
    DANE_KONTAKTOWE,

    /**
     * Obiekt Kontraktu
     * 
     */
    KONTRAKT,

    /**
     * Obiekt Wiosku
     * 
     */
    WNIOSEK,

    /**
     * Obiekt Decyzji
     * 
     */
    DECYZJA,

    /**
     * Obiekt Świadczenia
     * 
     */
    SWIADCZENIE,

    /**
     * Obiekt Dokumentu Tożsamości osoby w CBB
     * 
     */
    DOKUMENT_TOZSAMOSCI,

    /**
     * Obiekt rodziny
     * 
     */
    RODZINA,

    /**
     * Obiekt Pieczy zastępczej
     * 
     */
    PIECZA_ZASTEPCZA;

    public String value() {
        return name();
    }

    public static RodzajObiektuType fromValue(String v) {
        return valueOf(v);
    }

}
