
package pl.gov.mpips.xsd.csizs.pi.mkm.v2;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


/**
 * Typ reprezentujący potwierdzenie wiadomości, zawierający urzędowe potwierdzenie wiadomości jak: urzędowe potwierdzenie odbioru UPO, 
 * urzędowe potwierdzenie dostarczenia UPD.
 * Potwierdzenie, technicznie jest wiadomością, potwierdzającą odbiór innej wiadomości.
 * Typ ten reprezentuje potwierdzenie wysyłane, czyli nie ma jeszcze nadanego identyfikatora z bazy Modułu komunikacji.
 * W ramach dziedziczonego obiektu:
 * - WiadomoscWysTyp - w tym obiekcie zawierane są, nie dane potwierdzanej wiadomości, a dane specyficzne dla potwierdzenia.
 * WiadomoscWysTyp nie może zawierać wiadomości przekierowanej w aytrybucie wiadPrzekierowana.
 * W WiadomoscWysTyp.wiadomosc zawarty jest dokumnewt UPO zgodny ze schematem udostępnianym przez ePUAP:
 * schematUPO.xsd w wersji http://crd.gov.pl/xml/schematy/UPO/2008/05/09/
 * 
 * <p>Java class for PotwierdzenieWysTyp complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="PotwierdzenieWysTyp">
 *   &lt;complexContent>
 *     &lt;extension base="{http://mpips.gov.pl/xsd/csizs/pi/mkm/v2}WiadomoscWysTyp">
 *       &lt;sequence>
 *         &lt;element name="typPotwierdzenia" type="{http://mpips.gov.pl/xsd/csizs/pi/mkm/v2}TypPotwierdzeniaEnumTyp"/>
 *         &lt;element name="idWiadPotwierdzanej" type="{http://www.w3.org/2001/XMLSchema}long"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PotwierdzenieWysTyp", propOrder = {
    "typPotwierdzenia",
    "idWiadPotwierdzanej"
})
@XmlSeeAlso({
    PotwierdzenieOdebrTyp.class
})
public class PotwierdzenieWysTyp
    extends WiadomoscWysTyp
{

    @XmlElement(required = true)
    protected TypPotwierdzeniaEnumTyp typPotwierdzenia;
    protected long idWiadPotwierdzanej;

    /**
     * Gets the value of the typPotwierdzenia property.
     * 
     * @return
     *     possible object is
     *     {@link TypPotwierdzeniaEnumTyp }
     *     
     */
    public TypPotwierdzeniaEnumTyp getTypPotwierdzenia() {
        return typPotwierdzenia;
    }

    /**
     * Sets the value of the typPotwierdzenia property.
     * 
     * @param value
     *     allowed object is
     *     {@link TypPotwierdzeniaEnumTyp }
     *     
     */
    public void setTypPotwierdzenia(TypPotwierdzeniaEnumTyp value) {
        this.typPotwierdzenia = value;
    }

    /**
     * Gets the value of the idWiadPotwierdzanej property.
     * 
     */
    public long getIdWiadPotwierdzanej() {
        return idWiadPotwierdzanej;
    }

    /**
     * Sets the value of the idWiadPotwierdzanej property.
     * 
     */
    public void setIdWiadPotwierdzanej(long value) {
        this.idWiadPotwierdzanej = value;
    }

}
