<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator="," />
	<xsl:variable name="obsada" select="'###&#160;###&#160;###&#160;##0,00'" />
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'" />
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'" />
	<xsl:variable name="width" select="'944'" />
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
	<!-- <html> -->	
	<!-- 	<head> -->
				<style type="text/css">
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>px;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>px;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>px; padding-top: 6px;
                                				}

					.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
								font-family: Tahoma, Verdana; font-size: 10px;
								font-weight: normal;
								}
					.tab_row_no {padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
								color: #000000; font-family: Tahoma, Verdana; font-size: 10px;
								text-align: left; vertical-align: middle; font-weight: bold;
								}
                   			 .contents	{height: 2.5em;
                   			 			padding-right: 2px; padding-top: 2px; padding-bottom: 2px;
                                 				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.5em;
                   			 			padding-right: 2px; padding-top: 2px; padding-bottom: 2px;
                                 				background-color: silver; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: left; vertical-align: middle; font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: baseline;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				padding-top: 4px; font-weight: normal;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: super;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				padding-top: 2px; font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; padding-top: 24px;
                                				}
                    		.empty		{border: 0 0 0 0;}
				</style>
		<!--	</head> -->			
		<!-- 	<body> -->
				<xsl:apply-templates select="Świadczenia-rodzinne-G"/>
			<!-- </body> -->
		<!--  </html> -->
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Świadczenia-rodzinne-G">
		<xsl:apply-templates select="Metryczka"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Część_A"/>
		<xsl:apply-templates select="Część_B"/>
		<xsl:apply-templates select="Część_C"/>
		<xsl:apply-templates select="Część_D"/>
		<xsl:apply-templates select="Część_E"/>
		<xsl:apply-templates select="Część_F"/>
		<xsl:apply-templates select="Część_G"/>
		<xsl:apply-templates select="Część_H"/>
		<xsl:apply-templates select="Część_I"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/> <br/> <br/>
			</div>
		</xsl:if>

		<xsl:for-each select="../Nagłówek/Dane-jednostki-org">
			 <table cellspacing="0" cellpadding="0">
				<tr>
					<td class="stamp" colspan="2">
						<xsl:value-of select="Pełna-nazwa" />
					</td>
				</tr>
				 <xsl:for-each select="Adres-pocztowy">
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Ulica-i-numer" />
						</td>
					</tr>
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Kod-i-poczta" />
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="stamp" style="font-size: 12px; text-align: left">
						<xsl:for-each select="Telefon">
							Tel. <xsl:apply-templates/>&#160;
 						</xsl:for-each>
					</td>
					<td class="stamp" style="font-size: 12px; text-align: right">
						<xsl:for-each select="Faks">
							&#160;Fax <xsl:apply-templates />
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:for-each>

		<br/><br/>
		<div class="auth_name">
			<xsl:for-each select="../Nagłówek">
				<xsl:for-each select="Wojewoda">
					Wojewoda <xsl:apply-templates />
				</xsl:for-each>
				<xsl:for-each select="Gmina">
					Gmina <xsl:apply-templates />
				</xsl:for-each>
				<!--xsl:for-each select="Wojewoda">
					Wojewoda/<span style="text-decoration: line-through">Gmina</span><sup>1)</sup>&#160;&#160;<xsl:apply-templates />
				</xsl:for-each>
				<xsl:for-each select="Gmina">
					<span style="text-decoration: line-through">Wojewoda</span>/Gmina<sup>1)</sup>&#160;&#160;<xsl:apply-templates />
				</xsl:for-each-->
			</xsl:for-each>
		</div>
		<br/><br/>
		<div class="heading_1">
			SPRAWOZDANIE RZECZOWO-FINANSOWE<br/>O ZADANIACH Z ZAKRESU ŚWIADCZEŃ RODZINNYCH ZREALIZOWANYCH
			ZE ŚRODKÓW BUDŻETU PAŃSTWA ORAZ BUDŻETÓW GMIN<sup>1)</sup><br/>
			<span class="heading_2">
				<xsl:for-each select="Za-okres">
					<xsl:for-each select="Miesiąc">
						za <xsl:apply-templates />
					</xsl:for-each>
					<xsl:for-each select="Kwartał">
						za <xsl:apply-templates /> kwartał
					</xsl:for-each>
						<xsl:value-of select="concat(' ', Rok, ' r.')" />
				</xsl:for-each>
			</span>
		</div>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table width="800">
			<!--caption>Osoba&#160;sporządzająca&#160;sprawozdanie:</caption-->
			<tr>
				<th colspan="2" align="left">Osoba&#160;sporządzająca&#160;sprawozdanie:</th>
				<th align="center">Organ właściwy zobowiązany do sporządzenia sprawozdania:</th>
			</tr>
			<tr>
				<td>imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
				<td rowspan="5" align="center" valign="top">
					<xsl:for-each select="Nagłówek">
						<xsl:for-each select="Wojewoda">
							Wojewoda&#160;&#160;<xsl:apply-templates />
						</xsl:for-each>
						<xsl:for-each select="Gmina">
							Gmina&#160;&#160;<xsl:apply-templates />
						</xsl:for-each>
					</xsl:for-each>
				</td>
			</tr>
			<tr>
				<td>telefon:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>e-mail:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
			<tr>
				<td>podpis:</td> <td>........................................</td>
			</tr>
			<tr>
				<td>data:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
		</table>

	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Table-caption">
		<xsl:param name="width"/>
		<table border="0">
 			<xsl:attribute name="style">
 				<xsl:if test="name() != 'Część_A'">
 					page-break-before: always;
 				</xsl:if>
 				text-align: left; font-family: Tahoma, Verdana;
 				font-size: 18px; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px;
			</xsl:attribute>
			<tr style="vertical-align: top;">
				<td style="width: 1.5em;">
					<xsl:value-of select="concat(substring-after(name(.), '_'), '. ')"/>
				</td>
				<td style="margin-left: 0.2em">
					<xsl:value-of select="@Opis"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Row-description">
		<td class="tab_row_no">
			<xsl:value-of select="concat(substring-after(@Pozycja, '_'), '.')" />
		</td>
		<td class="row_descr">
			<xsl:choose>
				<xsl:when test="@Pozycja = 'A_2.4.1' or @Pozycja = 'A_2.4.2' or @Pozycja = 'A_2.4.3' or @Pozycja = 'A_2.4.4'
												or @Pozycja = 'A_4.1' or @Pozycja = 'A_4.2' or @Pozycja = 'A_4.3' or @Pozycja = 'A_4.4'">
					<xsl:value-of select="@Opis"/><sup>2)</sup>
				</xsl:when>
				<xsl:when test="@Pozycja = 'E_2'">
					<xsl:value-of select="@Opis"/><sup>1)</sup>
				</xsl:when>
				<xsl:when test="@Pozycja = 'F_1' or @Pozycja = 'F_2' or @Pozycja = 'F_5'">
					<xsl:value-of select="substring-before(@Opis, '85212')"/>
					85212<sup>1)</sup>
					<xsl:value-of select="substring-after(@Opis, '85212')"/>
				</xsl:when>
				<xsl:when test="@Pozycja = 'H_1' or @Pozycja = 'H_2'">
					<xsl:value-of select="substring-before(@Opis, 'rodzin pełnych')"/>
					rodzin pełnych<sup>1)</sup>
					<xsl:value-of select="substring-after(@Opis, 'pełnych')"/>
				</xsl:when>
				<xsl:when test="@Pozycja = 'H_3' or @Pozycja = 'H_4'">
					<xsl:value-of select="substring-before(@Opis, 'niepełnych')"/>
					niepełnych<sup>2)</sup>
					<xsl:value-of select="substring-after(@Opis, 'pełnych')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="@Opis"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="ABE_header">
		<xsl:param name="descrwidth" select="26"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(round((100-number($descrwidth)-3) div 2))"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 4))"/>
		</xsl:param>
		<xsl:param name="double">
			<xsl:value-of select="string(number($single) * 2)"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="3">L.p.</th>
				<th rowspan="3"><xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Wydatki narastająco od początku roku w zł
				</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Liczba świadczeń narastająco od początku roku
				</th>
			</tr>
			<tr>
				<th rowspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy<br/>miesiąc<br/>kwartału</th>
				<th rowspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Dwa<br/>miesiące<br/>kwartału</th>
				<th colspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>Trzy miesiące<br/>kwartału</th>
				<th rowspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy<br/>miesiąc<br/>kwartału</th>
				<th rowspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Dwa<br/>miesiące<br/>kwartału</th>
				<th colspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>Trzy miesiące<br/>kwartału</th>
			</tr>
				 <tr>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>razem</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym:<br/>w ramach<br/>koordynacji</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>razem</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym:<br/>w ramach<br/>koordynacji</th>
				</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
				<td class="tab_col_no">7</td>
				<td class="tab_col_no">8</td>
				<td class="tab_col_no">9</td>
				 <td class="tab_col_no">10</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_A">
		<xsl:call-template name="Część_AE"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_E">
		<xsl:call-template name="Część_AE"/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Część_AE">
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<xsl:call-template name="ABE_header"/>
			<tbody>
				<xsl:for-each select="Wydatki-i-świadczenia">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Wydatki-i-świadczeniobiorcy">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>

		_________
		<table style="padding-top: 6px;" width="600" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" valign="top">1)</td>
				<td class="remark">
					<xsl:choose>
						<xsl:when test="name(.) = 'Część_A'">
							W przypadku sprawozdania sporządzanego przez wojewodę jest to sprawozdanie zbiorcze.
						</xsl:when>
						<xsl:otherwise>
							Dotyczy ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych (Dz. U. z 2006 r. Nr 139, poz. 992, z późn. zm.).
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<xsl:if test="name(.) = 'Część_A'">
				<tr>
					<td class="stars" valign="top">2)</td>
					<td class="remark">
							Dotyczy ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych (Dz. U. z 2006 r. Nr 139, poz. 992, z późn. zm.).
					</td>
				</tr>
			</xsl:if>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Wydatki-i-świadczeniobiorcy">
		<xsl:param name="skladniki"/>

		<xsl:call-template name="_AE_contents">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Wydatki-narastająco'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>

		<xsl:call-template name="_AE_contents">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Liczba-świadczeń'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_AE_contents">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="format"/>
		<xsl:call-template name="_AE_column_12">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_AE_column_12">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_AE_column_34">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Razem'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_AE_column_34">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Koord'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_AE_column_12">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="_AE_total_12">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:when test="string(number($contents)) = 'NaN'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_AE_column_34">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/Trzy-miesiące/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="_AE_total_34">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:when test="string(number($contents)) = 'NaN'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_AE_total_12">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="items" select="../*[contains($skladniki,concat(@Pozycja,' '))]/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="suma">
			<xsl:for-each select="$items">
				<xsl:call-template name="_AE_add_tree_12">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="skladniki" select="../../@Składniki"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_AE_total_34">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="items" select="../*[contains($skladniki,concat(@Pozycja,' '))]/*[name(.) = $subtree]/Trzy-miesiące/*[name(.) = $column]"/>
		<xsl:param name="suma">
			<xsl:for-each select="$items">
				<xsl:choose>
					<xsl:when test=". != ''">
						<xsl:value-of select="."/>
						<xsl:value-of select="'+'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="_AE_add_tree_34">
							<xsl:with-param name="subtree" select="$subtree"/>
							<xsl:with-param name="skladniki" select="../../../@Składniki"/>
							<xsl:with-param name="column" select="$column"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="0"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="$suma"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="$contents"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_AE_add_tree_12">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="../../*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="skladniki"/>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:for-each select="../../../*[contains(concat($skladniki, ' '),concat(@Pozycja,' '))]/*[name(.) = $subtree]/*[name(.) = $column]">
					<xsl:call-template name="_AE_add_tree_12">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="skladniki" select="../../@Składniki"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_AE_add_tree_34">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="../../../*[name(.) = $subtree]/Trzy-miesiące/*[name(.) = $column]"/>
		<xsl:param name="skladniki"/>
		<xsl:choose>
			<xsl:when test="$skladniki and $contents = ''">
				<xsl:for-each select="../../../../*[contains(concat($skladniki, ' '),concat(@Pozycja,' '))]/*[name(.) = $subtree]/Trzy-miesiące/*[name(.) = $column]">
					<xsl:call-template name="_AE_add_tree_34">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="skladniki" select="../../../@Składniki"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="string(../../../*[name(.) = $subtree]/Trzy-miesiące/*[name(.) = $column]/@xsi:nil) != 'true'">
					<xsl:value-of select="$contents"/>
					<xsl:value-of select="'+'"/>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="sumuj">
		<xsl:param name="wynik"/>
		<xsl:param name="format"/>
		<xsl:param name="contents"/>
		<xsl:param name="suma"/>
		<xsl:choose>
			<xsl:when test="$suma!=''">
				<xsl:call-template name="sumuj">
					<xsl:with-param name="wynik" select="$wynik+substring-before($suma,'+')"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="suma" select="substring-after($suma,'+')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="string(number($wynik)) = 'NaN'">
						<td class="totals">
							<center>X</center>
						</td>
					</xsl:when>
					<xsl:when test="string(number($contents)) != 'NaN' and $contents != ''">
						<xsl:choose>
							<xsl:when test="$contents != $wynik">
								<td class="contents error">
									<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
									<br/>
									<xsl:value-of select="concat('powinno być: ', format-number($wynik, $format))"/>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td class="totals">
									<xsl:value-of select="format-number($wynik, $format)"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_B">
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<xsl:call-template name="ABE_header"/>
			<tbody>
				<xsl:for-each select="Wydatki-i-składki">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Wydatki-na-składki">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-na-składki">
		<xsl:param name="skladniki"/>

		<xsl:call-template name="_AE_contents">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Wydatki-narastająco'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>

		<xsl:choose>
			<xsl:when test="$skladniki or Liczba-osób/@xsi:nil">
				<td class="empty" colspan="4"></td>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="_AE_contents">
					<xsl:with-param name="skladniki" select="$skladniki"/>
					<xsl:with-param name="subtree" select="'Liczba-osób'"/>
					<xsl:with-param name="format" select="$liczba"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_C">
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<xsl:call-template name="FIG_header">
				<xsl:with-param name="remark" select="'1)'"/>
				<xsl:with-param name="grouphdr" select="'Kwoty narastająco od początku roku (w zł)'"/>
				<xsl:with-param name="descrwidth" select="63"/>
			</xsl:call-template>
			<tbody>
				<xsl:for-each select="Liczba-lub-kwota">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Realizacja"/>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>

		_________
		<table style="padding-top: 6px;" width="204" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars">1)</td>
				<td class="remark">
					Zasada narastania nie dotyczy wiersza 1
				</td>
			</tr>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Realizacja">
		<xsl:param name="format">
			<xsl:choose>
				<xsl:when test="Miesięcznie-kwota">
					<xsl:value-of select="$kwota"/>
				</xsl:when>
				<xsl:when test="Miesięcznie-etatów">
					<xsl:value-of select="$obsada"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$liczba"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<xsl:call-template name="C_column">
			<xsl:with-param name="skladniki" select="@Składniki"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="C_column">
			<xsl:with-param name="skladniki" select="@Składniki"/>
			<xsl:with-param name="column" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="C_column">
			<xsl:with-param name="skladniki" select="@Składniki"/>
			<xsl:with-param name="column" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="C_column">
		<xsl:param name="format"/>
		<xsl:param name="column"/> <xsl:param name="skladniki"/>
		<xsl:param name="item" select="./*/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>

		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="_C_total">
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:value-of select="format-number($contents, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_C_total">
		<xsl:param name="skladniki"/> <xsl:param name="column"/>
		<xsl:param name="items" select="../*[contains($skladniki,concat(@Pozycja,' '))]/*/*[name(.) = $column]"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="$items">
				<xsl:call-template name="_C_add_tree">
					<xsl:with-param name="skladniki" select="../@Składniki"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_C_add_tree">
		<xsl:param name="column"/>
		<xsl:param name="contents" select="../*[name(.) = $column]"/>
		<xsl:param name="skladniki"/>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:for-each select="../*[contains(concat($skladniki, ' '),concat(@Pozycja,' '))]/*[name(.) = $column]">
					<xsl:call-template name="_C_add_tree">
						<xsl:with-param name="skladniki" select="../@Składniki"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_D">
		<xsl:param name="descrwidth" select="40"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(100-number($descrwidth)-3)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 4))"/>
		</xsl:param>
		<xsl:param name="double">
			<xsl:value-of select="string(number($single) * 2)"/>
		</xsl:param>
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th width="3%" rowspan="3">L.p.</th>
					<th rowspan="3"><xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
					<th colspan="4">
						<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
						Kwoty narastająco od początku roku w zł
					</th>
				</tr>
				<tr>
					<th rowspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy miesiąc kwartału</th>
					<th rowspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Dwa miesiące kwartału</th>
					<th colspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>Trzy miesiące kwartału</th>
				</tr>
				<tr>
					 <th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>razem</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym: na podstawie decyzji marszałka</th>
				</tr>
				<tr>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Odzyskane-świadczenia">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Odzyskane-świadczenia">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Odzyskane-świadczenia">
		<xsl:param name="skladniki" select="'no default'"/>
		<xsl:param name="subtree" select="'Odzyskano-narastająco'"/>
		<xsl:param name="format" select="$kwota"/>

		<xsl:call-template name="_AE_column_12">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_AE_column_12">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_AE_column_34">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Razem'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_AE_column_34">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Ubiegłe'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="FIG_header">
		<xsl:param name="remark"/> <xsl:param name="grouphdr"/> <xsl:param name="descrwidth"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(100-number($descrwidth)-3)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">L.p.</th>
				<th rowspan="2"><xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
					<xsl:if test="$remark">
						<sup><xsl:value-of select="$remark"/></sup>
					</xsl:if>
				</th>
			</tr>
			<tr>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy miesiąc kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>drugi miesiąc kwartału</th>
				<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzeci miesiąc kwartału</th>
			</tr>
		<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_F">
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<xsl:call-template name="FIG_header">
				<xsl:with-param name="remark" select="'2)'"/>
				<xsl:with-param name="grouphdr" select="'Kwoty narastająco od początku roku'"/>
				<xsl:with-param name="descrwidth" select="60"/>
			</xsl:call-template>
			<tbody>
				<xsl:for-each select="Miesięcznie-kwota">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="F_column">
							<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
						</xsl:call-template>
						<xsl:call-template name="F_column">
							<xsl:with-param name="column" select="'Drugi-miesiąc'"/>
						</xsl:call-template>
						<xsl:call-template name="F_column">
							<xsl:with-param name="column" select="'Trzeci-miesiąc'"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>

		_________
		<table style="padding-top: 6px;" width="600" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars">1)</td>
				<td class="remark">
					Świadczenia rodzinne, zaliczka alimentacyjna oraz składki na ubezpieczenia emerytalne i rentowe z ubezpieczenia społecznego.
				</td>
			</tr>
			<tr>
				<td class="stars">2)</td>
				<td class="remark">
					Zasada narastania nie dotyczy wiersza 1
				</td>
			</tr>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="F_column">
		<xsl:param name="column"/>

		<td class="contents">
			<xsl:value-of select="format-number(*[name() = $column], $kwota)"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_G">
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<xsl:call-template name="FIG_header">
				<xsl:with-param name="grouphdr" select="'Wykonanie miesięczne'"/>
				<xsl:with-param name="descrwidth" select="60"/>
			</xsl:call-template>
			<tbody>
				<xsl:for-each select="Liczba-lub-kwota">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Realizacja"/>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
		<xsl:template name="Liczby_rodzin">
		<xsl:param name="skladniki"/>

		<xsl:call-template name="_H_contents">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>

		<xsl:call-template name="_H_contents">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>

		<xsl:call-template name="_H_contents">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_H_contents">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="format"/>
		<xsl:call-template name="_H_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Jedno-dziecko'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_H_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwoje-dzieci'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_H_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Troje-dzieci'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_H_column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Czworo-dzieci'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_H_column">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="_H_total">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string($item/@xsi:nil) = 'true'">
							<center>X</center>
						</xsl:when>
						<xsl:when test="string(number($contents)) = 'NaN'">
							<center>X</center>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_H_total">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="items" select="../*[contains($skladniki,concat(@Pozycja,' '))]/*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="suma">
			<xsl:for-each select="$items">
				<xsl:call-template name="_H_add_tree">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="skladniki" select="../../@Składniki"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_H_add_tree">
		<xsl:param name="subtree"/> <xsl:param name="column"/>
		<xsl:param name="contents" select="../../*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="skladniki"/>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:for-each select="../../../*[contains(concat($skladniki, ' '),concat(@Pozycja,' '))]/*[name(.) = $subtree]/*[name(.) = $column]">
					<xsl:call-template name="_H_add_tree">
						<xsl:with-param name="subtree" select="$subtree"/>
						<xsl:with-param name="skladniki" select="../../@Składniki"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_H">
		<xsl:param name="descrwidth" select="40"/>
		<xsl:param name="group">
			<xsl:value-of select="string(100-number($descrwidth)-3)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($group) div 12))"/>
		</xsl:param>
		<xsl:param name="subgrp">
			<xsl:value-of select="string(number($single) * 4)"/>
		</xsl:param>
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<thead>
				<tr>
					<th width="3%" rowspan="3">L.p.</th>
					<th rowspan="3"><xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
					<th colspan="12">
						<xsl:attribute name="width"><xsl:value-of select="concat($group,'%')"/></xsl:attribute>
						Wykonanie miesięczne
					</th>
				</tr>
				<tr>
					<th colspan="4"><xsl:attribute name="width"><xsl:value-of select="concat($subgrp,'%')"/></xsl:attribute>Pierwszy miesiąc kwartału</th>
					<th colspan="4"><xsl:attribute name="width"><xsl:value-of select="concat($subgrp,'%')"/></xsl:attribute>Drugi miesiąc kwartału</th>
					<th colspan="4"><xsl:attribute name="width"><xsl:value-of select="concat($subgrp,'%')"/></xsl:attribute>Trzeci miesiąc kwartału</th>
				</tr>
				<tr>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z 1 dziec-<br/>kiem</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z 2 dzieci</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z 3 dzieci</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z 4 i więcej dzieci</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z 1 dziec-<br/>kiem</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z 2 dzieci</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z 3 dzieci</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z 4 i więcej dzieci</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z 1 dziec-<br/>kiem</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z 2 dzieci</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z 3 dzieci</th>
					<th><xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z 4 i więcej dzieci</th>
				</tr>
				<tr>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
					<td class="tab_col_no">8</td>
					<td class="tab_col_no">9</td>
					<td class="tab_col_no">10</td>
					<td class="tab_col_no">11</td>
					<td class="tab_col_no">12</td>
					<td class="tab_col_no">13</td>
					<td class="tab_col_no">14</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Liczba-rodzin">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Liczby_rodzin">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>

		_________
		<table style="padding-top: 6px;" width="604" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars">1)</td>
				<td class="remark">
					Rodziny z wyłączeniem osób samotnie wychowyjących dzieci (art. 3 pkt 17a ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych)
				</td>
			</tr>
			<tr>
				<td class="stars">2)</td>
				<td class="remark">
					Rodziny osób samotnie wychowyjących dzieci (art. 3 pkt 17a ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych)
				</td>
			</tr>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_I">
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<xsl:call-template name="FIG_header">
				<xsl:with-param name="grouphdr" select="'Wykonanie miesięczne'"/>
				<xsl:with-param name="descrwidth" select="30"/>
			</xsl:call-template>
			<tbody>
				<xsl:for-each select="Miesięcznie-liczba">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="I_column">
							<xsl:with-param name="skladniki" select="@Składniki"/>
							<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
						</xsl:call-template>
						<xsl:call-template name="I_column">
							<xsl:with-param name="skladniki" select="@Składniki"/>
							<xsl:with-param name="column" select="'Drugi-miesiąc'"/>
						</xsl:call-template>
						<xsl:call-template name="I_column">
							<xsl:with-param name="skladniki" select="@Składniki"/>
							<xsl:with-param name="column" select="'Trzeci-miesiąc'"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="I_column">
		<xsl:param name="column"/> <xsl:param name="skladniki"/>
		<xsl:param name="item" select="*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>

		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="_I_total">
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$liczba"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:value-of select="format-number($contents, $liczba)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_I_total">
		<xsl:param name="skladniki"/> <xsl:param name="column"/>
		<xsl:param name="items" select="../*[contains($skladniki,concat(@Pozycja,' '))]/*[name(.) = $column]"/>
		<xsl:param name="format"/> <xsl:param name="contents"/>
		<xsl:param name="suma">
			<xsl:for-each select="$items">
				<xsl:call-template name="_I_add_tree">
					<xsl:with-param name="skladniki" select="../@Składniki"/>
					<xsl:with-param name="column" select="$column"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:param>
		<xsl:call-template name="sumuj">
			<xsl:with-param name="wynik" select="0"/>
			<xsl:with-param name="format" select="$format"/>
			<xsl:with-param name="contents" select="$contents"/>
			<xsl:with-param name="suma" select="$suma"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_I_add_tree">
		<xsl:param name="column"/>
		<xsl:param name="contents" select="../*[name(.) = $column]"/>
		<xsl:param name="skladniki"/>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:for-each select="../*[contains(concat($skladniki, ' '),concat(@Pozycja,' '))]/*[name(.) = $column]">
					<xsl:call-template name="_I_add_tree">
						<xsl:with-param name="skladniki" select="../@Składniki"/>
						<xsl:with-param name="column" select="$column"/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$contents"/>
				<xsl:value-of select="'+'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
