package pl.topteam.sprawozdania.utils;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDate;

public class LocalDateAdapter extends XmlAdapter<String, LocalDate> {
	public LocalDate unmarshal(String value) {
		return LocalDate.parse(value, DateUtils.DATE_FORMATTER);
	}

	public String marshal(LocalDate value) {
		return value.format(DateUtils.DATE_FORMATTER);
	}
}
