package pl.topteam.sprawozdania.utils;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.time.YearMonth;

import static pl.topteam.sprawozdania.utils.DateUtils.YEAR_MONTH_FORMATTER;

public class LocalYearMonthAdapter extends XmlAdapter<String, YearMonth> {
	public YearMonth unmarshal(String value) {
		return YearMonth.parse(value, YEAR_MONTH_FORMATTER);
	}

	public String marshal(YearMonth value) {
		return value.format(YEAR_MONTH_FORMATTER);
	}
}
