package pl.topteam.sprawozdania.utils;

import com.google.common.base.Preconditions;

import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;

public class WydrukSprawozdaniaUtil {

    public static String drukujPolonSRG_20171220(byte[] tresc){
        return drukuj(tresc, "xslt/uslugiGrupowe/POLON-SR-G_20171220.xslt");
    }
    public static String drukujSIOSRG_20171220(byte[] tresc){
        return drukuj(tresc, "xslt/uslugiGrupowe/SIO-SR-G_20171220.xslt");
    }
    public static String drukujSIOSWiDSG_20181116(byte[] tresc){
        return drukuj(tresc, "xslt/uslugiGrupowe/SIO-SWiDS-G_20181116.xslt");
    }
    public static String drukujZ1CBBSRG_20171220(byte[] tresc){
        return drukuj(tresc, "xslt/uslugiGrupowe/Z1-CBB-SR-G_20171220.xslt");
    }
    public static String drukujZ1CBBSWG_20171220(byte[] tresc){
        return drukuj(tresc, "xslt/uslugiGrupowe/Z1-CBB-SW-G_20171220.xslt");
    }
    public static String drukujSDSG_20181119(byte[] tresc){
        return drukuj(tresc, "xslt/dobryStart/SDS-G_20181119.xslt");
    }
    public static String drukujSDSG_20191115(byte[] tresc){
        return drukuj(tresc, "xslt/dobryStart/SDS-G_20191115.xslt");
    }

    public static String drukuj(byte[] tresc, String stylPath) {
        try (InputStream styl = WydrukSprawozdaniaUtil.class.getClassLoader().getResourceAsStream(stylPath)) {
            Preconditions.checkNotNull(styl, "nie udało się odnaleźć xsl sprawozdania");
            return transformuj(tresc, styl);
        } catch (IOException | TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private static String transformuj(byte[] tresc, InputStream styl) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(styl));
        Source xmlSource = new StreamSource(new ByteArrayInputStream(tresc));
        StringWriter sw = new StringWriter();
        transformer.transform(xmlSource, new StreamResult(sw));
        return sw.toString();
    }

}
