<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output omit-xml-declaration="yes" indent="yes"/>
	
	<xsl:template match="text()|@*"/>
	
	<xsl:template match="/">
		<xsl:element name="properties">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="*[@Pozycja]">
		<xsl:variable name="pozycja">
			<xsl:value-of select="@Pozycja"/>
		</xsl:variable>
		<xsl:for-each select="descendant::*[not(*)]">
			<xsl:variable name="pozycja">
				<xsl:value-of select="$pozycja"/>
				<xsl:text>#</xsl:text>
				<xsl:value-of select="position()+2"/>
			</xsl:variable>
			<xsl:variable name="sciezka">
				<xsl:for-each select="ancestor-or-self::*">
					<xsl:text>/</xsl:text>
					<xsl:value-of select="name()"/>
					<xsl:if test="count(../*[name(../*) = name(.)]) > 1">
						<xsl:text>[</xsl:text>
						<xsl:value-of select="count(preceding-sibling::*)"/>
						<xsl:text>]</xsl:text>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:if test="not(@xsi:nil='true')">
				<xsl:element name="entry">
					<xsl:attribute name="key"><xsl:value-of select="$pozycja"/></xsl:attribute>
					<xsl:value-of select="$sciezka"/>
				</xsl:element>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
