<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output omit-xml-declaration="yes" indent="yes"/>
	
	<xsl:template match="text()|@*"/>
	
	<xsl:template match="properties">
		<xsl:element name="properties">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	
	<xsl:template match="entry">
		<xsl:element name="entry">
			<xsl:attribute name="key">
				<xsl:value-of select="@key"/>
			</xsl:attribute>
			<xsl:call-template name="camelize">
				<xsl:with-param name="string">
					<xsl:call-template name="lower-case">
						<xsl:with-param name="string">
							<xsl:value-of select="substring(translate(., '/_', '.-'), 2)"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:element>
	</xsl:template>
	
	<!-- 
		Converts the string argument to upper-case
		Example: upper-case('The XML')
		Result: 'THE XML'
 -->
	<xsl:template name="upper-case">
		<xsl:param name="string"/>
		<xsl:value-of select="translate($string, 'abcdefghijklmnopqrstuvwxyząćęłńóśźż', 'ABCDEFGHIJKLMNOPQRSTUVWXYZĄĆĘŁŃÓŚŹŻ')"/>
	</xsl:template>
	
	<!--
	Converts the string argument to lower-case
	Example: lower-case('The XML')
	Result: 'the xml' 
	-->
	<xsl:template name="lower-case">
		<xsl:param name="string"/>
		<xsl:value-of select="translate($string, 'ABCDEFGHIJKLMNOPQRSTUVWXYZĄĆĘŁŃÓŚŹŻ', 'abcdefghijklmnopqrstuvwxyząćęłńóśźż')"/>
	</xsl:template>
	
	<!--
	Converts underscored or dasherized string to a camelized one
	Example: camelize('the-xml')
	Result: 'theXML'
	-->
	<xsl:template name="camelize">
		<xsl:param name="string"/>
		<xsl:choose>
			<xsl:when test="contains($string, '-')">
				<xsl:variable name="before" select="substring-before($string, '-')"/>
				<xsl:variable name="after" select="substring-after($string, '-')"/>
				<xsl:variable name="afterFirst">
					<xsl:call-template name="upper-case">
						<xsl:with-param name="string">
							<xsl:value-of select="substring($after, 1, 1)"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="afterRest">
					<xsl:call-template name="camelize">
						<xsl:with-param name="string">
							<xsl:value-of select="substring($after, 2)"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($before, $afterFirst, $afterRest)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$string"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
