package pl.topteam.sprawozdania.reflect;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

import javax.xml.bind.annotation.XmlElement;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;

public final class Składniki {
	private Składniki() {}
	
	public static Graph<Field> składniki(Class<?> część) {
		Map<String, Field> indeks = Arrays.stream(część.getDeclaredFields())
			.collect(ImmutableMap.toImmutableMap(Składniki::składnik, Function.identity()));
		// najpierw węzły
		ImmutableGraph.Builder<Field> składniki = GraphBuilder.directed().immutable();
		for (Field pole : część.getDeclaredFields()) {
			składniki.addNode(pole);
		}
		// potem krawędzie
		for (Field pole : część.getDeclaredFields()) {
			for (String składnik : składniki(pole)) {
				składniki.putEdge(indeks.get(składnik), pole);
			}
		}
		return składniki.build();
	}
	
	private static String składnik(Field pole) {
		return pole.getAnnotation(XmlElement.class).name();
	}
	
	private static Iterable<String> składniki(Field pole) {
		try {
			String składniki = (String) pole.getType().getField("SKŁADNIKI").get(null);
			return Splitter.on(" ").split(składniki);
		} catch (NoSuchFieldException wyjątek) {
			return Collections.emptyList();
		} catch (Exception wyjątek) {
			throw new AssertionError(wyjątek);
		}
	}
}
