package pl.topteam.sprawozdania.utils;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDateTime;

import static pl.topteam.sprawozdania.utils.DateUtils.DATE_TIME_FORMATTER;

public class LocalDateTimeAdapter extends XmlAdapter<String, LocalDateTime> {
	public LocalDateTime unmarshal(String value) {
		return LocalDateTime.parse(value, DATE_TIME_FORMATTER);
	}

	public String marshal(LocalDateTime value) {
		return value.format(DATE_TIME_FORMATTER);
	}
}
