package pl.topteam.swiadczenia.sprawozdania.rodzinne_1_04b;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import pl.topteam.sprawozdania.reflect.Deskryptory;
import pl.topteam.sprawozdania.reflect.Składniki;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;

public final class Część__UA_2_Validator implements ConstraintValidator<Część__UA_2_Constraint, Część__UA_2> {
	private static final Graph<Field> SKŁADNIKI = Składniki.składniki(Część__UA_2.class);
	
	@Override
	public void initialize(Część__UA_2_Constraint adnotacja) {
	}
	
	@Override
	public boolean isValid(Część__UA_2 czescUA2, ConstraintValidatorContext kontekst) {
		boolean wynik = true;
		kontekst.disableDefaultConstraintViolation();
		String komunikat = kontekst.getDefaultConstraintMessageTemplate();
		for (Field pole : SKŁADNIKI.nodes()) {
			if (SKŁADNIKI.predecessors(pole).isEmpty()) {
				continue;
			}
			WykonanieKwMienarast wartosc = wartość(czescUA2, pole);
			Set<WykonanieKwMienarast> skladniki = SKŁADNIKI.predecessors(pole).stream().map(skladnik -> wartość(czescUA2, skladnik)).collect(ImmutableSet.toImmutableSet());
			if (wartosc.getPierwszyMiesiąc() != skladniki.stream().mapToLong(WykonanieKwMienarast::getPierwszyMiesiąc).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
				wynik = false;
			}
			if (wartosc.getDrugiMiesiąc() != skladniki.stream().mapToLong(WykonanieKwMienarast::getDrugiMiesiąc).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("drugiMiesiąc").addConstraintViolation();
				wynik = false;
			}
			if (wartosc.getTrzeciMiesiąc() != skladniki.stream().mapToLong(WykonanieKwMienarast::getTrzeciMiesiąc).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("trzeciMiesiąc").addConstraintViolation();
				wynik = false;
			}
		}
		return wynik;
	}
	
	private WykonanieKwMienarast wartość(Część__UA_2 część, Field składnik) {
		try {
			return (WykonanieKwMienarast) DESKRYPTORY.get(składnik).getReadMethod().invoke(część);
		} catch (Exception wyjątek) {
			throw new AssertionError();
		}
	}
	
	private static final Map<Field, PropertyDescriptor> DESKRYPTORY = Deskryptory.deskryptory(Część__UA_2.class);
}
