<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="obsada" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'944'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<!-- <html> -->
			<!-- <head> -->
				<style type="text/css">
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>px;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-align: justify;
                                 				width: <xsl:value-of select="$width"/>px;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: 14px; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>px; padding-top: 6px;
                                				}

					.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
								font-family: Tahoma, Verdana; font-size: 10px;
								font-weight: normal;
								}
					.tab_row_no {padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
								color: #000000; font-family: Tahoma, Verdana; font-size: 10px;
								text-align: left; vertical-align: middle; font-weight: bold;
								}
                   			 .contents	{height: 2.5em;
                   			 			padding-right: 2px; padding-top: 2px; padding-bottom: 2px;
                                 				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.5em;
                   			 			padding-right: 2px; padding-top: 2px; padding-bottom: 2px;
                                 				background-color: silver; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: left; vertical-align: middle; font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: baseline;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				padding-top: 4px; font-weight: normal;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: super;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				padding-top: 2px; font-weight: normal;
                                				}
                    		.empty		{border: 0 0 0 0;}
				</style>
			<!-- </head> -->
			<!-- <body> -->
				<xsl:apply-templates select="Zasiłki-dla-opiekunów-G"/>
			<!-- </body> -->
		<!-- </html> -->
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Zasiłki-dla-opiekunów-G">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Część_A"/>
		<xsl:apply-templates select="Część_B"/>
		<xsl:apply-templates select="Część_C"/>
		<xsl:apply-templates select="Część_D"/>
		<xsl:apply-templates select="Część_E"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/>
				<br/>
				<br/>
			</div>
		</xsl:if>
		<xsl:for-each select="../Nagłówek/Dane-jednostki-org">
			<table cellspacing="0" cellpadding="0">
				<tr>
					<td class="stamp" colspan="2">
						<xsl:value-of select="Pełna-nazwa"/>
					</td>
				</tr>
				<xsl:for-each select="Adres-pocztowy">
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Ulica-i-numer"/>
						</td>
					</tr>
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Kod-i-poczta"/>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="stamp" style="font-size: 12px; text-align: left">
						<xsl:for-each select="Telefon">
							Tel. <xsl:apply-templates/>&#160;
 						</xsl:for-each>
					</td>
					<td class="stamp" style="font-size: 12px; text-align: right">
						<xsl:for-each select="Faks">
							&#160;Fax <xsl:apply-templates/>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:for-each>
		<br/>
		<br/>
		<div class="auth_name">
			<xsl:for-each select="../Nagłówek">
				<xsl:for-each select="Wojewoda">
					Wojewoda <xsl:apply-templates/>
					<sup>1)</sup>
				</xsl:for-each>
				<xsl:for-each select="Gmina">
					Gmina <xsl:apply-templates/>
				</xsl:for-each>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
		<div class="heading_1">
			<xsl:choose>
				<xsl:when test="../Nagłówek/Gmina">
				 KWARTALNE SPRAWOZDANIE
			</xsl:when>
				<xsl:otherwise>
				KWARTALNE ZBIORCZE SPRAWOZDANIE 
			</xsl:otherwise>
			</xsl:choose>
		RZECZOWO-FINANSOWE Z REALIZACJI ZADAŃ Z ZAKRESU ZASIŁKÓW DLA OPIEKUNÓW, O KTÓRYCH MOWA W USTAWIE Z DNIA 4 KWIETNIA 2014 R. O USTALENIU I WYPŁACIE ZASIŁKÓW DLA OPIEKUNÓW (DZ. U. POZ. 567, Z PÓŹN. ZM.), 
				<xsl:for-each select="Za-okres">
				<xsl:for-each select="Kwartał">
						ZA <xsl:apply-templates/> KWARTAŁ
					</xsl:for-each>
				<xsl:value-of select="concat(' ', Rok, ' R.')"/>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table width="500">
			<caption class="caption">Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td>imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td>telefon służbowy:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>e-mail służbowy:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
			<tr>
				<td>Data sporządzenia sprawozdania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Tables-description">
		<xsl:param name="table_name"/>
		<xsl:choose>
			<xsl:when test="$table_name = 'Część_A'">Wydatki na zasiłki dla opiekunów finansowane z dotacji celowej z budżetu państwa oraz liczba zasiłków</xsl:when>
			<xsl:when test="$table_name = 'Część_B'">Wydatki na składki na ubezpieczenia społeczne i ubezpieczenie zdrowotne oraz liczba składek</xsl:when>
			<xsl:when test="$table_name = 'Część_C'">Informacja na temat nienależnie pobranych zasiłków dla opiekunów</xsl:when>
			<xsl:when test="$table_name = 'Część_D'">Informacja na temat przyczyn zaprzestania pobierania zasiłku dla opiekuna oraz liczby decyzji w sprawach dotyczących zasiłku dla opiekuna</xsl:when>
			<xsl:when test="$table_name = 'Część_E'">Informacja na temat relacji pomiędzy osobami pobierającymi zasiłki dla opiekunów, a osobami wymagającymi opieki</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Table-caption">
		<xsl:param name="width"/>
		<table border="0">
			<xsl:attribute name="style"><xsl:if test="name() != 'Część_A'">
 					page-break-before: always;
 				</xsl:if>
 				text-align: left; font-family: Tahoma, Verdana;
 				font-size: 14px; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px;
			</xsl:attribute>
			<tr style="vertical-align: top;">
				<td style="width: 1.5em;">
					<xsl:value-of select="concat(substring-after(name(.), '_'), '. ')"/>
				</td>
				<td style="margin-left: 0.2em">
					<xsl:call-template name="Tables-description">
						<xsl:with-param name="table_name" select="name()"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Rows-description">
		<xsl:param name="row_name"/>
		<xsl:choose>
			<xsl:when test="$row_name = 'A_1'">Zasiłek dla opiekuna</xsl:when>
			<xsl:when test="$row_name = 'B_1'">Składki na ubezpieczenia emerytalne i rentowe opłacane za osoby pobierające zasiłki dla opiekunów, z tego:</xsl:when>
			<xsl:when test="$row_name = 'B_1.1'">- opłacane na podstawie przepisów o systemie ubezpieczeń społecznych<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'B_1.2'">- opłacane na podstawie przepisów <nobr>o ubezpieczeniu</nobr> społecznym rolników<sup>2)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'B_2'">Składki na ubezpieczenie zdrowotne opłacane <nobr>za osoby</nobr> pobierające zasiłki dla opiekunów</xsl:when>
			<xsl:when test="$row_name = 'C_1'">Stan należności z tytułu nienależnie pobranych zasiłków dla opiekunów na ostatni dzień miesiąca</xsl:when>
			<xsl:when test="$row_name = 'C_2'">Kwota umorzonych nienależnie pobranych zasiłków dla opiekunów</xsl:when>
			<xsl:when test="$row_name = 'C_3'">Kwota wygaszonych nienależnie pobranych zasiłków dla opiekunów</xsl:when>
			<xsl:when test="$row_name = 'C_4'">Kwota odzyskanych nienależnie pobranych zasiłków dla opiekunów, w tym:</xsl:when>
			<xsl:when test="$row_name = 'C_4.1'">- podlegająca zwrotowi do budżetu państwa</xsl:when>
			<xsl:when test="$row_name = 'D_1'">Upływ terminu ważności orzeczenia o niepełnosprawności lub orzeczenia o znacznym stopniu niepełnosprawności osoby wymagającej opieki</xsl:when>
			<xsl:when test="$row_name = 'D_2'">Podjęcie przez opiekuna zatrudnienia lub innej pracy zarobkowej</xsl:when>
			<xsl:when test="$row_name = 'D_3'">Nabycie przez opiekuna prawa do świadczeń, o których mowa w art. 17 ust. 5 pkt 1 ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych (Dz. U. z 2015 r. poz. 114, z późn. zm.) w brzmieniu obowiązującym w dniu 31 grudnia 2012 r.</xsl:when>
			<xsl:when test="$row_name = 'D_4'">Umieszczenie osoby wymagającej opieki w rodzinie zastępczej lub w placówce zapewniającej całodobową opiekę, o których mowa w art. 17 ust. 5 pkt 2 lit. b ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych w brzmieniu obowiązującym w dniu 31 grudnia 2012 r.</xsl:when>
			<xsl:when test="$row_name = 'D_5'">Ustalenie dla członka rodziny opiekuna prawa do dodatku do zasiłku rodzinnego, o którym mowa w art. 10 ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych, albo do świadczenia pielęgnacyjnego</xsl:when>
			<xsl:when test="$row_name = 'D_6'">Nabycie przez członka rodziny na osobę wymagającą opieki uprawnienia za granicą do świadczenia na pokrycie wydatków związanych z opieką</xsl:when>
			<xsl:when test="$row_name = 'D_7'">Rezygnacja opiekuna z zasiłku dla opiekuna</xsl:when>
			<xsl:when test="$row_name = 'D_8'">Śmierć opiekuna</xsl:when>
			<xsl:when test="$row_name = 'D_9'">Śmierć osoby wymagającej opieki</xsl:when>
			<xsl:when test="$row_name = 'D_10'">Zaprzestanie sprawowania opieki</xsl:when>
			<xsl:when test="$row_name = 'D_11'">Zmiana miejsca zamieszkania</xsl:when>
			<xsl:when test="$row_name = 'D_12'">Inna przyczyna</xsl:when>
			<xsl:when test="$row_name = 'D_13'">Liczba decyzji w sprawach dotyczących zasiłku dla opiekuna, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D_13.1'">liczba decyzji przyznających prawo do zasiłku dla opiekuna w związku z uzyskaniem nowego orzeczenia o niepełnosprawności lub orzeczenia o znacznym stopniu niepełnosprawności</xsl:when>
			<xsl:when test="$row_name = 'E_1'">córka/syn na matkę/ojca</xsl:when>
			<xsl:when test="$row_name = 'E_2'">matka/ojciec na córkę/syna</xsl:when>
			<xsl:when test="$row_name = 'E_3'">wnuczka/wnuk na babcię/dziadka</xsl:when>
			<xsl:when test="$row_name = 'E_4'">babcia/dziadek na wnuczkę/wnuka</xsl:when>
			<xsl:when test="$row_name = 'E_5'">siostra/brat na siostrę/brata</xsl:when>
			<xsl:when test="$row_name = 'E_6'">opiekun faktyczny osoby wymagającej opieki</xsl:when>
			<xsl:when test="$row_name = 'E_7'">inna relacja</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Row-description">
		<td class="tab_row_no">
			<xsl:value-of select="concat(substring-after(name(), '_'), '.')"/>
		</td>
		<td class="row_descr">
			<xsl:call-template name="Rows-description">
				<xsl:with-param name="row_name" select="name()"/>
			</xsl:call-template>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwoty-i-liczby-kw-narast-koord-header">
		<xsl:param name="grouphdr1" select="'Wydatki narastająco od początku roku w zł'"/>
		<xsl:param name="grouphdr2" select="'Liczba zasiłków narastająco od początku roku'"/>
		<xsl:param name="descrwidth" select="26"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(round((100-number($descrwidth)-3) div 2))"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 4))"/>
		</xsl:param>
		<xsl:param name="double">
			<xsl:value-of select="string(number($single) * 2)"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="3">L.p.</th>
				<th rowspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr1"/>
				</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr2"/>
				</th>
			</tr>
			<tr>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy<br/>miesiąc<br/>kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>dwa<br/>miesiące<br/>kwartału</th>
				<th colspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>trzy miesiące kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy<br/>miesiąc<br/>kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>dwa<br/>miesiące<br/>kwartału</th>
				<th colspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>trzy miesiące kwartału</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>razem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym:<br/>w ramach<br/>koordynacji</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>razem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym:<br/>w ramach<br/>koordynacji</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
				<td class="tab_col_no">7</td>
				<td class="tab_col_no">8</td>
				<td class="tab_col_no">9</td>
				<td class="tab_col_no">10</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwoty-kw-narast-header">
		<xsl:param name="remark" select="'1)'"/>
		<xsl:param name="grouphdr" select="'Kwoty narastająco od początku roku w zł'"/>
		<xsl:param name="descrwidth" select="63"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(100-number($descrwidth)-3)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">L.p.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
					<xsl:if test="$remark">
						<sup>
							<xsl:value-of select="$remark"/>
						</sup>
					</xsl:if>
				</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>dwa miesiące kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzy miesiące kwartału</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwoty-kw-nienarast-header">
		<xsl:param name="remark"/>
		<xsl:param name="grouphdr" select="'Wykonanie miesięczne'"/>
		<xsl:param name="descrwidth" select="63"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(100-number($descrwidth)-3)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">L.p.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
					<xsl:if test="$remark">
						<sup>
							<xsl:value-of select="$remark"/>
						</sup>
					</xsl:if>
				</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>drugi miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzeci miesiąc kwartału</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_A">
		<xsl:call-template name="Kwoty-i-liczby-kw-narast-koord">
			<xsl:with-param name="grouphdr1" select="'Wydatki narastająco od początku roku w zł'"/>
			<xsl:with-param name="grouphdr2" select="'Liczba zasiłków narastająco od początku roku'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_B">
		<xsl:call-template name="Kwoty-i-liczby-kw-narast-koord">
			<xsl:with-param name="grouphdr1" select="'Wydatki narastająco od początku roku w zł'"/>
			<xsl:with-param name="grouphdr2" select="'Liczba składek narastająco od początku roku'"/>
		</xsl:call-template>
		<table style="padding-top: 6px;" width="600" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" valign="top">1)</td>
				<td class="remark">
					Dotyczy ustawy z dnia 13 października 1998 r. o systemie ubezpieczeń społecznych (Dz.U. z 2015 r. poz. 121, z późn. zm.).
				</td>
			</tr>
			<tr>
				<td class="stars" valign="top">2)</td>
				<td class="remark">
					Dotyczy ustawy z dnia 20 grudnia 1990 r. o ubezpieczeniu społecznym rolników (Dz.U. z 2015 r. poz. 704, z późn. zm.).
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_C">
		<xsl:call-template name="Kwoty-kw-narast"/>
		<table style="padding-top: 6px;" width="200" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" valign="top">1)</td>
				<td class="remark">
					Zasada narastania nie dotyczy wiersza 1.
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<xsl:template match="Część_D">
		<xsl:call-template name="Kwoty-kw-nienarast"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_E">
		<xsl:call-template name="Kwoty-kw-nienarast"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwoty-i-liczby-kw-narast-koord">
		<xsl:param name="grouphdr1"/>
		<xsl:param name="grouphdr2"/>
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Kwoty-i-liczby-kw-narast-koord-header">
				<xsl:with-param name="grouphdr1" select="$grouphdr1"/>
				<xsl:with-param name="grouphdr2" select="$grouphdr2"/>
			</xsl:call-template>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Kwoty-i-liczby-kw-narast-koord-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-i-liczby-kw-narast-koord-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Narast-koord-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Kwoty-narastająco'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Narast-koord-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Liczby-narastająco'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Narast-koord-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Razem'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Koord'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-narast">
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Kwoty-kw-narast-header"/>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Kwoty-kw-narast-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-narast-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Narast-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Narast-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Trzy-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-nienarast">
		<xsl:call-template name="Table-caption">
			<xsl:with-param name="width" select="$width"/>
		</xsl:call-template>
		<table border="2" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Kwoty-kw-nienarast-header"/>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Kwoty-kw-nienarast-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-nienarast-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Nienarast-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Nienarast-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Column">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="skladniki"/>
		<xsl:param name="format"/>
		<xsl:variable name="item" select="descendant-or-self::*[name(.) = $column]"/>
		<xsl:variable name="subtree_item" select="*[name(.) = $subtree]/descendant-or-self::*[name(.) = $column]"/>
		<xsl:variable name="contents">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="$subtree_item"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$item"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="suma">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string(number($contents)) = 'NaN'">
							<div style="color: red; text-align: center;">???</div>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<!--
	=============================================================================================
	-->
	<xsl:template name="suma">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents"/>
		<xsl:param name="format"/>
		<xsl:param name="skladniki"/>
		<xsl:variable name="wynik">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="sum(../*[contains($skladniki,concat(name(.),' '))]/*[name(.) = $subtree]/descendant-or-self::*[name(.) = $column])"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="sum(../*[contains($skladniki,concat(name(.),' '))]/descendant-or-self::*[name(.) = $column])"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string(number($wynik)) = 'NaN'">
				<td class="totals" style="background-color: red">
					<center>???</center>
				</td>
			</xsl:when>
			<xsl:when test="string(number($contents)) != 'NaN' and $contents != ''">
				<xsl:choose>
					<xsl:when test="$contents != $wynik">
						<td class="contents error">
							<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
							<br/>
							<xsl:value-of select="concat('powinno być: ', format-number($wynik, $format))"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($wynik, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
