<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="obsada" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'944'"/>
	<xsl:variable name="widthTabSmall" select="'690'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
					.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
											font-weight: bold; text-align: right;
											width: <xsl:value-of select="$width"/>px;
										}
					.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
											font-weight: bold; text-align: center;
										}
					.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
											font-weight: bold;
										}
					.heading_1  	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
											font-weight: bold; text-align: center;
											width: <xsl:value-of select="$width"/>px;
										}
					.data_table	{border: 1px solid black; border-collapse: collapse;
											color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal;
										}
					.bottom_table {width: 690px; border-width: 0px;}
					th          		{padding: 5px; font-weight: bold; border: 1px solid black;}
					caption     	{color: #000000; font-family: Tahoma, Verdana;
											text-align: left; font-size: 14px; font-weight: bold;
											margin-bottom: 0.4em;
										}
					.tab_col_no	{text-align: center; font-size: 8px;
											border: 1px solid black; padding: 5px;
										}
					.tab_row_no	{padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
											text-align: left; border: 1px solid black;
										}
					.contents		{padding: 5px; text-align: right; border: 1px solid black;}
					.totals     		{padding: 5px; text-align: right; border: 1px solid black;}
					.blad				{background-color: red; font-weight: bold;}
					.row_descr	{padding: 5px; text-align: left; border: 1px solid black;}
					.remark			{padding-left: 8px; text-align: justify; vertical-align: baseline;
											color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
											padding-top: 4px; font-weight: normal;
										}
					.stars      		{padding-left: 2px; text-align: left; vertical-align: super;
											color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
											padding-top: 2px; font-weight: normal;
										}
					.stopka			{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal; width: 500px;
										}
				</style>
			</head>
			<body>
				<xsl:apply-templates select="SDS-G"/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="SDS-G">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Część_A"/>
		<xsl:apply-templates select="Część_B"/>
		<xsl:apply-templates select="Część_C"/>
		<xsl:apply-templates select="Część_D"/>
		<xsl:apply-templates select="Część_E"/>
		<xsl:apply-templates select="Część_F"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/>
				<br/>
				<br/>
			</div>
		</xsl:if>
		<xsl:for-each select="../Nagłówek/Dane-jednostki-org">
			<table cellspacing="0" cellpadding="0">
				<tr>
					<td class="stamp" colspan="2">
						<xsl:value-of select="Pełna-nazwa"/>
					</td>
				</tr>
				<xsl:for-each select="Adres-pocztowy">
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Ulica-i-numer"/>
						</td>
					</tr>
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Kod-i-poczta"/>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="stamp" style="font-size: 12px; text-align: left">
						<xsl:for-each select="Telefon">
							Tel. <xsl:apply-templates/>&#160;
 						</xsl:for-each>
					</td>
					<td class="stamp" style="font-size: 12px; text-align: right">
						<xsl:for-each select="Faks">
							&#160;Fax <xsl:apply-templates/>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:for-each>
		<br/>
		<br/>
		<div class="auth_name">
			<xsl:for-each select="../Nagłówek">
				<xsl:for-each select="Wojewoda">
					Wojewoda <xsl:apply-templates/>
				</xsl:for-each>
				<xsl:for-each select="Gmina">
					Gmina <xsl:apply-templates/>
				</xsl:for-each>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
		<div class="heading_1">
			<xsl:if test="../Nagłówek/Wojewoda">
				ZBIORCZE 
			</xsl:if>
			SPRAWOZDANIE RZECZOWO-FINANSOWE Z WYKONYWANIA PRZEZ ORGAN WŁAŚCIWY (GMINĘ)<br/>ZADAŃ Z ZAKRESU RZĄDOWEGO PROGRAMU &quot;DOBRY START&quot;
			<xsl:for-each select="Za-okres">
				<xsl:value-of select="concat(' ZA ', Rok, ' R.')"/>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table class="stopka">
			<caption class="stopka">Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td>imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td>telefon służbowy:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>e-mail służbowy:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
			<tr>
				<td>Data sporządzenia sprawozdania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
		</table>
	</xsl:template>

	<!--
	=============================================================================================
	-->
	<xsl:template name="Tables-description">
		<xsl:param name="table_name"/>
		<xsl:choose>
			<xsl:when test="$table_name = 'Część_A'">Wydatki na świadczenie dobry start sfinansowane z dotacji celowej z budżetu państwa oraz liczba przyznanych i wypłaconych świadczeń</xsl:when>
			<xsl:when test="$table_name = 'Część_B'">Informacje na temat należności z tytułu nienależnie pobranego świadczenia dobry start</xsl:when>
			<xsl:when test="$table_name = 'Część_C'">Informacje o odzyskanych nienależnie pobranych świadczeniach dobry start</xsl:when>
			<xsl:when test="$table_name = 'Część_D'">Informacje uzupełniające o realizacji świadczenia dobry start</xsl:when>
			<xsl:when test="$table_name = 'Część_E'">Informacje o przyczynie wypłacenia świadczenia dobry start</xsl:when>
			<xsl:when test="$table_name = 'Część_F'">Informacje na temat finansowania świadczenia dobry start i kosztów jego obsługi</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Table-caption">
		<caption>
			<xsl:value-of select="concat(substring-after(name(.), '_'), '. ')"/>
			<xsl:call-template name="Tables-description">
				<xsl:with-param name="table_name" select="name()"/>
			</xsl:call-template>
		</caption>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Rows-description">
		<xsl:param name="row_name"/>
		<xsl:choose>
			<xsl:when test="$row_name = 'A_1'">Świadczenie dobry start, w tym:</xsl:when>
			<xsl:when test="$row_name = 'A_1.1'">- w związku ze sprawowaniem opieki naprzemiennej nad dzieckiem</xsl:when>
			<xsl:when test="$row_name = 'B_1'">Stan należności z tytułu nienależnie pobranych świadczeń dobry start na ostatni dzień roku</xsl:when>
			<xsl:when test="$row_name = 'B_2'">Kwota umorzonych nienależnie pobranych świadczeń dobry start</xsl:when>
			<xsl:when test="$row_name = 'B_3'">Kwota nienależnie pobranych świadczeń dobry start potrącona z bieżąco wypłacanych świadczeń</xsl:when>
			<xsl:when test="$row_name = 'B_4'">Kwota nienależnie pobranych świadczeń dobry start wygaszona na podstawie § 31 ust. 11 rozporządzenia<sup>1)</sup></xsl:when>

			<xsl:when test="$row_name = 'C_1'">Kwota odzyskanych nienależnie pobranych świadczeń dobry start, w tym:</xsl:when>
			<xsl:when test="$row_name = 'C_1.1'">- podlegająca zwrotowi do budżetu państwa</xsl:when>
			
			<xsl:when test="$row_name = 'D_1'">Liczba wniosków dotyczących świadczenia dobry start złożonych do organu właściwego, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D_1.1'">- o przyznanie świadczenia</xsl:when>
			<xsl:when test="$row_name = 'D_1.2'">- przekazanych według właściwości</xsl:when>
			<xsl:when test="$row_name = 'D_1.3'">- pozostawionych bez rozpatrzenia, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D_1.3.1'">- z powodu złożenia wniosku o ustalenie prawa do świadczenia dobry start po 30 listopada danego roku</xsl:when>
			<xsl:when test="$row_name = 'D_1.3.2'">- z powodu niewywiązania się z obowiązku poprawienia/uzupełnienia danych w wyznaczonym terminie</xsl:when>
			<xsl:when test="$row_name = 'D_2'">Liczba wniosków dotyczących świadczenia dobry start złożonych do organu właściwego za pomocą systemu teleinformatycznego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'D_2.1'">- utworzonego przez ministra właściwego do spraw rodziny (tzw. Emp@tia)(§ 13 ust. 1 pkt 1 rozporządzenia<sup>1)</sup>)</xsl:when>
			<xsl:when test="$row_name = 'D_2.2'">- systemu banków krajowych oraz spółdzielczych kas oszczędnościowo-kredytowych świadczących usługi drogą elektroniczną (§ 13 ust. 1 pkt 2 rozporządzenia<sup>1)</sup>)</xsl:when>
			<xsl:when test="$row_name = 'D_3'">Liczba decyzji wydanych przez organ właściwy odmawiających prawa do świadczenia dobry start</xsl:when>
			<xsl:when test="$row_name = 'D_4'">Liczba decyzji wydanych przez organ właściwy w sprawie nienależnie pobranego świadczenia dobry start</xsl:when>
			<xsl:when test="$row_name = 'D_5'">Liczba spraw, w których organ właściwy wygasił nienależnie pobrane świadczenie dobry start na podstawie § 31 ust. 11 rozporządzenia<sup>1)</sup></xsl:when>
			
			<xsl:when test="$row_name = 'E_1'">Liczba dzieci (i osób uczących się), na które wypłacono świadczenie dobry start, z tego:</xsl:when>
			<xsl:when test="$row_name = 'E_1.1'">-  w związku z okolicznością, o której mowa w § 4 ust. 2 pkt 1 rozporządzenia<sup>1)</sup></xsl:when>
			<xsl:when test="$row_name = 'E_1.2'">-  w związku z okolicznością, o której mowa w § 4 ust. 2 pkt 2 rozporządzenia<sup>1)</sup></xsl:when>
			<xsl:when test="$row_name = 'E_1.3'">- w związku z okolicznością, o której mowa w § 4 ust. 3 pkt 1 rozporządzenia<sup>1)</sup></xsl:when>
			<xsl:when test="$row_name = 'E_1.4'">- w związku z okolicznością, o której mowa w § 4 ust. 3 pkt 2 rozporządzenia<sup>1)</sup></xsl:when>
			<xsl:when test="$row_name = 'E_2'">Liczba dzieci (i osób uczących się), na które wypłacono świadczenie dobry start w związku z rozpoczęciem roku szkolnego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'E_2.1'">- w szkole podstawowej</xsl:when>
			<xsl:when test="$row_name = 'E_2.2'">- w szkole ponadpodstawowej</xsl:when>
			<xsl:when test="$row_name = 'E_2.3'">- w dotychczasowym gimnazjum lub dotychczasowej szkole   ponadgimnazjalnej</xsl:when>
			<xsl:when test="$row_name = 'E_2.4'">- w szkole artystycznej, w której jest realizowany obowiązek szkolny lub nauki</xsl:when>
			<xsl:when test="$row_name = 'E_2.5'">- w młodzieżowym ośrodku socjoterapii</xsl:when>
			<xsl:when test="$row_name = 'E_2.6'">- w specjalnym ośrodku szkolno-wychowawczym</xsl:when>
			<xsl:when test="$row_name = 'E_2.7'">- w specjalnym ośrodku wychowawczym</xsl:when>
			<xsl:when test="$row_name = 'E_2.8'">- w ośrodku rewalidacyjno-wychowawczym</xsl:when>

			<xsl:when test="$row_name = 'F_1'">Otrzymana z budżetu państwa kwota dotacji na realizację przez organ właściwy świadczenia dobry start i koszty jego obsługi</xsl:when>
			<xsl:when test="$row_name = 'F_2'">Przysługująca z budżetu państwa organowi właściwemu kwota dotacji na koszty obsługi</xsl:when>
			<xsl:when test="$row_name = 'F_3'">Wydatki na obsługę świadczenia dobry start, z tego:</xsl:when>
			<xsl:when test="$row_name = 'F_3.1'">- wydatki na wynagrodzenia osób zatrudnionych na podstawie umowy o pracę do realizacji związanych ze świadczeniem</xsl:when>
			<xsl:when test="$row_name = 'F_3.2'">- wydatki na wynagrodzenia osób zatrudnionych na podstawie umowy cywilnoprawnej do realizacji zadań związanych ze świadczeniem</xsl:when>
			<xsl:when test="$row_name = 'F_3.3'">- wydatki na dodatki dla osób realizujących zadania związane ze świadczeniem, które w związku z wykonywaniem tych zadań otrzymują wyłącznie dodatek</xsl:when>
			<xsl:when test="$row_name = 'F_3.4'">- wydatki pozostałe</xsl:when>
			<xsl:when test="$row_name = 'F_4'">Wydatki na obsługę świadczenia dobry start o sfinansowane z dotacji z budżetu państwa na realizację świadczenia, z tego:</xsl:when>
			<xsl:when test="$row_name = 'F_4.1'">- wydatki na wynagrodzenia osób zatrudnionych na podstawie umowy o pracę do realizacji zadań związanych ze świadczeniem</xsl:when>
			<xsl:when test="$row_name = 'F_4.2'">- wydatki na wynagrodzenia osób zatrudnionych na podstawie umowy cywilnoprawnej do realizacji zadań związanych ze świadczeniem</xsl:when>
			<xsl:when test="$row_name = 'F_4.3'">- wydatki na dodatki dla osób realizujących zadania związane ze świadczeniem, które w związku z wykonywaniem tych zadań otrzymują wyłącznie dodatek</xsl:when>
			<xsl:when test="$row_name = 'F_4.4'">- wydatki pozostałe</xsl:when>
			<xsl:when test="$row_name = 'F_5'">Liczba osób realizujących w ramach organu właściwego (gminy) zadania związane ze świadczeniem dobry start, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F_5.1'">- zatrudnionych na podstawie umowy o pracę (w przeliczeniu na uśrednione pełne etaty)</xsl:when>
			<xsl:when test="$row_name = 'F_5.2'">- zatrudnionych na podstawie umowy cywilnoprawnej</xsl:when>
			<xsl:when test="$row_name = 'F_5.3'">- innych, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F_5.3.1'">- zatrudnionych na podstawie umowy o pracę, a otrzymujących wyłącznie dodatek za realizację zadań związanych ze świadczeniem</xsl:when>
			<xsl:when test="$row_name = 'F_5.3.2'">- zatrudnionych na podstawie umowy o pracę, a otrzymujących wyłącznie nagrody/premie  za realizację zadań związanych ze świadczeniem</xsl:when>
			
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Row-description">
		<td class="tab_row_no">
			<xsl:value-of select="concat(substring-after(name(), '_'), '.')"/>
		</td>
		<td class="row_descr">
			<xsl:call-template name="Rows-description">
				<xsl:with-param name="row_name" select="name()"/>
			</xsl:call-template>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Stopka-tabeli">
		<xsl:param name="remark1"/>
		<xsl:param name="remark2"/>
		<xsl:param name="remark3"/>
		<table class="bottom_table" cellspacing="0" cellpadding="0">
			<xsl:if test="$remark1">
				<xsl:call-template name="Stopka-tabeli-wiersz">
					<xsl:with-param name="numer" select="'1'"/>
					<xsl:with-param name="opis" select="$remark1"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$remark2">
				<xsl:call-template name="Stopka-tabeli-wiersz">
					<xsl:with-param name="numer" select="'2'"/>
					<xsl:with-param name="opis" select="$remark2"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$remark3">
				<xsl:call-template name="Stopka-tabeli-wiersz">
					<xsl:with-param name="numer" select="'3'"/>
					<xsl:with-param name="opis" select="$remark3"/>
				</xsl:call-template>
			</xsl:if>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka-tabeli-wiersz">
		<xsl:param name="numer"/>
		<xsl:param name="opis"/>
		<tr>
			<td class="stars">
				<xsl:value-of select="$numer"/>)
			</td>
			<td class="remark">
				<xsl:value-of select="$opis"/>
			</td>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_A">
		<xsl:call-template name="Kwoty-i-liczby"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_B">
		<xsl:call-template name="Kwota-w-roku"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy rozporządzenia Rady Ministrów z dnia 30 maja 2018 r. w sprawie szczegółowych warunków realizacji rządowego programu &quot;Dobry start&quot; (Dz.U. poz. 1061).'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_C">
		<xsl:call-template name="Kwota-w-roku"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_D">
		<xsl:call-template name="Wykonanie"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy rozporządzenia Rady Ministrów z dnia 30 maja 2018 r. w sprawie szczegółowych warunków realizacji rządowego programu &quot;Dobry start&quot;.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_E">
		<xsl:call-template name="Wykonanie"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy rozporządzenia Rady Ministrów z dnia 30 maja 2018 r. w sprawie szczegółowych warunków realizacji rządowego programu &quot;Dobry start&quot;.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_F">
		<xsl:call-template name="Wykonanie"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwoty-i-liczby">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-i-liczby-header"/>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Kwoty-i-liczby-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-i-liczby-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Wydatki'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Liczba-swiadczen-przyznanych'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Liczba-swiadczen-wyplaconych'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwota-w-roku">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$widthTabSmall"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Wykonanie-header">
				<xsl:with-param name="grouphdr" select="'Kwota w roku w zł'"/>
			</xsl:call-template>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Kwota-w-roku-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwota-w-roku-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Kwota-w-roku'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$widthTabSmall"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Wykonanie-header"/>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Wykonanie-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Wykonanie'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwoty-i-liczby-header">
		<xsl:param name="descrwidth" select="48"/>
		<xsl:param name="lpwidth" select="4"/>
		<xsl:param name="quadruple">
			<xsl:value-of select="string(100-number($descrwidth)-$lpwidth)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($quadruple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="{$lpwidth}%">L.p.</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Wydatki poniesione<br/>w roku w zł</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Liczba świadczeń przyznanych w roku</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Liczba świadczeń wypłaconych w roku</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie-header">
		<xsl:param name="grouphdr" select="'Wykonanie roczne'"/>
		<xsl:param name="descrwidth" select="73"/>
		<xsl:param name="lpwidth" select="5"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(100-number($descrwidth)-$lpwidth)"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="{$lpwidth}%">L.p.</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
				</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Column">
		<xsl:param name="column"/>
		<xsl:param name="skladniki"/>
		<xsl:param name="format"/>
		<xsl:variable name="item" select="descendant-or-self::*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="suma">
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$item"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string(number($item)) = 'NaN'">
							<div style="color: red; text-align: center;">???</div>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($item, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="suma">
		<xsl:param name="column"/>
		<xsl:param name="contents"/>
		<xsl:param name="format"/>
		<xsl:param name="skladniki"/>
		<xsl:variable name="wynik">
			<xsl:if test="$skladniki">
				<xsl:value-of select="sum(../*[contains($skladniki,concat(name(.),' '))]/descendant-or-self::*[name(.) = $column])"/>
			</xsl:if>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string(number($wynik)) = 'NaN'">
				<td class="totals blad">
					<center>???</center>
				</td>
			</xsl:when>
			<xsl:when test="string(number($contents)) != 'NaN' and $contents != ''">
				<xsl:choose>
					<xsl:when test="$contents != $wynik">
						<td class="contents blad">
							<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
							<br/>
							<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($wynik, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
