package pl.topteam.swiadczenia.sprawozdania.rodzinne_1_04c;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import pl.topteam.sprawozdania.reflect.Deskryptory;
import pl.topteam.sprawozdania.reflect.Składniki;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Część__A_2_Validator implements ConstraintValidator<Część__A_2_Constraint, Część__A_2> {
	private static final Graph<Field> SKŁADNIKI = Składniki.składniki(Część__A_2.class);
	
	@Override
	public void initialize(Część__A_2_Constraint adnotacja) {
	}
	
	@Override
	public boolean isValid(Część__A_2 część, ConstraintValidatorContext kontekst) {
		boolean wynik = true;
		kontekst.disableDefaultConstraintViolation();
		String komunikat = kontekst.getDefaultConstraintMessageTemplate();
		for (Field pole : SKŁADNIKI.nodes()) {
			if (SKŁADNIKI.predecessors(pole).isEmpty()) {
				continue;
			}
			WydatkiIŚwiadczenia wartość = wartość(część, pole);
			Set<WydatkiIŚwiadczenia> składniki = SKŁADNIKI.predecessors(pole).stream().map(składnik -> wartość(część, składnik)).collect(ImmutableSet.toImmutableSet());
			if (wartość.getWydatkiNarastająco().getPierwszyMiesiąc() != null && składniki.stream().map(WydatkiIŚwiadczenia::getWydatkiNarastająco).map(KwotyKwNarast::getPierwszyMiesiąc).anyMatch(Objects::nonNull)) {
				if (wartość.getWydatkiNarastająco().getPierwszyMiesiąc().compareTo(składniki.stream().map(WydatkiIŚwiadczenia::getWydatkiNarastająco).map(KwotyKwNarast::getPierwszyMiesiąc).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getWydatkiNarastająco().getDwaMiesiące() != null && składniki.stream().map(WydatkiIŚwiadczenia::getWydatkiNarastająco).map(KwotyKwNarast::getDwaMiesiące).anyMatch(Objects::nonNull)) {
				if (wartość.getWydatkiNarastająco().getDwaMiesiące().compareTo(składniki.stream().map(WydatkiIŚwiadczenia::getWydatkiNarastająco).map(KwotyKwNarast::getDwaMiesiące).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("dwaMiesiące").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getWydatkiNarastająco().getTrzyMiesiące() != null && składniki.stream().map(WydatkiIŚwiadczenia::getWydatkiNarastająco).map(KwotyKwNarast::getTrzyMiesiące).anyMatch(Objects::nonNull)) {
				if (wartość.getWydatkiNarastająco().getTrzyMiesiące().compareTo(składniki.stream().map(WydatkiIŚwiadczenia::getWydatkiNarastająco).map(KwotyKwNarast::getTrzyMiesiące).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("trzyMiesiące").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaŚwiadczeń().getPierwszyMiesiąc() != null && składniki.stream().map(WydatkiIŚwiadczenia::getLiczbaŚwiadczeń).map(LiczbyKwNarast::getPierwszyMiesiąc).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaŚwiadczeń().getPierwszyMiesiąc() != składniki.stream().map(WydatkiIŚwiadczenia::getLiczbaŚwiadczeń).map(LiczbyKwNarast::getPierwszyMiesiąc).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaŚwiadczeń().getDwaMiesiące() != null && składniki.stream().map(WydatkiIŚwiadczenia::getLiczbaŚwiadczeń).map(LiczbyKwNarast::getDwaMiesiące).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaŚwiadczeń().getDwaMiesiące() != składniki.stream().map(WydatkiIŚwiadczenia::getLiczbaŚwiadczeń).map(LiczbyKwNarast::getDwaMiesiące).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("dwaMiesiące").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaŚwiadczeń().getTrzyMiesiące() != null && składniki.stream().map(WydatkiIŚwiadczenia::getLiczbaŚwiadczeń).map(LiczbyKwNarast::getTrzyMiesiące).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaŚwiadczeń().getTrzyMiesiące() != składniki.stream().map(WydatkiIŚwiadczenia::getLiczbaŚwiadczeń).map(LiczbyKwNarast::getTrzyMiesiące).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("trzyMiesiące").addPropertyNode("razem").addConstraintViolation();
					wynik = false;
				}
			}
		}
		return wynik;
	}
	
	private WydatkiIŚwiadczenia wartość(Część__A_2 część, Field składnik) {
		try {
			return (WydatkiIŚwiadczenia) DESKRYPTORY.get(składnik).getReadMethod().invoke(część);
		} catch (Exception wyjątek) {
			throw new AssertionError();
		}
	}
	
	private static final Map<Field, PropertyDescriptor> DESKRYPTORY = Deskryptory.deskryptory(Część__A_2.class);
}
