package pl.topteam.swiadczenia.sprawozdania.rodzinne_1_04c;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import pl.topteam.sprawozdania.reflect.Deskryptory;
import pl.topteam.sprawozdania.reflect.Składniki;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Część__E_Validator implements ConstraintValidator<Część__E_Constraint, Część__E> {
	private static final Graph<Field> SKŁADNIKI = Składniki.składniki(Część__E.class);
	
	@Override
	public void initialize(Część__E_Constraint adnotacja) {
	}
	
	@Override
	public boolean isValid(Część__E część, ConstraintValidatorContext kontekst) {
		boolean wynik = true;
		kontekst.disableDefaultConstraintViolation();
		String komunikat = kontekst.getDefaultConstraintMessageTemplate();
		for (Field pole : SKŁADNIKI.nodes()) {
			if (SKŁADNIKI.predecessors(pole).isEmpty()) {
				continue;
			}
			WydatkiIŚwiadczeniaWlasne wartość = wartość(część, pole);
			Set<WydatkiIŚwiadczeniaWlasne> składniki = SKŁADNIKI.predecessors(pole).stream().map(składnik -> wartość(część, składnik)).collect(ImmutableSet.toImmutableSet());
			if (wartość.getWydatkiNarastająco().getPierwszyMiesiąc() != składniki.stream().map(WydatkiIŚwiadczeniaWlasne::getWydatkiNarastająco).mapToLong(KwotyKwNarastWlasne::getPierwszyMiesiąc).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getWydatkiNarastająco().getDwaMiesiące() != składniki.stream().map(WydatkiIŚwiadczeniaWlasne::getWydatkiNarastająco).mapToLong(KwotyKwNarastWlasne::getDwaMiesiące).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("dwaMiesiące").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getWydatkiNarastająco().getTrzyMiesiące() != składniki.stream().map(WydatkiIŚwiadczeniaWlasne::getWydatkiNarastająco).mapToLong(KwotyKwNarastWlasne::getTrzyMiesiące).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("trzyMiesiące").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getLiczbaŚwiadczeń().getPierwszyMiesiąc() != null && składniki.stream().map(WydatkiIŚwiadczeniaWlasne::getLiczbaŚwiadczeń).map(LiczbyKwNarast::getPierwszyMiesiąc).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaŚwiadczeń().getPierwszyMiesiąc() != składniki.stream().map(WydatkiIŚwiadczeniaWlasne::getLiczbaŚwiadczeń).map(LiczbyKwNarast::getPierwszyMiesiąc).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaŚwiadczeń().getDwaMiesiące() != null && składniki.stream().map(WydatkiIŚwiadczeniaWlasne::getLiczbaŚwiadczeń).map(LiczbyKwNarast::getDwaMiesiące).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaŚwiadczeń().getDwaMiesiące() != składniki.stream().map(WydatkiIŚwiadczeniaWlasne::getLiczbaŚwiadczeń).map(LiczbyKwNarast::getDwaMiesiące).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("dwaMiesiące").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaŚwiadczeń().getTrzyMiesiące() != null && składniki.stream().map(WydatkiIŚwiadczeniaWlasne::getLiczbaŚwiadczeń).map(LiczbyKwNarast::getTrzyMiesiące).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaŚwiadczeń().getTrzyMiesiące() != składniki.stream().map(WydatkiIŚwiadczeniaWlasne::getLiczbaŚwiadczeń).map(LiczbyKwNarast::getTrzyMiesiące).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("trzyMiesiące").addConstraintViolation();
					wynik = false;
				}
			}
		}
		return wynik;
	}
	
	private WydatkiIŚwiadczeniaWlasne wartość(Część__E część, Field składnik) {
		try {
			return (WydatkiIŚwiadczeniaWlasne) DESKRYPTORY.get(składnik).getReadMethod().invoke(część);
		} catch (Exception wyjątek) {
			throw new AssertionError();
		}
	}
	
	private static final Map<Field, PropertyDescriptor> DESKRYPTORY = Deskryptory.deskryptory(Część__E.class);
}
