package pl.topteam.swiadczenia.sprawozdania.rodzinne_1_04c;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import pl.topteam.sprawozdania.reflect.Deskryptory;
import pl.topteam.sprawozdania.reflect.Składniki;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Część__UA_1_Validator implements ConstraintValidator<Część__UA_1_Constraint, Część__UA_1> {
	private static final Graph<Field> SKŁADNIKI = Składniki.składniki(Część__UA_1.class);
	
	@Override
	public void initialize(Część__UA_1_Constraint adnotacja) {
	}
	
	@Override
	public boolean isValid(Część__UA_1 czescUA1, ConstraintValidatorContext kontekst) {
		boolean wynik = true;
		kontekst.disableDefaultConstraintViolation();
		String komunikat = kontekst.getDefaultConstraintMessageTemplate();
		for (Field pole : SKŁADNIKI.nodes()) {
			if (SKŁADNIKI.predecessors(pole).isEmpty()) {
				continue;
			}
			WydatkiIŚwiadczeniaOpiekun wartosc = wartość(czescUA1, pole);
			Set<WydatkiIŚwiadczeniaOpiekun> skladniki = SKŁADNIKI.predecessors(pole).stream().map(skladnik -> wartość(czescUA1, skladnik)).collect(ImmutableSet.toImmutableSet());
			if (wartosc.getWydatkiNarastająco().getPierwszyMiesiąc() != skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getWydatkiNarastająco).mapToLong(KwotyKwNarastOpiekun::getPierwszyMiesiąc).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
				wynik = false;
			}
			if (wartosc.getWydatkiNarastająco().getDwaMiesiące() != skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getWydatkiNarastająco).mapToLong(KwotyKwNarastOpiekun::getDwaMiesiące).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("dwaMiesiące").addConstraintViolation();
				wynik = false;
			}
			if (wartosc.getWydatkiNarastająco().getTrzyMiesiące().getRazem() != skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getWydatkiNarastająco).map(KwotyKwNarastOpiekun::getTrzyMiesiące).mapToLong(OpiekunKwota::getRazem).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("trzyMiesiące").addPropertyNode("razem").addConstraintViolation();
				wynik = false;
			}
			if (wartosc.getWydatkiNarastająco().getTrzyMiesiące().getOpiekun() != null && skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getWydatkiNarastająco).map(KwotyKwNarastOpiekun::getTrzyMiesiące).map(OpiekunKwota::getOpiekun).anyMatch(Objects::nonNull)) {
				if ((long) wartosc.getWydatkiNarastająco().getTrzyMiesiące().getOpiekun() != skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getWydatkiNarastająco).map(KwotyKwNarastOpiekun::getTrzyMiesiące).map(OpiekunKwota::getOpiekun).filter(Objects::nonNull).mapToLong(Number::longValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("trzyMiesiące").addPropertyNode("opiekun").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartosc.getLiczbaŚwiadczeń().getPierwszyMiesiąc() != null && skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getLiczbaŚwiadczeń).map(LiczbyKwNarastOpiekun::getPierwszyMiesiąc).anyMatch(Objects::nonNull)) {
				if ((int) wartosc.getLiczbaŚwiadczeń().getPierwszyMiesiąc() != skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getLiczbaŚwiadczeń).map(LiczbyKwNarastOpiekun::getPierwszyMiesiąc).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartosc.getLiczbaŚwiadczeń().getDwaMiesiące() != null && skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getLiczbaŚwiadczeń).map(LiczbyKwNarastOpiekun::getDwaMiesiące).anyMatch(Objects::nonNull)) {
				if ((int) wartosc.getLiczbaŚwiadczeń().getDwaMiesiące() != skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getLiczbaŚwiadczeń).map(LiczbyKwNarastOpiekun::getDwaMiesiące).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("dwaMiesiące").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartosc.getLiczbaŚwiadczeń().getTrzyMiesiące().getRazem() != null && skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getLiczbaŚwiadczeń).map(LiczbyKwNarastOpiekun::getTrzyMiesiące).map(OpiekunLiczba::getRazem).anyMatch(Objects::nonNull)) {
				if ((int) wartosc.getLiczbaŚwiadczeń().getTrzyMiesiące().getRazem() != skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getLiczbaŚwiadczeń).map(LiczbyKwNarastOpiekun::getTrzyMiesiące).map(OpiekunLiczba::getRazem).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("trzyMiesiące").addPropertyNode("razem").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartosc.getLiczbaŚwiadczeń().getTrzyMiesiące().getOpiekun() != null && skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getLiczbaŚwiadczeń).map(LiczbyKwNarastOpiekun::getTrzyMiesiące).map(OpiekunLiczba::getOpiekun).anyMatch(Objects::nonNull)) {
				if ((int) wartosc.getLiczbaŚwiadczeń().getTrzyMiesiące().getOpiekun() != skladniki.stream().map(WydatkiIŚwiadczeniaOpiekun::getLiczbaŚwiadczeń).map(LiczbyKwNarastOpiekun::getTrzyMiesiące).map(OpiekunLiczba::getOpiekun).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("trzyMiesiące").addPropertyNode("opiekun").addConstraintViolation();
					wynik = false;
				}
			}
		}
		return wynik;
	}
	
	private WydatkiIŚwiadczeniaOpiekun wartość(Część__UA_1 część, Field składnik) {
		try {
			return (WydatkiIŚwiadczeniaOpiekun) DESKRYPTORY.get(składnik).getReadMethod().invoke(część);
		} catch (Exception wyjątek) {
			throw new AssertionError();
		}
	}
	
	private static final Map<Field, PropertyDescriptor> DESKRYPTORY = Deskryptory.deskryptory(Część__UA_1.class);
}
