package pl.topteam.swiadczenia.sprawozdania.rodzinne_1_04d;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import pl.topteam.sprawozdania.reflect.Deskryptory;
import pl.topteam.sprawozdania.reflect.Składniki;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Część__A_1_Validator implements ConstraintValidator<Część__A_1_Constraint, Część__A_1> {
	private static final Graph<Field> SKŁADNIKI = Składniki.składniki(Część__A_1.class);
	
	@Override
	public void initialize(Część__A_1_Constraint adnotacja) {
	}
	
	@Override
	public boolean isValid(Część__A_1 część, ConstraintValidatorContext kontekst) {
		boolean wynik = true;
		kontekst.disableDefaultConstraintViolation();
		String komunikat = kontekst.getDefaultConstraintMessageTemplate();
		for (Field pole : SKŁADNIKI.nodes()) {
			if (SKŁADNIKI.predecessors(pole).isEmpty()) {
				continue;
			}
			WydatkiIŚwiadczeniaKoord wartość = wartość(część, pole);
			Set<WydatkiIŚwiadczeniaKoord> składniki = SKŁADNIKI.predecessors(pole).stream().map(składnik -> wartość(część, składnik)).collect(ImmutableSet.toImmutableSet());
			if (wartość.getWydatkiNarastająco().getPierwszyMiesiąc() != składniki.stream().map(WydatkiIŚwiadczeniaKoord::getWydatkiNarastająco).mapToLong(KwotyKwNarastKoord::getPierwszyMiesiąc).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getWydatkiNarastająco().getDwaMiesiące() != składniki.stream().map(WydatkiIŚwiadczeniaKoord::getWydatkiNarastająco).mapToLong(KwotyKwNarastKoord::getDwaMiesiące).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("dwaMiesiące").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getWydatkiNarastająco().getTrzyMiesiące().getRazem() != składniki.stream().map(WydatkiIŚwiadczeniaKoord::getWydatkiNarastająco).map(KwotyKwNarastKoord::getTrzyMiesiące).mapToLong(KoordKwota::getRazem).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("trzyMiesiące").addPropertyNode("razem").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getWydatkiNarastająco().getTrzyMiesiące().getKoord() != null && składniki.stream().map(WydatkiIŚwiadczeniaKoord::getWydatkiNarastająco).map(KwotyKwNarastKoord::getTrzyMiesiące).map(KoordKwota::getKoord).anyMatch(Objects::nonNull)) {
				if ((long) wartość.getWydatkiNarastająco().getTrzyMiesiące().getKoord() != składniki.stream().map(WydatkiIŚwiadczeniaKoord::getWydatkiNarastająco).map(KwotyKwNarastKoord::getTrzyMiesiące).map(KoordKwota::getKoord).filter(Objects::nonNull).mapToLong(Number::longValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("trzyMiesiące").addPropertyNode("koord").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaŚwiadczeń().getPierwszyMiesiąc() != null && składniki.stream().map(WydatkiIŚwiadczeniaKoord::getLiczbaŚwiadczeń).map(LiczbyKwNarastKoord::getPierwszyMiesiąc).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaŚwiadczeń().getPierwszyMiesiąc() != składniki.stream().map(WydatkiIŚwiadczeniaKoord::getLiczbaŚwiadczeń).map(LiczbyKwNarastKoord::getPierwszyMiesiąc).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaŚwiadczeń().getDwaMiesiące() != null && składniki.stream().map(WydatkiIŚwiadczeniaKoord::getLiczbaŚwiadczeń).map(LiczbyKwNarastKoord::getDwaMiesiące).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaŚwiadczeń().getDwaMiesiące() != składniki.stream().map(WydatkiIŚwiadczeniaKoord::getLiczbaŚwiadczeń).map(LiczbyKwNarastKoord::getDwaMiesiące).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("dwaMiesiące").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaŚwiadczeń().getTrzyMiesiące().getRazem() != null && składniki.stream().map(WydatkiIŚwiadczeniaKoord::getLiczbaŚwiadczeń).map(LiczbyKwNarastKoord::getTrzyMiesiące).map(KoordLiczba::getRazem).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaŚwiadczeń().getTrzyMiesiące().getRazem() != składniki.stream().map(WydatkiIŚwiadczeniaKoord::getLiczbaŚwiadczeń).map(LiczbyKwNarastKoord::getTrzyMiesiące).map(KoordLiczba::getRazem).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("trzyMiesiące").addPropertyNode("razem").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaŚwiadczeń().getTrzyMiesiące().getKoord() != null && składniki.stream().map(WydatkiIŚwiadczeniaKoord::getLiczbaŚwiadczeń).map(LiczbyKwNarastKoord::getTrzyMiesiące).map(KoordLiczba::getKoord).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaŚwiadczeń().getTrzyMiesiące().getKoord() != składniki.stream().map(WydatkiIŚwiadczeniaKoord::getLiczbaŚwiadczeń).map(LiczbyKwNarastKoord::getTrzyMiesiące).map(KoordLiczba::getKoord).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaŚwiadczeń").addPropertyNode("trzyMiesiące").addPropertyNode("koord").addConstraintViolation();
					wynik = false;
				}
			}
		}
		return wynik;
	}
	
	private WydatkiIŚwiadczeniaKoord wartość(Część__A_1 część, Field składnik) {
		try {
			return (WydatkiIŚwiadczeniaKoord) DESKRYPTORY.get(składnik).getReadMethod().invoke(część);
		} catch (Exception wyjątek) {
			throw new AssertionError();
		}
	}
	
	private static final Map<Field, PropertyDescriptor> DESKRYPTORY = Deskryptory.deskryptory(Część__A_1.class);
}
