package pl.topteam.swiadczenia.sprawozdania.rodzinne_1_04d;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import pl.topteam.sprawozdania.reflect.Deskryptory;
import pl.topteam.sprawozdania.reflect.Składniki;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;

public final class Część__H_2_Validator implements ConstraintValidator<Część__H_2_Constraint, Część__H_2> {
	private static final Graph<Field> SKŁADNIKI = Składniki.składniki(Część__H_2.class);
	
	@Override
	public void initialize(Część__H_2_Constraint adnotacja) {
	}
	
	@Override
	public boolean isValid(Część__H_2 część, ConstraintValidatorContext kontekst) {
		boolean wynik = true;
		kontekst.disableDefaultConstraintViolation();
		String komunikat = kontekst.getDefaultConstraintMessageTemplate();
		for (Field pole : SKŁADNIKI.nodes()) {
			if (SKŁADNIKI.predecessors(pole).isEmpty()) {
				continue;
			}
			WykonanieKwMienarast wartość = wartość(część, pole);
			Set<WykonanieKwMienarast> składniki = SKŁADNIKI.predecessors(pole).stream().map(składnik -> wartość(część, składnik)).collect(ImmutableSet.toImmutableSet());
			if (wartość.getPierwszyMiesiąc() != składniki.stream().mapToInt(WykonanieKwMienarast::getPierwszyMiesiąc).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getDrugiMiesiąc() != składniki.stream().mapToInt(WykonanieKwMienarast::getDrugiMiesiąc).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("drugiMiesiąc").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getTrzeciMiesiąc() != składniki.stream().mapToInt(WykonanieKwMienarast::getTrzeciMiesiąc).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("trzeciMiesiąc").addConstraintViolation();
				wynik = false;
			}
		}
		return wynik;
	}
	
	private WykonanieKwMienarast wartość(Część__H_2 część, Field składnik) {
		try {
			return (WykonanieKwMienarast) DESKRYPTORY.get(składnik).getReadMethod().invoke(część);
		} catch (Exception wyjątek) {
			throw new AssertionError();
		}
	}

	private static final Map<Field, PropertyDescriptor> DESKRYPTORY = Deskryptory.deskryptory(Część__H_2.class);
}
