package pl.topteam.swiadczenia.sprawozdania.zdo_1_04a;

import java.time.Year;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.threeten.extra.Quarter;
import org.threeten.extra.YearQuarter;

public final class ZaOkresAdapter extends XmlAdapter<ZaOkres, YearQuarter> {
	@Override
	public YearQuarter unmarshal(ZaOkres v) {
		if (v == null) {
			return null;
		}
		return YearQuarter.of(
			v.getRok(),
			v.getKwartał()
		);
	}
	
	@Override
	public ZaOkres marshal(YearQuarter v) {
		if (v == null) {
			return null;
		}
		ZaOkres okres = new ZaOkres();
		okres.setRok(Year.from(v));
		okres.setKwartał(Quarter.from(v));
		return okres;
	}
}
