<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet	version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:variable name="wersja" select="'1.1'"/>
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator="," />
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'" />
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'" />
	<!-- Table A & B width: AB_1 + AB_2 + 8*AB_4 + 9*2 + 2*3 -->
	<xsl:variable name="width" select="'944'" />
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
                    		.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
								font-weight: bold; text-align: right;
                                 				width: <xsl:value-of select="$width"/>px;
                                				}
                    		.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
                                 				font-weight: bold; text-decoration: underline;
                                				}
                    		.heading_1  {color: #000000; font-family: Tahoma, Verdana; font-size: 20px;
                                 				font-weight: bold; text-align: center;
                                 				width: <xsl:value-of select="$width"/>px;
                                				}
                    		.heading_2  {color: #000000; font-family: Tahoma, Verdana; font-size: 18px;
                                 				font-weight: bold;
                                				}
                    		th          		{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				font-weight: bold; text-align: center;
                                				}
                    		caption     	{color: #000000; font-family: Tahoma, Verdana;
                                 				text-align: left; font-size: medium; font-weight: bold;
                                 				margin-bottom: 0.4em;
                                				}
                    		.wide       	{width: <xsl:value-of select="$width"/>px; padding-top: 6px;
                                				}

					.AB_1       {width:   30px}
					.AB_2       {width: 260px}
					.AB_3       {width: 360px}	/* 4 * width defined for AB_4 class */
					.AB_4       {width:   90px}
					.AB_5       {width: 180px}	/* 2 * width defined for AB_4 class */

					.C_1        {width:   30px}
					.C_2        {width: 190px}
					.C_3        {width: 270px}		/* 3 * width defined for C_4 class */
					.C_4        {width:   90px}

					.tab_col_no {text-align: center; vertical-align: middle; color: #000000;
								font-family: Tahoma, Verdana; font-size: 10px;
								font-weight: normal;
								}
					.tab_row_no {padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
								color: #000000; font-family: Tahoma, Verdana; font-size: 10px;
								text-align: left; vertical-align: middle; font-weight: bold;
								}
                   			 .contents	{height: 2.5em;
                   			 			padding-right: 2px; padding-top: 2px; padding-bottom: 2px;
                                 				 color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: bold;
                                				}
                   			 .totals     	{height: 2.5em;
                   			 			padding-right: 2px; padding-top: 2px; padding-bottom: 2px;
                                 				background-color: silver; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: right; vertical-align: middle; font-weight: bold;
                                				}
                    		.row_descr	{padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
                                 				text-align: left; vertical-align: middle; font-weight: normal;
                                				}
                    		.remark		{padding-left: 8px; text-align: justify; vertical-align: middle;
                                				 color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				padding-top: 4px; font-weight: normal;
                                				}
                    		.stars      	{padding-left: 2px; text-align: left; vertical-align: top;
                                 				color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
                                 				padding-top: 4px; font-weight: normal;
                                				}
                    		.xslt_ver   	{font-family: Tahoma, Verdana; font-size: 12px;
                                 				font-weight: bold; padding-top: 24px;
                                				}
                    		.empty		{border: 0 0 0 0;}
				</style>
			</head>
			<body>
				<xsl:apply-templates select="Zaliczki-alimentacyjne"/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Zaliczki-alimentacyjne">
		<xsl:apply-templates select="Metryczka"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Część_A"/>
		<xsl:apply-templates select="Część_B"/>
		<xsl:apply-templates select="Część_C"/>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/> <br/> <br/>
			</div>
		</xsl:if>

		<xsl:for-each select="Nadawca">
			 <table cellspacing="0" cellpadding="0">
				<tr>
					<td class="stamp" colspan="2">
						<xsl:value-of select="Pełna-nazwa" />
					</td>
				</tr>
				 <xsl:for-each select="Adres-pocztowy">
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Ulica-i-numer" />
						</td>
					</tr>
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Kod-i-poczta" />
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="stamp" style="font-size: 12px; text-align: left">
						<xsl:for-each select="Telefon">
							Tel. <xsl:apply-templates/>&#160;
 						</xsl:for-each>
					</td>
					<td class="stamp" style="font-size: 12px; text-align: right">
						<xsl:for-each select="Faks">
							&#160;Fax <xsl:apply-templates />
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:for-each>

		<br/><br/>
		<div class="auth_name">
			<xsl:for-each select="../Nagłówek">
				<xsl:for-each select="Województwo">
					Województwo <xsl:apply-templates />
				</xsl:for-each>
				<xsl:for-each select="Gmina">
					Gmina <xsl:apply-templates />
				</xsl:for-each>
                    </xsl:for-each>
		</div>
		<br/><br/>
		<div class="heading_1">
			SPRAWOZDANIE RZECZOWO-FINANSOWE O WYDATKACH NA ZALICZKI ALIMENTACYJNE<br/>
			PONIESIONYCH ZE ŚRODKÓW BUDŻETU PAŃSTWA ORAZ BUDŻETÓW GMIN<br/>
			<span class="heading_2">
				<xsl:for-each select="Za-okres">
					<xsl:for-each select="Miesiąc">
						za <xsl:apply-templates />
					</xsl:for-each>
					<xsl:for-each select="Kwartał">
						za <xsl:apply-templates /> kwartał
					</xsl:for-each>
						<xsl:value-of select="concat(' ', Rok, ' r.')" />
				</xsl:for-each>
			</span>
		</div>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table width="310">
			<caption>Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td>Imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td>Podpis:</td> <td>........................................</td>
			</tr>
			<tr>
				<td>Telefon:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>Data wykonania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
		</table>

		<br/><br/>
<!--		<table class="wide" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="xslt_ver" style="text-align: left;">
					Wersja szablonu XSLT: <xsl:value-of select="$wersja"/>
				</td>
				<td class="xslt_ver" style="text-align: right;">
					<xsl:value-of select="concat('XSLT wersja ', system-property('xsl:version'), ', producent: ', system-property('xsl:vendor'))"/>
					<xsl:if test="system-property('msxsl:version')">
						<xsl:value-of select="concat(', MSXML: ', system-property('msxsl:version'))"/>
					</xsl:if>
				</td>
			</tr>
		</table>-->
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Table-caption">
		<xsl:param name="width" select="944"/>
		<table border="0">
 			<xsl:attribute name="style">
 				<xsl:if test="name() != 'Część_A'">
 					page-break-before: always;
 				</xsl:if>
 				text-align: left; font-family: Tahoma, Verdana;
 				font-size: 18px; font-weight: bold; margin-bottom: 0.4em;
 				width: <xsl:number value="$width"/>px;
			</xsl:attribute>
			<tr style="vertical-align: top;">
				<td style="width: 1.5em;">
					<xsl:value-of select="concat(substring-after(name(.), '_'), '. ')"/>
				</td>
				<td style="margin-left: 0.2em">
					<xsl:value-of select="@Opis"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Row-description">
		<xsl:param name="tabtype" select="'AB'"/>
		<td>
			<xsl:attribute name="class">
				<xsl:value-of select="concat($tabtype, '_')"/>1 tab_row_no
			</xsl:attribute>
                      <xsl:value-of select="concat(substring-after(@Pozycja, '_'), '.')" />
		</td>
		<td>
			<xsl:attribute name="class">
				<xsl:value-of select="concat($tabtype, '_')"/>2 row_descr
			</xsl:attribute>
			<xsl:value-of select="@Opis"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_A">
		<xsl:call-template name="Table-caption"/>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="860"/>
			</xsl:attribute>
			<thead>
				 <tr>
					<th class="AB_1" rowspan="2">L.p.</th>
					<th class="AB_2" rowspan="2">Wyszczególnienie</th>
					<th class="AB_3" colspan="3">Kwoty narastająco od początku roku*<br/>w złotych</th>
					<th class="AB_3" colspan="3">Liczba zaliczek dla osób<br/>uprawnionych narastająco od początku roku*</th>
				</tr>
				 <tr>
					<th class="AB_4">Pierwszy<br/>miesiąc<br/>kwartału</th>
					<th class="AB_4">Dwa<br/>miesiące<br/>kwartału</th>
					<th class="AB_4">Trzy miesiące<br/>kwartału</th>
					<th class="AB_4">Pierwszy<br/>miesiąc<br/>kwartału</th>
					<th class="AB_4">Dwa<br/>miesiące<br/>kwartału</th>
					<th class="AB_4">Trzy miesiące<br/>kwartału</th>
				</tr>
				 <tr>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
					<td class="tab_col_no">8</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Wydatki-i-świadczenia">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Wydatki-i-świadczeniobiorcy"/>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>

		<table style="padding-top: 6px;" width="860" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" width="6">*</td>
				<td class="remark">
					Liczbę świadczeń oraz wydatki ujmuje się narastająco od początku roku, np. informacja za maj ujęta
					w sprawozdaniu za II kwartał w kolumnach 4 i 7 obejmuje dane za okres od stycznia do maja włącznie.
				</td>
			</tr>
		</table>
		<br/><br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Wydatki-i-świadczeniobiorcy">
		<xsl:param name="skladniki"/>

		<xsl:call-template name="_AB_contents">
			<xsl:with-param name="subtree" select="'Wydatki-narastająco'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>

		<xsl:choose>
			<xsl:when test="Liczba-świadczeń/@xsi:nil">
				<xsl:if test="@Pozycja='A_2'">
					<td colspan="3" rowspan="5">&#160;</td>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="_AB_contents">
					<xsl:with-param name="subtree" select="'Liczba-świadczeń'"/>
					<xsl:with-param name="format" select="$liczba"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_AB_contents">
		<xsl:param name="subtree"/> <xsl:param name="format"/>
		<xsl:call-template name="_AB_column_12">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_AB_column_12">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_AB_column_12">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Trzy-miesiące'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:if test="name(..)='Część_B'">
			<td style="text-align: center; font-size: 24px;">X</td>
		</xsl:if>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_AB_column_12">
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<td class="contents">
			<xsl:choose>
				<xsl:when test="string($item/@xsi:nil) = 'true'">
					<center>X</center>
				</xsl:when>
				<xsl:when test="string(number($contents)) = 'NaN'">
					<div style="color: red; text-align: center;">???</div>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="format-number($contents, $format)"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="_AB_column_34">
		<xsl:param name="subtree"/> <xsl:param name="column"/> <xsl:param name="format"/>
		<xsl:param name="item" select="*[name(.) = $subtree]/Trzy-miesiące/*[name(.) = $column]"/>
		<xsl:param name="contents">
			<xsl:value-of select="$item"/>
		</xsl:param>
		<td class="contents">
			<xsl:choose>
				<xsl:when test="string($item/@xsi:nil) = 'true'">
					<center>X</center>
				</xsl:when>
				<xsl:when test="string(number($contents)) = 'NaN'">
					<div style="color: red; text-align: center;">???</div>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="format-number($contents, $format)"/>
				</xsl:otherwise>
			</xsl:choose>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_B">
		<xsl:call-template name="Table-caption"/>
		<table border="2" cellspacing="0" cellpadding="0">
 			<xsl:attribute name="width">
 				<xsl:number value="$width"/>
			</xsl:attribute>
			<thead>
				<tr>
					<th class="AB_1" rowspan="3">L.p.</th>
					<th class="AB_2" rowspan="3">Wyszczególnienie</th>
					<th class="AB_3" colspan="4">Narastająco od początku roku* w zł</th>
					<th class="AB_3" colspan="4">Liczba zaliczek dla osób<br/>uprawnionych narastająco od początku roku*</th>
				</tr>
				<tr>
					<th class="AB_4" rowspan="2">Pierwszy<br/>miesiąc<br />kwartału</th>
					<th class="AB_4" rowspan="2">Dwa<br/>miesiące<br />kwartału</th>
					<th class="AB_5" colspan="2">Trzy miesiące<br />kwartału</th>
					<th class="AB_4" rowspan="2">Pierwszy<br/>miesiąc<br/>kwartału</th>
					<th class="AB_4" rowspan="2">Dwa<br/>miesiące<br />kwartału</th>
					<th class="AB_5" colspan="2">Trzy miesiące<br />kwartału</th>
				</tr>
				<tr>
					<th class="AB_4">razem</th>
					<th class="AB_4">w tym:<br />z lat<br />ubiegłych</th>
					<th class="AB_4">razem</th>
					<th class="AB_4">w tym:<br />z lat<br />ubiegłych</th>
				</tr>
				<tr>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
					<td class="tab_col_no">6</td>
					<td class="tab_col_no">7</td>
					<td class="tab_col_no">8</td>
					<td class="tab_col_no">9</td>
					<td class="tab_col_no">10</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Odzyskane-świadczenia">
					<tr>
						<td class="AB_1 tab_row_no">1.</td>
						<td class="AB_2 row_descr"><xsl:value-of select="@Opis"/></td>
						<xsl:call-template name="Odzyskane-świadczenia">
							<xsl:with-param name="subtree" select="'Odzyskano-narastająco'"/>
							<xsl:with-param name="format" select="$kwota"/>
						</xsl:call-template>
						<xsl:call-template name="Odzyskane-świadczenia">
							<xsl:with-param name="subtree" select="'Liczba-świadczeń'"/>
							<xsl:with-param name="format" select="$liczba"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
				<xsl:for-each select="Wydatki-i-świadczenia">
					<tr>
						<td class="AB_1 tab_row_no">2.</td>
						<td class="AB_2 row_descr"><xsl:value-of select="@Opis"/></td>
						<xsl:call-template name="Wydatki-i-świadczeniobiorcy"/>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
                    <table class="wide" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td class="stars">*
                            </td>
                            <td class="remark">
					Liczbę świadczeń oraz wydatki ujmuje się narastająco od początku roku, np. informacja za maj ujęta
					w sprawozdaniu za II kwartał w kolumnach 4 i 8 obejmuje dane za okres od stycznia do maja włącznie.
                            </td>
                        </tr>
			<tr>
				<td class="stars" width="6">**</td>
				<td class="remark">
					Zwroty nienależnie pobranych zaliczek wykazuje się bez odsetek.
				</td>
			</tr>
			<tr>
				<td class="stars">***</td>
				<td class="remark">
					Dotyczy ustawy z dnia 22 kwietnia 2005 r. o postępowaniu wobec dłużników alimentacyjnych
					oraz zaliczce alimentacyjnej (Dz. U. nr 86, poz. 732).
				</td>
			</tr>
                    </table>
                    <br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Odzyskane-świadczenia">
		<xsl:param name="subtree"/> <xsl:param name="format"/>

		<xsl:call-template name="_AB_column_12">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_AB_column_12">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_AB_column_34">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Razem'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="_AB_column_34">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Ubiegłe'"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_C">
		<xsl:call-template name="Table-caption"/>
		<table border="2" cellspacing="0" cellpadding="0">
			<thead>
				<tr>
					<th class="C_1" rowspan="2">L.p.</th>
					<th class="C_2" rowspan="2">Wyszczególnienie</th>
					<th class="C_3" colspan="3">Wykonanie miesięczne*</th>
				</tr>
				<tr>
					<th class="C_4">Pierwszy<br/>miesiąc<br/>kwartału</th>
					<th class="C_4">Drugi<br/>miesiąc<br/>kwartału</th>
					<th class="C_4">Trzeci<br/>miesiąc<br/>kwartału</th>
				</tr>
				<tr>
					<td class="tab_col_no">1</td>
					<td class="tab_col_no">2</td>
					<td class="tab_col_no">3</td>
					<td class="tab_col_no">4</td>
					<td class="tab_col_no">5</td>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="Wykonanie-miesięczne">
					<tr>
						<xsl:call-template name="Row-description">
							<xsl:with-param name="tabtype" select="'C'"/>
						</xsl:call-template>
						<xsl:call-template name="Realizacja"/>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>

		<table style="padding-top: 6px;" width="504" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars">*</td>
				<td class="remark">
					Wszystkie dane podaje się w ujęciu miesięcznym.
				</td>
			</tr>
			<tr>
				<td class="stars">**</td>
				<td class="remark">
					Dotyczy ustawy z dnia 22 kwietnia 2005 r. o postępowaniu wobec dłużników alimentacyjnych
					oraz zaliczce alimentacyjnej (Dz. U. nr 86, poz. 732).
				</td>
			</tr>
		</table>
		<br/><br/><br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Realizacja">
		<td class="contents">
			<xsl:value-of select="format-number(Pierwszy-miesiąc, $liczba)"/>
		</td>
		<td class="contents">
			<xsl:value-of select="format-number(Drugi-miesiąc, $liczba)"/>
		</td>
		<td class="contents">
			<xsl:value-of select="format-number(Trzeci-miesiąc, $liczba)"/>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
