/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.sprawozdania.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Objects;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class WydrukSprawozdaniaUtil {
    public static String drukujPolonSRG_20171220(byte[] tresc) {
        return WydrukSprawozdaniaUtil.drukuj(tresc, "xslt/uslugiGrupowe/POLON-SR-G_20171220.xslt");
    }

    public static String drukujSIOSRG_20171220(byte[] tresc) {
        return WydrukSprawozdaniaUtil.drukuj(tresc, "xslt/uslugiGrupowe/SIO-SR-G_20171220.xslt");
    }

    public static String drukujSIOSWiDSG_20181116(byte[] tresc) {
        return WydrukSprawozdaniaUtil.drukuj(tresc, "xslt/uslugiGrupowe/SIO-SWiDS-G_20181116.xslt");
    }

    public static String drukujZ1CBBSRG_20171220(byte[] tresc) {
        return WydrukSprawozdaniaUtil.drukuj(tresc, "xslt/uslugiGrupowe/Z1-CBB-SR-G_20171220.xslt");
    }

    public static String drukujZ1CBBSWG_20171220(byte[] tresc) {
        return WydrukSprawozdaniaUtil.drukuj(tresc, "xslt/uslugiGrupowe/Z1-CBB-SW-G_20171220.xslt");
    }

    public static String drukujSDSG_20181119(byte[] tresc) {
        return WydrukSprawozdaniaUtil.drukuj(tresc, "xslt/dobryStart/SDS-G_20181119.xslt");
    }

    public static String drukujSDSG_20191115(byte[] tresc) {
        return WydrukSprawozdaniaUtil.drukuj(tresc, "xslt/dobryStart/SDS-G_20191115.xslt");
    }

    public static String drukuj(byte[] tresc, String stylPath) {
        String string;
        block8: {
            InputStream styl = WydrukSprawozdaniaUtil.class.getClassLoader().getResourceAsStream(stylPath);
            try {
                Objects.requireNonNull(styl, "nie uda\u0142o si\u0119 odnale\u017a\u0107 xsl sprawozdania");
                string = WydrukSprawozdaniaUtil.transformuj(tresc, styl);
                if (styl == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (styl != null) {
                        try {
                            styl.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | TransformerException e) {
                    throw new RuntimeException(e);
                }
            }
            styl.close();
        }
        return string;
    }

    private static String transformuj(byte[] tresc, InputStream styl) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(styl));
        StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(tresc));
        StringWriter sw = new StringWriter();
        transformer.transform(xmlSource, new StreamResult(sw));
        return sw.toString();
    }
}

