<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="obsada" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'944'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
                    .reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
											font-weight: bold; text-align: right;
											width: <xsl:value-of select="$width"/>px;
										}
					.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
											font-weight: bold; text-align: center;
										}
					.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
											font-weight: bold;
										}
					.heading_1  	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
											font-weight: bold; text-align: center;
											width: <xsl:value-of select="$width"/>px;
										}
					.data_table	{border: 1px solid black; border-collapse: collapse;
											color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal;
										}
					.bottom_table {max-width: 900px; border-width: 0px;}
					th          		{padding: 5px; font-weight: bold; border: 1px solid black;}
					caption     	{color: #000000; font-family: Tahoma, Verdana;
											text-align: left; font-size: 14px; font-weight: bold;
											margin-bottom: 0.4em;
										}
					.tab_col_no	{text-align: center; font-size: 8px;
											border: 1px solid black; padding: 5px;
										}
					.tab_row_no	{padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
											text-align: left; border: 1px solid black;
										}
					.contents		{padding: 5px; text-align: right; border: 1px solid black;}
					.totals     		{padding: 5px; text-align: right; border: 1px solid black;}
					.blad				{background-color: red; font-weight: bold;}
					.row_descr	{padding: 5px; text-align: left; border: 1px solid black;}
					.remark			{padding-left: 8px; text-align: justify; vertical-align: baseline;
											color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
											padding-top: 4px; font-weight: normal;
										}
					.stars      		{padding-left: 2px; text-align: left; vertical-align: super;
											color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
											padding-top: 2px; font-weight: normal;
										}
					.stopka			{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal; width: 500px;
										}
				</style>
			</head>
			<body>
				<xsl:apply-templates select="Świadczenia-rodzinne-G"/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Świadczenia-rodzinne-G">
		<xsl:apply-templates select="Metryczka"/>
		<!--
		- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		-->
		<xsl:apply-templates select="Część_A.1"/>
		<xsl:apply-templates select="Część_A.2"/>
		<xsl:apply-templates select="Część_A.3"/>
		<xsl:apply-templates select="Część_B"/>
		<xsl:apply-templates select="Część_C"/>
		<xsl:apply-templates select="Część_D.1"/>
		<xsl:apply-templates select="Część_D.2"/>
		<xsl:apply-templates select="Część_D.3"/>
		<xsl:apply-templates select="Część_E"/>
		<xsl:apply-templates select="Część_F.1"/>
		<xsl:apply-templates select="Część_F.2"/>
		<xsl:apply-templates select="Część_G.1"/>
		<xsl:apply-templates select="Część_G.2"/>
		<xsl:apply-templates select="Część_G.3"/>
		<xsl:apply-templates select="Część_H"/>
		<xsl:apply-templates select="Część_I"/>
		<xsl:apply-templates select="Część_J.1"/>
		<xsl:apply-templates select="Część_J.2"/>
		<xsl:apply-templates select="Część_UA.1"/>
		<xsl:apply-templates select="Część_UA.2"/>
		<!--
		- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/>
				<br/>
				<br/>
			</div>
		</xsl:if>
		<xsl:for-each select="../Nagłówek/Dane-jednostki-org">
			<table cellspacing="0" cellpadding="0">
				<tr>
					<td class="stamp" colspan="2">
						<xsl:value-of select="Pełna-nazwa"/>
					</td>
				</tr>
				<xsl:for-each select="Adres-pocztowy">
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Ulica-i-numer"/>
						</td>
					</tr>
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Kod-i-poczta"/>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="stamp" style="font-size: 12px; text-align: left">
						<xsl:for-each select="Telefon">
							Tel. <xsl:apply-templates/>&#160;
 						</xsl:for-each>
					</td>
					<td class="stamp" style="font-size: 12px; text-align: right">
						<xsl:for-each select="Faks">
							&#160;Fax <xsl:apply-templates/>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:for-each>
		<br/>
		<br/>
		<div class="auth_name">
			<xsl:for-each select="../Nagłówek">
				<xsl:for-each select="Gmina">
					Gmina <xsl:apply-templates/>
				</xsl:for-each>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
		<div class="heading_1">
			KWARTALNE
			<xsl:if test="../Nagłówek/Wojewoda"> ZBIORCZE</xsl:if>
			SPRAWOZDANIE RZECZOWO-FINANSOWE Z WYKONYWANIA ZADAŃ<br/>Z ZAKRESU ŚWIADCZEŃ RODZINNYCH<sup>1)</sup>
			<sup> 2)</sup>
			<xsl:for-each select="Za-okres">
				<xsl:for-each select="Miesiąc">
					ZA <xsl:apply-templates/>
				</xsl:for-each>
				<xsl:for-each select="Kwartał">
					ZA <xsl:apply-templates/> KWARTAŁ
				</xsl:for-each>
				<xsl:value-of select="concat(' ', Rok, ' R.')"/>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table class="stopka">
			<caption class="stopka">Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td>imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td>telefon służbowy:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>e-mail służbowy:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
			<tr>
				<td>Data sporządzenia sprawozdania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="suma">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents"/>
		<xsl:param name="format"/>
		<xsl:param name="skladniki"/>
		<xsl:variable name="iloscSkladowych">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="count(../*[contains($skladniki,concat(name(.),' '))]/*[name(.) = $subtree]/descendant-or-self::*[name(.) = $column and not(@xsi:nil)])"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="count(../*[contains($skladniki,concat(name(.),' '))]/descendant-or-self::*[name(.) = $column and not(@xsi:nil)])"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="wynik">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="sum(../*[contains($skladniki,concat(name(.),' '))]/*[name(.) = $subtree]/descendant-or-self::*[name(.) = $column and not(@xsi:nil)])"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="sum(../*[contains($skladniki,concat(name(.),' '))]/descendant-or-self::*[name(.) = $column and not(@xsi:nil)])"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$iloscSkladowych = 0">
				<td class="totals">
					<xsl:value-of select="$contents"/>
				</td>
			</xsl:when>
			<xsl:when test="string(number($wynik)) = 'NaN'">
				<td class="totals" style="background-color: red">
					<center>???</center>
				</td>
			</xsl:when>
			<xsl:when test="string(number($contents)) != 'NaN' and $contents != ''">
				<xsl:choose>
					<xsl:when test="format-number($contents, $format) != format-number($wynik, $format)">
						<td class="contents error" style="background-color: red">
							<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
							<br/>
							<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="$wynik"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Column">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="skladniki"/>
		<xsl:param name="format"/>
		<xsl:variable name="item" select="descendant-or-self::*[name(.) = $column]"/>
		<xsl:variable name="subtree_item" select="*[name(.) = $subtree]/descendant-or-self::*[name(.) = $column]"/>
		<xsl:variable name="contents">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="$subtree_item"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$item"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="czyNil">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="$subtree_item/@xsi:nil"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$item/@xsi:nil"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string($czyNil) = 'true'">
				<xsl:variable name="cssName">
					<xsl:choose>
						<xsl:when test="$skladniki">totals</xsl:when>
						<xsl:otherwise>contents</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<td>
					<xsl:attribute name="class"><xsl:value-of select="$cssName"/></xsl:attribute>
					<center>X</center>
				</td>
			</xsl:when>
			<xsl:when test="$skladniki">
				<xsl:call-template name="suma">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string(number($contents)) = 'NaN'">
							<div style="color: red; text-align: center;">???</div>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Table-caption">
		<caption>
			<xsl:value-of select="concat(substring-after(name(.), '_'), '. ')"/>
			<xsl:call-template name="Tables-description">
				<xsl:with-param name="table_name" select="name()"/>
			</xsl:call-template>
		</caption>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Tables-description">
		<xsl:param name="table_name"/>
		<xsl:choose>
			<xsl:when test="$table_name = 'Część_A.1'">Wydatki na świadczenia rodzinne finansowane z dotacji celowej z budżetu państwa oraz liczba świadczeń, z wyłączeniem świadczeń ustalonych na podstawie art. 5 ust. 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$table_name = 'Część_A.2'">Wydatki na świadczenia rodzinne finansowane z dotacji celowej z budżetu państwa oraz liczba świadczeń, w zakresie świadczeń ustalonych wyłącznie na podstawie art. 5 ust. 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$table_name = 'Część_A.3'">Wydatki na jednorazowe świadczenie w wysokości 4 000 zł<sup>1)</sup> finansowane z dotacji celowej z budżetu państwa oraz liczba świadczeń</xsl:when>
			<xsl:when test="$table_name = 'Część_B'">Wydatki na składki na ubezpieczenia społeczne i ubezpieczenie zdrowotne oraz liczba składek</xsl:when>
			<xsl:when test="$table_name = 'Część_C'">Informacje na temat należności z tytułu nienależnie pobranych świadczeń rodzinnych<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$table_name = 'Część_D.1'">Informacje o odzyskanych nienależnie pobranych świadczeniach rodzinnych, z wyłączeniem świadczeń ustalonych na podstawie art. 5 ust. 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$table_name = 'Część_D.2'">Informacje o odzyskanych świadczeniach nienależnie pobranych, w zakresie świadczeń ustalonych wyłącznie na podstawie art. 5 ust. 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$table_name = 'Część_D.3'">Informacje o odzyskanych nienależnie pobranych jednorazowych świadczeniach w wysokości 4 000 zł<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$table_name = 'Część_E'">Wydatki ze środków własnych gminy na świadczenia rodzinne oraz liczba świadczeń</xsl:when>
			<xsl:when test="$table_name = 'Część_F.1'">Informacje uzupełniające o realizacji świadczeń rodzinnych<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$table_name = 'Część_F.2'">Informacje uzupełniające o usługach wymiany informacji pomiędzy Systemem Dziedzinowym (SD) podobszaru świadczeń rodzinnych a Centralnym Systemem Informatycznym Zabezpieczenia Społecznego (CSIZS)<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$table_name = 'Część_G.1'">Informacje o rodzinach pobierających zasiłek rodzinny (i dodatki do zasiłku rodzinnego)</xsl:when>
			<xsl:when test="$table_name = 'Część_G.2'">Informacje o rodzinach pobierających jednorazową zapomogę z tytułu urodzenia się dziecka</xsl:when>
			<xsl:when test="$table_name = 'Część_G.3'">Informacje o rodzinach pobierających specjalny zasiłek opiekuńczy</xsl:when>
			<xsl:when test="$table_name = 'Część_H'">Informacje statystyczne<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$table_name = 'Część_I'">Informacje na temat przyczyn zaprzestania pobierania świadczenia pielęgnacyjnego oraz specjalnego zasiłku opiekuńczego</xsl:when>
			<xsl:when test="$table_name = 'Część_J.1'">Informacje na temat relacji pomiędzy osobami pobierającymi specjalny zasiłek opiekuńczy, a osobami wymagającymi opieki</xsl:when>
			<xsl:when test="$table_name = 'Część_J.2'">Informacje na temat relacji pomiędzy osobami pobierającymi świadczenie pielęgnacyjne, a osobami wymagającymi opieki</xsl:when>			
			<xsl:when test="$table_name = 'Część_UA.1'">Wydatki na świadczenia rodzinne oraz liczba świadczeń, do których prawo przysługuje na podstawie art. 26 ust. 1 pkt 1 ustawy z dnia 12 marca 2022 r. o pomocy obywatelom Ukrainy w związku z konfliktem zbrojnym na terytorium tego państwa (Dz.U. poz. 583<br/>z późn. zm.)</xsl:when>
			<xsl:when test="$table_name = 'Część_UA.2'">Informacje uzupełniające o realizacji świadczeń rodzinnych do których prawo przysługuje na podstawie art. 26 ust. 1 pkt 1 ustawy z dnia 12 marca 2022 r. o pomocy obywatelom Ukrainy w związku z konfliktem zbrojnym na terytorium tego państwa<br/>(Dz.U. poz. 583 z późn. zm.)</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Row-description">
		<td class="tab_row_no">
			<xsl:value-of select="concat(substring-after(name(), '_'), '.')"/>
		</td>
		<td class="row_descr">
			<xsl:call-template name="Rows-description">
				<xsl:with-param name="row_name" select="name()"/>
			</xsl:call-template>
		</td>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Rows-description">
		<xsl:param name="row_name"/>
		<xsl:choose>
			<xsl:when test="$row_name = 'A.1_1'">Zasiłek rodzinny, z tego na dziecko w wieku:</xsl:when>
			<xsl:when test="$row_name = 'A.1_1.1'">- do ukończenia 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'A.1_1.2'">- powyżej 5. roku życia do ukończenia 18. roku życia</xsl:when>
			<xsl:when test="$row_name = 'A.1_1.3'">- powyżej 18. roku życia do ukończenia 21. roku życia</xsl:when>
			<xsl:when test="$row_name = 'A.1_1.4'">- powyżej 21. roku życia do ukończenia 24. roku życia</xsl:when>
			<xsl:when test="$row_name = 'A.1_2'">Dodatki do zasiłku rodzinnego, z tego z tytułu:</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.1'">- urodzenia dziecka</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.2'">- opieki nad dzieckiem w okresie korzystania z urlopu wychowawczego</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.3'">- samotnego wychowywania dziecka, z tego, do którego prawo ustalono na podstawie:</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.3.1'">- art. 11a ust. 1 pkt 1 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.3.2'">- art. 11a ust. 1 pkt 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.3.3'">- art. 11a ust. 1 pkt 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.3.4'">- art. 11a ust. 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.4'">- kształcenia i rehabilitacji dziecka niepełnosprawnego, z tego w wieku:</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.4.1'">- do 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.4.2'">- powyżej 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.5'">- rozpoczęcia roku szkolnego</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.6'">- podjęcia przez dziecko nauki w szkole poza miejscem zamieszkania, z tego w związku z:</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.6.1'">- zamieszkaniem w miejscowości, w której znajduje się szkoła</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.6.2'">- dojazdem do miejscowości, w której znajduje się szkoła</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.7'">- wychowywania dziecka w rodzinie wielodzietnej</xsl:when>
			<xsl:when test="$row_name = 'A.1_3'">Zasiłek rodzinny i dodatki do zasiłku rodzinnego (wiersz 1 + wiersz 2)</xsl:when>
			<xsl:when test="$row_name = 'A.1_4'">Zasiłek pielęgnacyjny, z tego, do którego prawo ustalono na podstawie:</xsl:when>
			<xsl:when test="$row_name = 'A.1_4.1'">- art. 16 ust. 2 pkt 1 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.1_4.2'">- art. 16 ust. 2 pkt 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.1_4.3'">- art. 16 ust. 2 pkt 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.1_4.4'">- art. 16 ust. 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.1_5'">Świadczenie pielęgnacyjne, z tego, do którego prawo ustalono na podstawie:</xsl:when>
			<xsl:when test="$row_name = 'A.1_5.1'">- art. 17 ust. 1 pkt 1 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.1_5.2'">- art. 17 ust. 1 pkt 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.1_5.3'">- art. 17 ust. 1 pkt 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.1_5.4'">- art. 17 ust. 1 pkt 4 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.1_6'">Specjalny zasiłek opiekuńczy</xsl:when>
			<xsl:when test="$row_name = 'A.1_7'">Świadczenia opiekuńcze (wiersz 4 + wiersz 5 + wiersz 6)</xsl:when>
			<xsl:when test="$row_name = 'A.1_8'">Razem (wiersz 3 + wiersz 7)</xsl:when>
			<xsl:when test="$row_name = 'A.1_9'">Jednorazowa zapomoga z tytułu urodzenia się dziecka</xsl:when>
			<xsl:when test="$row_name = 'A.1_10'">Świadczenie rodzicielskie</xsl:when>
			<xsl:when test="$row_name = 'A.1_11'">Razem (wiersz 8 + wiersz 9 + wiersz 10)</xsl:when>
			<xsl:when test="$row_name = 'A.2_1'">Zasiłek rodzinny, z tego na dziecko w wieku:</xsl:when>
			<xsl:when test="$row_name = 'A.2_1.1'">- do ukończenia 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'A.2_1.2'">- powyżej 5. roku życia do ukończenia 18. roku życia</xsl:when>
			<xsl:when test="$row_name = 'A.2_1.3'">- powyżej 18. roku życia do ukończenia 21. roku życia</xsl:when>
			<xsl:when test="$row_name = 'A.2_1.4'">- powyżej 21. roku życia do ukończenia 24. roku życia</xsl:when>
			<xsl:when test="$row_name = 'A.2_2'">Dodatki do zasiłku rodzinnego, z tego z tytułu:</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.1'">- urodzenia dziecka</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.2'">- opieki nad dzieckiem w okresie korzystania z urlopu wychowawczego</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.3'">- samotnego wychowywania dziecka, z tego, do którego prawo ustalono na podstawie:</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.3.1'">- art. 11a ust. 1 pkt 1 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.3.2'">- art. 11a ust. 1 pkt 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.3.3'">- art. 11a ust. 1 pkt 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.3.4'">- art. 11a ust. 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.4'">- kształcenia i rehabilitacji dziecka niepełnosprawnego, z tego w wieku:</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.4.1'">- do 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.4.2'">- powyżej 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.5'">- rozpoczęcia roku szkolnego</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.6'">- podjęcia przez dziecko nauki w szkole poza miejscem zamieszkania, z tego w związku z:</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.6.1'">- zamieszkaniem w miejscowości, w której znajduje się szkoła</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.6.2'">- dojazdem do miejscowości, w której znajduje się szkoła</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.7'">- wychowywania dziecka w rodzinie wielodzietnej</xsl:when>
			<xsl:when test="$row_name = 'A.2_3'">Zasiłek rodzinny i dodatki do zasiłku rodzinnego (wiersz 1 + wiersz 2)</xsl:when>
			<xsl:when test="$row_name = 'A.2_4'">Zasiłek rodzinny i dodatki do zasiłku rodzinnego, do których prawo zostało ustalone przez wojewodę/marszałka województwa na podstawie przepisów o koordynacji systemów zabezpieczenia społecznego</xsl:when>
			<xsl:when test="$row_name = 'A.2_5'">Zasiłek rodzinny i dodatki do zasiłku rodzinnego (wiersz 3 + wiersz 4)</xsl:when>
			<xsl:when test="$row_name = 'A.3_1'">Jednorazowe świadczenie w wysokości 4 000 zł</xsl:when>
			<xsl:when test="$row_name = 'B_1'">Składki na ubezpieczenia emerytalne i rentowe opłacane za osoby pobierające świadczenia opiekuńcze, z tego: </xsl:when>
			<xsl:when test="$row_name = 'B_1.1'">- świadczenie pielęgnacyjne, z tego:</xsl:when>
			<xsl:when test="$row_name = 'B_1.1.1'">- opłacane na podstawie przepisów o systemie ubezpieczeń społecznych<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'B_1.1.2'">- opłacane na podstawie przepisów o ubezpieczeniu społecznym rolników<sup>2)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'B_1.2'">- specjalny zasiłek opiekuńczy, z tego:</xsl:when>
			<xsl:when test="$row_name = 'B_1.2.1'">- opłacane na podstawie przepisów o systemie ubezpieczeń społecznych<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'B_1.2.2'">- opłacane na podstawie przepisów o ubezpieczeniu społecznym rolników<sup>2)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'B_2'">Składki na ubezpieczenie zdrowotne opłacane za osoby pobierające świadczenia opiekuńcze, z tego:</xsl:when>
			<xsl:when test="$row_name = 'B_2.1'">- świadczenie pielęgnacyjne</xsl:when>
			<xsl:when test="$row_name = 'B_2.2'">- specjalny zasiłek opiekuńczy</xsl:when>
			<xsl:when test="$row_name = 'B_3'">Razem (wiersz 1 + wiersz 2)</xsl:when>
			<xsl:when test="$row_name = 'C_1'">Stan należności z tytułu nienależnie pobranych świadczeń rodzinnych na ostatni dzień miesiąca</xsl:when>
			<xsl:when test="$row_name = 'C_2'">Kwota umorzonych nienależnie pobranych świadczeń rodzinnych</xsl:when>
			<xsl:when test="$row_name = 'C_3'">Kwota nienależnie pobranych świadczeń rodzinnych, w przypadku których w danym miesiącu podjęto decyzję o rozłożeniu na raty</xsl:when>
			<xsl:when test="$row_name = 'C_4'">Kwota nienależnie pobranych świadczeń rodzinnych, potrącona w danym miesiącu z bieżąco wypłacanych świadczeń</xsl:when>
			<xsl:when test="$row_name = 'C_5'">Kwota nienależnie pobranych świadczeń rodzinnych wygaszonych na podstawie art. 30 ust. 11 ustawy<sup>3)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'D.1_1'">Zasiłek rodzinny</xsl:when>
			<xsl:when test="$row_name = 'D.1_2'">Dodatki do zasiłku rodzinnego, z tego tytułu:</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.1'">- urodzenia dziecka</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.2'">- opieki nad dzieckiem w okresie korzystania z urlopu wychowawczego</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.3'">- samotnego wychowywania dziecka</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.4'">- kształcenia i rehabilitacji dziecka niepełnosprawnego, z tego w wieku:</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.4.1'">- do 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.4.2'">- powyżej 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.5'">- rozpoczęcia roku szkolnego</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.6'">- podjęcia przez dziecko nauki w szkole poza miejscem zamieszkania, z tego w związku z:</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.6.1'">- zamieszkaniem w miejscowości, w której znajduje się szkoła</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.6.2'">- dojazdem do miejscowości, w której znajduje się szkoła</xsl:when>
			<xsl:when test="$row_name = 'D.1_2.7'">- wychowywania dziecka w rodzinie wielodzietnej</xsl:when>
			<xsl:when test="$row_name = 'D.1_3'">Zasiłek rodzinny i dodatki do zasiłku rodzinnego(wiersz 1 + wiersz 2)</xsl:when>
			<xsl:when test="$row_name = 'D.1_4'">Zasiłek pielęgnacyjny</xsl:when>
			<xsl:when test="$row_name = 'D.1_5'">Świadczenie pielęgnacyjne</xsl:when>
			<xsl:when test="$row_name = 'D.1_6'">Specjalny zasiłek opiekuńczy</xsl:when>
			<xsl:when test="$row_name = 'D.1_7'">Świadczenia opiekuńcze (wiersz 4 + wiersz 5 + wiersz 6)</xsl:when>
			<xsl:when test="$row_name = 'D.1_8'">Razem (wiersz 3 + wiersz 7)</xsl:when>
			<xsl:when test="$row_name = 'D.1_9'">Jednorazowa zapomoga z tytułu urodzenia się dziecka</xsl:when>
			<xsl:when test="$row_name = 'D.1_10'">Świadczenie rodzicielskie</xsl:when>
			<xsl:when test="$row_name = 'D.1_11'">Razem (wiersz 8 + wiersz 9 + wiersz 10)</xsl:when>
			<xsl:when test="$row_name = 'D.1_11.1'">- w tym kwota odzyskanych nienależnie pobranych świadczeń rodzinnych podlegająca zwrotowi do budżetu państwa</xsl:when>
			<xsl:when test="$row_name = 'D.2_1'">Zasiłek rodzinny i dodatki do zasiłku rodzinnego:</xsl:when>
			<xsl:when test="$row_name = 'D.2_1.1'">- w tym kwota odzyskanych nienależnie pobranych zasiłków rodzinnych i dodatków do zasiłku rodzinnego  podlegająca zwrotowi do budżetu państwa</xsl:when>
			<xsl:when test="$row_name = 'D.3_1'">Jednorazowe świadczenie w wysokości 4 000 zł</xsl:when>
			<xsl:when test="$row_name = 'D.3_1.1'">- w tym kwota odzyskanych nienależnie pobranych świadczeń podlegająca zwrotowi do budżetu państwa</xsl:when>
			<xsl:when test="$row_name = 'E_1'">Dodatki do zasiłku rodzinnego, z tego z tytułu:</xsl:when>
			<xsl:when test="$row_name = 'E_1.1'">- urodzenia dziecka</xsl:when>
			<xsl:when test="$row_name = 'E_1.2'">- opieki nad dzieckiem w okresie korzystania z urlopu wychowawczego</xsl:when>
			<xsl:when test="$row_name = 'E_1.3'">- samotnego wychowywania dziecka</xsl:when>
			<xsl:when test="$row_name = 'E_1.4'">- kształcenia i rehabilitacji dziecka niepełnosprawnego, z tego w wieku:</xsl:when>
			<xsl:when test="$row_name = 'E_1.4.1'">- do 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'E_1.4.2'">- powyżej 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'E_1.5'">- rozpoczęcia roku szkolnego</xsl:when>
			<xsl:when test="$row_name = 'E_1.6'">- podjęcia przez dziecko nauki w szkole poza miejscem zamieszkania, z tego w związku z:</xsl:when>
			<xsl:when test="$row_name = 'E_1.6.1'">- zamieszkaniem w miejscowości, w której znajduje się szkoła</xsl:when>
			<xsl:when test="$row_name = 'E_1.6.2'">- dojazdem do miejscowości, w której znajduje się szkoła</xsl:when>
			<xsl:when test="$row_name = 'E_1.7'">- wychowywania dziecka w rodzinie wielodzietnej</xsl:when>
			<xsl:when test="$row_name = 'E_2'">Zapomoga, o której mowa w art. 22a ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'E_3'">Świadczenia na rzecz rodziny, o których mowa w art. 22b ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'F.1_1'">Liczba wniosków dotyczących świadczeń rodzinnych złożonych do organu właściwego, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F.1_1.1'">- o przyznanie świadczeń, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F.1_1.1.1'">- przekazanych według właściwości</xsl:when>
			<xsl:when test="$row_name = 'F.1_1.1.2'">- zamkniętych bez nadania biegu lub bez rozpatrzenia z powodu niewywiązania się z obowiązku uzupełniania danych w ustawowo wyznaczonym terminie</xsl:when>
			<xsl:when test="$row_name = 'F.1_1.1.3'">- złożonych za pomocą systemu teleinformatycznego utworzonego przez ministra właściwego do spraw rodziny</xsl:when>
			<xsl:when test="$row_name = 'F.1_2'">Liczba decyzji wydanych przez organ właściwy w sprawach dotyczących świadczeń rodzinnych, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F.1_2.1'">- ustalających prawo do świadczeń</xsl:when>
			<xsl:when test="$row_name = 'F.1_2.2'">- stwierdzających nienależnie pobrane świadczenia</xsl:when>
			<xsl:when test="$row_name = 'F.1_2.3'">- umarzających należności z tytułu nienależnie pobranych świadczeń</xsl:when>
			<xsl:when test="$row_name = 'F.1_3'">Liczba decyzji wydanych przez organ właściwy w sprawach dotyczących wyłącznie świadczenia rodzicielskiego </xsl:when>
			<xsl:when test="$row_name = 'F.1_4'">Liczba spraw, w których wygaszono nienależnie pobrane świadczenia rodzinne na podstawie art. 30 ust. 11 ustawy<sup>2)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'F.2_1'">Wygenerowane usługi integracji SD z zasobami zbioru PESEL, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F.2_1.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'F.2_1.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'F.2_2'">Wygenerowane usługi integracji SD z Aplikacją Centralną Rynku Pracy, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F.2_2.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'F.2_2.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'F.2_3'">Wygenerowane usługi integracji SD z zasobami Centralnej Ewidencji i Informacji Działalności Gospodarczej (CEIDG), w tym:</xsl:when>
			<xsl:when test="$row_name = 'F.2_3.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'F.2_3.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'F.2_4'">Wygenerowane usługi integracji SD z zasobami Elektronicznego Krajowego Systemu Orzekania o Niepełnosprawności (EKSMOoN), w tym:</xsl:when>
			<xsl:when test="$row_name = 'F.2_4.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'F.2_4.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'F.2_5'">Wygenerowane usługi integracji SD z zasobami Ministerstwa Finansów, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F.2_5.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'F.2_5.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'F.2_6'">Wygenerowane usługi integracji SD z zasobami Zakładu Ubezpieczeń Społecznych, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F.2_6.1'">- uzyskane:</xsl:when>
			<xsl:when test="$row_name = 'F.2_6.1.1'">informacje o wysokości zapłaconej składki na ubezpieczenie zdrowotne dla celów związanych z przyznaniem świadczeń rodzinnych</xsl:when>
			<xsl:when test="$row_name = 'F.2_6.1.2'">- informacje potwierdzające zgłoszenie do ubezpieczeń społecznych osoby przebywającej na urlopie wychowawczym</xsl:when>
			<xsl:when test="$row_name = 'F.2_6.1.3'">- informacje o przebiegu ubezpieczenia osoby pobierającej świadczenie pielęgnacyjne/specjalny zasiłek opiekuńczy</xsl:when>
			<xsl:when test="$row_name = 'F.2_6.2'">- niepowodzenia:</xsl:when>
			<xsl:when test="$row_name = 'F.2_6.2.1'">- informacje o wysokości zapłaconej składki na ubezpieczenie zdrowotne dla celów związanych z przyznaniem świadczeń rodzinnych</xsl:when>
			<xsl:when test="$row_name = 'F.2_6.2.2'">- informacje potwierdzające zgłoszenie do ubezpieczeń społecznych osoby przebywającej na urlopie wychowawczym</xsl:when>
			<xsl:when test="$row_name = 'F.2_6.2.3'">- informacje o przebiegu ubezpieczenia osoby pobierającej świadczenie pielęgnacyjne/specjalny zasiłek opiekuńczy</xsl:when>
			<xsl:when test="$row_name = 'F.2_7'">Wygenerowane usługi integracji SD z zasobami Krajowego Rejestru Sądowego (KRS), w tym:</xsl:when>
			<xsl:when test="$row_name = 'F.2_7.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'F.2_7.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'F.2_8'">Wygenerowane usługi integracji SD z Centralną Bazą Beneficjentów w zakresie zasilania i udostępniania danych, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F.2_8.1'">- uzyskane</xsl:when>
			<xsl:when test="$row_name = 'F.2_8.2'">- niepowodzenia</xsl:when>
			<xsl:when test="$row_name = 'G.1_1'">Liczba rodzin pełnych<sup>1)</sup> bez dziecka niepełnosprawnego, pobierających zasiłek rodzinny (i dodatki do zasiłku rodzinnego), z tego o dochodzie rodziny w przeliczeniu na osobę:</xsl:when>
			<xsl:when test="$row_name = 'G.1_1.1'">- bez dochodu</xsl:when>
			<xsl:when test="$row_name = 'G.1_1.2'">- do 400 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_1.3'">- od 400,01 do 574 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_1.4'">- od 574,01 do 674 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_1.5'">- od 674,01 do 754 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_1.6'">- od 754,01 do 1100 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_1.7'">- od 1100,01 do 1500 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_1.8'">- od 1500,01 do 1922 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_1.9'">- pow. 1922 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_2'">Liczba rodzin pełnych<sup>1)</sup> z dzieckiem niepełnosprawnym, pobierających zasiłek rodzinny (i dodatki do zasiłku rodzinnego), z tego o dochodzie rodziny w przeliczeniu na osobę:</xsl:when>
			<xsl:when test="$row_name = 'G.1_2.1'">- bez dochodu</xsl:when>
			<xsl:when test="$row_name = 'G.1_2.2'">- do 400 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_2.3'">- od 400,01 do 664 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_2.4'">- od 664,01 do 764 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_2.5'">- od 764,01 do 844 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_2.6'">- od 844,01 do 1100 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_2.7'">- od 1100,01 do 1500 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_2.8'">- od 1500,01 do 1922 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_2.9'">- pow. 1922 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_3'">Liczba rodzin niepełnych<sup>2)</sup> bez dziecka niepełnosprawnego, pobierających zasiłek rodzinny (i dodatki do zasiłku rodzinnego), z tego o dochodzie rodziny w przeliczeniu na osobę:</xsl:when>
			<xsl:when test="$row_name = 'G.1_3.1'">- bez dochodu</xsl:when>
			<xsl:when test="$row_name = 'G.1_3.2'">- do 400 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_3.3'">- od 400,01 do 574 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_3.4'">- od 574,01 do 674 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_3.5'">- od 674,01 do 754 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_3.6'">- od 754,01 do 1100 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_3.7'">- od 1100,01 do 1500 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_3.8'">- od 1500,01 do 1922 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_3.9'">- pow. 1922 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_4'">Liczba rodzin niepełnych<sup>2)</sup> z dzieckiem niepełnosprawnym, pobierających zasiłek rodzinny (i dodatki do zasiłku rodzinnego), z tego o dochodzie rodziny w przeliczeniu na osobę:</xsl:when>
			<xsl:when test="$row_name = 'G.1_4.1'">- bez dochodu</xsl:when>
			<xsl:when test="$row_name = 'G.1_4.2'">- do 400 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_4.3'">- od 400,01 do 664 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_4.4'">- od 664,01 do 764 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_4.5'">- od 764,01 do 844 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_4.6'">- od 844,01 do 1100 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_4.7'">- od 1100,01 do 1500 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_4.8'">- od 1500,01 do 1922 zł</xsl:when>
			<xsl:when test="$row_name = 'G.1_4.9'">- pow. 1922 zł</xsl:when>
			<xsl:when test="$row_name = 'G.2_1'">Liczba rodzin pobierających jednorazową zapomogę z tytułu urodzenia się dziecka, z tego o dochodzie rodziny w przeliczeniu na osobę:</xsl:when>
			<xsl:when test="$row_name = 'G.2_1.1'">- bez dochodu</xsl:when>
			<xsl:when test="$row_name = 'G.2_1.2'">- do 400 zł</xsl:when>
			<xsl:when test="$row_name = 'G.2_1.3'">- od 400,01 do 574 zł</xsl:when>
			<xsl:when test="$row_name = 'G.2_1.4'">- od 574,01 do 674 zł</xsl:when>
			<xsl:when test="$row_name = 'G.2_1.5'">- od 674,01 do 754 zł</xsl:when>
			<xsl:when test="$row_name = 'G.2_1.6'">- od 754,01 do 1100 zł</xsl:when>
			<xsl:when test="$row_name = 'G.2_1.7'">- od 1100,01 do 1500 zł</xsl:when>
			<xsl:when test="$row_name = 'G.2_1.8'">- od 1500,01 do 1922 zł</xsl:when>
			<xsl:when test="$row_name = 'G.3_1'">Liczba rodzin pobierających specjalny zasiłek opiekuńczy, z tego o dochodzie rodziny w przeliczeniu na osobę:</xsl:when>
			<xsl:when test="$row_name = 'G.3_1.1'">- bez dochodu</xsl:when>
			<xsl:when test="$row_name = 'G.3_1.2'">- do 400 zł</xsl:when>
			<xsl:when test="$row_name = 'G.3_1.3'">- od 400,01 do 664 zł</xsl:when>
			<xsl:when test="$row_name = 'G.3_1.4'">- od 664,01 do 764 zł</xsl:when>
			<xsl:when test="$row_name = 'G.3_1.5'">- od 764,01 do 859 zł</xsl:when>
			<xsl:when test="$row_name = 'H_1'">Liczba rodzin pobierających świadczenia rodzinne</xsl:when>
			<xsl:when test="$row_name = 'H_2'">Liczba rodzin pobierających zasiłek rodzinny, w tym:</xsl:when>
			<xsl:when test="$row_name = 'H_2.1'">- na jedno dziecko</xsl:when>
			<xsl:when test="$row_name = 'H_2.2'">- na dwoje dzieci</xsl:when>
			<xsl:when test="$row_name = 'H_2.3'">- na troje dzieci</xsl:when>
			<xsl:when test="$row_name = 'H_2.4'">- na czworo i więcej dzieci</xsl:when>
			<xsl:when test="$row_name = 'I_1'">Upływ terminu ważności orzeczenia o niepełnosprawności lub orzeczenia o znacznym stopniu niepełnosprawności osoby wymagającej opieki jako przyczyna zaprzestania pobierania świadczenia opiekuńczego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'I_1.1'">- świadczenia pielęgnacyjnego</xsl:when>
			<xsl:when test="$row_name = 'I_1.2'">- specjalnego zasiłku opiekuńczego</xsl:when>
			<xsl:when test="$row_name = 'I_2'">Podjęcie przez osobę sprawującą opiekę zatrudnienia lub innej pracy zarobkowej jako przyczyna zaprzestania pobierania świadczenia opiekuńczego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'I_2.1'">- świadczenia pielęgnacyjnego</xsl:when>
			<xsl:when test="$row_name = 'I_2.2'">- specjalnego zasiłku opiekuńczego</xsl:when>
			<xsl:when test="$row_name = 'I_3'">Nabycie przez osobę sprawującą opiekę prawa do świadczeń, o których mowa w art.16a ust. 8 pkt 1 ustawy<sup>1)</sup>
				<sup> 3)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'I_4'">Nabycie przez osobę sprawującą opiekę prawa do świadczeń, o których mowa w art.17 ust. 5 pkt 1 ustawy<sup>2)</sup>
				<sup> 3)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'I_5'">Umieszczenie osoby wymagającej opieki w rodzinie zastępczej lub w placówce zapewniającej całodobową opiekę jako przyczyna zaprzestania pobierania świadczenia opiekuńczego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'I_5.1'">- świadczenia pielęgnacyjnego, na podstawie art. 17 ust. 5 pkt 2 lit. b ustawy<sup>3)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'I_5.2'">- specjalnego zasiłku opiekuńczego, na podstawie art. 16a ust. 8 pkt 2 ustawy<sup>3)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'I_6'">Ustalenie dla członka rodziny osoby sprawującej opiekę prawa do dodatku do zasiłku rodzinnego, o którym mowa w art. 10 ustawy<sup>3)</sup>, prawa do świadczenia pielęgnacyjnego, specjalnego zasiłku opiekuńczego albo zasiłku dla opiekuna jako przyczyna zaprzestania pobierania świadczenia opiekuńczego, z tego: </xsl:when>
			<xsl:when test="$row_name = 'I_6.1'">- świadczenia pielęgnacyjnego</xsl:when>
			<xsl:when test="$row_name = 'I_6.2'">- specjalnego zasiłku opiekuńczego</xsl:when>
			<xsl:when test="$row_name = 'I_7'">Nabycie przez członka rodziny na osobę wymagającą opieki uprawnienia za granicą do świadczenia na pokrycie wydatków związanych z opieką jako przyczyna zaprzestania pobierania świadczenia opiekuńczego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'I_7.1'">- świadczenia pielęgnacyjnego</xsl:when>
			<xsl:when test="$row_name = 'I_7.2'">- specjalnego zasiłku opiekuńczego</xsl:when>
			<xsl:when test="$row_name = 'I_8'">Rezygnacja osoby sprawującej opiekę ze specjalnego zasiłku opiekuńczego lub świadczenia pielęgnacyjnego jako przyczyna zaprzestania pobierania świadczenia opiekuńczego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'I_8.1'">- świadczenia pielęgnacyjnego</xsl:when>
			<xsl:when test="$row_name = 'I_8.2'">- specjalnego zasiłku opiekuńczego</xsl:when>
			<xsl:when test="$row_name = 'I_9'">Śmierć osoby sprawującej opiekę jako przyczyna zaprzestania pobierania świadczenia opiekuńczego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'I_9.1'">- świadczenia pielęgnacyjnego</xsl:when>
			<xsl:when test="$row_name = 'I_9.2'">- specjalnego zasiłku opiekuńczego</xsl:when>
			<xsl:when test="$row_name = 'I_10'">Śmierć osoby wymagającej opieki jako przyczyna zaprzestania pobierania świadczenia opiekuńczego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'I_10.1'">- świadczenia pielęgnacyjnego</xsl:when>
			<xsl:when test="$row_name = 'I_10.2'">- specjalnego zasiłku opiekuńczego</xsl:when>
			<xsl:when test="$row_name = 'I_11'">Zaprzestanie sprawowania opieki jako przyczyna zaprzestania pobierania świadczenia opiekuńczego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'I_11.1'">- świadczenia pielęgnacyjnego</xsl:when>
			<xsl:when test="$row_name = 'I_11.2'">- specjalnego zasiłku opiekuńczego</xsl:when>
			<xsl:when test="$row_name = 'I_12'">Zmiana miejsca zamieszkania osoby sprawującej opiekę jako przyczyna zaprzestania pobierania świadczenia opiekuńczego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'I_12.1'">- świadczenia pielęgnacyjnego</xsl:when>
			<xsl:when test="$row_name = 'I_12.2'">- specjalnego zasiłku opiekuńczego</xsl:when>
			<xsl:when test="$row_name = 'I_13'">Przekroczenie kryterium dochodowego uprawniającego do specjalnego zasiłku opiekuńczego<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'I_14'">Legitymowanie się przez osobę pobierającą specjalny zasiłek opiekuńczy znacznym stopniem niepełnosprawności<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'I_15'">Uzyskanie przez osobę, na której ciąży obowiązek alimentacyjny - inną niż osoby wymienione w art. 17 ust. 1 pkt 1-3 ustawy<sup>3)</sup> - orzeczenia o znacznym stopniu niepełnosprawności<sup>2)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'I_16'">Inne przyczyny zaprzestania pobierania świadczenia opiekuńczego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'I_16.1'">- świadczenia pielęgnacyjnego</xsl:when>
			<xsl:when test="$row_name = 'I_16.2'">- specjalnego zasiłku opiekuńczego</xsl:when>
			<xsl:when test="$row_name = 'J.1_1'">córka/syn na matkę/ojca</xsl:when>
			<xsl:when test="$row_name = 'J.1_2'">matka/ojciec na córkę/syna</xsl:when>
			<xsl:when test="$row_name = 'J.1_3'">wnuczka/wnuk na babcię/dziadka</xsl:when>
			<xsl:when test="$row_name = 'J.1_4'">babcia/dziadek na wnuczka/wnuczkę</xsl:when>
			<xsl:when test="$row_name = 'J.1_5'">siostra/brat na siostrę/brata</xsl:when>
			<xsl:when test="$row_name = 'J.1_6'">mąż na żonę</xsl:when>
			<xsl:when test="$row_name = 'J.1_7'">żona na męża</xsl:when>
			<xsl:when test="$row_name = 'J.1_8'">inna relacja</xsl:when>
			<xsl:when test="$row_name = 'J.2_1'">córka/syn na matkę/ojca</xsl:when>
			<xsl:when test="$row_name = 'J.2_2'">matka/ojciec na córkę/syna</xsl:when>
			<xsl:when test="$row_name = 'J.2_3'">wnuczka/wnuk na babcię/dziadka</xsl:when>
			<xsl:when test="$row_name = 'J.2_4'">babcia/dziadek na wnuczka/wnuczkę</xsl:when>
			<xsl:when test="$row_name = 'J.2_5'">siostra/brat na siostrę/brata</xsl:when>
			<xsl:when test="$row_name = 'J.2_6'">opiekun faktyczny osoby wymagającej opieki</xsl:when>
			<xsl:when test="$row_name = 'J.2_7'">rodzina zastępcza spokrewniona</xsl:when>
			<xsl:when test="$row_name = 'J.2_8'">inna relacja</xsl:when>
			
			<xsl:when test="$row_name = 'UA.1_1'">Zasiłek rodzinny, z tego na dziecko w wieku:</xsl:when>
			<xsl:when test="$row_name = 'UA.1_1.1'">- do ukończenia 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'UA.1_1.2'">- powyżej 5. roku życia do ukończenia 18. roku życia</xsl:when>
			<xsl:when test="$row_name = 'UA.1_1.3'">- powyżej 18. roku życia do ukończenia 21. roku życia</xsl:when>
			<xsl:when test="$row_name = 'UA.1_1.4'">- powyżej 21. roku życia do ukończenia 24. roku życia</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2'">Dodatki do zasiłku rodzinnego, z tego z tytułu:</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.1'">- urodzenia dziecka</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.2'">- opieki nad dzieckiem w okresie korzystania z urlopu wychowawczego</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.3'">- samotnego wychowywania dziecka, z tego, do którego prawo ustalono na podstawie:</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.3.1'">- art. 11a ust. 1 pkt 1 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.3.2'">- art. 11a ust. 1 pkt 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.3.3'">- art. 11a ust. 1 pkt 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.3.4'">- art. 11a ust. 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.4'">- kształcenia i rehabilitacji dziecka niepełnosprawnego, z tego w wieku:</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.4.1'">- do 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.4.2'">- powyżej 5. roku życia</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.5'">- rozpoczęcia roku szkolnego</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.6'">- podjęcia przez dziecko nauki w szkole poza miejscem zamieszkania, z tego w związku z:</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.6.1'">- zamieszkaniem w miejscowości, w której znajduje się szkoła</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.6.2'">- dojazdem do miejscowości, w której znajduje się szkoła</xsl:when>
			<xsl:when test="$row_name = 'UA.1_2.7'">- wychowywania dziecka w rodzinie wielodzietnej</xsl:when>
			<xsl:when test="$row_name = 'UA.1_3'">Zasiłek rodzinny i dodatki do zasiłku rodzinnego (wiersz 1 + wiersz 2)</xsl:when>
			<xsl:when test="$row_name = 'UA.1_4'">Zasiłek pielęgnacyjny, z tego, do którego prawo ustalono na podstawie:</xsl:when>
			<xsl:when test="$row_name = 'UA.1_4.1'">- art. 16 ust. 2 pkt 1 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'UA.1_4.2'">- art. 16 ust. 2 pkt 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'UA.1_4.3'">- art. 16 ust. 2 pkt 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'UA.1_4.4'">- art. 16 ust. 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'UA.1_5'">Świadczenie pielęgnacyjne, z tego, do którego prawo ustalono na podstawie:</xsl:when>
			<xsl:when test="$row_name = 'UA.1_5.1'">- art. 17 ust. 1 pkt 1 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'UA.1_5.2'">- art. 17 ust. 1 pkt 2 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'UA.1_5.3'">- art. 17 ust. 1 pkt 3 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'UA.1_5.4'">- art. 17 ust. 1 pkt 4 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'UA.1_6'">Specjalny zasiłek opiekuńczy</xsl:when>
			<xsl:when test="$row_name = 'UA.1_7'">Świadczenia opiekuńcze (wiersz 4 + wiersz 5 + wiersz 6)</xsl:when>
			<xsl:when test="$row_name = 'UA.1_8'">Razem (wiersz 3 + wiersz 7)</xsl:when>
			<xsl:when test="$row_name = 'UA.1_9'">Jednorazowa zapomoga z tytułu urodzenia się dziecka</xsl:when>
			<xsl:when test="$row_name = 'UA.1_10'">Świadczenie rodzicielskie</xsl:when>
			<xsl:when test="$row_name = 'UA.1_11'">Razem (wiersz 8 + wiersz 9 + wiersz 10)</xsl:when>			
			<xsl:when test="$row_name = 'UA.1_12'">Składki na ubezpieczenia emerytalne i rentowe opłacane za osoby pobierające świadczenia opiekuńcze, z tego:</xsl:when>
			<xsl:when test="$row_name = 'UA.1_12.1'">- świadczenie pielęgnacyjne</xsl:when>
			<xsl:when test="$row_name = 'UA.1_12.2'">- specjalny zasiłek opiekuńczy</xsl:when>
			<xsl:when test="$row_name = 'UA.1_13'">Składki na ubezpieczenie zdrowotne opłacane za osoby pobierające świadczenia opiekuńcze, z tego:</xsl:when>
			<xsl:when test="$row_name = 'UA.1_13.1'">- świadczenie pielęgnacyjne</xsl:when>
			<xsl:when test="$row_name = 'UA.1_13.2'">- specjalny zasiłek opiekuńczy</xsl:when>
			<xsl:when test="$row_name = 'UA.1_14'">Razem (wiersz 12 + wiersz 13)</xsl:when>
			
			<xsl:when test="$row_name = 'UA.2_1'">Liczba wniosków dotyczących świadczeń rodzinnych złożonych do organu właściwego, w tym:</xsl:when>
			<xsl:when test="$row_name = 'UA.2_1.1'">- o przyznanie świadczeń</xsl:when>
			<xsl:when test="$row_name = 'UA.2_2'">Liczba decyzji wydanych przez organ właściwy w sprawach dotyczących świadczeń rodzinnych, w tym:</xsl:when>
			<xsl:when test="$row_name = 'UA.2_2.1'">- ustalających prawo do świadczeń</xsl:when>
			<xsl:when test="$row_name = 'UA.2_2.2'">- stwierdzających nienależnie pobrane świadczenia</xsl:when>
			<xsl:when test="$row_name = 'UA.2_3'">Liczba rodzin pobierających świadczenia rodzinne, w tym:</xsl:when>
			<xsl:when test="$row_name = 'UA.2_3.1'">- zasiłek rodzinny</xsl:when>
			<xsl:when test="$row_name = 'UA.2_4'">Liczba opiekunów tymczasowych pobierających świadczenia rodzinne, w tym:</xsl:when>
			<xsl:when test="$row_name = 'UA.2_4.1'">- opiekunów tymczasowych, o których mowa w art. 25 ust. 7 zdanie trzecie ustawy o pomocy obywatelom Ukrainy w związku z konfliktem zbrojnym na terytorium tego państwa</xsl:when>
			<xsl:when test="$row_name = 'UA.2_5'">Stan należności z tytułu nienależnie pobranych świadczeń rodzinnych na ostatni dzień miesiąca</xsl:when>
			<xsl:when test="$row_name = 'UA.2_6'">Kwota odzyskanych nienależnie pobranych świadczeń rodzinnych</xsl:when>			
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Trzy-kw-header">
		<xsl:param name="remark"/>
		<xsl:param name="grouphdr"/>
		<xsl:param name="opisKol1"/>
		<xsl:param name="opisKol2"/>
		<xsl:param name="opisKol3"/>
		<xsl:param name="descrwidth" select="64"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(100-number($descrwidth)-3)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">L.p.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
					<xsl:if test="$remark">
						<sup>
							<xsl:value-of select="$remark"/>
						</sup>
					</xsl:if>
				</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>
					<xsl:value-of select="$opisKol1"/>
				</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>
					<xsl:value-of select="$opisKol2"/>
				</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>
					<xsl:value-of select="$opisKol3"/>
				</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-table">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-kw-narast-header"/>
			<xsl:call-template name="Kwoty-body"/>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-narast-header">
		<xsl:call-template name="Trzy-kw-header">
			<xsl:with-param name="remark" select="'2)'"/>
			<xsl:with-param name="grouphdr" select="'Kwoty narastająco od początku roku w zł'"/>
			<xsl:with-param name="opisKol1" select="'Pierwszy miesiąc kwartału'"/>
			<xsl:with-param name="opisKol2" select="'Dwa miesiące kwartału'"/>
			<xsl:with-param name="opisKol3" select="'Trzy miesiące kwartału'"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-body">
		<tbody>
			<xsl:for-each select="*">
				<tr>
					<xsl:call-template name="Row-description"/>
					<xsl:call-template name="Kwoty-content">
						<xsl:with-param name="skladniki" select="@Składniki"/>
						<xsl:with-param name="format" select="$kwota"/>
					</xsl:call-template>
				</tr>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Trzy-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie-table">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Wykonanie-header"/>
			<xsl:call-template name="Wykonanie-body"/>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie-header">
		<xsl:param name="remark"/>
		<xsl:param name="grouphdr" select="'Wykonanie miesięczne'"/>
		<xsl:call-template name="Trzy-kw-header">
			<xsl:with-param name="remark" select="$remark"/>
			<xsl:with-param name="grouphdr" select="$grouphdr"/>
			<xsl:with-param name="opisKol1" select="'Pierwszy miesiąc kwartału'"/>
			<xsl:with-param name="opisKol2" select="'Drugi miesiąc kwartału'"/>
			<xsl:with-param name="opisKol3" select="'Trzeci miesiąc kwartału'"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie-body">
		<tbody>
			<xsl:for-each select="*">
				<tr>
					<xsl:call-template name="Row-description"/>
					<xsl:call-template name="Wykonanie-content">
						<xsl:with-param name="skladniki" select="@Składniki"/>
						<xsl:with-param name="format" select="$liczba"/>
					</xsl:call-template>
				</tr>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie-rodzina-table">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Wykonanie-rodzina-header"/>
			<xsl:call-template name="Wykonanie-rodzina-body"/>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie-rodzina-header">
		<xsl:param name="descrwidth" select="25"/>
		<xsl:param name="group">
			<xsl:value-of select="string(100-number($descrwidth)-3)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($group) div 12))"/>
		</xsl:param>
		<xsl:param name="subgrp">
			<xsl:value-of select="string(number($single) * 4)"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="3">L.p.</th>
				<th rowspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="12">
					<xsl:attribute name="width"><xsl:value-of select="concat($group,'%')"/></xsl:attribute>
						Wykonanie miesięczne
				</th>
			</tr>
			<tr>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($subgrp,'%')"/></xsl:attribute>Pierwszy miesiąc kwartału</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($subgrp,'%')"/></xsl:attribute>Drugi miesiąc kwartału</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($subgrp,'%')"/></xsl:attribute>Trzeci miesiąc kwartału</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z jednym dziec-<br/>kiem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z dwoj-<br/>giem dzieci</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z troj-<br/>giem dzieci</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z czwor-<br/>giem i więcej dzieci</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z jednym dziec-<br/>kiem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z dwoj-<br/>giem dzieci</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z troj-<br/>giem dzieci</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z czwor-<br/>giem i więcej dzieci</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z jednym dziec-<br/>kiem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z dwoj-<br/>giem dzieci</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z troj-<br/>giem dzieci</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>z czwor-<br/>giem i więcej dzieci</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
				<td class="tab_col_no">7</td>
				<td class="tab_col_no">8</td>
				<td class="tab_col_no">9</td>
				<td class="tab_col_no">10</td>
				<td class="tab_col_no">11</td>
				<td class="tab_col_no">12</td>
				<td class="tab_col_no">13</td>
				<td class="tab_col_no">14</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie-rodzina-body">
		<tbody>
			<xsl:for-each select="*">
				<tr>
					<xsl:call-template name="Row-description"/>
					<xsl:call-template name="Wykonanie-rodzina-content">
						<xsl:with-param name="skladniki" select="@Składniki"/>
						<xsl:with-param name="format" select="$liczba"/>
					</xsl:call-template>
				</tr>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie-rodzina-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="column" select="'Jedno-dziecko'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="column" select="'Dwoje-dzieci'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="column" select="'Troje-dzieci'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="column" select="'Czworo-dzieci'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="column" select="'Jedno-dziecko'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="column" select="'Dwoje-dzieci'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="column" select="'Troje-dzieci'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="column" select="'Czworo-dzieci'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="column" select="'Jedno-dziecko'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="column" select="'Dwoje-dzieci'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="column" select="'Troje-dzieci'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="column" select="'Czworo-dzieci'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-table">
		<xsl:param name="formatWydatki" select="$kwota"/>
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Wydatki-i-liczby-header"/>
			<xsl:call-template name="Wydatki-i-liczby-body">
				<xsl:with-param name="formatWydatki" select="$formatWydatki"/>
			</xsl:call-template>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-header">
		<xsl:param name="descrwidth" select="31"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(round((100-number($descrwidth)-3) div 2))"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">Lp.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Wydatki narastająco od początku roku w zł
				</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Liczba świadczeń narastająco od początku roku
				</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Dwa miesiące kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Trzy miesiące kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Dwa miesiące kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Trzy miesiące kwartału</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
				<td class="tab_col_no">7</td>
				<td class="tab_col_no">8</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-body">
		<xsl:param name="formatWydatki"/>
		<tbody>
			<xsl:for-each select="*">
				<tr>
					<xsl:call-template name="Row-description"/>
					<xsl:call-template name="Wydatki-i-liczby-content">
						<xsl:with-param name="skladniki" select="@Składniki"/>
						<xsl:with-param name="formatWydatki" select="$formatWydatki"/>
					</xsl:call-template>
				</tr>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="formatWydatki"/>
		<xsl:call-template name="Kwoty-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Wydatki-narastająco'"/>
			<xsl:with-param name="format" select="$formatWydatki"/>
		</xsl:call-template>
		<xsl:call-template name="Kwoty-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Liczba-świadczeń'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-koord-table">
		<xsl:param name="grouphdr" select="'Liczba świadczeń narastająco od początku roku'"/>
		<xsl:param name="col2Name"/>
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Wydatki-i-liczby-koord-header">
				<xsl:with-param name="grouphdr" select="$grouphdr"/>
			</xsl:call-template>
			<xsl:call-template name="Wydatki-i-liczby-koord-body">
				<xsl:with-param name="col2Name" select="$col2Name"/>
			</xsl:call-template>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-koord-header">
		<xsl:param name="grouphdr"/>
		<xsl:param name="descrwidth" select="25"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(round((100-number($descrwidth)-3) div 2))"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 4))"/>
		</xsl:param>
		<xsl:param name="double">
			<xsl:value-of select="string(number($single) * 2)"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="3">L.p.</th>
				<th rowspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>
					Wyszczególnienie
				</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Wydatki narastająco od początku roku w zł
				</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
				</th>
			</tr>
			<tr>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy miesiąc kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Dwa miesiące kwartału</th>
				<th colspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>Trzy miesiące kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy miesiąc kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Dwa miesiące kwartału</th>
				<th colspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>Trzy miesiące kwartału</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>razem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym:<br/>w ramach koordynacji</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>razem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym:<br/>w ramach koordynacji</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
				<td class="tab_col_no">7</td>
				<td class="tab_col_no">8</td>
				<td class="tab_col_no">9</td>
				<td class="tab_col_no">10</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-koord-body">
		<xsl:param name="col2Name"/>
		<tbody>
			<xsl:for-each select="*">
				<tr>
					<xsl:call-template name="Row-description"/>
					<xsl:call-template name="Wydatki-i-liczby-koord-content">
						<xsl:with-param name="skladniki" select="@Składniki"/>
						<xsl:with-param name="format" select="$liczba"/>
						<xsl:with-param name="col2Name" select="$col2Name"/>
					</xsl:call-template>
				</tr>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-koord-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="col2Name"/>
		<xsl:call-template name="Kwoty-koord-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Wydatki-narastająco'"/>
			<xsl:with-param name="format" select="$kwota"/>
			<xsl:with-param name="koordName" select="'Koord'"/>
		</xsl:call-template>
		<xsl:call-template name="Kwoty-koord-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="$col2Name"/>
			<xsl:with-param name="format" select="$liczba"/>
			<xsl:with-param name="koordName" select="'Koord'"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-opiekun-table">
		<xsl:param name="grouphdr" select="'Liczba świadczeń narastająco od początku roku'"/>
		<xsl:param name="col2Name"/>
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Wydatki-i-liczby-opiekun-header">
				<xsl:with-param name="grouphdr" select="$grouphdr"/>
			</xsl:call-template>
			<xsl:call-template name="Wydatki-i-liczby-opiekun-body">
				<xsl:with-param name="col2Name" select="$col2Name"/>
			</xsl:call-template>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-opiekun-header">
		<xsl:param name="grouphdr"/>
		<xsl:param name="descrwidth" select="25"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(round((100-number($descrwidth)-3) div 2))"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 4))"/>
		</xsl:param>
		<xsl:param name="double">
			<xsl:value-of select="string(number($single) * 2)"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="3">L.p.</th>
				<th rowspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>
					Wyszczególnienie
				</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					Wydatki narastająco od początku roku w zł
				</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
				</th>
			</tr>
			<tr>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy miesiąc kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Dwa miesiące kwartału</th>
				<th colspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>Trzy miesiące kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy miesiąc kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Dwa miesiące kwartału</th>
				<th colspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>Trzy miesiące kwartału</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>razem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym dla<br/>opiekuna tymczasowego</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>razem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym dla<br/>opiekuna tymczasowego</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
				<td class="tab_col_no">7</td>
				<td class="tab_col_no">8</td>
				<td class="tab_col_no">9</td>
				<td class="tab_col_no">10</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-opiekun-body">
		<xsl:param name="col2Name"/>
		<tbody>
			<xsl:for-each select="*">
				<tr>
					<xsl:call-template name="Row-description"/>
					<xsl:call-template name="Wydatki-i-liczby-opiekun-content">
						<xsl:with-param name="skladniki" select="@Składniki"/>
						<xsl:with-param name="format" select="$liczba"/>
						<xsl:with-param name="col2Name" select="$col2Name"/>
					</xsl:call-template>
				</tr>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczby-opiekun-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="col2Name"/>
		<xsl:call-template name="Kwoty-koord-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Wydatki-narastająco'"/>
			<xsl:with-param name="format" select="$kwota"/>
			<xsl:with-param name="koordName" select="'Opiekun'"/>
		</xsl:call-template>
		<xsl:call-template name="Kwoty-koord-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="$col2Name"/>
			<xsl:with-param name="format" select="$liczba"/>
			<xsl:with-param name="koordName" select="'Opiekun'"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->	
	<xsl:template name="Kwoty-marsz-table">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-marsz-header"/>
			<xsl:call-template name="Kwoty-marsz-body"/>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-marsz-header">
		<xsl:param name="grouphdr"/>
		<xsl:param name="descrwidth" select="53"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(round((100-number($descrwidth)-3)))"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 4))"/>
		</xsl:param>
		<xsl:param name="double">
			<xsl:value-of select="string(number($single) * 2)"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="3">L.p.</th>
				<th rowspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
						Kwoty narastająco od początku roku w zł
					</th>
			</tr>
			<tr>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Pierwszy miesiąc kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Dwa miesiące kwartału</th>
				<th colspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>Trzy miesiące kwartału</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>razem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym: na podstawie decyzji wojewody/marszałka województwa</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-marsz-body">
		<tbody>
			<xsl:for-each select="*">
				<tr>
					<xsl:call-template name="Row-description"/>
					<xsl:call-template name="Kwoty-koord-content">
						<xsl:with-param name="skladniki" select="@Składniki"/>
						<xsl:with-param name="format" select="$kwota"/>
						<xsl:with-param name="koordName" select="'Ubiegłe'"/>
					</xsl:call-template>
				</tr>
			</xsl:for-each>
		</tbody>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-koord-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/>
		<xsl:param name="format"/>
		<xsl:param name="koordName"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Razem'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="$koordName"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka-tabeli">
		<xsl:param name="remark1"/>
		<xsl:param name="remark2"/>
		<xsl:param name="remark3"/>
		<table class="bottom_table" cellspacing="0" cellpadding="0">
			<xsl:if test="$remark1">
				<xsl:call-template name="Stopka-tabeli-wiersz">
					<xsl:with-param name="numer" select="'1'"/>
					<xsl:with-param name="opis" select="$remark1"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$remark2">
				<xsl:call-template name="Stopka-tabeli-wiersz">
					<xsl:with-param name="numer" select="'2'"/>
					<xsl:with-param name="opis" select="$remark2"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$remark3">
				<xsl:call-template name="Stopka-tabeli-wiersz">
					<xsl:with-param name="numer" select="'3'"/>
					<xsl:with-param name="opis" select="$remark3"/>
				</xsl:call-template>
			</xsl:if>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka-tabeli-wiersz">
		<xsl:param name="numer"/>
		<xsl:param name="opis"/>
		<tr>
			<td class="stars">
				<xsl:value-of select="$numer"/>)
			</td>
			<td class="remark">
				<xsl:value-of select="$opis"/>
			</td>
		</tr>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_A.1">
		<xsl:call-template name="Wydatki-i-liczby-koord-table">
			<xsl:with-param name="col2Name" select="'Liczba-świadczeń'"/>
		</xsl:call-template>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych (Dz.U. z 2022 r. poz. 615).'"/>
			<xsl:with-param name="remark2" select="'Obejmuje także wykonywanie zadań z zakresu jednorazowego świadczenia w wysokości 4 000 zł, o którym mowa w art. 10 ustawy z dnia 4 listopada 2016 r. o wsparciu kobiet w ciąży i rodzin &quot;Za życiem&quot; (Dz.U. z 2016 r. poz. 1860).'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_A.2">
		<xsl:call-template name="Wydatki-i-liczby-table">
			<xsl:with-param name="formatWydatki" select="$obsada"/>
		</xsl:call-template>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_A.3">
		<xsl:call-template name="Wydatki-i-liczby-koord-table">
			<xsl:with-param name="col2Name" select="'Liczba-świadczeń'"/>
		</xsl:call-template>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy świadczenia, o którym mowa w art. 10 ustawy z dnia 4 listopada 2016 r. o wsparciu kobiet w ciąży i rodzin &quot;Za życiem&quot;.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_B">
		<xsl:call-template name="Wydatki-i-liczby-koord-table">
			<xsl:with-param name="grouphdr" select="'Liczba składek narastająco od początku roku'"/>
			<xsl:with-param name="col2Name" select="'Liczba-osób'"/>
		</xsl:call-template>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 13 października 1998 r. o systemie ubezpieczeń społecznych (Dz.U. z 2017 r. poz. 1778 z późn. zm.).'"/>
			<xsl:with-param name="remark2" select="'Dotyczy ustawy z dnia 20 grudnia 1990 r. o ubezpieczeniu społecznym rolników (Dz.U. z 2017 r. poz. 2336).'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_C">
		<xsl:call-template name="Kwoty-table"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Ujmuje się także wartości dotyczące jednorazowego świadczenia w wysokości 4 000 zł, o którym mowa w art. 10 ustawy z dnia 4 listopada 2016 r. o wsparciu kobiet w ciąży i rodzin &quot;Za życiem&quot;.'"/>
			<xsl:with-param name="remark2" select="'Zasada narastania nie dotyczy wiersza 1.'"/>
			<xsl:with-param name="remark3" select="'Dotyczy ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_D.1">
		<xsl:call-template name="Kwoty-marsz-table"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_D.2">
		<xsl:call-template name="Kwoty-marsz-table"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_D.3">
		<xsl:call-template name="Kwoty-marsz-table"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy świadczenia, o którym mowa w art. 10 ustawy z dnia 4 listopada 2016 r. o wsparciu kobiet w ciąży i rodzin &quot;Za życiem&quot;.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_E">
		<xsl:call-template name="Wydatki-i-liczby-table"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_F.1">
		<xsl:call-template name="Wykonanie-table"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Ujmuje się także wartości dotyczące jednorazowego świadczenia w wysokości 4 000 zł, o którym mowa w art. 10 ustawy z dnia 4 listopada 2016 r. o wsparciu kobiet w ciąży i rodzin &quot;Za życiem&quot;.'"/>
			<xsl:with-param name="remark2" select="'Dotyczy ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_F.2">
		<xsl:call-template name="Wykonanie-table"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Ujmuje się także wartości dotyczące jednorazowego świadczenia w wysokości 4 000 zł, o którym mowa w art. 10 ustawy z dnia 4 listopada 2016 r. o wsparciu kobiet w ciąży i rodzin &quot;Za życiem&quot;.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_G.1">
		<xsl:call-template name="Wykonanie-rodzina-table"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Rodziny z wyłączeniem osób samotnie wychowujących dzieci (art. 3 pkt 17a ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych).'"/>
			<xsl:with-param name="remark2" select="'Rodziny osób samotnie wychowujących dzieci (art. 3 pkt 17a ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych).'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_G.2">
		<xsl:call-template name="Wykonanie-rodzina-table"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_G.3">
		<xsl:call-template name="Wykonanie-table"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_H">
		<xsl:call-template name="Wykonanie-table"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'W wierszu 1 ujmuje się także wartości dotyczące jednorazowego świadczenia w wysokości 4 000 zł, o którym mowa w art. 10 ustawy z dnia 4 listopada 2016 r. o wsparciu kobiet w ciąży i rodzin &quot;Za życiem&quot;.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_I">
		<xsl:call-template name="Wykonanie-table"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy tylko specjalnego zasiłku opiekuńczego.'"/>
			<xsl:with-param name="remark2" select="'Dotyczy tylko świadczenia pielęgnacyjnego.'"/>
			<xsl:with-param name="remark3" select="'Dotyczy ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_J.1">
		<xsl:call-template name="Wykonanie-table"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_J.2">
		<xsl:call-template name="Wykonanie-table"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_UA.1">
		<xsl:call-template name="Wydatki-i-liczby-opiekun-table">
			<xsl:with-param name="col2Name" select="'Liczba-świadczeń'"/>
		</xsl:call-template>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_UA.2">
		<xsl:call-template name="Wykonanie-table"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
