<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="obsada" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="liczba" select="'##&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'944'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
<!--		<html>
			<head>-->
				<style type="text/css">
                    .reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
											font-weight: bold; text-align: right;
											width: <xsl:value-of select="$width"/>px;
										}
					.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
											font-weight: bold; text-align: center;
										}
					.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
											font-weight: bold;
										}
					.heading_1  	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
											font-weight: bold; text-align: justify;
											width: <xsl:value-of select="$width"/>px;
										}
					.data_table	{border: 1px solid black; border-collapse: collapse;
											color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal;
										}
					.bottom_table {max-width: 900px; border-width: 0px;}
					th          		{padding: 5px; font-weight: bold; border: 1px solid black;}
					caption     	{color: #000000; font-family: Tahoma, Verdana;
											text-align: left; font-size: 14px; font-weight: bold;
											margin-bottom: 0.4em;
										}
					.tab_col_no	{text-align: center; font-size: 8px;
											border: 1px solid black; padding: 5px;
										}
					.tab_row_no	{padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
											text-align: left; border: 1px solid black;
										}
					.contents		{padding: 5px; text-align: right; border: 1px solid black;}
					.totals     		{padding: 5px; text-align: right; border: 1px solid black;}
					.blad				{background-color: red; font-weight: bold;}
					.row_descr	{padding: 5px; text-align: left; border: 1px solid black;}
					.remark			{padding-left: 8px; text-align: justify; vertical-align: baseline;
											color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
											padding-top: 4px; font-weight: normal;
										}
					.stars      		{padding-left: 2px; text-align: left; vertical-align: super;
											color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
											padding-top: 2px; font-weight: normal;
										}
					.stopka			{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal; width: 500px;
										}
				</style>
			<!--</head>
			<body>-->
				<xsl:apply-templates select="Zasiłki-dla-opiekunów-G"/>
			<!--</body>
		</html>-->
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Zasiłki-dla-opiekunów-G">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Część_A"/>
		<xsl:apply-templates select="Część_B"/>
		<xsl:apply-templates select="Część_C"/>
		<xsl:apply-templates select="Część_D"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/>
				<br/>
				<br/>
			</div>
		</xsl:if>
		<xsl:for-each select="../Nagłówek/Dane-jednostki-org">
			<table cellspacing="0" cellpadding="0">
				<tr>
					<td class="stamp" colspan="2">
						<xsl:value-of select="Pełna-nazwa"/>
					</td>
				</tr>
				<xsl:for-each select="Adres-pocztowy">
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Ulica-i-numer"/>
						</td>
					</tr>
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Kod-i-poczta"/>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="stamp" style="font-size: 12px; text-align: left">
						<xsl:for-each select="Telefon">
							Tel. <xsl:apply-templates/>&#160;
 						</xsl:for-each>
					</td>
					<td class="stamp" style="font-size: 12px; text-align: right">
						<xsl:for-each select="Faks">
							&#160;Fax <xsl:apply-templates/>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:for-each>
		<br/>
		<br/>
		<div class="auth_name">
			<xsl:for-each select="../Nagłówek">
				<xsl:for-each select="Wojewoda">
					Wojewoda <xsl:apply-templates/>
				</xsl:for-each>
				<xsl:for-each select="Gmina">
					Gmina <xsl:apply-templates/>
				</xsl:for-each>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
		<div class="heading_1">
			<xsl:choose>
				<xsl:when test="../Nagłówek/Gmina">
				 KWARTALNE SPRAWOZDANIE
			</xsl:when>
				<xsl:otherwise>
				KWARTALNE ZBIORCZE SPRAWOZDANIE 
			</xsl:otherwise>
			</xsl:choose>
		RZECZOWO-FINANSOWE Z REALIZACJI ZADAŃ Z ZAKRESU ZASIŁKÓW DLA OPIEKUNÓW<sup>1)</sup>
				<xsl:for-each select="Za-okres">
				<xsl:for-each select="Kwartał">
						ZA <xsl:apply-templates/> KWARTAŁ
					</xsl:for-each>
				<xsl:value-of select="concat(' ', Rok, ' R.')"/>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table class="stopka">
			<caption class="stopka">Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td>imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td>telefon służbowy:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>e-mail służbowy:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
			<tr>
				<td>Data sporządzenia sprawozdania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Tables-description">
		<xsl:param name="table_name"/>
		<xsl:choose>
			<xsl:when test="$table_name = 'Część_A'">Wydatki na zasiłek dla opiekuna finansowane z dotacji celowej z budżetu państwa oraz liczba zasiłków</xsl:when>
			<xsl:when test="$table_name = 'Część_B'">Wydatki na składki na ubezpieczenia społeczne i ubezpieczenie zdrowotne oraz liczba składek</xsl:when>
			<xsl:when test="$table_name = 'Część_C'">Informacja na temat nienależnie pobranych zasiłków dla opiekunów</xsl:when>
			<xsl:when test="$table_name = 'Część_D'">Informacja uzupełniająca o realizacji zasiłku dla opiekuna</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Table-caption">
		<caption>
			<xsl:value-of select="concat(substring-after(name(.), '_'), '. ')"/>
			<xsl:call-template name="Tables-description">
				<xsl:with-param name="table_name" select="name()"/>
			</xsl:call-template>
		</caption>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Rows-description">
		<xsl:param name="row_name"/>
		<xsl:choose>
			<xsl:when test="$row_name = 'A_1'">Zasiłek dla opiekuna</xsl:when>
			<xsl:when test="$row_name = 'B_1'">Składki na ubezpieczenia emerytalne i rentowe opłacane za osoby pobierające zasiłek dla opiekuna, z tego:</xsl:when>
			<xsl:when test="$row_name = 'B_1.1'">- opłacane na podstawie przepisów o systemie ubezpieczeń społecznych<sup>1)</sup></xsl:when>
			<xsl:when test="$row_name = 'B_1.2'">- opłacane na podstawie przepisów <nobr>o ubezpieczeniu</nobr> społecznym rolników<sup>2)</sup></xsl:when>
			<xsl:when test="$row_name = 'B_2'">Składki na ubezpieczenie zdrowotne opłacane <nobr>za osoby</nobr> pobierające zasiłek dla opiekuna</xsl:when>
			<xsl:when test="$row_name = 'C_1'">Stan należności z tytułu nienależnie pobranych zasiłków dla opiekunów na ostatni dzień miesiąca</xsl:when>
			<xsl:when test="$row_name = 'C_2'">Kwota umorzonych nienależnie pobranych zasiłków dla opiekunów</xsl:when>
			<xsl:when test="$row_name = 'C_3'">Kwota wygaszonych nienależnie pobranych zasiłków dla opiekunów</xsl:when>
			<xsl:when test="$row_name = 'C_4'">Kwota odzyskanych nienależnie pobranych zasiłków dla opiekunów, w tym:</xsl:when>
			<xsl:when test="$row_name = 'C_4.1'">- podlegająca zwrotowi do budżetu państwa</xsl:when>
			<xsl:when test="$row_name = 'D_1'">Liczba decyzji wydanych przez organ właściwy w sprawach dotyczących zasiłku dla opiekuna, w tym:</xsl:when>
			<xsl:when test="$row_name = 'D_1.1'">- ustalających prawo do zasiłku  w związku z uzyskaniem nowego orzeczenia o niepełnosprawności lub orzeczenia o znacznym stopniu niepełnosprawności</xsl:when>
			<xsl:when test="$row_name = 'D_1.2'">- stwierdzających nienależnie pobrane zasiłki</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Row-description">
		<td class="tab_row_no">
			<xsl:value-of select="concat(substring-after(name(), '_'), '.')"/>
		</td>
		<td class="row_descr">
			<xsl:call-template name="Rows-description">
				<xsl:with-param name="row_name" select="name()"/>
			</xsl:call-template>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwoty-i-liczby-kw-narast-koord-header">
		<xsl:param name="grouphdr1" select="'Wydatki narastająco od początku roku w zł'"/>
		<xsl:param name="grouphdr2" select="'Liczba zasiłków narastająco od początku roku'"/>
		<xsl:param name="descrwidth" select="25"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(round((100-number($descrwidth)-3) div 2))"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 4))"/>
		</xsl:param>
		<xsl:param name="double">
			<xsl:value-of select="string(number($single) * 2)"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="3">L.p.</th>
				<th rowspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr1"/>
				</th>
				<th colspan="4">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr2"/>
				</th>
			</tr>
			<tr>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy<br/>miesiąc<br/>kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>dwa<br/>miesiące<br/>kwartału</th>
				<th colspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>trzy miesiące kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy<br/>miesiąc<br/>kwartału</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>dwa<br/>miesiące<br/>kwartału</th>
				<th colspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>trzy miesiące kwartału</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>razem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym:<br/>w ramach<br/>koordynacji</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>razem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym:<br/>w ramach<br/>koordynacji</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
				<td class="tab_col_no">7</td>
				<td class="tab_col_no">8</td>
				<td class="tab_col_no">9</td>
				<td class="tab_col_no">10</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwoty-kw-narast-header">
		<xsl:param name="remark" select="'1)'"/>
		<xsl:param name="grouphdr" select="'Kwoty narastająco od początku roku w zł'"/>
		<xsl:param name="descrwidth" select="64"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(100-number($descrwidth)-3)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">L.p.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
					<xsl:if test="$remark">
						<sup>
							<xsl:value-of select="$remark"/>
						</sup>
					</xsl:if>
				</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>dwa miesiące kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzy miesiące kwartału</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwoty-kw-nienarast-header">
		<xsl:param name="remark"/>
		<xsl:param name="grouphdr" select="'Wykonanie miesięczne'"/>
		<xsl:param name="descrwidth" select="64"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(100-number($descrwidth)-3)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($triple) div 3))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="3%" rowspan="2">L.p.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="3">
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
					<xsl:if test="$remark">
						<sup>
							<xsl:value-of select="$remark"/>
						</sup>
					</xsl:if>
				</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>pierwszy miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>drugi miesiąc kwartału</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>trzeci miesiąc kwartału</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_A">
		<xsl:call-template name="Kwoty-i-liczby-kw-narast-koord">
			<xsl:with-param name="grouphdr1" select="'Wydatki narastająco od początku roku w zł'"/>
			<xsl:with-param name="grouphdr2" select="'Liczba zasiłków narastająco od początku roku'"/>
		</xsl:call-template>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 4 kwietnia 2014 r. o ustaleniu i wypłacie zasiłków dla opiekunów (Dz.U. z 2017 r. poz. 2092).'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_B">
		<xsl:call-template name="Kwoty-i-liczby-kw-narast-koord">
			<xsl:with-param name="grouphdr1" select="'Wydatki narastająco od początku roku w zł'"/>
			<xsl:with-param name="grouphdr2" select="'Liczba składek narastająco od początku roku'"/>
		</xsl:call-template>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Dotyczy ustawy z dnia 13 października 1998 r. o systemie ubezpieczeń  społecznych (Dz.U. z 2017 r. poz. 1778 z późn. zm.).'"/>
			<xsl:with-param name="remark2" select="'Dotyczy ustawy z dnia 20 grudnia 1990 r. o ubezpieczeniu społecznym rolników (Dz.U. z 2016 r. poz. 277 z późn. zm.).'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_C">
		<xsl:call-template name="Kwoty-kw-narast"/>
		<xsl:call-template name="Stopka-tabeli">
			<xsl:with-param name="remark1" select="'Zasada narastania nie dotyczy wiersza 1.'"/>
		</xsl:call-template>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_D">
		<xsl:call-template name="Kwoty-kw-nienarast"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwoty-i-liczby-kw-narast-koord">
		<xsl:param name="grouphdr1"/>
		<xsl:param name="grouphdr2"/>
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-i-liczby-kw-narast-koord-header">
				<xsl:with-param name="grouphdr1" select="$grouphdr1"/>
				<xsl:with-param name="grouphdr2" select="$grouphdr2"/>
			</xsl:call-template>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Kwoty-i-liczby-kw-narast-koord-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-i-liczby-kw-narast-koord-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Narast-koord-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Kwoty-narastająco'"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Narast-koord-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="subtree" select="'Liczby-narastająco'"/>
			<xsl:with-param name="format" select="$liczba"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Narast-koord-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Razem'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Koord'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-narast">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-kw-narast-header"/>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Kwoty-kw-narast-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-narast-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Narast-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Narast-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Dwa-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Trzy-miesiące'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-nienarast">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwoty-kw-nienarast-header"/>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Kwoty-kw-nienarast-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwoty-kw-nienarast-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Nienarast-content">
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Nienarast-content">
		<xsl:param name="skladniki"/>
		<xsl:param name="subtree"/>
		<xsl:param name="format"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Pierwszy-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Drugi-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="subtree" select="$subtree"/>
			<xsl:with-param name="column" select="'Trzeci-miesiąc'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$format"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Column">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="skladniki"/>
		<xsl:param name="format"/>
		<xsl:variable name="item" select="descendant-or-self::*[name(.) = $column]"/>
		<xsl:variable name="subtree_item" select="*[name(.) = $subtree]/descendant-or-self::*[name(.) = $column]"/>
		<xsl:variable name="contents">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="$subtree_item"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$item"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="suma">
					<xsl:with-param name="subtree" select="$subtree"/>
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$contents"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string(number($contents)) = 'NaN'">
							<div style="color: red; text-align: center;">???</div>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($contents, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<!--
	=============================================================================================
	-->
	<xsl:template name="suma">
		<xsl:param name="subtree"/>
		<xsl:param name="column"/>
		<xsl:param name="contents"/>
		<xsl:param name="format"/>
		<xsl:param name="skladniki"/>
		<xsl:variable name="wynik">
			<xsl:choose>
				<xsl:when test="$subtree">
					<xsl:value-of select="sum(../*[contains($skladniki,concat(name(.),' '))]/*[name(.) = $subtree]/descendant-or-self::*[name(.) = $column])"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="sum(../*[contains($skladniki,concat(name(.),' '))]/descendant-or-self::*[name(.) = $column])"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
        <xsl:choose>
            <xsl:when test="string(number($wynik)) = 'NaN'">
                <td class="totals" style="background-color: red">
                    <center>???</center>
                </td>
            </xsl:when>
            <xsl:when test="string(number($contents)) != 'NaN' and $contents != ''">
                <xsl:choose>
                    <xsl:when test="$contents != $wynik">
                        <td class="contents error">
                            <xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
                            <br/>
                            <xsl:value-of select="concat('powinno być: ', format-number($wynik, $format))"/>
                        </td>
                    </xsl:when>
                    <xsl:otherwise>
                        <td class="totals">
                            <xsl:value-of select="format-number($wynik, $format)"/>
                        </td>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <td class="totals">
                    <xsl:value-of select="format-number($wynik, $format)"/>
                </td>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Stopka-tabeli">
		<xsl:param name="remark1"/>
		<xsl:param name="remark2"/>
		<xsl:param name="remark3"/>
		<table class="bottom_table" cellspacing="0" cellpadding="0">
			<xsl:if test="$remark1">
				<xsl:call-template name="Stopka-tabeli-wiersz">
					<xsl:with-param name="numer" select="'1'"/>
					<xsl:with-param name="opis" select="$remark1"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$remark2">
				<xsl:call-template name="Stopka-tabeli-wiersz">
					<xsl:with-param name="numer" select="'2'"/>
					<xsl:with-param name="opis" select="$remark2"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$remark3">
				<xsl:call-template name="Stopka-tabeli-wiersz">
					<xsl:with-param name="numer" select="'3'"/>
					<xsl:with-param name="opis" select="$remark3"/>
				</xsl:call-template>
			</xsl:if>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka-tabeli-wiersz">
		<xsl:param name="numer"/>
		<xsl:param name="opis"/>
		<tr>
			<td class="stars">
				<xsl:value-of select="$numer"/>)
			</td>
			<td class="remark">
				<xsl:value-of select="$opis"/>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
