package pl.topteam.sprawozdania.reflect;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;

import com.google.common.collect.ImmutableMap;

public final class Deskryptory {
	private Deskryptory() {}
	
	public static Map<Field, PropertyDescriptor> deskryptory(Class<?> część) {
		Field[] fields = część.getDeclaredFields();
		try {
			PropertyDescriptor[] descriptors = Introspector.getBeanInfo(część).getPropertyDescriptors();
			Map<String, PropertyDescriptor> index = Arrays.stream(descriptors).collect(ImmutableMap.toImmutableMap(PropertyDescriptor::getName, Function.identity()));
			return Arrays.stream(fields).collect(ImmutableMap.toImmutableMap(Function.identity(), field -> index.get(field.getName())));
		} catch (IntrospectionException exception) {
			throw new AssertionError();
		}
	}
}
