package pl.topteam.swiadczenia.sprawozdania.rodzinne_1_04b;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;

import pl.topteam.sprawozdania.reflect.Deskryptory;
import pl.topteam.sprawozdania.reflect.Składniki;

public final class Część__B_Validator implements ConstraintValidator<Część__B_Constraint, Część__B> {
	private static final Graph<Field> SKŁADNIKI = Składniki.składniki(Część__B.class);
	
	@Override
	public void initialize(Część__B_Constraint adnotacja) {
	}
	
	@Override
	public boolean isValid(Część__B część, ConstraintValidatorContext kontekst) {
		boolean wynik = true;
		kontekst.disableDefaultConstraintViolation();
		String komunikat = kontekst.getDefaultConstraintMessageTemplate();
		for (Field pole : SKŁADNIKI.nodes()) {
			if (SKŁADNIKI.predecessors(pole).isEmpty()) {
				continue;
			}
			WydatkiISkladkiKoord wartość = wartość(część, pole);
			Set<WydatkiISkladkiKoord> składniki = SKŁADNIKI.predecessors(pole).stream().map(składnik -> wartość(część, składnik)).collect(ImmutableSet.toImmutableSet());
			if (wartość.getWydatkiNarastająco().getPierwszyMiesiąc() != składniki.stream().map(WydatkiISkladkiKoord::getWydatkiNarastająco).mapToLong(KwotyKwNarastKoord::getPierwszyMiesiąc).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getWydatkiNarastająco().getDwaMiesiące() != składniki.stream().map(WydatkiISkladkiKoord::getWydatkiNarastająco).mapToLong(KwotyKwNarastKoord::getDwaMiesiące).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("dwaMiesiące").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getWydatkiNarastająco().getTrzyMiesiące().getRazem() != składniki.stream().map(WydatkiISkladkiKoord::getWydatkiNarastająco).map(KwotyKwNarastKoord::getTrzyMiesiące).mapToLong(KoordKwota::getRazem).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("trzyMiesiące").addPropertyNode("razem").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getWydatkiNarastająco().getTrzyMiesiące().getKoord() != null && składniki.stream().map(WydatkiISkladkiKoord::getWydatkiNarastająco).map(KwotyKwNarastKoord::getTrzyMiesiące).map(KoordKwota::getKoord).anyMatch(Objects::nonNull)) {
				if ((long) wartość.getWydatkiNarastająco().getTrzyMiesiące().getKoord() != składniki.stream().map(WydatkiISkladkiKoord::getWydatkiNarastająco).map(KwotyKwNarastKoord::getTrzyMiesiące).map(KoordKwota::getKoord).filter(Objects::nonNull).mapToLong(Number::longValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("wydatkiNarastająco").addPropertyNode("trzyMiesiące").addPropertyNode("koord").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaOsób().getPierwszyMiesiąc() != null && składniki.stream().map(WydatkiISkladkiKoord::getLiczbaOsób).map(LiczbyKwNarastKoord::getPierwszyMiesiąc).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaOsób().getPierwszyMiesiąc() != składniki.stream().map(WydatkiISkladkiKoord::getLiczbaOsób).map(LiczbyKwNarastKoord::getPierwszyMiesiąc).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaOsób").addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaOsób().getDwaMiesiące() != null && składniki.stream().map(WydatkiISkladkiKoord::getLiczbaOsób).map(LiczbyKwNarastKoord::getDwaMiesiące).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaOsób().getDwaMiesiące() != składniki.stream().map(WydatkiISkladkiKoord::getLiczbaOsób).map(LiczbyKwNarastKoord::getDwaMiesiące).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaOsób").addPropertyNode("dwaMiesiące").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaOsób().getTrzyMiesiące().getRazem() != null && składniki.stream().map(WydatkiISkladkiKoord::getLiczbaOsób).map(LiczbyKwNarastKoord::getTrzyMiesiące).map(KoordLiczba::getRazem).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaOsób().getTrzyMiesiące().getRazem() != składniki.stream().map(WydatkiISkladkiKoord::getLiczbaOsób).map(LiczbyKwNarastKoord::getTrzyMiesiące).map(KoordLiczba::getRazem).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaOsób").addPropertyNode("trzyMiesiące").addPropertyNode("razem").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getLiczbaOsób().getTrzyMiesiące().getKoord() != null && składniki.stream().map(WydatkiISkladkiKoord::getLiczbaOsób).map(LiczbyKwNarastKoord::getTrzyMiesiące).map(KoordLiczba::getKoord).anyMatch(Objects::nonNull)) {
				if ((int) wartość.getLiczbaOsób().getTrzyMiesiące().getKoord() != składniki.stream().map(WydatkiISkladkiKoord::getLiczbaOsób).map(LiczbyKwNarastKoord::getTrzyMiesiące).map(KoordLiczba::getKoord).filter(Objects::nonNull).mapToInt(Number::intValue).sum()) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbaOsób").addPropertyNode("trzyMiesiące").addPropertyNode("koord").addConstraintViolation();
					wynik = false;
				}
			}
		}
		return wynik;
	}
	
	private WydatkiISkladkiKoord wartość(Część__B część, Field składnik) {
		try {
			return (WydatkiISkladkiKoord) DESKRYPTORY.get(składnik).getReadMethod().invoke(część);
		} catch (Exception wyjątek) {
			throw new AssertionError();
		}
	}
	
	private static final Map<Field, PropertyDescriptor> DESKRYPTORY = Deskryptory.deskryptory(Część__B.class);
}
