package pl.topteam.swiadczenia.sprawozdania.rodzinne_1_04b;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;

import pl.topteam.sprawozdania.reflect.Deskryptory;
import pl.topteam.sprawozdania.reflect.Składniki;

public final class Część__C_Validator implements ConstraintValidator<Część__C_Constraint, Część__C> {
	private static final Graph<Field> SKŁADNIKI = Składniki.składniki(Część__C.class);
	
	@Override
	public void initialize(Część__C_Constraint adnotacja) {
	}
	
	@Override
	public boolean isValid(Część__C część, ConstraintValidatorContext kontekst) {
		boolean wynik = true;
		kontekst.disableDefaultConstraintViolation();
		String komunikat = kontekst.getDefaultConstraintMessageTemplate();
		for (Field pole : SKŁADNIKI.nodes()) {
			if (SKŁADNIKI.predecessors(pole).isEmpty()) {
				continue;
			}
			KwotyKwNarast wartość = wartość(część, pole);
			Set<KwotyKwNarast> składniki = SKŁADNIKI.predecessors(pole).stream().map(składnik -> wartość(część, składnik)).collect(ImmutableSet.toImmutableSet());
			if (wartość.getPierwszyMiesiąc() != null && składniki.stream().map(KwotyKwNarast::getPierwszyMiesiąc).anyMatch(Objects::nonNull)) {
				if (wartość.getPierwszyMiesiąc().compareTo(składniki.stream().map(KwotyKwNarast::getPierwszyMiesiąc).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getDwaMiesiące() != null && składniki.stream().map(KwotyKwNarast::getDwaMiesiące).anyMatch(Objects::nonNull)) {
				if (wartość.getDwaMiesiące().compareTo(składniki.stream().map(KwotyKwNarast::getDwaMiesiące).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("dwaMiesiące").addConstraintViolation();
					wynik = false;
				}
			}
			if (wartość.getTrzyMiesiące() != null && składniki.stream().map(KwotyKwNarast::getTrzyMiesiące).anyMatch(Objects::nonNull)) {
				if (wartość.getTrzyMiesiące().compareTo(składniki.stream().map(KwotyKwNarast::getTrzyMiesiące).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
					kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("trzyMiesiące").addConstraintViolation();
					wynik = false;
				}
			}
		}
		return wynik;
	}
	
	private KwotyKwNarast wartość(Część__C część, Field składnik) {
		try {
			return (KwotyKwNarast) DESKRYPTORY.get(składnik).getReadMethod().invoke(część);
		} catch (Exception wyjątek) {
			throw new AssertionError();
		}
	}
	
	private static final Map<Field, PropertyDescriptor> DESKRYPTORY = Deskryptory.deskryptory(Część__C.class);
}
