package pl.topteam.swiadczenia.sprawozdania.rodzinne_1_04b;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;

import pl.topteam.sprawozdania.reflect.Deskryptory;
import pl.topteam.sprawozdania.reflect.Składniki;

public final class Część__G_1_Validator implements ConstraintValidator<Część__G_1_Constraint, Część__G_1> {
	private static final Graph<Field> SKŁADNIKI = Składniki.składniki(Część__G_1.class);
	
	@Override
	public void initialize(Część__G_1_Constraint adnotacja) {
	}
	
	@Override
	public boolean isValid(Część__G_1 część, ConstraintValidatorContext kontekst) {
		boolean wynik = true;
		kontekst.disableDefaultConstraintViolation();
		String komunikat = kontekst.getDefaultConstraintMessageTemplate();
		for (Field pole : SKŁADNIKI.nodes()) {
			if (SKŁADNIKI.predecessors(pole).isEmpty()) {
				continue;
			}
			WykonanieKwMienarastRodziny wartość = wartość(część, pole);
			Set<WykonanieKwMienarastRodziny> składniki = SKŁADNIKI.predecessors(pole).stream().map(składnik -> wartość(część, składnik)).collect(ImmutableSet.toImmutableSet());
			if (wartość.getPierwszyMiesiąc().getJednoDziecko() != składniki.stream().map(WykonanieKwMienarastRodziny::getPierwszyMiesiąc).mapToInt(Dzieci::getJednoDziecko).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("pierwszyMiesiąc").addPropertyNode("jednoDziecko").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getPierwszyMiesiąc().getDwojeDzieci() != składniki.stream().map(WykonanieKwMienarastRodziny::getPierwszyMiesiąc).mapToInt(Dzieci::getDwojeDzieci).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("pierwszyMiesiąc").addPropertyNode("dwojeDzieci").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getPierwszyMiesiąc().getTrojeDzieci() != składniki.stream().map(WykonanieKwMienarastRodziny::getPierwszyMiesiąc).mapToInt(Dzieci::getTrojeDzieci).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("pierwszyMiesiąc").addPropertyNode("trojeDzieci").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getPierwszyMiesiąc().getCzworoDzieci() != składniki.stream().map(WykonanieKwMienarastRodziny::getPierwszyMiesiąc).mapToInt(Dzieci::getCzworoDzieci).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("pierwszyMiesiąc").addPropertyNode("czworoDzieci").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getDrugiMiesiąc().getJednoDziecko() != składniki.stream().map(WykonanieKwMienarastRodziny::getDrugiMiesiąc).mapToInt(Dzieci::getJednoDziecko).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("drugiMiesiąc").addPropertyNode("jednoDziecko").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getDrugiMiesiąc().getDwojeDzieci() != składniki.stream().map(WykonanieKwMienarastRodziny::getDrugiMiesiąc).mapToInt(Dzieci::getDwojeDzieci).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("drugiMiesiąc").addPropertyNode("dwojeDzieci").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getDrugiMiesiąc().getTrojeDzieci() != składniki.stream().map(WykonanieKwMienarastRodziny::getDrugiMiesiąc).mapToInt(Dzieci::getTrojeDzieci).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("drugiMiesiąc").addPropertyNode("trojeDzieci").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getDrugiMiesiąc().getCzworoDzieci() != składniki.stream().map(WykonanieKwMienarastRodziny::getDrugiMiesiąc).mapToInt(Dzieci::getCzworoDzieci).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("drugiMiesiąc").addPropertyNode("czworoDzieci").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getTrzeciMiesiąc().getJednoDziecko() != składniki.stream().map(WykonanieKwMienarastRodziny::getTrzeciMiesiąc).mapToInt(Dzieci::getJednoDziecko).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("trzeciMiesiąc").addPropertyNode("jednoDziecko").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getTrzeciMiesiąc().getDwojeDzieci() != składniki.stream().map(WykonanieKwMienarastRodziny::getTrzeciMiesiąc).mapToInt(Dzieci::getDwojeDzieci).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("trzeciMiesiąc").addPropertyNode("dwojeDzieci").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getTrzeciMiesiąc().getTrojeDzieci() != składniki.stream().map(WykonanieKwMienarastRodziny::getTrzeciMiesiąc).mapToInt(Dzieci::getTrojeDzieci).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("trzeciMiesiąc").addPropertyNode("trojeDzieci").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getTrzeciMiesiąc().getCzworoDzieci() != składniki.stream().map(WykonanieKwMienarastRodziny::getTrzeciMiesiąc).mapToInt(Dzieci::getCzworoDzieci).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("trzeciMiesiąc").addPropertyNode("czworoDzieci").addConstraintViolation();
				wynik = false;
			}
		}
		return wynik;
	}
	
	private WykonanieKwMienarastRodziny wartość(Część__G_1 część, Field składnik) {
		try {
			return (WykonanieKwMienarastRodziny) DESKRYPTORY.get(składnik).getReadMethod().invoke(część);
		} catch (Exception wyjątek) {
			throw new AssertionError();
		}
	}
	
	private static final Map<Field, PropertyDescriptor> DESKRYPTORY = Deskryptory.deskryptory(Część__G_1.class);
}
