package pl.topteam.swiadczenia.sprawozdania.rodzinne_1_04c;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import pl.topteam.sprawozdania.reflect.Deskryptory;
import pl.topteam.sprawozdania.reflect.Składniki;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;

public final class Część__D_2_Validator implements ConstraintValidator<Część__D_2_Constraint, Część__D_2> {
	private static final Graph<Field> SKŁADNIKI = Składniki.składniki(Część__D_2.class);
	
	@Override
	public void initialize(Część__D_2_Constraint adnotacja) {
	}
	
	@Override
	public boolean isValid(Część__D_2 część, ConstraintValidatorContext kontekst) {
		boolean wynik = true;
		kontekst.disableDefaultConstraintViolation();
		String komunikat = kontekst.getDefaultConstraintMessageTemplate();
		for (Field pole : SKŁADNIKI.nodes()) {
			if (SKŁADNIKI.predecessors(pole).isEmpty()) {
				continue;
			}
			KwotyKwNarastMarszalek wartość = wartość(część, pole);
			Set<KwotyKwNarastMarszalek> składniki = SKŁADNIKI.predecessors(pole).stream().map(składnik -> wartość(część, składnik)).collect(ImmutableSet.toImmutableSet());
			if (wartość.getPierwszyMiesiąc() != składniki.stream().mapToLong(KwotyKwNarastMarszalek::getPierwszyMiesiąc).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getDwaMiesiące() != składniki.stream().mapToLong(KwotyKwNarastMarszalek::getDwaMiesiące).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("dwaMiesiące").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getTrzyMiesiące().getRazem() != składniki.stream().map(KwotyKwNarastMarszalek::getTrzyMiesiące).mapToLong(UbiegłeKwota::getRazem).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("trzyMiesiące").addPropertyNode("razem").addConstraintViolation();
				wynik = false;
			}
			if (wartość.getTrzyMiesiące().getUbiegłe() != składniki.stream().map(KwotyKwNarastMarszalek::getTrzyMiesiące).mapToLong(UbiegłeKwota::getUbiegłe).sum()) {
				kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("trzyMiesiące").addPropertyNode("ubiegłe").addConstraintViolation();
				wynik = false;
			}
		}
		return wynik;
	}
	
	private KwotyKwNarastMarszalek wartość(Część__D_2 część, Field składnik) {
		try {
			return (KwotyKwNarastMarszalek) DESKRYPTORY.get(składnik).getReadMethod().invoke(część);
		} catch (Exception wyjątek) {
			throw new AssertionError();
		}
	}
	
	private static final Map<Field, PropertyDescriptor> DESKRYPTORY = Deskryptory.deskryptory(Część__D_2.class);
}
