package pl.topteam.swiadczenia.sprawozdania.zdo_1_04a;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import pl.topteam.sprawozdania.reflect.Deskryptory;
import pl.topteam.sprawozdania.reflect.Składniki;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;

public class Część__B_Validator implements ConstraintValidator<Część__B_Constraint, Część__B> {

    private static final Graph<Field> SKŁADNIKI = Składniki.składniki(Część__B.class);

    @Override
    public void initialize(Część__B_Constraint adnotacja) {
    }

    @Override
    public boolean isValid(Część__B czescB, ConstraintValidatorContext kontekst) {
        boolean wynik = true;
        kontekst.disableDefaultConstraintViolation();
        String komunikat = kontekst.getDefaultConstraintMessageTemplate();
        for (Field pole : SKŁADNIKI.nodes()) {
            if (SKŁADNIKI.predecessors(pole).isEmpty()) {
                continue;
            }
            KwotyILiczbyKwNarastKoord wartość = wartość(czescB, pole);
            Set<KwotyILiczbyKwNarastKoord> składniki = SKŁADNIKI.predecessors(pole).stream().map(składnik -> wartość(czescB, składnik)).collect(ImmutableSet.toImmutableSet());
            if (wartość.getKwotyNarastająco().getPierwszyMiesiąc() != składniki.stream().map(KwotyILiczbyKwNarastKoord::getKwotyNarastająco).mapToLong(KwotyNarastKwKoord::getPierwszyMiesiąc).sum()) {
                kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("kwotyNarastająco").addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
                wynik = false;
            }
            if (wartość.getKwotyNarastająco().getDwaMiesiące() != składniki.stream().map(KwotyILiczbyKwNarastKoord::getKwotyNarastająco).mapToLong(KwotyNarastKwKoord::getDwaMiesiące).sum()) {
                kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("kwotyNarastająco").addPropertyNode("dwaMiesiace").addConstraintViolation();
                wynik = false;
            }
            if (wartość.getKwotyNarastająco().getTrzyMiesiące().getRazem() != składniki.stream().map(KwotyILiczbyKwNarastKoord::getKwotyNarastająco).map(KwotyNarastKwKoord::getTrzyMiesiące).mapToLong(KwotaKwKoord::getRazem).sum()) {
                kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("kwotyNarastająco").addPropertyNode("trzyMiesiące").addPropertyNode("razem").addConstraintViolation();
                wynik = false;
            }
            if (wartość.getKwotyNarastająco().getTrzyMiesiące().getKoord() != składniki.stream().map(KwotyILiczbyKwNarastKoord::getKwotyNarastająco).map(KwotyNarastKwKoord::getTrzyMiesiące).mapToLong(KwotaKwKoord::getKoord).sum()) {
                kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("kwotyNarastająco").addPropertyNode("trzyMiesiące").addPropertyNode("koord").addConstraintViolation();
                wynik = false;
            }
            if (wartość.getLiczbyNarastająco().getPierwszyMiesiąc() != składniki.stream().map(KwotyILiczbyKwNarastKoord::getLiczbyNarastająco).mapToInt(LiczbyNarastKwKoord::getPierwszyMiesiąc).sum()) {
                kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbyNarastająco").addPropertyNode("pierwszyMiesiąc").addConstraintViolation();
                wynik = false;
            }
            if (wartość.getLiczbyNarastająco().getDwaMiesiące() != składniki.stream().map(KwotyILiczbyKwNarastKoord::getLiczbyNarastająco).mapToInt(LiczbyNarastKwKoord::getDwaMiesiące).sum()) {
                kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbyNarastająco").addPropertyNode("dwaMiesiace").addConstraintViolation();
                wynik = false;
            }
            if (wartość.getLiczbyNarastająco().getTrzyMiesiące().getRazem() != składniki.stream().map(KwotyILiczbyKwNarastKoord::getLiczbyNarastająco).map(LiczbyNarastKwKoord::getTrzyMiesiące).mapToInt(LiczbaKwKoord::getRazem).sum()) {
                kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbyNarastająco").addPropertyNode("trzyMiesiące").addPropertyNode("razem").addConstraintViolation();
                wynik = false;
            }
            if (wartość.getLiczbyNarastająco().getTrzyMiesiące().getKoord() != składniki.stream().map(KwotyILiczbyKwNarastKoord::getLiczbyNarastająco).map(LiczbyNarastKwKoord::getTrzyMiesiące).mapToInt(LiczbaKwKoord::getKoord).sum()) {
                kontekst.buildConstraintViolationWithTemplate(komunikat).addPropertyNode(pole.getName()).addPropertyNode("liczbyNarastająco").addPropertyNode("trzyMiesiące").addPropertyNode("koord").addConstraintViolation();
                wynik = false;
            }
        }
        return wynik;
    }

    private KwotyILiczbyKwNarastKoord wartość(Część__B część, Field składnik) {
        try {
            return (KwotyILiczbyKwNarastKoord) DESKRYPTORY.get(składnik).getReadMethod().invoke(część);
        } catch (Exception wyjątek) {
            throw new AssertionError();
        }
    }

    private static final Map<Field, PropertyDescriptor> DESKRYPTORY = Deskryptory.deskryptory(Część__B.class);
}
