<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<!--
	=============================================================================================
	-->
	<xsl:decimal-format grouping-separator="&#160;" decimal-separator=","/>
	<xsl:variable name="obsada" select="'###&#160;###&#160;###&#160;##0,00'"/>
	<xsl:variable name="kwota" select="'###&#160;###&#160;###&#160;##0'"/>
	<xsl:variable name="width" select="'944'"/>
	<xsl:variable name="widthTabSmall" select="'690'"/>
	<!--
	=============================================================================================
	-->
	<xsl:template match="/">
		<html>
			<head>
				<style type="text/css">
					.reason     	{color: red; font-family: Tahoma, Verdana; font-size: 14px;
											font-weight: bold; text-align: right;
											width: <xsl:value-of select="$width"/>px;
										}
					.stamp      	{color: #000000; font-family: Tahoma, Verdana; font-size: 14px;
											font-weight: bold; text-align: center;
										}
					.auth_name	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
											font-weight: bold;
										}
					.heading_1  	{color: #000000; font-family: Tahoma, Verdana; font-size: 16px;
											font-weight: bold; text-align: justify;
											width: <xsl:value-of select="$width"/>px;
										}
					.data_table	{border: 1px solid black; border-collapse: collapse;
											color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal;
										}
					.bottom_table {width: 600px; border-width: 0px;}
					th          		{padding: 5px; font-weight: bold; border: 1px solid black;}
					caption     	{color: #000000; font-family: Tahoma, Verdana;
											text-align: left; font-size: 14px; font-weight: bold;
											margin-bottom: 0.4em;
										}
					.tab_col_no	{text-align: center; font-size: 8px;
											border: 1px solid black; padding: 5px;
										}
					.tab_row_no	{padding-left: 5px; padding-top: 5px; padding-bottom: 5px;
											text-align: left; border: 1px solid black;
										}
					.contents		{padding: 5px; text-align: right; border: 1px solid black;}
					.totals     		{padding: 5px; text-align: right; border: 1px solid black;}
					.blad				{background-color: red; font-weight: bold;}
					.row_descr	{padding: 5px; text-align: left; border: 1px solid black;}
					.remark			{padding-left: 8px; text-align: justify; vertical-align: baseline;
											color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
											padding-top: 4px; font-weight: normal;
										}
					.stars      		{padding-left: 2px; text-align: left; vertical-align: super;
											color: #000000; font-family: Tahoma, Verdana; font-size: 9px;
											padding-top: 2px; font-weight: normal;
										}
					.stopka			{color: #000000; font-family: Tahoma, Verdana; font-size: 11px;
											font-weight: normal; width: 500px;
										}
				</style>
			</head>
			<body>
				<xsl:apply-templates select="SW-G"/>
			</body>
		</html>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="SW-G">
		<xsl:apply-templates select="Metryczka"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:apply-templates select="Część_A.1"/>
		<xsl:apply-templates select="Część_A.2"/>
		<xsl:apply-templates select="Część_B.1"/>
		<xsl:apply-templates select="Część_B.2"/>
		<xsl:apply-templates select="Część_C"/>
		<xsl:apply-templates select="Część_D"/>
		<xsl:apply-templates select="Część_E"/>
		<!-- część F nie wyświetlana w okresie październik - grudzień-->
		<xsl:if test="number(Metryczka/Za-okres/Miesiąc) &lt; 10">
			<xsl:apply-templates select="Część_F"/>
		</xsl:if>
		<xsl:apply-templates select="Część_G"/>
		<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
		<xsl:call-template name="Stopka"/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Metryczka">
		<xsl:if test="Opis and Opis != ''">
			<div class="reason">
				<xsl:value-of select="Opis"/>
				<br/>
				<br/>
			</div>
		</xsl:if>
		<xsl:for-each select="../Nagłówek/Dane-jednostki-org">
			<table cellspacing="0" cellpadding="0">
				<tr>
					<td class="stamp" colspan="2">
						<xsl:value-of select="Pełna-nazwa"/>
					</td>
				</tr>
				<xsl:for-each select="Adres-pocztowy">
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Ulica-i-numer"/>
						</td>
					</tr>
					<tr>
						<td class="stamp" colspan="2">
							<xsl:value-of select="Kod-i-poczta"/>
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="stamp" style="font-size: 12px; text-align: left">
						<xsl:for-each select="Telefon">
							Tel. <xsl:apply-templates/>&#160;
 						</xsl:for-each>
					</td>
					<td class="stamp" style="font-size: 12px; text-align: right">
						<xsl:for-each select="Faks">
							&#160;Fax <xsl:apply-templates/>
						</xsl:for-each>
					</td>
				</tr>
			</table>
		</xsl:for-each>
		<br/>
		<br/>
		<div class="auth_name">
			<xsl:for-each select="../Nagłówek">
				<xsl:for-each select="Wojewoda">
					Wojewoda <xsl:apply-templates/>
				</xsl:for-each>
				<xsl:for-each select="Gmina">
					Gmina <xsl:apply-templates/>
				</xsl:for-each>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
		<div class="heading_1">
			<xsl:if test="../Nagłówek/Wojewoda">
				MIESIĘCZNE ZBIORCZE 
			</xsl:if>
			SPRAWOZDANIE RZECZOWO-FINANSOWE Z WYKONYWANIA ZADAŃ Z ZAKRESU ŚWIADCZENIA WYCHOWAWCZEGO
			<xsl:for-each select="Za-okres">
				<xsl:apply-templates select="Miesiąc"/>
				<xsl:value-of select="concat(' ', Rok, ' R.')"/>
			</xsl:for-each>
		</div>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Stopka">
		<xsl:variable name="kto" select="Nagłówek/Osoba-sporządzająca"/>
		<table class="stopka">
			<caption class="stopka">Osoba&#160;sporządzająca&#160;sprawozdanie:</caption>
			<tr>
				<td>imię i nazwisko:</td>
				<td>
					<xsl:value-of select="$kto/Imię-i-nazwisko"/>
				</td>
			</tr>
			<tr>
				<td>telefon służbowy:</td>
				<td>
					<xsl:value-of select="$kto/Telefon"/>
				</td>
			</tr>
			<tr>
				<td>e-mail służbowy:</td>
				<td>
					<xsl:value-of select="$kto/E-mail"/>
				</td>
			</tr>
			<tr>
				<td>Data sporządzenia sprawozdania:</td>
				<td>
					<xsl:value-of select="$kto/Data-wykonania"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Miesiąc">
		ZA MIESIĄC
		<xsl:choose>
			<xsl:when test=". = '1'">STYCZEŃ</xsl:when>
			<xsl:when test=". = '2'">LUTY</xsl:when>
			<xsl:when test=". = '3'">MARZEC</xsl:when>
			<xsl:when test=". = '4'">KWIECIEŃ</xsl:when>
			<xsl:when test=". = '5'">MAJ</xsl:when>
			<xsl:when test=". = '6'">CZERWIEC</xsl:when>
			<xsl:when test=". = '7'">LIPIEC</xsl:when>
			<xsl:when test=". = '8'">SIERPIEŃ</xsl:when>
			<xsl:when test=". = '9'">WRZESIEŃ</xsl:when>
			<xsl:when test=". = '10'">PAŹDZIERNIK</xsl:when>
			<xsl:when test=". = '11'">LISTOPAD</xsl:when>
			<xsl:otherwise>GRUDZIEŃ</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Tables-description">
		<xsl:param name="table_name"/>
		<xsl:choose>
			<xsl:when test="$table_name = 'Część_A.1'">Wydatki na świadczenie wychowawcze sfinansowane z dotacji celowej z budżetu państwa oraz liczba świadczeń wypłaconych należnych za ten miesiąc</xsl:when>
			<xsl:when test="$table_name = 'Część_A.2'">Wydatki na świadczenie wychowawcze sfinansowane z dotacji celowej z budżetu państwa oraz liczba świadczeń wypłaconych należnych za wcześniejsze miesiące</xsl:when>
			<xsl:when test="$table_name = 'Część_B.1'">Informacje na temat należności z tytułu nienależnie pobranych świadczeń wychowawczych</xsl:when>
			<xsl:when test="$table_name = 'Część_B.2'">Informacje o odzyskanych świadczeniach wychowawczych nienależnie pobranych</xsl:when>
			<xsl:when test="$table_name = 'Część_C'">Informacje uzupełniające o realizacji świadczeń wychowawczych</xsl:when>
			<xsl:when test="$table_name = 'Część_D'">Informacje o rodzinach pobierających świadczenie wychowawcze na pierwsze dziecko</xsl:when>
			<xsl:when test="$table_name = 'Część_E'">Informacje o liczbie rodzin pobierających świadczenie wychowawcze</xsl:when>
			<xsl:when test="$table_name = 'Część_F'">Informacje na temat przyczyny ustalenia prawa do świadczenia wychowawczego<sup>1)</sup>
</xsl:when>
			<xsl:when test="$table_name = 'Część_G'">Informacje na temat finansowania świadczeń wychowawczych i kosztów ich obsługi</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Table-caption">
		<caption>
			<xsl:value-of select="concat(substring-after(name(.), '_'), '. ')"/>
			<xsl:call-template name="Tables-description">
				<xsl:with-param name="table_name" select="name()"/>
			</xsl:call-template>
		</caption>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Rows-description">
		<xsl:param name="row_name"/>
		<xsl:choose>
			<xsl:when test="$row_name = 'A.1_1'">Świadczenie wychowawcze przekazane w formie pieniężnej</xsl:when>
			<xsl:when test="$row_name = 'A.1_2'">Świadczenie wychowawcze przekazane w formie rzeczowej lub w formie opłacania usług w związku z wystąpieniem co najmniej jednej z przesłanek, o których mowa w art. 9 ustawy<sup>1)</sup>, z tego:</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.1'">- przekazane w formie rzeczowej</xsl:when>
			<xsl:when test="$row_name = 'A.1_2.2'">- przekazane w formie opłacenia usług</xsl:when>
			<xsl:when test="$row_name = 'A.2_1'">Świadczenie wychowawcze przekazane w formie pieniężnej</xsl:when>
			<xsl:when test="$row_name = 'A.2_2'">Świadczenie wychowawcze przekazane w formie rzeczowej lub w formie opłacania usług w związku z wystąpieniem co najmniej jednej z przesłanek, o których mowa w art. 9 ustawy<sup>1)</sup>, z tego:</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.1'">- przekazane w formie rzeczowej</xsl:when>
			<xsl:when test="$row_name = 'A.2_2.2'">- przekazane w formie opłacenia usług</xsl:when>
			<xsl:when test="$row_name = 'B.1_1'">Stan należności z tytułu nienależnie pobranych świadczeń wychowawczych na ostatni dzień miesiąca</xsl:when>
			<xsl:when test="$row_name = 'B.1_2'">Kwota umorzonych nienależnie pobranych świadczeń wychowawczych</xsl:when>
			<xsl:when test="$row_name = 'B.1_3'">Kwota nienależnie pobranych świadczeń wychowawczych, w przypadku których w danym miesiącu podjęto decyzję o rozłożeniu na raty</xsl:when>
			<xsl:when test="$row_name = 'B.1_4'">Kwota nienależnie pobranych świadczeń wychowawczych, potrącona w danym miesiącu z bieżąco wypłacanych świadczeń</xsl:when>
			<xsl:when test="$row_name = 'B.1_5'">Kwota nienależnie pobranych świadczeń wychowawczych wygaszonych na podstawie art. 25 ust. 12 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'B.2_1'">Kwota odzyskanych nienależnie pobranych świadczeń wychowawczych, w tym: </xsl:when>
			<xsl:when test="$row_name = 'B.2_1.1'">- podlegająca zwrotowi do budżetu państwa</xsl:when>
			<xsl:when test="$row_name = 'C_1'">Liczba wniosków dotyczących świadczenia wychowawczego złożonych do organu właściwego, w tym:</xsl:when>
			<xsl:when test="$row_name = 'C_1.1'">- o przyznanie świadczeń, z tego :</xsl:when>
			<xsl:when test="$row_name = 'C_1.1.1'">- na pierwsze dziecko i na kolejne dzieci</xsl:when>
			<xsl:when test="$row_name = 'C_1.1.2'">- na drugie dziecko i na kolejne dzieci</xsl:when>
			<xsl:when test="$row_name = 'C_1.2'">- przekazanych według właściwości, w tym:</xsl:when>
			<xsl:when test="$row_name = 'C_1.2.1'">- przekazanych według właściwości do marszałka województwa</xsl:when>
			<xsl:when test="$row_name = 'C_1.3'">- pozostawionych bez rozpatrzenia z powodu niewywiązania się z obowiązku uzupełnienia danych w ustawowo wyznaczonym terminie</xsl:when>
			<xsl:when test="$row_name = 'C_2'">Liczba wniosków dotyczących świadczenia wychowawczego złożonych do organu właściwego za pomocą systemu teleinformatycznego, z tego:</xsl:when>
			<xsl:when test="$row_name = 'C_2.1'">- utworzonego przez ministra właściwego do spraw rodziny (art. 13 ust. 5 pkt 1 ustawy<sup>1)</sup>)</xsl:when>
			<xsl:when test="$row_name = 'C_2.2'">- udostępnianego przez Zakład Ubezpieczeń Społecznych (art. 13 ust. 5 pkt 2 ustawy<sup>1)</sup>)</xsl:when>
			<xsl:when test="$row_name = 'C_2.3'">- systemu banków krajowych świadczących usługi drogą elektroniczną (art. 13 ust. 5 pkt 3 ustawy<sup>1)</sup>)</xsl:when>
			<xsl:when test="$row_name = 'C_2.4'">- systemu wskazanego w informacji zamieszczonej na stronie podmiotowej Biuletynu Informacji Publicznej ministra właściwego do spraw rodziny po uzgodnieniu z ministrem właściwym do spraw informatyzacji (art. 13 ust. 5 pkt 4 ustawy<sup>1)</sup>)</xsl:when>
			<xsl:when test="$row_name = 'C_3'">Liczba decyzji wydanych przez organ właściwy w sprawach dotyczących świadczenia wychowawczego, w tym:</xsl:when>
			<xsl:when test="$row_name = 'C_3.1'">- w sprawie ustalenia prawa do świadczenia</xsl:when>
			<xsl:when test="$row_name = 'C_3.2'">- stwierdzających nienależnie pobrane świadczenia</xsl:when>
			<xsl:when test="$row_name = 'C_3.3'">- w sprawie umorzenia nienależnie pobranych świadczeń</xsl:when>
			<xsl:when test="$row_name = 'C_4'">Liczba spraw, w których organ właściwy wygasił nienależnie pobrane świadczenia na podstawie art. 25 ust. 12 ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'D_1'">Liczba rodzin bez dziecka niepełnosprawnego, pobierających świadczenie wychowawcze na pierwsze dziecko z tego o dochodzie rodziny w przeliczeniu na osobę:</xsl:when>
			<xsl:when test="$row_name = 'D_1.1'">- bez dochodu</xsl:when>
			<xsl:when test="$row_name = 'D_1.2'">- do 400 zł</xsl:when>
			<xsl:when test="$row_name = 'D_1.3'">- od 400,01 do 574 zł</xsl:when>
			<xsl:when test="$row_name = 'D_1.4'">- od 574,01 do 674 zł</xsl:when>
			<xsl:when test="$row_name = 'D_1.5'">- od 674,01 do 754 zł</xsl:when>
			<xsl:when test="$row_name = 'D_1.6'">- od 754,01 do 800 zł</xsl:when>
			<xsl:when test="$row_name = 'D_2'">Liczba rodzin z dzieckiem niepełnosprawnym pobierających świadczenie wychowawcze na pierwsze dziecko, z tego o dochodzie rodziny w przeliczeniu na osobę:</xsl:when>
			<xsl:when test="$row_name = 'D_2.1'">- bez dochodu</xsl:when>
			<xsl:when test="$row_name = 'D_2.2'">- do 400 zł</xsl:when>
			<xsl:when test="$row_name = 'D_2.3'">- od 400,01 do 664 zł</xsl:when>
			<xsl:when test="$row_name = 'D_2.4'">- od 664,01 do 764 zł</xsl:when>
			<xsl:when test="$row_name = 'D_2.5'">- od 764,01 do 800 zł</xsl:when>
			<xsl:when test="$row_name = 'D_2.6'">- od 800,01 do 844 zł</xsl:when>
			<xsl:when test="$row_name = 'D_2.7'">- od 844,01 do 1100 zł</xsl:when>
			<xsl:when test="$row_name = 'D_2.8'">- od 1100,01 do 1200 zł</xsl:when>
			<xsl:when test="$row_name = 'E_1'">Liczba rodzin pobierających świadczenie wychowawcze, z tego:</xsl:when>
			<xsl:when test="$row_name = 'E_1.1'">- na jedno dziecko, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_1.1.1'">- na pierwsze dziecko</xsl:when>
			<xsl:when test="$row_name = 'E_1.2'">- na dwoje dzieci, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_1.2.1'">- na pierwsze dziecko</xsl:when>
			<xsl:when test="$row_name = 'E_1.3'">- na troje dzieci, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_1.3.1'">- na pierwsze dziecko</xsl:when>
			<xsl:when test="$row_name = 'E_1.4'">- na czworo dzieci, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_1.4.1'">- na pierwsze dziecko</xsl:when>
			<xsl:when test="$row_name = 'E_1.5'">- na pięcioro dzieci, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_1.5.1'">- na pierwsze dziecko</xsl:when>
			<xsl:when test="$row_name = 'E_1.6'">- na sześcioro dzieci i więcej, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_1.6.1'">- na pierwsze dziecko</xsl:when>
			<xsl:when test="$row_name = 'E_2'">Liczba rodzin niepełnych<sup>1)</sup> pobierających świadczenie wychowawcze, z tego:</xsl:when>
			<xsl:when test="$row_name = 'E_2.1'">- na jedno dziecko, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_2.1.1'">- na pierwsze dziecko</xsl:when>
			<xsl:when test="$row_name = 'E_2.2'">- na dwoje dzieci, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_2.2.1'">- na pierwsze dziecko</xsl:when>
			<xsl:when test="$row_name = 'E_2.3'">- na troje dzieci, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_2.3.1'">- na pierwsze dziecko</xsl:when>
			<xsl:when test="$row_name = 'E_2.4'">- na czworo dzieci, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_2.4.1'">- na pierwsze dziecko</xsl:when>
			<xsl:when test="$row_name = 'E_2.5'">- na pięcioro dzieci, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_2.5.1'">- na pierwsze dziecko</xsl:when>
			<xsl:when test="$row_name = 'E_2.6'">- na sześcioro dzieci i więcej, w tym:</xsl:when>
			<xsl:when test="$row_name = 'E_2.6.1'">- na pierwsze dziecko</xsl:when>
			<xsl:when test="$row_name = 'F_1'">Liczba ustaleń prawa do świadczenia wychowawczego, w tym z powodu:</xsl:when>
			<xsl:when test="$row_name = 'F_1.1'">- urodzenia się dziecka w rodzinie, w tym: </xsl:when>
			<xsl:when test="$row_name = 'F_1.1.1'">- urodzenia się dziecka w rodzinie, które jest pierwszym i jedynym dzieckiem w wieku do ukończenia 18 r. życia i przysługuje na nie prawo do świadczenia wychowawczego</xsl:when>
			<xsl:when test="$row_name = 'F_1.1.2'">- urodzenia się dziecka w rodzinie skutkującego nabyciem prawa do świadczenia wychowawczego na inne dziecko będące pierwszym dzieckiem (tj. urodzenia się co najmniej drugiego dziecka w rodzinie skutkującym nabyciem prawa do świadczenia wychowawczego na dziecko pierwsze oraz to drugie nowonarodzone lub kolejne w przypadku porodów mnogich)</xsl:when>
			<xsl:when test="$row_name = 'F_1.1.3'">- urodzenia się dziecka/dzieci w rodzinie innego/innych niż pierwsze dziecko (tj. urodzenia się dziecka/dzieci skutkującego nabyciem prawa do świadczenia wychowawczego począwszy od co najmniej drugiego dziecka)</xsl:when>
			<xsl:when test="$row_name = 'F_1.2'">- utraty dochodu skutkującej ustaleniem prawa do świadczenia na pierwsze dziecko, w tym:</xsl:when>
			<xsl:when test="$row_name = 'F_1.2.1'">- utraty dochodu w związku z wyrejestrowaniem pozarolniczej działalności gospodarczej lub zawieszeniem jej wykonywania w rozumieniu art. 14a ust. 1d ustawy z dnia 2 lipca 2004 r. o swobodzie działalności gospodarczej</xsl:when>
			<xsl:when test="$row_name = 'F_1.2.2'">- utraty dochodu w związku z utratą zatrudnienia lub innej pracy zarobkowej</xsl:when>
			<xsl:when test="$row_name = 'F_1.3'">- złożenia w danym okresie po raz pierwszy wniosku o ustalenie prawa do świadczenia wychowawczego (nie obejmuje wartości wykazanych w wierszach 1.1. i 1.2.)</xsl:when>
			<xsl:when test="$row_name = 'F_1.4'">- powrotu dziecka do rodziny biologicznej</xsl:when>
			<xsl:when test="$row_name = 'F_1.5'">- inne przyczyny</xsl:when>
			<xsl:when test="$row_name = 'G_1'">Wysokość planowanych w danym roku wydatków budżetu państwa na realizację ustawy<sup>1)</sup> (wg stanu na ostatni dzień miesiąca)</xsl:when>
			<xsl:when test="$row_name = 'G_2'">Otrzymana z budżetu państwa w danym miesiącu dotacja na realizację ustawy<sup>1)</sup>, z tego:</xsl:when>
			<xsl:when test="$row_name = 'G_2.1'">- na wypłaty świadczeń wychowawczych</xsl:when>
			<xsl:when test="$row_name = 'G_2.2'">- na koszty obsługi</xsl:when>
			<xsl:when test="$row_name = 'G_3'">Wydatki na obsługę ustawy<sup>1)</sup>, z tego:</xsl:when>
			<xsl:when test="$row_name = 'G_3.1'">- wydatki na wynagrodzenia osób zatrudnionych na podstawie umowy o pracę do realizacji tej ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'G_3.2'">- wydatki na wynagrodzenia osób zatrudnionych na podstawie umowy cywilnoprawnej do realizacji tej ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'G_3.3'">- wydatki pozostałe, w tym:</xsl:when>
			<xsl:when test="$row_name = 'G_3.3.1'">- wydatki na dodatki dla osób realizujących zadania wynikające z ustawy<sup>1)</sup>, które w związku z wykonywaniem tych zadań otrzymują wyłącznie dodatek</xsl:when>
			<xsl:when test="$row_name = 'G_3.3.2'">- wydatki inwestycyjne</xsl:when>
			<xsl:when test="$row_name = 'G_4'">Wydatki na obsługę świadczeń wychowawczych sfinansowane z dotacji z budżetu państwa na realizację ustawy<sup>1)</sup>, z tego:</xsl:when>
			<xsl:when test="$row_name = 'G_4.1'">- wydatki na wynagrodzenia osób zatrudnionych na podstawie umowy o pracę do realizacji tej ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'G_4.2'">- wydatki na wynagrodzenia osób zatrudnionych na podstawie umowy cywilnoprawnej do realizacji tej ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'G_4.3'">- wydatki pozostałe, w tym:</xsl:when>
			<xsl:when test="$row_name = 'G_4.3.1'">- wydatki na dodatki dla osób realizujących zadania wynikające z ustawy<sup>1)</sup>, które w związku z wykonywaniem tych zadań otrzymują wyłącznie dodatek</xsl:when>
			<xsl:when test="$row_name = 'G_4.3.2'">- wydatki inwestycyjne</xsl:when>
			<xsl:when test="$row_name = 'G_5'">Liczba osób realizujących ustawę<sup>1)</sup>, w tym:</xsl:when>
			<xsl:when test="$row_name = 'G_5.1'">- zatrudnionych na podstawie umowy o pracę do realizacji tej ustawy<sup>1)</sup> (w przeliczeniu na pełne etaty)</xsl:when>
			<xsl:when test="$row_name = 'G_5.2'">- zatrudnionych na podstawie umowy cywilnoprawnej do realizacji tej ustawy<sup>1)</sup>
			</xsl:when>
			<xsl:when test="$row_name = 'G_5.3'">- innych, w tym:</xsl:when>
			<xsl:when test="$row_name = 'G_5.3.1'">- zatrudnionych na podstawie umowy o pracę lub umowy cywilnoprawnej, a otrzymujących wyłączne dodatek za realizację zadań wynikających z ustawy<sup>1)</sup>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Row-description">
		<td class="tab_row_no">
			<xsl:value-of select="concat(substring-after(name(), '_'), '.')"/>
		</td>
		<td class="row_descr">
			<xsl:call-template name="Rows-description">
				<xsl:with-param name="row_name" select="name()"/>
			</xsl:call-template>
		</td>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template match="Część_A.1">
		<xsl:call-template name="Wydatki-i-liczba-koord"/>
		<table class="bottom_table" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" valign="top">1)</td>
				<td class="remark">
					Dotyczy ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu dzieci (Dz. U. z 2017 r. poz.1851).
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_A.2">
		<xsl:call-template name="Wydatki-i-liczba-koord"/>
		<table class="bottom_table" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" valign="top">1)</td>
				<td class="remark">
					Dotyczy ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu dzieci.
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_B.1">
		<xsl:call-template name="Kwota-w-miesiacu"/>
		<table class="bottom_table" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" valign="top">1)</td>
				<td class="remark">
					Dotyczy ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu dzieci.
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_B.2">
		<xsl:call-template name="Kwota-w-miesiacu-w-tym-koordynacja"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_C">
		<xsl:call-template name="Wykonanie"/>
		<table class="bottom_table" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" valign="top">1)</td>
				<td class="remark">
					Dotyczy ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu dzieci.
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_D">
		<xsl:call-template name="Wykonanie"/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_E">
		<xsl:call-template name="Wykonanie"/>
		<table class="bottom_table" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" valign="top">1)</td>
				<td class="remark">
					Rodziny osób samotnie wychowujących dzieci (art. 2 pkt. 13 ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu dzieci).
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_F">
		<xsl:call-template name="Wykonanie"/>
		<table class="bottom_table" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" valign="top">1)</td>
				<td class="remark">
					Część F po raz pierwszy wypełniana jest w odniesieniu do sprawozdania za miesiąc styczeń danego okresu oraz nie dotyczy ustaleń <nobr>w związku</nobr> z wnioskami na kolejny okres składanymi od lipca.
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template match="Część_G">
		<xsl:call-template name="Wykonanie"/>
		<table class="bottom_table" cellspacing="0" cellpadding="0">
			<tr>
				<td class="stars" valign="top">1)</td>
				<td class="remark">
					Dotyczy ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu dzieci.
				</td>
			</tr>
		</table>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwota-w-miesiacu-w-tym-koordynacja">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$widthTabSmall"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Kwota-w-miesiacu-w-tym-koordynacja-header"/>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Kwota-w-miesiacu-w-tym-koordynacja-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwota-w-miesiacu-w-tym-koordynacja-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Razem'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Koord'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczba-koord">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$width"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Wydatki-i-liczba-koord-header"/>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Wydatki-i-liczba-koord-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczba-koord-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Wydatki'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Wydatki-koord'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Liczba-swiadczen'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Liczba-swiadczen-koord'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwota-w-miesiacu">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$widthTabSmall"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Wykonanie-header">
				<xsl:with-param name="grouphdr" select="'Kwota w miesiącu w zł'"/>
			</xsl:call-template>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Kwota-w-miesiacu-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Kwota-w-miesiacu-content">
		<xsl:param name="skladniki"/>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Kwota-w-miesiacu'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$kwota"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie">
		<table class="data_table" cellspacing="0" cellpadding="0">
			<xsl:attribute name="width"><xsl:number value="$widthTabSmall"/></xsl:attribute>
			<xsl:call-template name="Table-caption"/>
			<xsl:call-template name="Wykonanie-header"/>
			<tbody>
				<xsl:for-each select="*">
					<tr>
						<xsl:call-template name="Row-description"/>
						<xsl:call-template name="Wykonanie-content">
							<xsl:with-param name="skladniki" select="@Składniki"/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie-content">
		<xsl:param name="skladniki"/>
		<xsl:variable name="formatKomorki">
			<xsl:choose>
				<xsl:when test="name() = 'G_5.1'">
					<xsl:value-of select="$obsada"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$kwota"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:call-template name="Column">
			<xsl:with-param name="column" select="'Wykonanie'"/>
			<xsl:with-param name="skladniki" select="$skladniki"/>
			<xsl:with-param name="format" select="$formatKomorki"/>
		</xsl:call-template>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Kwota-w-miesiacu-w-tym-koordynacja-header">
		<xsl:param name="descrwidth" select="61"/>
		<xsl:param name="lpwidth" select="3"/>
		<xsl:param name="double">
			<xsl:value-of select="string(100-number($descrwidth)-$lpwidth)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($double) div 2))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="{$lpwidth}%" rowspan="2">L.p.</th>
				<th rowspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th colspan="2">
					<xsl:attribute name="width"><xsl:value-of select="concat($double,'%')"/></xsl:attribute>Kwota w miesiącu w zł</th>
			</tr>
			<tr>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Razem</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym: na podstawie decyzji marszałka województwa</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wydatki-i-liczba-koord-header">
		<xsl:param name="descrwidth" select="48"/>
		<xsl:param name="lpwidth" select="4"/>
		<xsl:param name="quadruple">
			<xsl:value-of select="string(100-number($descrwidth)-$lpwidth)"/>
		</xsl:param>
		<xsl:param name="single">
			<xsl:value-of select="string(round(number($quadruple) div 4))"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="{$lpwidth}%">L.p.</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Wydatki poniesione w miesiącu w zł</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym:<br/>w ramach koordynacji</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>Liczba świadczeń wypłaconych w miesiącu</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($single,'%')"/></xsl:attribute>w tym:<br/>w ramach koordynacji</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
				<td class="tab_col_no">4</td>
				<td class="tab_col_no">5</td>
				<td class="tab_col_no">6</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	-->
	<xsl:template name="Wykonanie-header">
		<xsl:param name="grouphdr" select="'Wykonanie miesięczne'"/>
		<xsl:param name="descrwidth" select="73"/>
		<xsl:param name="lpwidth" select="5"/>
		<xsl:param name="triple">
			<xsl:value-of select="string(100-number($descrwidth)-$lpwidth)"/>
		</xsl:param>
		<thead>
			<tr>
				<th width="{$lpwidth}%">L.p.</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($descrwidth,'%')"/></xsl:attribute>Wyszczególnienie</th>
				<th>
					<xsl:attribute name="width"><xsl:value-of select="concat($triple,'%')"/></xsl:attribute>
					<xsl:value-of select="$grouphdr"/>
				</th>
			</tr>
			<tr>
				<td class="tab_col_no">1</td>
				<td class="tab_col_no">2</td>
				<td class="tab_col_no">3</td>
			</tr>
		</thead>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="Column">
		<xsl:param name="column"/>
		<xsl:param name="skladniki"/>
		<xsl:param name="format"/>
		<xsl:variable name="item" select="descendant-or-self::*[name(.) = $column]"/>
		<xsl:choose>
			<xsl:when test="$skladniki">
				<xsl:call-template name="suma">
					<xsl:with-param name="column" select="$column"/>
					<xsl:with-param name="contents" select="$item"/>
					<xsl:with-param name="format" select="$format"/>
					<xsl:with-param name="skladniki" select="concat($skladniki, ' ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<td class="contents">
					<xsl:choose>
						<xsl:when test="string(number($item)) = 'NaN'">
							<div style="color: red; text-align: center;">???</div>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="format-number($item, $format)"/>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
	<xsl:template name="suma">
		<xsl:param name="column"/>
		<xsl:param name="contents"/>
		<xsl:param name="format"/>
		<xsl:param name="skladniki"/>
		<xsl:variable name="wynik">
			<xsl:if test="$skladniki">
				<xsl:value-of select="sum(../*[contains($skladniki,concat(name(.),' '))]/descendant-or-self::*[name(.) = $column])"/>
			</xsl:if>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string(number($wynik)) = 'NaN'">
				<td class="totals blad">
					<center>???</center>
				</td>
			</xsl:when>
			<xsl:when test="string(number($contents)) != 'NaN' and $contents != ''">
				<xsl:choose>
					<xsl:when test="$contents != $wynik">
						<td class="contents blad">
							<xsl:value-of select="concat('jest: ', format-number($contents, $format))"/>
							<br/>
							<xsl:value-of select="concat('suma: ', format-number($wynik, $format))"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="totals">
							<xsl:value-of select="format-number($wynik, $format)"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<td class="totals">
					<xsl:value-of select="format-number($wynik, $format)"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	=============================================================================================
	-->
</xsl:stylesheet>
