<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:jxb="http://java.sun.com/xml/ns/jaxb" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	
	<xsl:output indent="yes" />
	
	<xsl:template match="/">
		<jxb:bindings>
			<xsl:apply-templates />
		</jxb:bindings>
	</xsl:template>
	
	<xsl:template match="text()" />
	
	<xsl:template match="xs:element[contains(@name, '_') or contains(@name, '.')]">
		<xsl:variable name="name0" select="@name" />
		<xsl:variable name="name1" select="replace($name0, '[_]', '__')" />
		<xsl:variable name="name2" select="replace($name1, '[.]', '_')" />
		<xsl:element name="jxb:bindings">
			<xsl:attribute name="node">
				<xsl:text>//xs:element[@name='</xsl:text>
				<xsl:value-of select="@name" />
				<xsl:text>']</xsl:text>
			</xsl:attribute>
			<xsl:if test="./xs:complexType">
				<jxb:bindings node="xs:complexType">
					<xsl:element name="jxb:class">
						<xsl:attribute name="name">
							<xsl:attribute name="name" select="$name2" />
						</xsl:attribute>
					</xsl:element>
				</jxb:bindings>
			</xsl:if>
			<xsl:element name="jxb:property">
				<xsl:attribute name="name" select="lower-case($name2)" />
			</xsl:element>
		</xsl:element>
		<xsl:apply-templates />
	</xsl:template>
	
</xsl:stylesheet>
