package pl.topteam.tytul_wykonawczy.utils;

import com.google.common.io.Resources;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.xmlgraphics.util.MimeConstants;
import org.xml.sax.SAXException;

import javax.xml.transform.*;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

public class Wydruk {
    public static byte[] drukujTW1_202101(byte[] tresc) throws URISyntaxException, SAXException, TransformerException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();

        URL base = Resources.getResource("");
        URL config = Resources.getResource("fop.xml");
        URL style = Resources.getResource("xsl/tw1_202101.xsl");

        ByteArrayInputStream configStream = new ByteArrayInputStream(Resources.toByteArray(config));
        FopFactory fopFactory = FopFactory.newInstance(base.toURI(), configStream);
        Fop fop = fopFactory.newFop(MimeConstants.MIME_PDF, output);

        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(style.toURI().toString()));

        Source src = new StreamSource(new ByteArrayInputStream(tresc));
        Result res = new SAXResult(fop.getDefaultHandler());

        transformer.transform(src, res);

        return output.toByteArray();
    }

    public static byte[] drukujTW1_202008(byte[] tresc) throws URISyntaxException, SAXException, TransformerException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();

        URL base = Resources.getResource("");
        URL config = Resources.getResource("fop.xml");
        URL style = Resources.getResource("xsl/tw1_202008.xsl");

        ByteArrayInputStream configStream = new ByteArrayInputStream(Resources.toByteArray(config));
        FopFactory fopFactory = FopFactory.newInstance(base.toURI(), configStream);
        Fop fop = fopFactory.newFop(MimeConstants.MIME_PDF, output);

        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(style.toURI().toString()));

        Source src = new StreamSource(new ByteArrayInputStream(tresc));
        Result res = new SAXResult(fop.getDefaultHandler());

        transformer.transform(src, res);

        return output.toByteArray();
    }
}
