<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ega="http://crd.gov.pl/wzor/2017/03/24/4090/" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">
	<xsl:output version="4.0" method="html" indent="no" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
	<xsl:param name="SV_OutputFormat" select="'HTML'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:decimal-format name="format2" grouping-separator="." decimal-separator=","/>
	<xsl:decimal-format name="format1" grouping-separator=" " decimal-separator=","/>
	<xsl:template match="/">
		<html>
			<head>
				<title>TW-1(3) TYTUŁ WYKONAWCZY STOSOWANY W EGZEKUCJI NALEŻNOŚCI PIENIĘŻNYCH</title>
				<meta http-equiv="X-UA-Compatible" content="IE=7"/>
			</head>
			<body>
				<xsl:for-each select="$XML">
					<xsl:for-each select="ega:Dokument">
						<xsl:for-each select="ega:TrescDokumentu">
							<xsl:for-each select="ega:Wniosek">
								<xsl:variable name="XSDKodyKrajow" select="document('http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2016/01/25/eD/DefinicjeTypy/KodyKrajow_v4-1E.xsd')"/>
								<xsl:variable name="XSDKodyGmin" select="document('http://crd.gov.pl/xml/schematy/dziedzinowe/mf/2017/01/02/eD/KodyGMIN/KodyGmin_v6-0E.xsd')"/>
								<table style="border-color:black; border-style:solid; border-width:thin; " border="0" cellpadding="0" cellspacing="0" width="100%">
									<xsl:variable name="ckeaCurrContextGrid_0" select="."/>
									<tbody>
										<xsl:for-each select="ega:Naglowek">
											<tr>
												<td>
													<table style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; " border="0" cellpadding="0" cellspacing="0" width="100%">
														<xsl:variable name="ckeaCurrContextGrid_1" select="."/>
														<tbody>
															<tr style="height:0.14in; ">
																<td rowspan="4" style="background-color:#a5a5a5; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:larger; font-weight:bold; padding-bottom:0; padding-left:0; padding-right:0; padding-top:0; text-align:center; vertical-align:middle; ">
																	<xsl:for-each select="ega:KodFormularza">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																	<span>
																		<xsl:text> </xsl:text>
																	</span>
																	<br/>
																	<span>
																		<xsl:text>(</xsl:text>
																	</span>
																	<xsl:for-each select="ega:WariantFormularza">
																		<xsl:apply-templates/>
																	</xsl:for-each>
																	<span>
																		<xsl:text>)</xsl:text>
																	</span>
																	<br/>
																</td>
																<td style="background-color:#a5a5a5; padding-bottom:0; padding-left:0; padding-right:0; padding-top:0; "/>
																<td style="background-color:silver; border-left-color:black; border-left-style:solid; border-left-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																	<span>
																		<xsl:text>Numer systemowy sprawy organu egzekucyjnego</xsl:text>
																	</span>
																</td>
															</tr>
															<tr>
																<td style="background-color:#a5a5a5; font-family:Arial; font-size:x-large; font-weight:bold; padding-bottom:0; padding-left:0; padding-right:0; padding-top:0; text-align:center; ">
																	<span>
																		<xsl:text>TYTUŁ WYKONAWCZY</xsl:text>
																	</span>
																</td>
																<td rowspan="3" style="background-color:silver; border-left-color:black; border-left-style:solid; border-left-width:thin; padding-bottom:0; padding-left:0; padding-right:0; padding-top:0; "/>
															</tr>
															<tr>
																<td style="background-color:#a5a5a5; font-family:Arial; font-weight:bold; padding-bottom:0; padding-left:0; padding-right:0; padding-top:0; text-align:center; ">
																	<span>
																		<xsl:text>STOSOWANY W EGZEKUCJI NALEŻNOŚCI PIENIĘŻNYCH</xsl:text>
																	</span>
																</td>
															</tr>
															<tr>
																<td style="background-color:#a5a5a5; padding-bottom:0; padding-left:0; padding-right:0; padding-top:0; "/>
															</tr>
															<tr>
																<td colspan="3" style="background-color:#d2d2d2; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-weight:bold; padding-bottom:0; padding-left:0; padding-right:0; padding-top:0; " align="center" bgcolor="silver" valign="middle">
																	<span>
																		<xsl:text>Podstawa prawna: art. 26 ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2016 r. poz. 599, z późn. zm.), zwanej dalej „ustawą”</xsl:text>
																	</span>
																</td>
															</tr>
														</tbody>
													</table>
												</td>
											</tr>
										</xsl:for-each>
										<xsl:for-each select="ega:TW-1">
											<tr>
												<td>
													<table border="0" cellpadding="0" cellspacing="0" width="100%">
														<xsl:variable name="ckeaCurrContextGrid_2" select="."/>
														<tbody>
															<xsl:for-each select="ega:DaneReferencyjne">
																<tr>
																	<td>
																		<table border="0" cellpadding="0" cellspacing="0" width="100%">
																			<xsl:variable name="ckeaCurrContextGrid_3" select="."/>
																			<tbody>
																				<tr>
																					<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:bottom; " align="left">
																						<span>
																							<xsl:text>1. Numer tytułu wykonawczego</xsl:text>
																						</span>
																					</td>
																					<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:bottom; ">
																						<span>
																							<xsl:text>2. Data wystawienia</xsl:text>
																						</span>
																					</td>
																					<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:bottom; ">
																						<span>
																							<xsl:text>3. Rodzaj dokumentu</xsl:text>
																						</span>
																						<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																							<xsl:text>1)</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																						<xsl:for-each select="ega:Sygnatura">
																							<xsl:apply-templates/>
																						</xsl:for-each>
																					</td>
																					<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																						<xsl:choose>
																							<xsl:when test="ega:DataWystawienia[not(normalize-space())]">
																								<span>
																									<xsl:text> </xsl:text>
																								</span>
																							</xsl:when>
																							<xsl:otherwise>
																								<xsl:for-each select="ega:DataWystawienia">
																									<span>
																										<xsl:variable name="ckeaseqContentStrings_4">
																											<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																											<xsl:text>-</xsl:text>
																											<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00', 'format1')"/>
																											<xsl:text>-</xsl:text>
																											<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																										</xsl:variable>
																										<xsl:variable name="ckeasContent_4" select="string($ckeaseqContentStrings_4)"/>
																										<xsl:value-of select="$ckeasContent_4"/>
																									</span>
																								</xsl:for-each>
																							</xsl:otherwise>
																						</xsl:choose>
																					</td>
																					<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																						<xsl:for-each select="ega:RodzajDokumentu">
																							<span>
																								<xsl:text>[</xsl:text>
																							</span>
																							<xsl:choose>
																								<xsl:when test="text()='1'">
																									<span style="font-family:Courier; font-size:larger; font-weight:bold; ">
																										<xsl:text>x</xsl:text>
																									</span>
																								</xsl:when>
																								<xsl:otherwise>
																									<span style="font-family:Courier; font-size:larger; ">
																										<xsl:text> </xsl:text>
																									</span>
																								</xsl:otherwise>
																							</xsl:choose>
																							<span>
																								<xsl:text>]</xsl:text>
																							</span>
																						</xsl:for-each>
																						<span>
																							<xsl:text> 1. tytuł wykonawczy</xsl:text>
																						</span>
																					</td>
																					<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																						<xsl:for-each select="ega:RodzajDokumentu">
																							<span>
																								<xsl:text>[</xsl:text>
																							</span>
																							<xsl:choose>
																								<xsl:when test="text()='2'">
																									<span style="font-family:Courier; font-size:larger; font-weight:bold; ">
																										<xsl:text>x</xsl:text>
																									</span>
																								</xsl:when>
																								<xsl:otherwise>
																									<span style="font-family:Courier; font-size:larger; ">
																										<xsl:text> </xsl:text>
																									</span>
																								</xsl:otherwise>
																							</xsl:choose>
																							<span>
																								<xsl:text>]</xsl:text>
																							</span>
																						</xsl:for-each>
																						<span>
																							<xsl:text> 2. zmieniony tytuł wykonawczy</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																						<span>
																							<xsl:text>4. Numer porządkowy dalszego tytułu wykonawczego</xsl:text>
																						</span>
																						<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																							<xsl:text>2)</xsl:text>
																						</span>
																					</td>
																					<td colspan="3" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																						<span>
																							<xsl:text>5. Cel wydania dalszego tytułu wykonawczego</xsl:text>
																						</span>
																						<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																							<xsl:text>1) 2)</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																						<xsl:for-each select="ega:DalszyTW">
																							<xsl:for-each select="ega:NumerPorzadkowy">
																								<xsl:apply-templates/>
																							</xsl:for-each>
																						</xsl:for-each>
																					</td>
																					<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																						<span>
																							<xsl:text>[</xsl:text>
																						</span>
																						<xsl:choose>
																							<xsl:when test="ega:DalszyTW/ega:CelWydania/text()='1'">
																								<span style="font-family:Courier; font-size:larger; font-weight:bold; ">
																									<xsl:text>x</xsl:text>
																								</span>
																							</xsl:when>
																							<xsl:otherwise>
																								<span style="font-family:Courier; font-size:larger; ">
																									<xsl:text> </xsl:text>
																								</span>
																							</xsl:otherwise>
																						</xsl:choose>
																						<span>
																							<xsl:text>] 1. prowadzenie egzekucji przez inny organ egzekucyjny</xsl:text>
																						</span>
																					</td>
																					<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																						<span>
																							<xsl:text>[</xsl:text>
																						</span>
																						<xsl:choose>
																							<xsl:when test="ega:DalszyTW/ega:CelWydania/text()='2'">
																								<span style="font-family:Courier; font-size:larger; font-weight:bold; ">
																									<xsl:text>x</xsl:text>
																								</span>
																							</xsl:when>
																							<xsl:otherwise>
																								<span style="font-family:Courier; font-size:larger; ">
																									<xsl:text> </xsl:text>
																								</span>
																							</xsl:otherwise>
																						</xsl:choose>
																						<span>
																							<xsl:text>] 2. zabezpieczenie hipoteką przymusową, w tym hipoteką przymusową morską</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="4" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:bottom; ">
																						<span>
																							<xsl:text>6. Adnotacja dotycząca ponownie wydanego tytułu wykonawczego/zmienionego tytułu wykonawczego</xsl:text>
																						</span>
																						<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																							<xsl:text>2)</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="4" style="font-family:Arial; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																						<xsl:for-each select="ega:Adnotacja">
																							<xsl:apply-templates/>
																						</xsl:for-each>
																						<span>
																							<xsl:text> </xsl:text>
																						</span>
																					</td>
																				</tr>
																			</tbody>
																		</table>
																	</td>
																</tr>
															</xsl:for-each>
															<xsl:for-each select="ega:Zobowiazany">
																<tr>
																	<td>
																		<table border="0" cellpadding="0" cellspacing="0" width="100%">
																			<xsl:variable name="ckeaCurrContextGrid_5" select="."/>
																			<tbody>
																				<tr>
																					<td style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:middle; ">
																						<span>
																							<xsl:text>A. DANE ZOBOWIĄZANEGO/ZOBOWIĄZANYCH - MAŁŻONKÓW ODPOWIEDZIALNYCH SOLIDARNIE</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td>
																						<xsl:for-each select="ega:OsobaFizyczna/ega:DaneOsobowe | ega:OsobaNiefizyczna/ega:DaneOsobowe | ega:Solidarni/ega:Malzonek">
																							<table border="0" cellspacing="0" width="100%">
																								<xsl:variable name="ckeaCurrContextGrid_6" select="."/>
																								<tbody>
																									<tr>
																										<td rowspan="18" style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; font-weight:bold; text-align:center; vertical-align:top; width:0.6in; " align="center" valign="top">
																											<span>
																												<xsl:text>A.</xsl:text>
																											</span>
																											<span>
																												<xsl:value-of select="position()"/>
																											</span>
																											<span>
																												<xsl:text>.</xsl:text>
																											</span>
																										</td>
																										<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																											<span>
																												<xsl:text>1. Rodzaj zobowiązanego</xsl:text>
																											</span>
																											<span style="font-size:xx-small; font-weight:bold; vertical-align:super; ">
																												<xsl:text>1)</xsl:text>
																											</span>
																										</td>
																										<td colspan="5" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																											<span>
																												<xsl:text>2. Rodzaj odpowiedzialności zobowiązanego</xsl:text>
																											</span>
																											<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																												<xsl:text>1)</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>[</xsl:text>
																											</span>
																											<xsl:choose>
																												<xsl:when test="../../ega:OsobaFizyczna | ../../ega:Solidarni">
																													<span style="font-family:Courier; font-size:larger; font-weight:bold; ">
																														<xsl:text>x</xsl:text>
																													</span>
																												</xsl:when>
																												<xsl:otherwise>
																													<span style="font-family:Courier; font-size:larger; ">
																														<xsl:text> </xsl:text>
																													</span>
																												</xsl:otherwise>
																											</xsl:choose>
																											<span>
																												<xsl:text>] 1.osoba fizyczna</xsl:text>
																											</span>
																										</td>
																										<td colspan="5" style="font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>[</xsl:text>
																											</span>
																											<xsl:choose>
																												<xsl:when test="boolean( ../../ega:Solidarni ) or not(../ega:ZobowiazanyPierwotny )">
																													<span style="font-family:Courier; font-size:larger; font-weight:bold; ">
																														<xsl:text>x</xsl:text>
																													</span>
																												</xsl:when>
																												<xsl:otherwise>
																													<span style="font-family:Courier; font-size:larger; ">
																														<xsl:text> </xsl:text>
																													</span>
																												</xsl:otherwise>
																											</xsl:choose>
																											<span>
																												<xsl:text>] 1.podmiot, u którego powstał obowiązek</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>[</xsl:text>
																											</span>
																											<xsl:choose>
																												<xsl:when test="../../ega:OsobaNiefizyczna">
																													<span style="font-family:Courier; font-size:larger; font-weight:bold; ">
																														<xsl:text>x</xsl:text>
																													</span>
																												</xsl:when>
																												<xsl:otherwise>
																													<span style="font-family:Courier; font-size:larger; ">
																														<xsl:text> </xsl:text>
																													</span>
																												</xsl:otherwise>
																											</xsl:choose>
																											<span>
																												<xsl:text>] 2.podmiot niebędący osobą fizyczną</xsl:text>
																											</span>
																										</td>
																										<td colspan="5" style="font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>[</xsl:text>
																											</span>
																											<xsl:choose>
																												<xsl:when test="../ega:ZobowiazanyPierwotny/@odpowiedzialnosc = 1">
																													<span style="font-family:Courier; font-size:larger; font-weight:bold; ">
																														<xsl:text>x</xsl:text>
																													</span>
																												</xsl:when>
																												<xsl:otherwise>
																													<span style="font-family:Courier; font-size:larger; ">
																														<xsl:text> </xsl:text>
																													</span>
																												</xsl:otherwise>
																											</xsl:choose>
																											<span>
																												<xsl:text>] 2.następca prawny</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; "/>
																										<td colspan="5" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>[</xsl:text>
																											</span>
																											<xsl:choose>
																												<xsl:when test="../ega:ZobowiazanyPierwotny/@odpowiedzialnosc = 2">
																													<span style="font-family:Courier; font-size:larger; font-weight:bold; ">
																														<xsl:text>x</xsl:text>
																													</span>
																												</xsl:when>
																												<xsl:otherwise>
																													<span style="font-family:Courier; font-size:larger; ">
																														<xsl:text> </xsl:text>
																													</span>
																												</xsl:otherwise>
																											</xsl:choose>
																											<span>
																												<xsl:text>] 3.osoba trzecia</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																											<span>
																												<xsl:text>3. Imię</xsl:text>
																											</span>
																											<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																												<xsl:text>3)</xsl:text>
																											</span>
																										</td>
																										<td colspan="6" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																											<span>
																												<xsl:text>4. Nazwisko/Nazwa</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:Imie">
																												<xsl:apply-templates/>
																											</xsl:for-each>
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</td>
																										<td colspan="6" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:Nazwisko | ega:Nazwa">
																												<xsl:choose>
																													<xsl:when test="self::*">
																														<xsl:apply-templates/>
																													</xsl:when>
																													<xsl:otherwise>
																														<xsl:value-of select="."/>
																													</xsl:otherwise>
																												</xsl:choose>
																											</xsl:for-each>
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>5. Kraj</xsl:text>
																											</span>
																										</td>
																										<td colspan="4" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>6. Województwo</xsl:text>
																											</span>
																										</td>
																										<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>7. Powiat</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:Adres">
																												<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																													<xsl:for-each select="ega:KodKraju">
																														<xsl:variable name="kodKraju" select="./text()"/>
																														<span>
																															<xsl:value-of select="$XSDKodyKrajow//xs:enumeration[@value = $kodKraju]/xs:annotation/xs:documentation/text()"/>
																														</span>
																													</xsl:for-each>
																												</xsl:for-each>
																											</xsl:for-each>
																										</td>
																										<td colspan="4" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:Adres">
																												<xsl:for-each select="ega:AdresPolski">
																													<xsl:for-each select="ega:PodzialAdm">
																														<xsl:choose>
																															<xsl:when test="ega:KodGminy">
																																<xsl:for-each select="ega:KodGminy">
																																	<xsl:choose>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '02'">
																																			<span>
																																				<xsl:text>DOLNOŚLĄSKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '04'">
																																			<span>
																																				<xsl:text>KUJAWSKO-POMORSKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '06'">
																																			<span>
																																				<xsl:text>LUBELSKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '08'">
																																			<span>
																																				<xsl:text>LUBUSKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '10'">
																																			<span>
																																				<xsl:text>ŁÓDZKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '12'">
																																			<span>
																																				<xsl:text>MAŁOPOLSKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '14'">
																																			<span>
																																				<xsl:text>MAZOWIECKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '16'">
																																			<span>
																																				<xsl:text>OPOLSKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '18'">
																																			<span>
																																				<xsl:text>PODKARPACKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '20'">
																																			<span>
																																				<xsl:text>PODLASKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '22'">
																																			<span>
																																				<xsl:text>POMORSKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '24'">
																																			<span>
																																				<xsl:text>ŚLĄSKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '26'">
																																			<span>
																																				<xsl:text>ŚWIĘTOKRZYSKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '28'">
																																			<span>
																																				<xsl:text>WARMIŃSKO-MAZURSKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '30'">
																																			<span>
																																				<xsl:text>WIELKOPOLSKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:when test="substring( ./text() , 1 , 2 ) = '32'">
																																			<span>
																																				<xsl:text>ZACHODNIOPOMORSKIE</xsl:text>
																																			</span>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<span>
																																				<xsl:text>TERYT:</xsl:text>
																																			</span>
																																			<xsl:apply-templates/>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</xsl:when>
																															<xsl:otherwise>
																																<xsl:for-each select="ega:Wojewodztwo">
																																	<xsl:apply-templates/>
																																</xsl:for-each>
																															</xsl:otherwise>
																														</xsl:choose>
																													</xsl:for-each>
																												</xsl:for-each>
																											</xsl:for-each>
																											<br/>
																										</td>
																										<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:Adres">
																												<xsl:for-each select="ega:AdresPolski">
																													<xsl:for-each select="ega:PodzialAdm">
																														<xsl:choose>
																															<xsl:when test="ega:KodGminy">
																																<span>
																																	<xsl:text>TERC:</xsl:text>
																																</span>
																																<xsl:for-each select="ega:KodGminy">
																																	<xsl:apply-templates/>
																																</xsl:for-each>
																															</xsl:when>
																															<xsl:otherwise>
																																<xsl:for-each select="ega:Powiat">
																																	<xsl:apply-templates/>
																																</xsl:for-each>
																															</xsl:otherwise>
																														</xsl:choose>
																													</xsl:for-each>
																												</xsl:for-each>
																											</xsl:for-each>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>8. Gmina</xsl:text>
																											</span>
																										</td>
																										<td colspan="4" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>9. Ulica</xsl:text>
																											</span>
																										</td>
																										<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>10. Numer domu</xsl:text>
																											</span>
																										</td>
																										<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>11. Numer lokalu</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																											<xsl:for-each select="ega:Adres">
																												<xsl:for-each select="ega:AdresPolski">
																													<xsl:for-each select="ega:PodzialAdm">
																														<xsl:choose>
																															<xsl:when test="ega:KodGminy">
																																<xsl:for-each select="ega:KodGminy">
																																	<xsl:variable name="kodGminy" select="./text()"/>
																																	<span>
																																		<xsl:value-of select="$XSDKodyGmin//xs:enumeration[@value = $kodGminy]/xs:annotation/xs:documentation/text()"/>
																																	</span>
																																</xsl:for-each>
																															</xsl:when>
																															<xsl:otherwise>
																																<xsl:for-each select="ega:Gmina">
																																	<xsl:apply-templates/>
																																</xsl:for-each>
																															</xsl:otherwise>
																														</xsl:choose>
																													</xsl:for-each>
																												</xsl:for-each>
																											</xsl:for-each>
																										</td>
																										<td colspan="4" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:Adres">
																												<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																													<xsl:for-each select="ega:Ulica">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																												</xsl:for-each>
																											</xsl:for-each>
																										</td>
																										<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:Adres">
																												<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																													<xsl:for-each select="ega:NrDomu">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																												</xsl:for-each>
																											</xsl:for-each>
																										</td>
																										<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:Adres">
																												<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																													<xsl:for-each select="ega:NrLokalu">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																												</xsl:for-each>
																											</xsl:for-each>
																										</td>
																									</tr>
																									<tr>
																										<td colspan="3" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>12. Miejscowość</xsl:text>
																											</span>
																										</td>
																										<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>13. Kod pocztowy</xsl:text>
																											</span>
																										</td>
																										<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>14. Poczta</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:Adres">
																												<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																													<xsl:for-each select="ega:Miejscowosc">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																												</xsl:for-each>
																											</xsl:for-each>
																										</td>
																										<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:Adres">
																												<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																													<xsl:for-each select="ega:KodPocztowy">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																												</xsl:for-each>
																											</xsl:for-each>
																										</td>
																										<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:Adres">
																												<xsl:for-each select="ega:AdresPolski">
																													<xsl:for-each select="ega:Poczta">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																												</xsl:for-each>
																											</xsl:for-each>
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																											<span>
																												<xsl:text>15. NIP</xsl:text>
																											</span>
																										</td>
																										<td colspan="3" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																											<span>
																												<xsl:text>16. Numer PESEL</xsl:text>
																											</span>
																											<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																												<xsl:text>3)</xsl:text>
																											</span>
																										</td>
																										<td colspan="3" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																											<span>
																												<xsl:text>17. REGON</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:AdmId">
																												<xsl:for-each select="ega:NIP">
																													<xsl:apply-templates/>
																												</xsl:for-each>
																											</xsl:for-each>
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</td>
																										<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:AdmId">
																												<xsl:for-each select="ega:PESEL">
																													<xsl:apply-templates/>
																												</xsl:for-each>
																											</xsl:for-each>
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</td>
																										<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:AdmId">
																												<xsl:for-each select="ega:REGON">
																													<xsl:apply-templates/>
																												</xsl:for-each>
																											</xsl:for-each>
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																											<span>
																												<xsl:text>18. Data urodzenia</xsl:text>
																											</span>
																											<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																												<xsl:text>3)</xsl:text>
																											</span>
																										</td>
																										<td colspan="3" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																											<span>
																												<xsl:text>19. Imię ojca</xsl:text>
																											</span>
																											<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																												<xsl:text>3)</xsl:text>
																											</span>
																										</td>
																										<td colspan="3" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																											<span>
																												<xsl:text>20. Imię matki</xsl:text>
																											</span>
																											<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																												<xsl:text>3)</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:DataUrodzenia">
																												<span>
																													<xsl:variable name="ckeaseqContentStrings_7">
																														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																														<xsl:text>-</xsl:text>
																														<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00', 'format1')"/>
																														<xsl:text>-</xsl:text>
																														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																													</xsl:variable>
																													<xsl:variable name="ckeasContent_7" select="string($ckeaseqContentStrings_7)"/>
																													<xsl:value-of select="$ckeasContent_7"/>
																												</span>
																											</xsl:for-each>
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</td>
																										<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:ImieOjca">
																												<xsl:apply-templates/>
																											</xsl:for-each>
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</td>
																										<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:ImieMatki">
																												<xsl:apply-templates/>
																											</xsl:for-each>
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>21. Numer telefonu</xsl:text>
																											</span>
																										</td>
																										<td colspan="6" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span>
																												<xsl:text>22. Adres e-mail</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:NrTelefonu">
																												<xsl:apply-templates/>
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</xsl:for-each>
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</td>
																										<td colspan="6" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																											<xsl:for-each select="ega:Email">
																												<xsl:apply-templates/>
																											</xsl:for-each>
																										</td>
																									</tr>
																								</tbody>
																							</table>
																						</xsl:for-each>
																					</td>
																				</tr>
																				<tr>
																					<td style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; ">
																						<span>
																							<xsl:text>B. DANE MAŁŻONKA ZOBOWIĄZANEGO (ODPOWIEDZIALNEGO MAJĄTKIEM WSPÓLNYM)</xsl:text>
																						</span>
																						<span style="font-family:Arial; font-size:small; font-weight:bold; vertical-align:super; ">
																							<xsl:text>2)</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td>
																						<xsl:choose>
																							<xsl:when test="ega:OsobaFizyczna/ega:Malzonek">
																								<xsl:for-each select="ega:OsobaFizyczna">
																									<xsl:for-each select="ega:Malzonek">
																										<table border="0" cellspacing="0" width="100%">
																											<xsl:variable name="ckeaCurrContextGrid_8" select="."/>
																											<tbody>
																												<tr>
																													<td rowspan="14" style="background-color:#a5a5a5; border-right-color:black; border-right-style:solid; border-right-width:thin; width:0.6in; "/>
																													<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>1. Imię</xsl:text>
																														</span>
																													</td>
																													<td colspan="4" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>2. Nazwisko</xsl:text>
																														</span>
																													</td>
																												</tr>
																												<tr style="height:0.20in; ">
																													<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Imie">
																															<xsl:apply-templates/>
																														</xsl:for-each>
																													</td>
																													<td colspan="4" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Nazwisko">
																															<xsl:apply-templates/>
																														</xsl:for-each>
																													</td>
																												</tr>
																												<tr>
																													<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>3. Kraj</xsl:text>
																														</span>
																													</td>
																													<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>4. Województwo</xsl:text>
																														</span>
																													</td>
																													<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>5. Powiat</xsl:text>
																														</span>
																													</td>
																												</tr>
																												<tr>
																													<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Adres">
																															<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																																<xsl:for-each select="ega:KodKraju">
																																	<xsl:variable name="kodKraju" select="./text()"/>
																																	<span>
																																		<xsl:value-of select="$XSDKodyKrajow//xs:enumeration[@value = $kodKraju]/xs:annotation/xs:documentation/text()"/>
																																	</span>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																													</td>
																													<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Adres">
																															<xsl:for-each select="ega:AdresPolski">
																																<xsl:for-each select="ega:PodzialAdm">
																																	<xsl:choose>
																																		<xsl:when test="ega:KodGminy">
																																			<xsl:for-each select="ega:KodGminy">
																																				<xsl:choose>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '02'">
																																						<span>
																																							<xsl:text>DOLNOŚLĄSKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '04'">
																																						<span>
																																							<xsl:text>KUJAWSKO-POMORSKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '06'">
																																						<span>
																																							<xsl:text>LUBELSKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '08'">
																																						<span>
																																							<xsl:text>LUBUSKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '10'">
																																						<span>
																																							<xsl:text>ŁÓDZKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '12'">
																																						<span>
																																							<xsl:text>MAŁOPOLSKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '14'">
																																						<span>
																																							<xsl:text>MAZOWIECKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '16'">
																																						<span>
																																							<xsl:text>OPOLSKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '18'">
																																						<span>
																																							<xsl:text>PODKARPACKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '20'">
																																						<span>
																																							<xsl:text>PODLASKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '22'">
																																						<span>
																																							<xsl:text>POMORSKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '24'">
																																						<span>
																																							<xsl:text>ŚLĄSKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '26'">
																																						<span>
																																							<xsl:text>ŚWIĘTOKRZYSKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '28'">
																																						<span>
																																							<xsl:text>WARMIŃSKO-MAZURSKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '30'">
																																						<span>
																																							<xsl:text>WIELKOPOLSKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:when test="substring( ./text() , 1 , 2 ) = '32'">
																																						<span>
																																							<xsl:text>ZACHODNIOPOMORSKIE</xsl:text>
																																						</span>
																																					</xsl:when>
																																					<xsl:otherwise>
																																						<span>
																																							<xsl:text>TERYT:</xsl:text>
																																						</span>
																																						<xsl:apply-templates/>
																																					</xsl:otherwise>
																																				</xsl:choose>
																																			</xsl:for-each>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<xsl:for-each select="ega:Wojewodztwo">
																																				<xsl:apply-templates/>
																																			</xsl:for-each>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																														<br/>
																													</td>
																													<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Adres">
																															<xsl:for-each select="ega:AdresPolski">
																																<xsl:for-each select="ega:PodzialAdm">
																																	<xsl:choose>
																																		<xsl:when test="ega:KodGminy">
																																			<span>
																																				<xsl:text>TERC:</xsl:text>
																																			</span>
																																			<xsl:for-each select="ega:KodGminy">
																																				<xsl:apply-templates/>
																																			</xsl:for-each>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<xsl:for-each select="ega:Powiat">
																																				<xsl:apply-templates/>
																																			</xsl:for-each>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																													</td>
																												</tr>
																												<tr>
																													<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>6. Gmina</xsl:text>
																														</span>
																													</td>
																													<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>7. Ulica</xsl:text>
																														</span>
																													</td>
																													<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>8. Numer domu</xsl:text>
																														</span>
																													</td>
																													<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>9. Numer lokalu</xsl:text>
																														</span>
																													</td>
																												</tr>
																												<tr>
																													<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Adres">
																															<xsl:for-each select="ega:AdresPolski">
																																<xsl:for-each select="ega:PodzialAdm">
																																	<xsl:choose>
																																		<xsl:when test="ega:KodGminy">
																																			<xsl:for-each select="ega:KodGminy">
																																				<xsl:variable name="kodGminy" select="./text()"/>
																																				<span>
																																					<xsl:value-of select="$XSDKodyGmin//xs:enumeration[@value = $kodGminy]/xs:annotation/xs:documentation/text()"/>
																																				</span>
																																			</xsl:for-each>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<xsl:for-each select="ega:Gmina">
																																				<xsl:apply-templates/>
																																			</xsl:for-each>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																													</td>
																													<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Adres">
																															<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																																<xsl:for-each select="ega:Ulica">
																																	<xsl:apply-templates/>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																													</td>
																													<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Adres">
																															<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																																<xsl:for-each select="ega:NrDomu">
																																	<xsl:apply-templates/>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																													</td>
																													<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Adres">
																															<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																																<xsl:for-each select="ega:NrLokalu">
																																	<xsl:apply-templates/>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																													</td>
																												</tr>
																												<tr>
																													<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>10. Miejscowość</xsl:text>
																														</span>
																													</td>
																													<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>11. Kod pocztowy</xsl:text>
																														</span>
																													</td>
																													<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>12. Poczta</xsl:text>
																														</span>
																													</td>
																												</tr>
																												<tr>
																													<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Adres">
																															<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																																<xsl:for-each select="ega:Miejscowosc">
																																	<xsl:apply-templates/>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																													</td>
																													<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Adres">
																															<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																																<xsl:for-each select="ega:KodPocztowy">
																																	<xsl:apply-templates/>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																													</td>
																													<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Adres">
																															<xsl:for-each select="ega:AdresPolski">
																																<xsl:for-each select="ega:Poczta">
																																	<xsl:apply-templates/>
																																</xsl:for-each>
																															</xsl:for-each>
																														</xsl:for-each>
																													</td>
																												</tr>
																												<tr>
																													<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>13. NIP</xsl:text>
																														</span>
																													</td>
																													<td colspan="3" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>14. Numer PESEL </xsl:text>
																														</span>
																													</td>
																												</tr>
																												<tr>
																													<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:AdmId">
																															<xsl:for-each select="ega:NIP">
																																<xsl:apply-templates/>
																															</xsl:for-each>
																														</xsl:for-each>
																													</td>
																													<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:AdmId">
																															<xsl:for-each select="ega:PESEL">
																																<xsl:apply-templates/>
																															</xsl:for-each>
																														</xsl:for-each>
																													</td>
																												</tr>
																												<tr>
																													<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>15. Numer telefonu</xsl:text>
																														</span>
																													</td>
																													<td colspan="4" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>16. Adres e-mail</xsl:text>
																														</span>
																													</td>
																												</tr>
																												<tr>
																													<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:NrTelefonu">
																															<xsl:apply-templates/>
																														</xsl:for-each>
																														<span>
																															<xsl:text> </xsl:text>
																														</span>																														
																													</td>
																													<td colspan="4" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Email">
																															<xsl:apply-templates/>
																														</xsl:for-each>
																													</td>
																												</tr>
																												<tr>
																													<td colspan="5" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																														<span>
																															<xsl:text>17. Podstawa prawna prowadzenia egzekucji administracyjnej</xsl:text>
																														</span>
																													</td>
																												</tr>
																												<tr>
																													<td colspan="5" style="font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:PodstawaPrawna">
																															<xsl:apply-templates/>
																														</xsl:for-each>
																														<span>
																															<xsl:text> </xsl:text>
																														</span>
																													</td>
																												</tr>
																											</tbody>
																										</table>
																									</xsl:for-each>
																								</xsl:for-each>
																							</xsl:when>
																							<xsl:otherwise>
																								<table border="0" cellspacing="0" width="100%">
																									<xsl:variable name="ckeaCurrContextGrid_9" select="."/>
																									<tbody>
																										<tr>
																											<td rowspan="14" style="background-color:#a5a5a5; border-right-color:black; border-right-style:solid; border-right-width:thin; width:0.6in; "/>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>1. Imię</xsl:text>
																												</span>
																											</td>
																											<td colspan="4" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>2. Nazwisko</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr style="height:0.20in; ">
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>  </xsl:text>
																												</span>
																											</td>
																											<td colspan="4" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>3. Kraj</xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>4. Województwo</xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>5. Powiat</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>6. Gmina</xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>7. Ulica</xsl:text>
																												</span>
																											</td>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>8. Numer domu</xsl:text>
																												</span>
																											</td>
																											<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>9. Numer lokalu</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>10. Miejscowość</xsl:text>
																												</span>
																											</td>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>11. Kod pocztowy</xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>12. Poczta</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>13. NIP</xsl:text>
																												</span>
																											</td>
																											<td colspan="3" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>14. Numer PESEL </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>15. Numer telefonu</xsl:text>
																												</span>
																											</td>
																											<td colspan="4" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>16. Adres e-mail</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="4" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td colspan="5" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>17. Podstawa prawna prowadzenia egzekucji administracyjnej</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td colspan="5" style="font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																									</tbody>
																								</table>
																							</xsl:otherwise>
																						</xsl:choose>
																					</td>
																				</tr>
																				<tr>
																					<td style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; ">
																						<span>
																							<xsl:text>C. DANE WSPÓLNIKÓW SPÓŁKI NIEPOSIADAJĄCEJ OSOBOWOŚCI PRAWNEJ</xsl:text>
																						</span>
																						<span style="font-family:Arial; font-size:small; font-weight:bold; vertical-align:super; ">
																							<xsl:text>2)</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td>
																						<xsl:choose>
																							<xsl:when test="ega:OsobaNiefizyczna/ega:Wspolnicy/ega:Wspolnik">
																								<xsl:for-each select="ega:OsobaNiefizyczna">
																									<xsl:for-each select="ega:Wspolnicy">
																										<xsl:for-each select="ega:Wspolnik">
																											<xsl:for-each select="(ega:OsobaFizyczna | ega:OsobaNiefizyczna )">
																												<table border="0" cellspacing="0" width="100%">
																													<xsl:variable name="ckeaCurrContextGrid_10" select="."/>
																													<tbody>
																														<tr>
																															<td rowspan="12" style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; font-weight:bold; text-align:center; vertical-align:top; width:0.6in; " align="center" valign="top">
																																<span>
																																	<xsl:text>C.</xsl:text>
																																</span>
																																<span>
																																	<xsl:value-of select="count(../preceding-sibling::*) + 1"/>
																																</span>
																																<span>
																																	<xsl:text>.</xsl:text>
																																</span>
																															</td>
																															<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:bottom; width:3.90in; ">
																																<span>
																																	<xsl:text>1. Imię</xsl:text>
																																</span>
																																<span style="font-size:xx-small; font-weight:bold; vertical-align:super; ">
																																	<xsl:text>3)</xsl:text>
																																</span>
																															</td>
																															<td colspan="5" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:bottom; ">
																																<span>
																																	<xsl:text>2. Nazwisko/Nazwa</xsl:text>
																																</span>
																															</td>
																														</tr>
																														<tr>
																															<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; width:3.90in; ">
																																<xsl:for-each select="ega:Imie">
																																	<xsl:apply-templates/>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																															<td colspan="5" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																																<xsl:for-each select="ega:Nazwisko | ega:Nazwa">
																																	<xsl:choose>
																																		<xsl:when test="self::*">
																																			<xsl:apply-templates/>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<xsl:value-of select="."/>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																														</tr>
																														<tr>
																															<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; width:3.90in; ">
																																<span>
																																	<xsl:text>3. Kraj</xsl:text>
																																</span>
																															</td>
																															<td colspan="3" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																																<span>
																																	<xsl:text>4. Województwo</xsl:text>
																																</span>
																															</td>
																															<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																																<span>
																																	<xsl:text>5. Powiat</xsl:text>
																																</span>
																															</td>
																														</tr>
																														<tr>
																															<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; width:3.90in; ">
																																<xsl:for-each select="ega:Adres">
																																	<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																																		<xsl:for-each select="ega:KodKraju">
																																			<xsl:variable name="kodKraju" select="./text()"/>
																																			<span>
																																				<xsl:value-of select="$XSDKodyKrajow//xs:enumeration[@value = $kodKraju]/xs:annotation/xs:documentation/text()"/>
																																			</span>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</xsl:for-each>
																															</td>
																															<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																																<xsl:for-each select="ega:Adres">
																																	<xsl:for-each select="ega:AdresPolski">
																																		<xsl:for-each select="ega:PodzialAdm">
																																			<xsl:choose>
																																				<xsl:when test="ega:KodGminy">
																																					<xsl:for-each select="ega:KodGminy">
																																						<xsl:choose>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '02'">
																																								<span>
																																									<xsl:text>DOLNOŚLĄSKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '04'">
																																								<span>
																																									<xsl:text>KUJAWSKO-POMORSKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '06'">
																																								<span>
																																									<xsl:text>LUBELSKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '08'">
																																								<span>
																																									<xsl:text>LUBUSKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '10'">
																																								<span>
																																									<xsl:text>ŁÓDZKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '12'">
																																								<span>
																																									<xsl:text>MAŁOPOLSKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '14'">
																																								<span>
																																									<xsl:text>MAZOWIECKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '16'">
																																								<span>
																																									<xsl:text>OPOLSKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '18'">
																																								<span>
																																									<xsl:text>PODKARPACKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '20'">
																																								<span>
																																									<xsl:text>PODLASKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '22'">
																																								<span>
																																									<xsl:text>POMORSKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '24'">
																																								<span>
																																									<xsl:text>ŚLĄSKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '26'">
																																								<span>
																																									<xsl:text>ŚWIĘTOKRZYSKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '28'">
																																								<span>
																																									<xsl:text>WARMIŃSKO-MAZURSKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '30'">
																																								<span>
																																									<xsl:text>WIELKOPOLSKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:when test="substring( ./text() , 1 , 2 ) = '32'">
																																								<span>
																																									<xsl:text>ZACHODNIOPOMORSKIE</xsl:text>
																																								</span>
																																							</xsl:when>
																																							<xsl:otherwise>
																																								<span>
																																									<xsl:text>TERYT:</xsl:text>
																																								</span>
																																								<xsl:apply-templates/>
																																							</xsl:otherwise>
																																						</xsl:choose>
																																					</xsl:for-each>
																																				</xsl:when>
																																				<xsl:otherwise>
																																					<xsl:for-each select="ega:Wojewodztwo">
																																						<xsl:apply-templates/>
																																					</xsl:for-each>
																																				</xsl:otherwise>
																																			</xsl:choose>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</xsl:for-each>
																															</td>
																															<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																																<xsl:for-each select="ega:Adres">
																																	<xsl:for-each select="ega:AdresPolski">
																																		<xsl:for-each select="ega:PodzialAdm">
																																			<xsl:choose>
																																				<xsl:when test="ega:KodGminy">
																																					<span>
																																						<xsl:text>TERC:</xsl:text>
																																					</span>
																																					<xsl:for-each select="ega:KodGminy">
																																						<xsl:apply-templates/>
																																					</xsl:for-each>
																																				</xsl:when>
																																				<xsl:otherwise>
																																					<xsl:for-each select="ega:Powiat">
																																						<xsl:apply-templates/>
																																					</xsl:for-each>
																																				</xsl:otherwise>
																																			</xsl:choose>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</xsl:for-each>
																															</td>
																														</tr>
																														<tr>
																															<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; width:3.90in; ">
																																<span>
																																	<xsl:text>6. Gmina</xsl:text>
																																</span>
																															</td>
																															<td colspan="3" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																																<span>
																																	<xsl:text>7. Ulica</xsl:text>
																																</span>
																															</td>
																															<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																																<span>
																																	<xsl:text>8. Numer domu</xsl:text>
																																</span>
																															</td>
																															<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																																<span>
																																	<xsl:text>9. Numer lokalu</xsl:text>
																																</span>
																															</td>
																														</tr>
																														<tr>
																															<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; width:3.90in; ">
																																<xsl:for-each select="ega:Adres">
																																	<xsl:for-each select="ega:AdresPolski">
																																		<xsl:for-each select="ega:PodzialAdm">
																																			<xsl:choose>
																																				<xsl:when test="ega:KodGminy">
																																					<xsl:for-each select="ega:KodGminy">
																																						<xsl:variable name="kodGminy" select="./text()"/>
																																						<span>
																																							<xsl:value-of select="$XSDKodyGmin//xs:enumeration[@value = $kodGminy]/xs:annotation/xs:documentation/text()"/>
																																						</span>
																																					</xsl:for-each>
																																				</xsl:when>
																																				<xsl:otherwise>
																																					<xsl:for-each select="ega:Gmina">
																																						<xsl:apply-templates/>
																																					</xsl:for-each>
																																				</xsl:otherwise>
																																			</xsl:choose>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																															<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																																<xsl:for-each select="ega:Adres">
																																	<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																																		<xsl:for-each select="ega:Ulica">
																																			<xsl:apply-templates/>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																															<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																																<xsl:for-each select="ega:Adres">
																																	<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																																		<xsl:for-each select="ega:NrDomu">
																																			<xsl:apply-templates/>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																															<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																																<xsl:for-each select="ega:Adres">
																																	<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																																		<xsl:for-each select="ega:NrLokalu">
																																			<xsl:apply-templates/>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																														</tr>
																														<tr>
																															<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; width:3.90in; ">
																																<span>
																																	<xsl:text>10. Miejscowość</xsl:text>
																																</span>
																															</td>
																															<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																																<span>
																																	<xsl:text>11. Kod pocztowy</xsl:text>
																																</span>
																															</td>
																															<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																																<span>
																																	<xsl:text>12. Poczta</xsl:text>
																																</span>
																															</td>
																														</tr>
																														<tr>
																															<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; width:3.90in; ">
																																<xsl:for-each select="ega:Adres">
																																	<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																																		<xsl:for-each select="ega:Miejscowosc">
																																			<xsl:apply-templates/>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																															<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																																<xsl:for-each select="ega:Adres">
																																	<xsl:for-each select="ega:AdresPolski | ega:AdresZagraniczny">
																																		<xsl:for-each select="ega:KodPocztowy">
																																			<xsl:apply-templates/>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																															<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																																<xsl:for-each select="ega:Adres">
																																	<xsl:for-each select="ega:AdresPolski">
																																		<xsl:for-each select="ega:Poczta">
																																			<xsl:apply-templates/>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																														</tr>
																														<tr>
																															<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; width:3.90in; ">
																																<span>
																																	<xsl:text>13. NIP</xsl:text>
																																</span>
																																<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																																	<xsl:text>4)</xsl:text>
																																</span>
																															</td>
																															<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																																<span>
																																	<xsl:text>14. Numer PESEL</xsl:text>
																																</span>
																																<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																																	<xsl:text>3)</xsl:text>
																																</span>
																															</td>
																															<td colspan="3" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:bottom; width:2.44in; ">
																																<span>
																																	<xsl:text>15. REGON</xsl:text>
																																</span>
																															</td>
																														</tr>
																														<tr>
																															<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; width:3.90in; ">
																																<xsl:for-each select="ega:AdmId">
																																	<xsl:for-each select="ega:NIP">
																																		<xsl:apply-templates/>
																																	</xsl:for-each>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																															<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																																<xsl:for-each select="ega:AdmId">
																																	<xsl:for-each select="ega:PESEL">
																																		<xsl:apply-templates/>
																																	</xsl:for-each>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																															<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; width:2.44in; ">
																																<xsl:for-each select="ega:AdmId">
																																	<xsl:for-each select="ega:REGON">
																																		<xsl:apply-templates/>
																																	</xsl:for-each>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																														</tr>
																														<tr>
																															<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; width:3.90in; ">
																																<span>
																																	<xsl:text>16. Numer telefonu</xsl:text>
																																</span>
																															</td>
																															<td colspan="5" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																																<span>
																																	<xsl:text>17. Adres e-mail</xsl:text>
																																</span>
																															</td>
																														</tr>
																														<tr>
																															<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; width:3.90in; ">
																																<xsl:for-each select="ega:NrTelefonu">
																																	<xsl:apply-templates/>
																																</xsl:for-each>
																																<span>
																																	<xsl:text> </xsl:text>
																																</span>
																															</td>
																															<td colspan="5" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																																<xsl:for-each select="ega:Email">
																																	<xsl:apply-templates/>
																																	<span>
																																		<xsl:text> </xsl:text>
																																	</span>
																																</xsl:for-each>
																															</td>
																														</tr>
																													</tbody>
																												</table>
																											</xsl:for-each>
																										</xsl:for-each>
																									</xsl:for-each>
																								</xsl:for-each>
																							</xsl:when>
																							<xsl:otherwise>
																								<table border="0" cellspacing="0" width="100%">
																									<xsl:variable name="ckeaCurrContextGrid_11" select="."/>
																									<tbody>
																										<tr>
																											<td rowspan="12" style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; font-weight:bold; text-align:center; vertical-align:top; width:0.6in; "/>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:bottom; ">
																												<span>
																													<xsl:text>1. Imię</xsl:text>
																												</span>
																												<span style="font-size:xx-small; font-weight:bold; vertical-align:super; ">
																													<xsl:text>3)</xsl:text>
																												</span>
																											</td>
																											<td colspan="5" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:bottom; ">
																												<span>
																													<xsl:text>2. Nazwisko/Nazwa</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="5" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>3. Kraj</xsl:text>
																												</span>
																											</td>
																											<td colspan="3" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>4. Województwo</xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>5. Powiat</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>6. Gmina</xsl:text>
																												</span>
																											</td>
																											<td colspan="3" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>7. Ulica</xsl:text>
																												</span>
																											</td>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>8. Numer domu</xsl:text>
																												</span>
																											</td>
																											<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>9. Numer lokalu</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>10. Miejscowość</xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>11. Kod pocztowy</xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text>12. Poczta</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																												<span>
																													<xsl:text>13. NIP</xsl:text>
																												</span>
																												<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																													<xsl:text>4)</xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																												<span>
																													<xsl:text>14. Numer PESEL</xsl:text>
																												</span>
																												<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																													<xsl:text>3)</xsl:text>
																												</span>
																											</td>
																											<td colspan="3" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:bottom; ">
																												<span>
																													<xsl:text>15. REGON</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="3" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																												<span>
																													<xsl:text>16. Numer telefonu</xsl:text>
																												</span>
																											</td>
																											<td colspan="5" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																												<span>
																													<xsl:text>17. Adres e-mail</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="5" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																									</tbody>
																								</table>
																							</xsl:otherwise>
																						</xsl:choose>
																					</td>
																				</tr>
																				<tr>
																					<td style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:bottom; ">
																						<span>
																							<xsl:text>D. DANE ZOBOWIĄZANEGO, U KTÓREGO POWSTAŁ OBOWIĄZEK</xsl:text>
																						</span>
																						<span style="font-size:small; vertical-align:super; ">
																							<xsl:text>2)</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td>
																						<xsl:choose>
																							<xsl:when test="(ega:OsobaFizyczna | ega:OsobaNiefizyczna )/ega:ZobowiazanyPierwotny">
																								<xsl:for-each select="(ega:OsobaFizyczna | ega:OsobaNiefizyczna )/ega:ZobowiazanyPierwotny">
																									<xsl:for-each select="ega:OsobaFizyczna | ega:OsobaNiefizyczna">
																										<table border="0" cellspacing="0" width="100%">
																											<xsl:variable name="ckeaCurrContextGrid_12" select="."/>
																											<tbody>
																												<tr>
																													<td rowspan="4" style="background-color:#a5a5a5; border-right-color:black; border-right-style:solid; border-right-width:thin; width:0.6in; "/>
																													<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																														<span>
																															<xsl:text>1. Imię</xsl:text>
																														</span>
																														<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																															<xsl:text>3)</xsl:text>
																														</span>
																													</td>
																													<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																														<span>
																															<xsl:text>2. Nazwisko/Nazwa</xsl:text>
																														</span>
																													</td>
																												</tr>
																												<tr>
																													<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Imie">
																															<xsl:apply-templates/>
																														</xsl:for-each>
																														<span>
																															<xsl:text> </xsl:text>
																														</span>
																													</td>
																													<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:Nazwisko | ega:Nazwa">
																															<xsl:choose>
																																<xsl:when test="self::*">
																																	<xsl:apply-templates/>
																																</xsl:when>
																																<xsl:otherwise>
																																	<xsl:value-of select="."/>
																																</xsl:otherwise>
																															</xsl:choose>
																														</xsl:for-each>
																														<span>
																															<xsl:text> </xsl:text>
																														</span>
																													</td>
																												</tr>
																												<tr>
																													<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																														<span>
																															<xsl:text>3. NIP</xsl:text>
																														</span>
																													</td>
																													<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																														<span>
																															<xsl:text>4. Numer PESEL</xsl:text>
																														</span>
																														<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																															<xsl:text>3)</xsl:text>
																														</span>
																													</td>
																													<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																														<span>
																															<xsl:text>5. REGON</xsl:text>
																														</span>
																													</td>
																												</tr>
																												<tr>
																													<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:AdmId">
																															<xsl:for-each select="ega:NIP">
																																<xsl:apply-templates/>
																															</xsl:for-each>
																														</xsl:for-each>
																														<span>
																															<xsl:text> </xsl:text>
																														</span>
																													</td>
																													<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:AdmId">
																															<xsl:for-each select="ega:PESEL">
																																<xsl:apply-templates/>
																															</xsl:for-each>
																														</xsl:for-each>
																														<span>
																															<xsl:text> </xsl:text>
																														</span>
																													</td>
																													<td style="font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																														<xsl:for-each select="ega:AdmId">
																															<xsl:for-each select="ega:REGON">
																																<xsl:apply-templates/>
																															</xsl:for-each>
																														</xsl:for-each>
																													</td>
																												</tr>
																											</tbody>
																										</table>
																									</xsl:for-each>
																								</xsl:for-each>
																							</xsl:when>
																							<xsl:otherwise>
																								<table border="0" cellspacing="0" width="100%">
																									<xsl:variable name="ckeaCurrContextGrid_13" select="."/>
																									<tbody>
																										<tr>
																											<td rowspan="4" style="background-color:#a5a5a5; border-right-color:black; border-right-style:solid; border-right-width:thin; width:0.6in; "/>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																												<span>
																													<xsl:text>1. Imię</xsl:text>
																												</span>
																												<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																													<xsl:text>3)</xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																												<span>
																													<xsl:text>2. Nazwisko/Nazwa</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span style="font-weight:bold; ">
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																												<span>
																													<xsl:text>3. NIP</xsl:text>
																												</span>
																											</td>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																												<span>
																													<xsl:text>4. Numer PESEL</xsl:text>
																												</span>
																												<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																													<xsl:text>3)</xsl:text>
																												</span>
																											</td>
																											<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom; ">
																												<span>
																													<xsl:text>5. REGON</xsl:text>
																												</span>
																											</td>
																										</tr>
																										<tr>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																											<td style="font-family:Arial; padding-left:5px; padding-right:5px; ">
																												<span>
																													<xsl:text> </xsl:text>
																												</span>
																											</td>
																										</tr>
																									</tbody>
																								</table>
																							</xsl:otherwise>
																						</xsl:choose>
																					</td>
																				</tr>
																			</tbody>
																		</table>
																	</td>
																</tr>
															</xsl:for-each>
															<tr>
																<td style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; ">
																	<span>
																		<xsl:text>E. DANE DOTYCZĄCE NALEŻNOŚCI PIENIĘŻNYCH</xsl:text>
																	</span>
																</td>
															</tr>
															<xsl:for-each select="ega:Naleznosc">
																<tr>
																	<td>
																		<table border="0" cellspacing="0" width="100%">
																			<xsl:variable name="ckeaCurrContextGrid_14" select="."/>
																			<tbody>
																				<tr>
																					<td rowspan="17" style="background-color:#a5a5a5; border-right-color:black; border-right-style:solid; border-right-width:thin; width:0.6in; "/>
																					<td colspan="3" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom;">
																						<span>
																							<xsl:text>1. Akt normatywny</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="3" style="font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top;">
																						<xsl:for-each select="ega:AktNormatywny">
																							<xsl:apply-templates/>
																						</xsl:for-each>
																						<span>
																							<xsl:text> </xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="3" style="border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom;">
																						<span>
																							<xsl:text>2. Rodzaj należności pieniężnej</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="3" style="font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top;">
																						<xsl:for-each select="ega:RodzajNaleznosci">
																							<xsl:apply-templates/>
																						</xsl:for-each>
																						<span>
																							<xsl:text> </xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom;">
																						<span>
																							<xsl:text>3. Podstawa prawna obowiązku</xsl:text>
																						</span>
																						<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																							<xsl:text>1)</xsl:text>
																						</span>
																					</td>
																					<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom;">
																						<span>
																							<xsl:text>4. Identyfikacja podstawy prawnej obowiązku</xsl:text>
																						</span>
																					</td>
																					<td style="border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom;" nowrap="set">
																						<span>
																							<xsl:text>5. Data wydania orzeczenia</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px;" nowrap="set">
																						<span>
																							<xsl:text>[</xsl:text>
																						</span>
																						<xsl:choose>
																							<xsl:when test="ega:Obowiazek/ega:ZMocyPrawa">
																								<span style="font-family:Courier; font-size:larger; font-weight:bold; ">
																									<xsl:text>x</xsl:text>
																								</span>
																							</xsl:when>
																							<xsl:otherwise>
																								<span>
																									<xsl:text>  </xsl:text>
																								</span>
																							</xsl:otherwise>
																						</xsl:choose>
																						<span>
																							<xsl:text>] 1.z mocy prawa</xsl:text>
																						</span>
																					</td>
																					<td rowspan="3" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top;">
																						<xsl:for-each select="ega:Obowiazek">
																							<xsl:for-each select="(ega:ZMocyPrawa | ega:InnyDokument | ega:Orzeczenie)">
																								<xsl:choose>
																									<xsl:when test="self::*">
																										<xsl:apply-templates/>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:value-of select="."/>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</xsl:for-each>
																					</td>
																					<td rowspan="3" style="font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top;">
																						<xsl:for-each select="ega:Obowiazek">
																							<xsl:for-each select="ega:Orzeczenie">
																								<xsl:for-each select="@dataWydania">
																									<span>
																										<xsl:variable name="ckeaseqContentStrings_15">
																											<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																											<xsl:text>-</xsl:text>
																											<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00', 'format1')"/>
																											<xsl:text>-</xsl:text>
																											<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																										</xsl:variable>
																										<xsl:variable name="ckeasContent_15" select="string($ckeaseqContentStrings_15)"/>
																										<xsl:value-of select="$ckeasContent_15"/>
																									</span>
																								</xsl:for-each>
																							</xsl:for-each>
																						</xsl:for-each>
																					</td>
																				</tr>
																				<tr>
																					<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px;" nowrap="set">
																						<span>
																							<xsl:text>[</xsl:text>
																						</span>
																						<xsl:choose>
																							<xsl:when test="ega:Obowiazek/ega:InnyDokument">
																								<span style="font-family:Courier; font-size:larger; font-weight:bold; ">
																									<xsl:text>x</xsl:text>
																								</span>
																							</xsl:when>
																							<xsl:otherwise>
																								<span style="font-family:Courier; font-size:larger; ">
																									<xsl:text> </xsl:text>
																								</span>
																							</xsl:otherwise>
																						</xsl:choose>
																						<span>
																							<xsl:text>] 2.dokument, o którym mowa w art. 3a § 1 ustawy</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px;" nowrap="set">
																						<span>
																							<xsl:text>[</xsl:text>
																						</span>
																						<xsl:choose>
																							<xsl:when test="ega:Obowiazek/ega:Orzeczenie">
																								<span style="font-family:Courier; font-size:larger; font-weight:bold; ">
																									<xsl:text>x</xsl:text>
																								</span>
																							</xsl:when>
																							<xsl:otherwise>
																								<span style="font-family:Courier; font-size:larger; ">
																									<xsl:text> </xsl:text>
																								</span>
																							</xsl:otherwise>
																						</xsl:choose>
																						<span>
																							<xsl:text>] 3.orzeczenie</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr style="height:0.17in; ">
																					<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom;" valign="top">
																						<span>
																							<xsl:text>6. Rodzaj odsetek</xsl:text>
																						</span>
																						<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																							<xsl:text>1)</xsl:text>
																						</span>
																					</td>
																					<td style="border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:bottom;">
																						<span>
																							<xsl:text>7. Stawka odsetek</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; padding-left:5px; padding-right:5px;" valign="top">
																						<table align="left" border="0" cellpadding="0" cellspacing="0" width="100%">
																							<xsl:variable name="ckeaCurrContextGrid_16" select="."/>
																							<tbody>
																								<tr>
																									<td style="text-align:left; width:20%; " valign="top">
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>[</xsl:text>
																										</span>
																										<xsl:choose>
																											<xsl:when test="ega:Zobowiazanie/ega:Odsetki/@rodzaj = 1">
																												<span style="font-family:Courier; font-size:larger; font-weight:bold; text-align:left; vertical-align:top; ">
																													<xsl:text>x</xsl:text>
																												</span>
																											</xsl:when>
																											<xsl:otherwise>
																												<span style="font-family:Courier; font-size:larger; text-align:left; vertical-align:top; ">
																													<xsl:text> </xsl:text>
																												</span>
																											</xsl:otherwise>
																										</xsl:choose>
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>] 1.odsetki za zwłokę</xsl:text>
																										</span>
																									</td>
																									<td style="text-align:left; width:30%; " valign="top">
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>[</xsl:text>
																										</span>
																										<xsl:choose>
																											<xsl:when test="ega:Zobowiazanie/ega:Odsetki/@rodzaj = 3">
																												<span style="font-family:Courier; font-size:larger; font-weight:bold; text-align:left; vertical-align:top; ">
																													<xsl:text>x</xsl:text>
																												</span>
																											</xsl:when>
																											<xsl:otherwise>
																												<span style="font-family:Courier; font-size:larger; text-align:left; vertical-align:top; ">
																													<xsl:text> </xsl:text>
																												</span>
																											</xsl:otherwise>
																										</xsl:choose>
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>] 3.podwyższona stawka odsetek za zwłokę</xsl:text>
																										</span>
																									</td>
																									<td style="text-align:left; width:30%; " valign="top">
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>[</xsl:text>
																										</span>
																										<xsl:choose>
																											<xsl:when test="ega:Zobowiazanie/ega:Odsetki/@rodzaj = 5">
																												<span style="font-family:Courier; font-size:larger; font-weight:bold; text-align:left; vertical-align:top; ">
																													<xsl:text>x</xsl:text>
																												</span>
																											</xsl:when>
																											<xsl:otherwise>
																												<span style="font-family:Courier; font-size:larger; text-align:left; vertical-align:top; ">
																													<xsl:text> </xsl:text>
																												</span>
																											</xsl:otherwise>
																										</xsl:choose>
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>] 5.odsetki ustawowe za opóźnienie</xsl:text>
																										</span>
																									</td>
																									<td style="text-align:left; width:20%; " valign="top">
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>[</xsl:text>
																										</span>
																										<xsl:choose>
																											<xsl:when test="ega:Zobowiazanie/ega:BrakOdsetek">
																												<span style="font-family:Courier; font-size:larger; font-weight:bold; text-align:left; vertical-align:top; ">
																													<xsl:text>x</xsl:text>
																												</span>
																											</xsl:when>
																											<xsl:otherwise>
																												<span style="font-family:Courier; font-size:larger; text-align:left; vertical-align:top; ">
																													<xsl:text> </xsl:text>
																												</span>
																											</xsl:otherwise>
																										</xsl:choose>
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>] 7.nie pobiera się odsetek</xsl:text>
																										</span>
																									</td>
																								</tr>
																								<tr>
																									<td style="text-align:left; width:20%; " valign="top">
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>[</xsl:text>
																										</span>
																										<xsl:choose>
																											<xsl:when test="ega:Zobowiazanie/ega:Odsetki/@rodzaj = 2">
																												<span style="font-family:Courier; font-size:larger; font-weight:bold; text-align:left; vertical-align:top; ">
																													<xsl:text>x</xsl:text>
																												</span>
																											</xsl:when>
																											<xsl:otherwise>
																												<span style="font-family:Courier; font-size:larger; text-align:left; vertical-align:top; ">
																													<xsl:text> </xsl:text>
																												</span>
																											</xsl:otherwise>
																										</xsl:choose>
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>] 2.połowa odsetek za zwłokę</xsl:text>
																										</span>
																									</td>
																									<td style="text-align:left; width:30%; " valign="top">
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>[</xsl:text>
																										</span>
																										<xsl:choose>
																											<xsl:when test="ega:Zobowiazanie/ega:Odsetki/@rodzaj = 4">
																												<span style="font-family:Courier; font-size:larger; font-weight:bold; text-align:left; vertical-align:top; ">
																													<xsl:text>x</xsl:text>
																												</span>
																											</xsl:when>
																											<xsl:otherwise>
																												<span style="font-family:Courier; font-size:larger; text-align:left; vertical-align:top; ">
																													<xsl:text> </xsl:text>
																												</span>
																											</xsl:otherwise>
																										</xsl:choose>
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>] 4.odsetki ustawowe</xsl:text>
																										</span>
																									</td>
																									<td style="text-align:left; width:30%; " valign="top">
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>[</xsl:text>
																										</span>
																										<xsl:choose>
																											<xsl:when test="ega:Zobowiazanie/ega:Odsetki/@rodzaj = 6">
																												<span style="font-family:Courier; font-size:larger; font-weight:bold; text-align:left; vertical-align:top; ">
																													<xsl:text>x</xsl:text>
																												</span>
																											</xsl:when>
																											<xsl:otherwise>
																												<span style="font-family:Courier; font-size:larger; text-align:left; vertical-align:top; ">
																													<xsl:text> </xsl:text>
																												</span>
																											</xsl:otherwise>
																										</xsl:choose>
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>] 6.odsetki ustawowe za opóźnienie w transakcjach handlowych</xsl:text>
																										</span>
																									</td>
																									<td style="text-align:left; width:20%; " valign="top">
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>[</xsl:text>
																										</span>
																										<xsl:choose>
																											<xsl:when test="ega:Zobowiazanie/ega:Odsetki/@rodzaj = 8">
																												<span style="font-family:Courier; font-size:larger; font-weight:bold; text-align:left; vertical-align:top; ">
																													<xsl:text>x</xsl:text>
																												</span>
																											</xsl:when>
																											<xsl:otherwise>
																												<span style="font-family:Courier; font-size:larger; text-align:left; vertical-align:top; ">
																													<xsl:text> </xsl:text>
																												</span>
																											</xsl:otherwise>
																										</xsl:choose>
																										<span style="text-align:left; vertical-align:top; ">
																											<xsl:text>] 8.odsetki za zwłokę od należności celnych</xsl:text>
																										</span>
																									</td>
																								</tr>
																							</tbody>
																						</table>
																					</td>
																					<td style="font-family:Arial; padding-left:5px; padding-right:5px; text-align:right; vertical-align:top;">
																						<xsl:for-each select="ega:Zobowiazanie">
																							<xsl:for-each select="ega:Odsetki">
																								<xsl:choose>
																									<xsl:when test="@stawka[not(normalize-space())]">
																										<span>
																											<xsl:text> </xsl:text>
																										</span>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:for-each select="@stawka">
																											<span>
																												<xsl:variable name="ckeaseqContentStrings_17">
																													<xsl:value-of select="format-number(number(string(.)), '##0,00', 'format2')"/>
																												</xsl:variable>
																												<xsl:variable name="ckeasContent_17" select="string($ckeaseqContentStrings_17)"/>
																												<xsl:value-of select="$ckeasContent_17"/>
																											</span>
																											<span>
																												<xsl:text>%</xsl:text>
																											</span>
																										</xsl:for-each>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</xsl:for-each>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="3" style="border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px;">
																						<span>
																							<xsl:text>8. Zabezpieczenie należności pieniężnej hipoteką przymusową lub zastawem i data powstania zabezpieczenia</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="3" style="font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top;">
																						<xsl:for-each select="ega:Zabezpieczenia">
																							<xsl:for-each select="ega:HipotekaZastaw">
																								<xsl:apply-templates/>
																								<xsl:choose>
																									<xsl:when test="@dataPowstania[not(normalize-space())]">
																										<span>
																											<xsl:text> </xsl:text>
																										</span>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:for-each select="@dataPowstania">
																											<span>
																												<xsl:text> [</xsl:text>
																											</span>
																											<span>
																												<xsl:variable name="ckeaseqContentStrings_18">
																													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																													<xsl:text>-</xsl:text>
																													<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00', 'format1')"/>
																													<xsl:text>-</xsl:text>
																													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																												</xsl:variable>
																												<xsl:variable name="ckeasContent_18" select="string($ckeaseqContentStrings_18)"/>
																												<xsl:value-of select="$ckeasContent_18"/>
																											</span>
																											<span>
																												<xsl:text>]</xsl:text>
																											</span>
																										</xsl:for-each>
																									</xsl:otherwise>
																								</xsl:choose>
																								<xsl:choose>
																									<xsl:when test="position() = last()"/>
																									<xsl:otherwise>
																										<span>
																											<xsl:text>, </xsl:text>
																										</span>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</xsl:for-each>
																						<span>
																							<xsl:text> </xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px;">
																						<span>
																							<xsl:text>9. Podstawa prawna braku obowiązku doręczenia upomnienia/ data doręczenia upomnienia/ data doręczenia powiadomienia</xsl:text>
																						</span>
																					</td>
																					<td style="border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px;" nowrap="set" valign="top">
																						<span>
																							<xsl:text>10. Kwota kosztów upomnienia</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="2" style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top;" valign="top">
																						<xsl:for-each select="ega:Doreczenia">
																							<xsl:for-each select="ega:BrakUpomnienia">
																								<xsl:apply-templates/>
																							</xsl:for-each>
																							<xsl:for-each select="ega:KosztyUpomnienia">
																								<xsl:choose>
																									<xsl:when test="@dataDoreczenia[not(normalize-space())]">
																										<span>
																											<xsl:text> </xsl:text>
																										</span>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:for-each select="@dataDoreczenia">
																											<span>
																												<xsl:variable name="ckeaseqContentStrings_19">
																													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																													<xsl:text>-</xsl:text>
																													<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00', 'format1')"/>
																													<xsl:text>-</xsl:text>
																													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																												</xsl:variable>
																												<xsl:variable name="ckeasContent_19" select="string($ckeaseqContentStrings_19)"/>
																												<xsl:value-of select="$ckeasContent_19"/>
																											</span>
																										</xsl:for-each>
																									</xsl:otherwise>
																								</xsl:choose>
																								<xsl:choose>
																									<xsl:when test="position() = last()"/>
																									<xsl:otherwise>
																										<span>
																											<xsl:text>, </xsl:text>
																										</span>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																							<xsl:for-each select="ega:Powiadomienie">
																								<xsl:choose>
																									<xsl:when test="@dataDoreczenia[not(normalize-space())]">
																										<span>
																											<xsl:text> </xsl:text>
																										</span>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:for-each select="@dataDoreczenia">
																											<span>
																												<xsl:variable name="ckeaseqContentStrings_20">
																													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																													<xsl:text>-</xsl:text>
																													<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00', 'format1')"/>
																													<xsl:text>-</xsl:text>
																													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																												</xsl:variable>
																												<xsl:variable name="ckeasContent_20" select="string($ckeaseqContentStrings_20)"/>
																												<xsl:value-of select="$ckeasContent_20"/>
																											</span>
																										</xsl:for-each>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																						</xsl:for-each>
																					</td>
																					<td style="font-family:Arial; padding-left:5px; padding-right:5px; text-align:right; vertical-align:top;" valign="top">
																						<xsl:choose>
																							<xsl:when test="ega:Doreczenia/ega:KosztyUpomnienia[not(normalize-space())]">
																								<span>
																									<xsl:text> </xsl:text>
																								</span>
																							</xsl:when>
																							<xsl:when test="ega:Doreczenia/ega:Powiadomienie">
																								<span>
																									<xsl:text> </xsl:text>
																								</span>
																							</xsl:when>
																							<xsl:when test="ega:Doreczenia/ega:BrakUpomnienia">
																								<span>
																									<xsl:text> </xsl:text>
																								</span>
																							</xsl:when>
																							<xsl:otherwise>
																								<span>
																									<xsl:variable name="ckeaseqContentStrings_21">
																										<xsl:value-of select="format-number(number(sum(ega:Doreczenia/ega:KosztyUpomnienia)), '### ##0,00', 'format1')"/>
																									</xsl:variable>
																									<xsl:variable name="ckeasContent_21" select="string($ckeaseqContentStrings_21)"/>
																									<xsl:value-of select="$ckeasContent_21"/>
																								</span>
																							</xsl:otherwise>
																						</xsl:choose>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="3" style="background-color:silver; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px;">
																						<span>
																							<xsl:text>Należności pieniężne są wymagalne i podlegają egzekucji administracyjnej na podstawie art. 2 ustawy oraz na podstawie</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="3" style="border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px;">
																						<span>
																							<xsl:text>11. Inna podstawa prawna</xsl:text>
																						</span>
																						<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																							<xsl:text>2)</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="3" style="font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top;">
																						<xsl:for-each select="ega:InnaPodstawaPrawna">
																							<xsl:apply-templates/>
																						</xsl:for-each>
																						<span>
																							<xsl:text> </xsl:text>
																						</span>
																					</td>
																				</tr>
																			</tbody>
																		</table>
																		<xsl:for-each select="ega:Zobowiazanie">
																			<xsl:for-each select="( ega:BrakOdsetek | ega:Odsetki )/ega:Pozycja">
																				<table border="0" cellspacing="0" width="100%">
																					<xsl:variable name="ckeaCurrContextGrid_22" select="."/>
																					<tbody>
																						<tr>
																							<td style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:smaller; font-weight:bold; padding-left:5px; padding-right:5px; text-align:center; vertical-align:top; " align="center" valign="top">
																								<span>
																									<xsl:text>E.</xsl:text>
																								</span>
																								<span>
																									<xsl:value-of select="position()"/>
																								</span>
																								<span>
																									<xsl:text>.</xsl:text>
																								</span>
																							</td>
																							<td colspan="4" style="background-color:silver; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; text-align:left; "/>
																						</tr>
																						<tr>
																							<td rowspan="5" style="background-color:#a5a5a5; border-right-color:black; border-right-style:solid; border-right-width:thin; width:0.6in; "/>
																							<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																								<span>
																									<xsl:text>1. Kwota należności pieniężnej</xsl:text>
																								</span>
																							</td>
																							<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																								<span>
																									<xsl:text>2. Data, od której nalicza się odsetki</xsl:text>
																								</span>
																							</td>
																							<td style="border-left-color:black; border-left-style:solid; border-left-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; vertical-align:top; ">
																								<span>
																									<xsl:text>3. Kwota odsetek na dzień wystawienia tytułu wykonawczego</xsl:text>
																								</span>
																							</td>
																							<td style="border-left-color:black; border-left-style:solid; border-left-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																								<span>
																									<xsl:text>4. Data, do której należność pieniężna może być dochodzona</xsl:text>
																								</span>
																							</td>
																						</tr>
																						<tr>
																							<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; text-align:right; vertical-align:top; ">
																								<xsl:choose>
																									<xsl:when test="ega:Kwota[not(normalize-space())]">
																										<span>
																											<xsl:text> </xsl:text>
																										</span>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:for-each select="ega:Kwota">
																											<span>
																												<xsl:variable name="ckeaseqContentStrings_23">
																													<xsl:value-of select="format-number(number(string(.)), '### ##0,00', 'format1')"/>
																												</xsl:variable>
																												<xsl:variable name="ckeasContent_23" select="string($ckeaseqContentStrings_23)"/>
																												<xsl:value-of select="$ckeasContent_23"/>
																											</span>
																										</xsl:for-each>
																									</xsl:otherwise>
																								</xsl:choose>
																							</td>
																							<td style="font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																								<xsl:choose>
																									<xsl:when test="ega:OdsetkiDniaOd[not(normalize-space())]">
																										<span>
																											<xsl:text> </xsl:text>
																										</span>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:for-each select="ega:OdsetkiDniaOd">
																											<span>
																												<xsl:variable name="ckeaseqContentStrings_24">
																													<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																													<xsl:text>-</xsl:text>
																													<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00', 'format1')"/>
																													<xsl:text>-</xsl:text>
																													<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																												</xsl:variable>
																												<xsl:variable name="ckeasContent_24" select="string($ckeaseqContentStrings_24)"/>
																												<xsl:value-of select="$ckeasContent_24"/>
																											</span>
																										</xsl:for-each>
																									</xsl:otherwise>
																								</xsl:choose>
																							</td>
																							<td style="border-left-color:black; border-left-style:solid; border-left-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; text-align:right; vertical-align:top; ">
																								<xsl:choose>
																									<xsl:when test="ega:KwotaOdsetek[not(normalize-space())]">
																										<span>
																											<xsl:text> </xsl:text>
																										</span>
																									</xsl:when>
																									<xsl:otherwise>
																										<xsl:for-each select="ega:KwotaOdsetek">
																											<span>
																												<xsl:variable name="ckeaseqContentStrings_25">
																													<xsl:value-of select="format-number(number(string(.)), '### ##0,00', 'format1')"/>
																												</xsl:variable>
																												<xsl:variable name="ckeasContent_25" select="string($ckeaseqContentStrings_25)"/>
																												<xsl:value-of select="$ckeasContent_25"/>
																											</span>
																										</xsl:for-each>
																									</xsl:otherwise>
																								</xsl:choose>
																							</td>
																							<td style="border-left-color:black; border-left-style:solid; border-left-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																								<xsl:for-each select="ega:DochodzicDniaDo">
																									<span>
																										<xsl:variable name="ckeaseqContentStrings_26">
																											<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																											<xsl:text>-</xsl:text>
																											<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00', 'format1')"/>
																											<xsl:text>-</xsl:text>
																											<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																										</xsl:variable>
																										<xsl:variable name="ckeasContent_26" select="string($ckeaseqContentStrings_26)"/>
																										<xsl:value-of select="$ckeasContent_26"/>
																									</span>
																								</xsl:for-each>
																							</td>
																						</tr>
																						<tr>
																							<td colspan="2" style="background-color:#e1e1e1; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																								<span>
																									<xsl:text>Data powstania należności pieniężnej/okres, którego dotyczy należność pieniężna</xsl:text>
																								</span>
																							</td>
																							<td colspan="2" style="border-left-color:black; border-left-style:solid; border-left-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																								<span>
																									<xsl:text>7. Podstawa prawna pierwszeństwa zaspokojenia należności pieniężnej</xsl:text>
																								</span>
																							</td>
																						</tr>
																						<tr>
																							<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																								<span>
																									<xsl:text>5. data/od dnia: </xsl:text>
																								</span>
																							</td>
																							<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																								<span>
																									<xsl:text>6. do dnia:</xsl:text>
																								</span>
																							</td>
																							<td colspan="2" rowspan="2" style="border-left-color:black; border-left-style:solid; border-left-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																								<xsl:for-each select="ega:PodstawaPrawnaPierwszenstwa">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																							</td>
																						</tr>
																						<tr>
																							<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																								<xsl:for-each select="ega:Okres">
																									<xsl:choose>
																										<xsl:when test="ega:DniaOd[not(normalize-space())]">
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</xsl:when>
																										<xsl:otherwise>
																											<xsl:for-each select="ega:DniaOd">
																												<span>
																													<xsl:variable name="ckeaseqContentStrings_27">
																														<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																														<xsl:text>-</xsl:text>
																														<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00', 'format1')"/>
																														<xsl:text>-</xsl:text>
																														<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																													</xsl:variable>
																													<xsl:variable name="ckeasContent_27" select="string($ckeaseqContentStrings_27)"/>
																													<xsl:value-of select="$ckeasContent_27"/>
																												</span>
																											</xsl:for-each>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</td>
																							<td style="font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																								<xsl:for-each select="ega:Okres">
																									<xsl:for-each select="ega:DniaDo">
																										<span>
																											<xsl:variable name="ckeaseqContentStrings_28">
																												<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00', 'format1')"/>
																												<xsl:text>-</xsl:text>
																												<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00', 'format1')"/>
																												<xsl:text>-</xsl:text>
																												<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000', 'format1')"/>
																											</xsl:variable>
																											<xsl:variable name="ckeasContent_28" select="string($ckeaseqContentStrings_28)"/>
																											<xsl:value-of select="$ckeasContent_28"/>
																										</span>
																									</xsl:for-each>
																								</xsl:for-each>
																							</td>
																						</tr>
																					</tbody>
																				</table>
																			</xsl:for-each>
																		</xsl:for-each>
																	</td>
																</tr>
															</xsl:for-each>
															<tr>
																<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; line-height:1px; ">
																	<span>
																		<xsl:text> </xsl:text>
																	</span>
																</td>
															</tr>
															<tr>
																<td style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; ">
																	<span>
																		<xsl:text>F. OZNACZENIE I WNIOSEK WIERZYCIELA</xsl:text>
																	</span>
																</td>
															</tr>
															<xsl:for-each select="ega:Wierzyciel">
																<tr>
																	<td>
																		<table border="0" cellspacing="0" width="100%">
																			<xsl:variable name="ckeaCurrContextGrid_29" select="."/>
																			<tbody>
																				<tr>
																					<td rowspan="10" style="background-color:#a5a5a5; border-right-color:black; border-right-style:solid; border-right-width:thin; width:0.6in; "/>
																					<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																						<span style="vertical-align:middle; ">
																							<xsl:text>1. Nazwa wierzyciela</xsl:text>
																						</span>
																					</td>
																					<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																						<span style="vertical-align:middle; ">
																							<xsl:text>2. Adres siedziby wierzyciela</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																						<xsl:for-each select="ega:Nazwa">
																							<xsl:apply-templates/>
																						</xsl:for-each>
																					</td>
																					<td style="font-family:Arial; padding-left:5px; padding-right:5px; text-align:left; vertical-align:top; ">
																						<xsl:for-each select="ega:Adres">
																							<xsl:for-each select="ega:Miejscowosc">
																								<xsl:apply-templates/>
																							</xsl:for-each>
																							<span>
																								<xsl:text> </xsl:text>
																							</span>
																							<xsl:for-each select="ega:Ulica">
																								<xsl:apply-templates/>
																							</xsl:for-each>
																							<span>
																								<xsl:text> </xsl:text>
																							</span>
																							<xsl:for-each select="ega:NrDomu">
																								<xsl:apply-templates/>
																							</xsl:for-each>
																							<xsl:for-each select="ega:NrLokalu">
																								<span>
																									<xsl:text>/</xsl:text>
																								</span>
																								<xsl:apply-templates/>
																							</xsl:for-each>
																							<br/>
																							<xsl:for-each select="ega:KodPocztowy">
																								<xsl:apply-templates/>
																							</xsl:for-each>
																							<span>
																								<xsl:text> </xsl:text>
																							</span>
																							<xsl:for-each select="ega:Poczta">
																								<xsl:apply-templates/>
																							</xsl:for-each>
																						</xsl:for-each>
																						<span>
																							<xsl:text> </xsl:text>
																						</span>
																						<br/>
																						<span>
																							<xsl:text> </xsl:text>
																						</span>
																						<span style="vertical-align:middle; ">
																							<xsl:text>  </xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																						<span style="vertical-align:middle; ">
																							<xsl:text>3. NIP wierzyciela</xsl:text>
																						</span>
																					</td>
																					<td style="border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																						<span style="vertical-align:middle; ">
																							<xsl:text>4. REGON wierzyciela</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																						<xsl:for-each select="ega:NIP">
																							<xsl:apply-templates/>
																						</xsl:for-each>
																						<span>
																							<xsl:text> </xsl:text>
																						</span>
																					</td>
																					<td style="font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																						<xsl:for-each select="ega:REGON">
																							<xsl:apply-templates/>
																						</xsl:for-each>
																						<span>
																							<xsl:text> </xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="2" style="border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																						<span style="vertical-align:middle; ">
																							<xsl:text>5. Nazwa i adres siedziby podmiotu, któremu należy przekazać wyegzekwowaną należność pieniężną</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="2" style="font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																						<xsl:for-each select="ega:Beneficjent">
																							<xsl:for-each select="ega:Nazwa">
																								<xsl:apply-templates/>
																							</xsl:for-each>
																							<br/>
																							<xsl:for-each select="ega:Adres">
																								<xsl:for-each select="ega:Miejscowosc">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																								<span>
																									<xsl:text> </xsl:text>
																								</span>
																								<xsl:for-each select="ega:Ulica">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																								<span>
																									<xsl:text> </xsl:text>
																								</span>
																								<xsl:for-each select="ega:NrDomu">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																								<xsl:for-each select="ega:NrLokalu">
																									<span>
																										<xsl:text>/</xsl:text>
																									</span>
																									<xsl:apply-templates/>
																								</xsl:for-each>
																								<br/>
																								<xsl:for-each select="ega:KodPocztowy">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																								<span>
																									<xsl:text> </xsl:text>
																								</span>
																								<xsl:for-each select="ega:Poczta">
																									<xsl:apply-templates/>
																								</xsl:for-each>
																							</xsl:for-each>
																						</xsl:for-each>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="2" style="border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																						<span style="vertical-align:middle; ">
																							<xsl:text>6. Numer rachunku bankowego</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td colspan="2" style="font-family:Arial; padding-left:5px; padding-right:5px; vertical-align:top; ">
																						<xsl:for-each select="ega:Beneficjent">
																							<xsl:for-each select="ega:NrRachunkuPL">
																								<xsl:apply-templates/>
																							</xsl:for-each>
																						</xsl:for-each>
																						<span>
																							<xsl:text> </xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td rowspan="2" style="background-color:silver; border-right-color:black; border-right-style:solid; border-right-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; text-align:center; vertical-align:middle; ">
																						<xsl:for-each select="ega:WniosekOWszczecie">
																							<xsl:apply-templates/>
																						</xsl:for-each>
																					</td>
																					<td style="border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																						<span style="vertical-align:middle; ">
																							<xsl:text>7. Imię, nazwisko, stanowisko służbowe i podpis osoby upoważnionej do działania w imieniu wierzyciela</xsl:text>
																						</span>
																					</td>
																				</tr>
																				<tr>
																					<td style="font-family:Arial; padding-left:5px; padding-right:5px; text-align:center; vertical-align:top; ">
																						<span>
																							<xsl:text> </xsl:text>
																						</span>
																						<br/>
																						<xsl:choose>
																							<xsl:when test="count( /ega:Dokument/ds:Signature[1]/ds:SignatureValue) = 0">
																								<span style="font-family:Arial; font-size:smaller; ">
																									<xsl:text>Dokument nie posiada podpisu elektronicznego</xsl:text>
																								</span>
																							</xsl:when>
																							<xsl:otherwise>
																								<span style="font-family:Arial; font-size:10pt; font-weight:bold; margin-top:5px; ">
																									<xsl:text>P</xsl:text>
																								</span>
																								<span style="font-family:Arial; font-size:10pt; font-weight:bold; margin-top:5px; vertical-align:middle; ">
																									<xsl:text>odpis elektroniczny</xsl:text>
																								</span>
																								<br/>
																								<span style="font-family:Arial; font-size:smaller; ">
																									<xsl:text>(Imię i nazwisko zawarte w podpisie elektronicznym)</xsl:text>
																								</span>
																								<br/>
																								<xsl:for-each select="ega:StanowiskoSluzbowe">
																									<span style="font-family:Arial; ">
																										<xsl:apply-templates/>
																									</span>
																								</xsl:for-each>
																								<br/>
																								<span style="font-family:Arial; font-size:x-small; ">
																									<xsl:text>Dokument został podpisany, aby go zweryfikować należy </xsl:text>
																								</span>
																								<br/>
																								<span style="font-family:Arial; font-size:x-small; ">
																									<xsl:text>użyć oprogramowania do weryfikacji podpisu</xsl:text>
																								</span>
																								<br/>
																								<span style="font-size:xx-small; ">
																									<xsl:text> </xsl:text>
																								</span>
																								<br/>
																								<span style="font-family:Arial; font-size:x-small; font-weight:bold; ">
																									<xsl:text>Podpis elektroniczny</xsl:text>
																								</span>
																								<br/>
																								<xsl:for-each select="$XML">
																									<xsl:for-each select="ega:Dokument">
																										<xsl:for-each select="ds:Signature">
																											<xsl:for-each select="ds:Object">
																												<xsl:for-each select="descendant::*[local-name() = 'SigningTime']">
																													<span style="font-family:Arial; font-size:smaller; font-style:italic; ">
																														<xsl:choose>
																															<xsl:when test="self::*">
																																<xsl:apply-templates/>
																															</xsl:when>
																															<xsl:otherwise>
																																<xsl:value-of select="."/>
																															</xsl:otherwise>
																														</xsl:choose>
																													</span>
																												</xsl:for-each>
																											</xsl:for-each>
																										</xsl:for-each>
																									</xsl:for-each>
																								</xsl:for-each>
																							</xsl:otherwise>
																						</xsl:choose>
																						<br/>
																					</td>
																				</tr>
																			</tbody>
																		</table>
																	</td>
																</tr>
															</xsl:for-each>
															<tr>
																<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; line-height:1px; ">
																	<span>
																		<xsl:text> </xsl:text>
																	</span>
																</td>
															</tr>
															<tr>
																<td style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; ">
																	<span>
																		<xsl:text>G. OZNACZENIE ORGANU LUB ORGANÓW, O KTÓRYCH MOWA W ART. 17 UST. 1 PKT 1 LIT. D USTAWY Z DNIA 10 czerwca 2016 r. O DELEGOWANIU PRACOWNIKÓW W RAMACH ŚWIADCZENIA USŁUG (Dz. U. poz. 868)</xsl:text>
																	</span>
																	<span style="font-family:Arial; font-size:small; font-weight:bold; vertical-align:super; ">
																		<xsl:text>2)</xsl:text>
																	</span>
																</td>
															</tr>
															<xsl:for-each select="ega:Naleznosc">
																<xsl:for-each select="ega:Doreczenia">
																	<tr>
																		<td align="left" valign="top">
																			<xsl:choose>
																				<xsl:when test="ega:Powiadomienie/ega:OrganOdpowiedzialny">
																					<xsl:for-each select="ega:Powiadomienie">
																						<xsl:for-each select="ega:OrganOdpowiedzialny">
																							<table border="0" cellpadding="0" cellspacing="0" width="100%">
																								<xsl:variable name="ckeaCurrContextGrid_30" select="."/>
																								<tbody>
																									<tr>
																										<td rowspan="5" style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; font-weight:bold; padding-left:5px; padding-right:5px; width:0.6in; " align="center" valign="top">
																											<span style="font-family:Arial; font-weight:bold; ">
																												<xsl:text>G.1.</xsl:text>
																											</span>
																										</td>
																										<td colspan="2" style="background-color:silver; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-size:small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span style="font-family:Arial; font-size:smaller; font-weight:bold; ">
																												<xsl:text>Oznaczenie organu odpowiedzialnego za rozpatrzenie administracyjnej kary pieniężnej lub grzywny administracyjnej</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span style="vertical-align:middle; ">
																												<xsl:text>1. Nazwa wierzyciela</xsl:text>
																											</span>
																										</td>
																										<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span style="vertical-align:middle; ">
																												<xsl:text>2. Adres organu</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; " align="left" valign="top">
																											<xsl:for-each select="ega:Nazwa">
																												<xsl:apply-templates/>
																											</xsl:for-each>
																										</td>
																										<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; " align="left" valign="top">
																											<xsl:for-each select="ega:Adres">
																												<xsl:for-each select="ega:AdresPolski">
																													<xsl:for-each select="ega:Miejscowosc">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<span>
																														<xsl:text> </xsl:text>
																													</span>
																													<xsl:for-each select="ega:Ulica">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<span>
																														<xsl:text> </xsl:text>
																													</span>
																													<xsl:for-each select="ega:NrDomu">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<xsl:for-each select="ega:NrLokalu">
																														<span>
																															<xsl:text>/</xsl:text>
																														</span>
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<br/>
																													<xsl:for-each select="ega:KodPocztowy">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<span>
																														<xsl:text> </xsl:text>
																													</span>
																													<xsl:for-each select="ega:Poczta">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																												</xsl:for-each>
																												<br/>
																												<xsl:for-each select="ega:AdresZagraniczny">
																													<xsl:for-each select="ega:Miejscowosc">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<span>
																														<xsl:text> </xsl:text>
																													</span>
																													<xsl:for-each select="ega:Ulica">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<span>
																														<xsl:text> </xsl:text>
																													</span>
																													<xsl:for-each select="ega:NrDomu">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<xsl:for-each select="ega:NrLokalu">
																														<span>
																															<xsl:text>/</xsl:text>
																														</span>
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<br/>
																													<xsl:for-each select="ega:KodPocztowy">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<span>
																														<xsl:text> </xsl:text>
																													</span>
																													<xsl:for-each select="ega:KodKraju">
																														<xsl:variable name="kodKraju" select="./text()"/>
																														<span>
																															<xsl:value-of select="$XSDKodyKrajow//xs:enumeration[@value = $kodKraju]/xs:annotation/xs:documentation/text()"/>
																														</span>
																													</xsl:for-each>
																												</xsl:for-each>
																											</xsl:for-each>
																										</td>
																									</tr>
																									<tr>
																										<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span style="vertical-align:middle; ">
																												<xsl:text>3. Inne dane kontaktowe</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																											<xsl:for-each select="ega:InneDaneKontaktowe">
																												<xsl:apply-templates/>
																											</xsl:for-each>
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</td>
																									</tr>
																								</tbody>
																							</table>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:when>
																				<xsl:otherwise>
																					<table border="0" cellpadding="0" cellspacing="0" width="100%">
																						<xsl:variable name="ckeaCurrContextGrid_31" select="."/>
																						<tbody>
																							<tr>
																								<td rowspan="5" style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; font-weight:bold; width:0.6in; " align="center" valign="top">
																									<span style="font-family:Arial; font-weight:bold; ">
																										<xsl:text>G.1.</xsl:text>
																									</span>
																								</td>
																								<td colspan="2" style="background-color:silver; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-weight:bold; ">
																									<span>
																										<xsl:text>Oznaczenie organu odpowiedzialnego za rozpatrzenie administracyjnej kary pieniężnej lub grzywny administracyjnej</xsl:text>
																									</span>
																									<span style="font-family:Arial; font-size:small; font-weight:bold; vertical-align:super; ">
																										<xsl:text>2)</xsl:text>
																									</span>
																								</td>
																							</tr>
																							<tr>
																								<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; ">
																									<span style="vertical-align:middle; ">
																										<xsl:text>1. Nazwa wierzyciela</xsl:text>
																									</span>
																								</td>
																								<td style="font-family:Arial; font-size:x-small; font-weight:bold; ">
																									<span style="vertical-align:middle; ">
																										<xsl:text>2. Adres organu</xsl:text>
																									</span>
																								</td>
																							</tr>
																							<tr>
																								<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; " align="left" valign="top">
																									<span>
																										<xsl:text> </xsl:text>
																									</span>
																								</td>
																								<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; " align="left" valign="top">
																									<span>
																										<xsl:text>  </xsl:text>
																									</span>
																								</td>
																							</tr>
																							<tr>
																								<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; ">
																									<span style="vertical-align:middle; ">
																										<xsl:text>3. Inne dane kontaktowe</xsl:text>
																									</span>
																								</td>
																							</tr>
																							<tr>
																								<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; ">
																									<span>
																										<xsl:text> </xsl:text>
																									</span>
																								</td>
																							</tr>
																						</tbody>
																					</table>
																				</xsl:otherwise>
																			</xsl:choose>
																			<xsl:choose>
																				<xsl:when test="ega:Powiadomienie/ega:OrganUdzielajacyInformacji">
																					<xsl:for-each select="ega:Powiadomienie">
																						<xsl:for-each select="ega:OrganUdzielajacyInformacji">
																							<table border="0" cellpadding="0" cellspacing="0" width="100%">
																								<xsl:variable name="ckeaCurrContextGrid_32" select="."/>
																								<tbody>
																									<tr>
																										<td rowspan="5" style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; font-weight:bold; padding-left:5px; padding-right:5px; width:0.6in; " align="center" valign="top">
																											<span style="font-family:Arial; font-weight:bold; ">
																												<xsl:text>G.2.</xsl:text>
																											</span>
																										</td>
																										<td colspan="2" style="background-color:silver; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-size:small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span style="font-family:Arial; font-size:smaller; font-weight:bold; ">
																												<xsl:text>Oznaczenie organu, który może udzielić dodatkowych informacji dotyczących administracyjnej kary pieniężnej lub grzywny administracyjnej lub możliwości odwołania się od obowiązku zapłaty lub zaskarżenia decyzji w sprawie ich nałożenia</xsl:text>
																											</span>
																											<span style="font-family:Arial; font-size:smaller; font-weight:bold; vertical-align:super; ">
																												<xsl:text>2)</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span style="vertical-align:middle; ">
																												<xsl:text>1. Nazwa wierzyciela</xsl:text>
																											</span>
																										</td>
																										<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span style="vertical-align:middle; ">
																												<xsl:text>2. Adres organu</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; " align="left" valign="top">
																											<xsl:for-each select="ega:Nazwa">
																												<xsl:apply-templates/>
																											</xsl:for-each>
																										</td>
																										<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; " align="left" valign="top">
																											<xsl:for-each select="ega:Adres">
																												<xsl:for-each select="ega:AdresPolski">
																													<xsl:for-each select="ega:Miejscowosc">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<span>
																														<xsl:text> </xsl:text>
																													</span>
																													<xsl:for-each select="ega:Ulica">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<span>
																														<xsl:text> </xsl:text>
																													</span>
																													<xsl:for-each select="ega:NrDomu">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<xsl:for-each select="ega:NrLokalu">
																														<span>
																															<xsl:text>/</xsl:text>
																														</span>
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<br/>
																													<xsl:for-each select="ega:KodPocztowy">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<span>
																														<xsl:text> </xsl:text>
																													</span>
																													<xsl:for-each select="ega:Poczta">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																												</xsl:for-each>
																												<br/>
																												<xsl:for-each select="ega:AdresZagraniczny">
																													<xsl:for-each select="ega:Miejscowosc">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<span>
																														<xsl:text> </xsl:text>
																													</span>
																													<xsl:for-each select="ega:Ulica">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<span>
																														<xsl:text> </xsl:text>
																													</span>
																													<xsl:for-each select="ega:NrDomu">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<xsl:for-each select="ega:NrLokalu">
																														<span>
																															<xsl:text>/</xsl:text>
																														</span>
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<br/>
																													<xsl:for-each select="ega:KodPocztowy">
																														<xsl:apply-templates/>
																													</xsl:for-each>
																													<span>
																														<xsl:text> </xsl:text>
																													</span>
																													<xsl:for-each select="ega:KodKraju">
																														<xsl:variable name="kodKraju" select="./text()"/>
																														<span>
																															<xsl:value-of select="$XSDKodyKrajow//xs:enumeration[@value = $kodKraju]/xs:annotation/xs:documentation/text()"/>
																														</span>
																													</xsl:for-each>
																												</xsl:for-each>
																											</xsl:for-each>
																										</td>
																									</tr>
																									<tr>
																										<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																											<span style="vertical-align:middle; ">
																												<xsl:text>3. Inne dane kontaktowe</xsl:text>
																											</span>
																										</td>
																									</tr>
																									<tr>
																										<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																											<xsl:for-each select="ega:InneDaneKontaktowe">
																												<xsl:apply-templates/>
																											</xsl:for-each>
																											<span>
																												<xsl:text> </xsl:text>
																											</span>
																										</td>
																									</tr>
																								</tbody>
																							</table>
																						</xsl:for-each>
																					</xsl:for-each>
																				</xsl:when>
																				<xsl:otherwise>
																					<table border="0" cellpadding="0" cellspacing="0" width="100%">
																						<xsl:variable name="ckeaCurrContextGrid_33" select="."/>
																						<tbody>
																							<tr>
																								<td rowspan="5" style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:smaller; font-weight:bold; width:0.6in; " align="center" valign="top">
																									<span style="font-family:Arial; font-weight:bold; ">
																										<xsl:text>G.2.</xsl:text>
																									</span>
																								</td>
																								<td colspan="2" style="background-color:silver; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-weight:bold; ">
																									<span>
																										<xsl:text>Oznaczenie organu, który może udzielić dodatkowych informacji dotyczących administracyjnej kary pieniężnej lub grzywny administracyjnej lub możliwości odwołania się od obowiązku zapłaty lub zaskarżenia decyzji w sprawie ich nałożenia</xsl:text>
																									</span>
																									<span style="font-family:Arial; font-size:small; font-weight:bold; vertical-align:super; ">
																										<xsl:text>2)</xsl:text>
																									</span>
																								</td>
																							</tr>
																							<tr>
																								<td style="border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; ">
																									<span style="vertical-align:middle; ">
																										<xsl:text>1. Nazwa wierzyciela</xsl:text>
																									</span>
																								</td>
																								<td style="font-family:Arial; font-size:x-small; font-weight:bold; ">
																									<span style="vertical-align:middle; ">
																										<xsl:text>2. Adres organu</xsl:text>
																									</span>
																								</td>
																							</tr>
																							<tr>
																								<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; " align="left" valign="top">
																									<span>
																										<xsl:text> </xsl:text>
																									</span>
																								</td>
																								<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; " align="left" valign="top">
																									<span>
																										<xsl:text>  </xsl:text>
																									</span>
																								</td>
																							</tr>
																							<tr>
																								<td colspan="2" style="font-family:Arial; font-size:x-small; font-weight:bold; ">
																									<span style="vertical-align:middle; ">
																										<xsl:text>3. Inne dane kontaktowe</xsl:text>
																									</span>
																								</td>
																							</tr>
																							<tr>
																								<td colspan="2" style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; ">
																									<span>
																										<xsl:text> </xsl:text>
																									</span>
																								</td>
																							</tr>
																						</tbody>
																					</table>
																				</xsl:otherwise>
																			</xsl:choose>
																		</td>
																	</tr>
																</xsl:for-each>
															</xsl:for-each>
															<tr style="height:2px; ">
																<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; line-height:1px; "/>
															</tr>
															<tr>
																<td style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; ">
																	<span>
																		<xsl:text>H. KWOTA KOSZTÓW EGZEKUCYJNYCH</xsl:text>
																	</span>
																	<span style="font-family:Arial; font-size:small; font-weight:bold; vertical-align:super; ">
																		<xsl:text>2)</xsl:text>
																	</span>
																</td>
															</tr>
															<tr>
																<td>
																	<table border="0" cellpadding="0" cellspacing="0" width="100%">
																		<xsl:variable name="ckeaCurrContextGrid_34" select="."/>
																		<tbody>
																			<tr>
																				<td rowspan="2" style="background-color:#a5a5a5; border-right-color:black; border-right-style:solid; border-right-width:thin; width:0.6in; "/>
																				<td style="font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																					<span>
																						<xsl:text>Kwota kosztów egzekucyjnych</xsl:text>
																					</span>
																				</td>
																			</tr>
																			<tr>
																				<td style="font-family:Arial; padding-left:5px; padding-right:5px; ">
																					<xsl:for-each select="ega:DaneReferencyjne">
																						<xsl:for-each select="ega:DalszyTW">
																							<xsl:for-each select="ega:KosztyEgzekucyjne">
																								<span>
																									<xsl:variable name="ckeaseqContentStrings_35">
																										<xsl:value-of select="format-number(number(string(.)), '### ##0,00', 'format1')"/>
																									</xsl:variable>
																									<xsl:variable name="ckeasContent_35" select="string($ckeaseqContentStrings_35)"/>
																									<xsl:value-of select="$ckeasContent_35"/>
																								</span>
																							</xsl:for-each>
																						</xsl:for-each>
																					</xsl:for-each>
																					<span>
																						<xsl:text> </xsl:text>
																					</span>
																				</td>
																			</tr>
																		</tbody>
																	</table>
																</td>
															</tr>
															<tr style="height:2px; ">
																<td style="border-top-color:black; border-top-style:solid; border-top-width:thin; line-height:1px; "/>
															</tr>
															<tr>
																<td style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:middle; ">
																	<span>
																		<xsl:text>I. OZNACZENIE I KLAUZULA ORGANU EGZEKUCYJNEGO</xsl:text>
																	</span>
																</td>
															</tr>
															<tr>
																<td>
																	<table border="0" cellspacing="0" width="100%">
																		<xsl:variable name="ckeaCurrContextGrid_36" select="."/>
																		<tbody>
																			<tr>
																				<td rowspan="5" style="background-color:#a5a5a5; border-right-color:black; border-right-style:solid; border-right-width:thin; width:0.6in; "/>
																				<td colspan="2" style="background-color:silver; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																					<span>
																						<xsl:text>Potwierdza się zgodność danych zawartych w wydruku tytułu wykonawczego z treścią tytułu wykonawczego otrzymanego przy wykorzystaniu systemu teleinformatycznego albo z użyciem środków komunikacji elektronicznej</xsl:text>
																					</span>
																					<span style="font-family:Arial; font-size:xx-small; font-weight:bold; vertical-align:super; ">
																						<xsl:text>4)</xsl:text>
																					</span>
																				</td>
																			</tr>
																			<tr>
																				<td style="background-color:silver; border-right-color:black; border-right-style:solid; border-right-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; text-align:center; vertical-align:middle; ">
																					<span>
																						<xsl:text>Na podstawie art. 27 § 1 pkt 10 ustawy kieruję tytuł wykonawczy do egzekucji administracyjnej</xsl:text>
																					</span>
																				</td>
																				<td style="background-color:silver; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; " valign="top">
																					<span>
																						<xsl:text>2. Imię, nazwisko, stanowisko służbowe i podpis osoby upoważnionej do działania w imieniu organu egzekucyjnego.</xsl:text>
																					</span>
																				</td>
																			</tr>
																			<tr>
																				<td style="background-color:silver; border-right-color:black; border-right-style:solid; border-right-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:middle; ">
																					<span>
																						<xsl:text>1. Nazwa i adres siedziby organu egzekucyjnego</xsl:text>
																					</span>
																				</td>
																				<td style="background-color:silver; padding-left:5px; padding-right:5px; "/>
																			</tr>
																			<tr>
																				<td rowspan="2" style="background-color:silver; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; text-align:center; vertical-align:middle; ">
																					<span>
																						<xsl:text> </xsl:text>
																					</span>
																				</td>
																				<td style="background-color:silver; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																					<span>
																						<xsl:text>3. Data nadania klauzuli</xsl:text>
																					</span>
																				</td>
																			</tr>
																			<tr>
																				<td style="background-color:silver; padding-left:5px; padding-right:5px; ">
																					<span>
																						<xsl:text> </xsl:text>
																					</span>
																				</td>
																			</tr>
																		</tbody>
																	</table>
																</td>
															</tr>
															<tr style="line-height:1px; ">
																<td style="border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; border-top-color:black; border-top-style:solid; border-top-width:thin; ">
																	<span>
																		<xsl:text> </xsl:text>
																	</span>
																</td>
															</tr>
															<tr>
																<td style="background-color:#a5a5a5; border-bottom-color:black; border-bottom-style:solid; border-bottom-width:thin; font-family:Arial; font-weight:bold; padding-left:5px; padding-right:5px; text-align:left; vertical-align:middle; ">
																	<span>
																		<xsl:text>J. POTWIERDZENIE ODBIORU TYTUŁU WYKONAWCZEGO</xsl:text>
																	</span>
																</td>
															</tr>
															<tr>
																<td>
																	<table border="0" cellspacing="0" width="100%">
																		<xsl:variable name="ckeaCurrContextGrid_37" select="."/>
																		<tbody>
																			<tr>
																				<td rowspan="2" style="background-color:#a5a5a5; border-right-color:black; border-right-style:solid; border-right-width:thin; width:0.6in; "/>
																				<td style="background-color:silver; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																					<span>
																						<xsl:text>1. Data doręczenia odpisu/wydruku tytułu wykonawczego</xsl:text>
																					</span>
																				</td>
																				<td style="background-color:silver; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																					<span>
																						<xsl:text>2. Czytelny podpis otrzymującego odpis/wydruk tytułu wykonawczego</xsl:text>
																					</span>
																				</td>
																				<td style="background-color:silver; font-family:Arial; font-size:x-small; font-weight:bold; padding-left:5px; padding-right:5px; ">
																					<span>
																						<xsl:text>3. Podpis doręczającego odpis/wydruk tytułu wykonawczego</xsl:text>
																					</span>
																				</td>
																			</tr>
																			<tr>
																				<td style="background-color:silver; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; "/>
																				<td style="background-color:silver; border-right-color:black; border-right-style:solid; border-right-width:thin; font-family:Arial; padding-left:5px; padding-right:5px; ">
																					<span>
																						<xsl:text> </xsl:text>
																					</span>
																				</td>
																				<td style="background-color:silver; font-family:Arial; padding-left:5px; padding-right:5px; ">
																					<span>
																						<xsl:text> </xsl:text>
																					</span>
																				</td>
																			</tr>
																		</tbody>
																	</table>
																</td>
															</tr>
															<tr>
																<td style="background-color:#f0f0f0; border-top-color:black; border-top-style:solid; border-top-width:thin; font-family:Arial; font-size:small; font-weight:bold; padding-bottom:5px; padding-left:5px; padding-right:5px; padding-top:5px; text-align:center; vertical-align:middle; ">
																	<span>
																		<xsl:text>POUCZENIE</xsl:text>
																	</span>
																</td>
															</tr>
															<tr>
																<td style="background-color:#f0f0f0; font-family:Arial; font-size:small; padding-bottom:10px; padding-left:5px; padding-right:5px; padding-top:5px; text-align:justify; vertical-align:middle; white-space:normal; " align="justify">
																	<span>
																		<xsl:text>Środkami egzekucyjnymi stosowanymi w egzekucji należności pieniężnych są egzekucje: z pieniędzy, z wynagrodzenia za pracę, ze świadczeń z zaopatrzenia emerytalnego oraz z ubezpieczenia społecznego, a także z renty socjalnej, z rachunków bankowych, z innych wierzytelności pieniężnych, z praw z instrumentów finansowych w rozumieniu przepisów o obrocie instrumentami finansowymi, zapisanych na rachunku papierów wartościowych lub innym rachunku oraz wierzytelności z rachunku pieniężnego służącego do obsługi takich rachunków, z papierów wartościowych niezapisanych na rachunku papierów wartościowych, z weksla, z autorskich praw majątkowych i praw pokrewnych oraz z praw własności przemysłowej, z udziału w spółce z ograniczoną odpowiedzialnością, z pozostałych praw majątkowych, z ruchomości oraz z nieruchomości.</xsl:text>
																	</span>
																	<br/>
																	<br/>
																	<span>
																		<xsl:text>Jeżeli w części A wpisano jako zobowiązanych dane małżonków, tytuł wykonawczy stanowi podstawę przeprowadzenia egzekucji administracyjnej z ich majątku wspólnego i ich majątków osobistych.</xsl:text>
																	</span>
																	<br/>
																	<span>
																		<xsl:text>Jeżeli w części B wpisano dane małżonka zobowiązanego, tytuł wykonawczy stanowi podstawę do przeprowadzenia egzekucji administracyjnej z majątku wspólnego małżonków i majątku osobistego zobowiązanego z wyłączeniem majątku osobistego małżonka wskazanego w części B.</xsl:text>
																	</span>
																	<br/>
																	<br/>
																	<span>
																		<xsl:text>Na podstawie art. 33 § 1 ustawy zobowiązanemu przysługuje w terminie 7 dni od dnia doręczenia odpisu/wydruku tytułu wykonawczego prawo zgłoszenia do organu egzekucyjnego zarzutów w sprawie prowadzenia egzekucji administracyjnej. W przypadku zmienionego tytułu wykonawczego zobowiązanemu nie przysługuje prawo zgłoszenia zarzutów w sprawie prowadzenia egzekucji administracyjnej.</xsl:text>
																	</span>
																	<br/>
																	<br/>
																	<span>
																		<xsl:text>Zgodnie z art. 36 § 3 ustawy zobowiązany, przeciwko któremu wszczęto postępowanie egzekucyjne, jest obowiązany do powiadomienia, w terminie 7 dni, organu egzekucyjnego o każdej zmianie miejsca swego pobytu trwającej dłużej niż jeden miesiąc. W razie zaniedbania tego obowiązku na zobowiązanego może być nałożona kara pieniężna na podstawie art.168d § 3 ustawy. </xsl:text>
																	</span>
																	<br/>
																</td>
															</tr>
														</tbody>
													</table>
												</td>
											</tr>
										</xsl:for-each>
									</tbody>
								</table>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:for-each>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>