<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns2="http://topteam.pl/tytulwykonawczy/schema/t20200801"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:java="http://xml.apache.org/xslt/java"
                exclude-result-prefixes="fo java">

    <xsl:decimal-format name="KWOTA_FORMAT" grouping-separator=" " decimal-separator=","/>

    <xsl:attribute-set name="solidBorder">
        <xsl:attribute name="border">solid 0.1mm black</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="noBottomBorder">
        <xsl:attribute name="border-bottom-style">none</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="noTopBorder">
        <xsl:attribute name="border-top-style">none</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="noRightBorder">
        <xsl:attribute name="border-right-style">none</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="noLeftBorder">
        <xsl:attribute name="border-left-style">none</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="grey">
        <xsl:attribute name="background-color">#e0e0e0</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="center">
        <xsl:attribute name="text-align">center</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="tytulKomorki">
        <xsl:attribute name="font-size">7pt</xsl:attribute>
        <xsl:attribute name="margin">0.1cm</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="wartoscKomorki">
        <xsl:attribute name="font-size">8pt</xsl:attribute>
        <xsl:attribute name="margin-left">0.1cm</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="pouczenie">
        <xsl:attribute name="font-size">6pt</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="naglowek">
        <xsl:attribute name="font-size">10pt</xsl:attribute>
        <xsl:attribute name="margin-left">0.1cm</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
    </xsl:attribute-set>

    <xsl:template match="ns2:Tytul-wykonawczy">
        <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" font-family="DejaVuSans">
            <fo:layout-master-set>
                <fo:simple-page-master master-name="simpleA4" page-height="29.7cm" page-width="21cm" margin-top="2cm" margin-bottom="1cm" margin-left="1cm" margin-right="1.7cm">
                    <fo:region-body region-name="xsl-region-body"/>
                    <fo:region-after region-name="xsl-region-after"/>
                </fo:simple-page-master>
            </fo:layout-master-set>
            <fo:page-sequence id="main-page-sequence" master-reference="simpleA4">

                <fo:flow flow-name="xsl-region-body">
                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                        <fo:table-column column-width="2cm"/>
                        <fo:table-column column-width="12cm"/>
                        <fo:table-column column-width="5cm"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey center" padding="0.2cm">
                                    <fo:block>TW-1</fo:block>
                                    <fo:block font-size="8pt">(4)</fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder center grey" padding="0.2cm">
                                    <fo:block font-weight="bold">
                                        TYTUŁ WYKONAWCZY
                                    </fo:block>
                                    <fo:block font-size="8pt">
                                        STOSOWANY W EGZEKUCJI NALEŻNOŚCI PIENIĘŻNYCH
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">Numer systemowy sprawy organu egzekucyjnego</xsl:with-param>
                                        <xsl:with-param name="value" />
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                        <fo:table-column column-width="8cm"/>
                        <fo:table-column column-width="11cm"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="solidBorder noBottomBorder center grey" padding="0.2cm">
                                    <fo:block font-weight="bold" font-size="8pt">
                                        Podstawa prawna: art. 26 ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2019 r. poz. 1438, z późn. zm.),
                                        zwanej dalej „ustawą”
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">1. Numer tytułu wykonawczego</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dane-podstawowe/Numer-tytulu"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">2. Data wystawienia</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dane-podstawowe/Data-wystawienia"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="rodzajDokumentuField">
                                        <xsl:with-param name="title">3. Rodzaj dokumentu</xsl:with-param>
                                        <xsl:with-param name="checked" select="ns2:Dane-podstawowe/Rodzaj-dokumentu"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">4. Numer porządkowy dalszego tytułu wykonawczego ²⁾</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dane-podstawowe/Numer-porzadkowy-dalszego-tytulu"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="celWydaniaDalszegoTytuluField">
                                        <xsl:with-param name="title">5. Cel wydania dalszego tytułu wykonawczego ¹⁾ ²⁾</xsl:with-param>
                                        <xsl:with-param name="checked" select="ns2:Dane-podstawowe/Cel-wydania-dalszego-tytulu"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">6. Adnotacja dotycząca ponownie wydanego tytułu wykonawczego/zmienionego tytułu wykonawczego ²⁾</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dane-podstawowe/Adnotacja-dotyczaca-ponownego-tytulu"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                    <!-- dzial A -->
                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                        <fo:table-column column-width="1cm"/>
                        <fo:table-column column-width="5cm"/>
                        <fo:table-column column-width="4cm"/>
                        <fo:table-column column-width="3cm"/>
                        <fo:table-column column-width="4cm"/>
                        <fo:table-column column-width="2cm"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey naglowek" number-columns-spanned="6">
                                    <fo:block>A. DANE ZOBOWIĄZANEGO/ ZOBOWIĄZANYCH – MAŁŻONKÓW ODPOWIEDZIALNYCH SOLIDARNIE</fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey" number-rows-spanned="7">
                                    <fo:block font-size="8pt">A1.</fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="rodzajZobowiazanegoField">
                                        <xsl:with-param name="title">1. Rodzaj zobowiązanego ¹⁾</xsl:with-param>
                                        <xsl:with-param name="checked" select="ns2:Dzial-A/Rodzaj-zobowiazanego"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="3">
                                    <xsl:call-template name="rodzajOdpowiedzialnosciZobowiazanegoField">
                                        <xsl:with-param name="title">2. Rodzaj odpowiedzialności zobowiązanego ¹⁾</xsl:with-param>
                                        <xsl:with-param name="checked" select="ns2:Dzial-A/Rodzaj-odpowiedzialnosci"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">3. Imię ³⁾</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/Imie"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="4">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">4. Nazwisko/Nazwa</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/Nazwisko"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">5. Kraj</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/Kraj"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">6. Województwo</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/Wojewodztwo"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">7. Powiat</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/Powiat"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">8. Gmina</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/Gmina"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">9. Ulica</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/Ulica"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">10. Numer domu</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/Numer-domu"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">11. Numer lokalu</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/Numer-lokalu"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="3">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">12. Miejscowość</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/Miejscowosc"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">13. Kod pocztowy</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/Kod-pocztowy"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">14. NIP</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/NIP"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">15. Numer PESEL ³⁾</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/PESEL"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">16. Numer REGON</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/REGON"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="5">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">17. Data urodzenia ³⁾ ⁴⁾</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-A/Data-urodzenia"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                    <!-- Dzial B -->
                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                        <fo:table-column column-width="1cm"/>
                        <fo:table-column column-width="5cm"/>
                        <fo:table-column column-width="7cm"/>
                        <fo:table-column column-width="4cm"/>
                        <fo:table-column column-width="2cm"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey naglowek" number-columns-spanned="5">
                                    <fo:block>B. DANE WSPÓLNIKÓW SPÓŁKI NIEPOSIADAJĄCEJ OSOBOWOŚCI PRAWNEJ ²⁾</fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey" number-rows-spanned="5">
                                    <fo:block font-size="8pt">B1.</fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">1. Imię ³⁾</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="3">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">2. Nazwisko/Nazwa</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">3. Kraj</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">4. Województwo</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">5. Powiat</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">6. Gmina</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">7. Ulica</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">8. Numer domu</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">9. Numer lokalu</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">10. Miejscowość</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">11. Kod pocztowy</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">12. NIP</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">13. Numer PESEL ³⁾</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">14. Numer REGON</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                    <!-- Dzial C -->
                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                        <fo:table-column column-width="1cm"/>
                        <fo:table-column column-width="5cm"/>
                        <fo:table-column column-width="7cm"/>
                        <fo:table-column column-width="6cm"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey naglowek" number-columns-spanned="4">
                                    <fo:block>C. DANE ZOBOWIĄZANEGO, U KTÓREGO POWSTAŁ OBOWIĄZEK ²⁾</fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey" number-rows-spanned="2">
                                    <fo:block font-size="8pt">C1.</fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">1. Imię ³⁾</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">2. Nazwisko/Nazwa</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">3. NIP</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">4. Numer PESEL ³⁾</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">5. Numer REGON</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                    <!-- Dzial D -->
                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                        <fo:table-column column-width="1cm"/>
                        <fo:table-column column-width="6cm"/>
                        <fo:table-column column-width="6cm"/>
                        <fo:table-column column-width="6cm"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey naglowek" number-columns-spanned="4">
                                    <fo:block>D. DANE DOTYCZĄCE NALEŻNOŚCI PIENIĘŻNYCH</fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey" number-rows-spanned="10">
                                    <fo:block/>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="3">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">1. Akt normatywny</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-D/Akt-normatywny"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="3">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">2. Rodzaj należności pieniężnej</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-D/Rodzaj-naleznosci-pienieznej"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="podstawaPrawnaObowiazkuField">
                                        <xsl:with-param name="title">3. Podstawa prawna obowiązku ¹⁾</xsl:with-param>
                                        <xsl:with-param name="checked" select="ns2:Dzial-D/Podstawa-prawna"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">4. Identyfikacja podstawy prawnej obowiązku</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-D/Identyfikacja-podstawy-prawnej"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">5. Data wydania orzeczenia</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-D/Data-wydania-orzeczenia"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="3">
                                    <xsl:call-template name="informacjeDotyczaceNaleznosciPienieznejField">
                                        <xsl:with-param name="title">6. Informacje dotyczące należności pieniężnej ¹⁾, ³⁾</xsl:with-param>
                                        <xsl:with-param name="checked" select="ns2:Dzial-D/Informacje-dot-naleznosci-pienieznej"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2" number-rows-spanned="2">
                                    <xsl:call-template name="rodzajOdsetekField">
                                        <xsl:with-param name="title">7. Rodzaj odsetek ¹⁾</xsl:with-param>
                                        <xsl:with-param name="checked" select="ns2:Dzial-D/Rodzaj-odsetek"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">8. Stawka odsetek</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-D/Stawka-odsetek"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">8.1. Podwyższona stawka odsetek za zwłokę</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">9. Rodzaj zabezpieczenia należności pieniężnej</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-D/Zabezpieczenie-naleznosci-pienieznej"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">10. Data powstania zabezpieczenia</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-D/Data-powstania-zabezpieczenia"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">11. Podstawa prawna braku obowiązku doręczenia upomnienia/ data doręczenia upomnienia/ data doręczenia
                                            powiadomienia</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-D/Podstawa-prawna-braku-obowiazku-doreczenia"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">12. Wysokość kosztów upomnienia </xsl:with-param>
                                        <xsl:with-param name="value" select="format-number(number(ns2:Dzial-D/Kwota-kosztow-upomnienia), '# ##0,00', 'KWOTA_FORMAT')"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey" number-columns-spanned="3">
                                    <fo:block font-size="7pt" font-weight="bold">
                                        <xsl:text>Należności pieniężne są wymagalne i podlegają egzekucji administracyjnej na podstawie art. 2 ustawy oraz na podstawie</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="3">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">13. Inna podstawa prawna ²⁾</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-D/Inna-podstawa-prawna"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                    <!--Dzial D1 - Dn-->
                    <xsl:for-each select="ns2:Dzial-D/Element-D">
                        <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                            <fo:table-column column-width="1cm"/>
                            <fo:table-column column-width="6cm"/>
                            <fo:table-column column-width="1cm"/>
                            <fo:table-column column-width="3cm"/>
                            <fo:table-column column-width="4cm"/>
                            <fo:table-column column-width="4cm"/>
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder grey">
                                        <fo:block font-size="8pt">
                                            <xsl:text>D</xsl:text>
                                            <xsl:value-of select="ID"/>
                                            <xsl:text>.</xsl:text>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="5" xsl:use-attribute-sets="solidBorder grey">
                                        <fo:block/>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell number-rows-spanned="3" xsl:use-attribute-sets="solidBorder grey">
                                        <fo:block/>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="solidBorder">
                                        <xsl:call-template name="field">
                                            <xsl:with-param name="title">1. Wysokość należności pieniężnej</xsl:with-param>
                                            <xsl:with-param name="value" select="format-number(number(Kwota-naleznosci-pienieznej), '# ##0,00', 'KWOTA_FORMAT')"/>
                                        </xsl:call-template>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <xsl:call-template name="field">
                                            <xsl:with-param name="title">2. Data, od której nalicza się odsetki</xsl:with-param>
                                            <xsl:with-param name="value" select="Data-od-ktorej-nalicza-sie-odsetki"/>
                                        </xsl:call-template>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <xsl:call-template name="field">
                                            <xsl:with-param name="title">3. Wysokość odsetek na dzień wystawienia tytułu wykonawczego</xsl:with-param>
                                            <xsl:with-param name="value" select="format-number(number(Kwota-odsetek-na-dzien-wystawienia-tytulu), '# ##0,00', 'KWOTA_FORMAT')"/>
                                        </xsl:call-template>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <xsl:call-template name="field">
                                            <xsl:with-param name="title">4. Data, do której należność pieniężna może być dochodzona</xsl:with-param>
                                            <xsl:with-param name="value" select="Data-do-ktorej-naleznosc-dochodzona"/>
                                        </xsl:call-template>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell xsl:use-attribute-sets="grey solidBorder" number-columns-spanned="3">
                                        <fo:block font-size="7pt" font-weight="bold">
                                            <xsl:text>Data powstania należności pieniężnej/ okres, którego dotyczy należność pieniężna</xsl:text>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2" number-rows-spanned="2">
                                        <xsl:call-template name="field">
                                            <xsl:with-param name="title">7. Podstawa prawna pierwszeństwa zaspokojenia należności pieniężnej</xsl:with-param>
                                            <xsl:with-param name="value" select="Podstawa-prawna-pierwszenstwa-zaspokojenia"/>
                                        </xsl:call-template>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                        <xsl:call-template name="field">
                                            <xsl:with-param name="title">5. data/ od dnia:</xsl:with-param>
                                            <xsl:with-param name="value" select="Data-okres-naleznosci-od-dnia"/>
                                        </xsl:call-template>
                                    </fo:table-cell>
                                    <fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="solidBorder">
                                        <xsl:call-template name="field">
                                            <xsl:with-param name="title">6. do dnia:</xsl:with-param>
                                            <xsl:with-param name="value" select="Data-okres-naleznosci-do-dnia"/>
                                        </xsl:call-template>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>
                    </xsl:for-each>
                    <!-- Dzial E -->
                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                        <fo:table-column column-width="1cm"/>
                        <fo:table-column column-width="10cm"/>
                        <fo:table-column column-width="8cm"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey naglowek" number-columns-spanned="3">
                                    <fo:block>
                                        <xsl:text>E. OZNACZENIE I WNIOSEK WIERZYCIELA</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey" number-rows-spanned="5">
                                    <fo:block/>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">1. Nazwa wierzyciela</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-E/Nazwa-wierzyciela"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">2. Adres siedziby wierzyciela </xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-E/Adres-siedziby-wierzyciela"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">3. NIP wierzyciela </xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-E/NIP-wierzyciela"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">4. Numer REGON wierzyciela</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-E/REGON-wierzyciela"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">5. Nazwa i adres siedziby podmiotu, któremu należy przekazać wyegzekwowaną należność pieniężną</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-E/Nazwa-adres-siedziby-podmiotu"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">6. Numer rachunku bankowego</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-E/Numer-rachunku-bankowego"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey center">
                                    <fo:block font-size="7pt" font-weight="bold">
                                        <xsl:text>Na podstawie art. 26 ustawy wnoszę o wszczęcie egzekucji administracyjnej</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">7. Imię, nazwisko, stanowisko służbowe i podpis osoby upoważnionej do działania w imieniu wierzyciela</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-E/Imie-nazwisko-stanowisko"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                    <!--Dzial F-->
                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                        <fo:table-column column-width="1cm"/>
                        <fo:table-column column-width="11cm"/>
                        <fo:table-column column-width="7cm"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey naglowek" number-columns-spanned="3">
                                    <fo:block>
                                        <xsl:text>F. OZNACZENIE ORGANU LUB ORGANÓW, O KTÓRYCH MOWA W ART. 17 UST. 1 PKT 1 lIT. D uSTAWy Z DNIA 10 CZERWCA 2016 R.
                                            O DELEGOWANIU PRACOWNIKÓW W RAMACH ŚWIADCZENIA USŁUG (Dz. U. z 2018 r. poz. 2206, z późn. zm.) ²⁾</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey" number-rows-spanned="3">
                                    <fo:block font-size="8pt">
                                        <xsl:text>F1.</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey" number-columns-spanned="2">
                                    <fo:block font-size="7pt">
                                        <xsl:text>Oznaczenie organu odpowiedzialnego za rozpatrzenie administracyjnej kary pieniężnej lub grzywny administracyjnej ²⁾</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">1. Nazwa organu</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-F/Nazwa-organu-rozpatrzenie"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">2. Adres organu</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-F/Adres-organu-rozpatrzenie"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">3. Inne dane kontaktowe</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-F/Dane-kontaktowe-organu-rozpatrzenie"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey" number-rows-spanned="3">
                                    <fo:block font-size="8pt">
                                        <xsl:text>F2.</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey" number-columns-spanned="2">
                                    <fo:block font-size="7pt">
                                        <xsl:text>Oznaczenie organu, który może udzielić dodatkowych informacji dotyczących administracyjnej kary pieniężnej lub grzywny administracyjnej lub możliwości odwołania się od obowiązku zapłaty lub zaskarżenia decyzji w sprawie ich nałożenia ²⁾</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">1. Nazwa organu</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-F/Nazwa-organu-informowanie"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">2. Adres organu</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-F/Adres-organu-informowanie"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder" number-columns-spanned="2">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">3. Inne dane kontaktowe</xsl:with-param>
                                        <xsl:with-param name="value" select="ns2:Dzial-F/Dane-kontaktowe-organu-informowanie"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                    <!-- Dzial G -->
                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                        <fo:table-column column-width="1cm"/>
                        <fo:table-column column-width="18cm"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey naglowek" number-columns-spanned="2">
                                    <fo:block>
                                        <xsl:text>G. WYSOKOŚĆ KOSZTÓW EGZEKUCYJNYCH ²⁾</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey">
                                    <fo:block/>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder">
                                    <xsl:call-template name="field">
                                        <xsl:with-param name="title">Wysokość kosztów egzekucyjnych</xsl:with-param>
                                        <xsl:with-param name="value" select="format-number(number(ns2:Dzial-G/Kwota-kosztow-egzekucyjnych), '# ##0,00', 'KWOTA_FORMAT')"/>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>

                    <!--Dzial H-->
                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                        <fo:table-column column-width="1cm"/>
                        <fo:table-column column-width="10cm"/>
                        <fo:table-column column-width="8cm"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey naglowek" number-columns-spanned="3">
                                    <fo:block>
                                        <xsl:text>H. OZNACZENIE I KLAUZULA ORGANU EGZEKUCYJNEGO</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey" number-rows-spanned="4">
                                    <fo:block/>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey center" number-columns-spanned="2">
                                    <fo:block font-size="7pt" font-weight="bold">W przypadku sporządzenia tytułu wykonawczego w postaci elektronicznej wydruk tego tytułu stanowi dowód tego, co zostało w nim stwierdzone. </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey center">
                                    <fo:block font-size="8pt" font-weight="bold">
                                        <xsl:text>Na podstawie art. 27 § 1 pkt 10 ustawy kieruję tytuł wykonawczy do egzekucji administracyjnej </xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                                <fo:table-cell number-rows-spanned="2" xsl:use-attribute-sets="solidBorder grey">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">2. Imię, nazwisko, stanowisko służbowe i podpis osoby upoważnionej do
                                            działania w imieniu organu egzekucyjnego</xsl:with-param>
                                    </xsl:call-template>
                                    <fo:block padding="15px"/>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell number-rows-spanned="2" xsl:use-attribute-sets="solidBorder grey">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">1. Nazwa i adres siedziby organu egzekucyjnego</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">3. Data nadania klauzuli</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                    <!-- Dzial I -->
                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                        <fo:table-column column-width="1cm"/>
                        <fo:table-column column-width="4cm"/>
                        <fo:table-column column-width="8cm"/>
                        <fo:table-column column-width="6cm"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey naglowek" number-columns-spanned="4">
                                    <fo:block>
                                        <xsl:text>I. POTWIERDZENIE ODBIORU TYTUŁU WYKONAWCZEGO</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey">
                                    <fo:block/>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">1. Data doręczenia odpisu/ wydruku tytułu wykonawczego</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">2. Czytelny podpis otrzymującego odpis/ wydruk tytułu wykonawczego</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder grey">
                                    <xsl:call-template name="emptyField">
                                        <xsl:with-param name="title">3. Podpis doręczającego odpis/ wydruk tytułu wykonawczego</xsl:with-param>
                                    </xsl:call-template>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                    <!--pouczenie-->
                    <fo:table table-layout="fixed" width="100%" border-collapse="separate">
                        <fo:table-column column-width="19cm"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder center noBottomBorder" padding="0.2cm">
                                    <fo:block>
                                        <xsl:text>POUCZENIE</xsl:text>
                                    </fo:block>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell xsl:use-attribute-sets="solidBorder noTopBorder pouczenie">
                                    <fo:block>
                                        <xsl:text>Środkami egzekucyjnymi stosowanymi w egzekucji należności pieniężnych są egzekucje: z pieniędzy, z wynagrodzenia za pracę, ze świadczeń z zaopatrzenia
                                        emerytalnego oraz z ubezpieczenia społecznego, a także z renty socjalnej, z rachunków bankowych, z innych wierzytelności pieniężnych, z praw z instrumentów
                                        finansowych w rozumieniu przepisów o obrocie instrumentami finansowymi, zapisanych na rachunku papierów wartościowych lub innym rachunku oraz
                                        wierzytelności z rachunku pieniężnego służącego do obsługi takich rachunków, z papierów wartościowych niezapisanych na rachunku papierów
                                        wartościowych, z weksla, z autorskich praw majątkowych i praw pokrewnych oraz z praw własności przemysłowej, z udziału w spółce z ograniczoną
                                        odpowiedzialnością, z pozostałych praw majątkowych, z ruchomości oraz z nieruchomości.
                                        </xsl:text>
                                    </fo:block>
                                    <fo:block>
                                        <xsl:text>
                                            Zobowiązanemu przysługuje prawo wniesienia do wierzyciela, za pośrednictwem organu egzekucyjnego, zarzutu w sprawie egzekucji administracyjnej.
                                            Zarzut w sprawie egzekucji administracyjnej winien określać istotę i zakres żądania oraz dowody uzasadniające to żądanie (art. 33 § 1, 2 i 4 ustawy).
                                            Wniesienie przez zobowiązanego zarzutu w sprawie egzekucji administracyjnej, nie później niż w terminie 7 dni od dnia doręczenia odpisu/ wydruku
                                            tytułu wykonawczego, zawiesza postępowanie egzekucyjne w całości albo w części z dniem doręczenia tego zarzutu organowi egzekucyjnemu do czasu
                                            zawiadomienia tego organu o wydaniu ostatecznego postanowienia w sprawie tego zarzutu (art. 35 § 1 ustawy). Wniesienie zarzutu w sprawie egzekucji
                                            administracyjnej po terminie 7 dni od dnia doręczenia odpisu/ wydruku tytułu wykonawczego nie zawiesza postępowania egzekucyjnego. Wierzyciel
                                            po otrzymaniu zarzutu w sprawie egzekucji administracyjnej może w uzasadnionych przypadkach wystąpić z wnioskiem o podjęcie zawieszonego
                                            postępowania egzekucyjnego w całości albo w części (art. 35 § 1a ustawy).
                                        </xsl:text>
                                    </fo:block>
                                    <fo:block>
                                        <xsl:text>W przypadku zmienionego tytułu wykonawczego nie przysługuje prawo zgłoszenia zarzutu w sprawie egzekucji administracyjnej</xsl:text>
                                    </fo:block>
                                    <fo:block>
                                        <xsl:text>Zarzut w sprawie egzekucji administracyjnej wnosi się nie później niż::</xsl:text>
                                    </fo:block>
                                    <fo:block>
                                        <fo:list-block>
                                            <fo:list-item>
                                                <fo:list-item-label end-indent="label-end()"><fo:block><fo:inline>1)</fo:inline></fo:block></fo:list-item-label>
                                                <fo:list-item-body start-indent="body-start()"><fo:block>) w terminie 30 dni od dnia wyegzekwowania w całości obowiązku, kosztów upomnienia i kosztów egzekucyjnych;</fo:block></fo:list-item-body>
                                            </fo:list-item>
                                            <fo:list-item>
                                                <fo:list-item-label end-indent="label-end()"><fo:block>2)</fo:block></fo:list-item-label>
                                                <fo:list-item-body start-indent="body-start()"><fo:block> do dnia zapłaty w całości należności pieniężnej, odsetek z tytułu niezapłacenia jej w terminie, kosztów upomnienia i kosztów egzekucyjnych;</fo:block></fo:list-item-body>
                                            </fo:list-item>
                                            <fo:list-item>
                                                <fo:list-item-label end-indent="label-end()"><fo:block><fo:inline>3)</fo:inline></fo:block></fo:list-item-label>
                                                <fo:list-item-body start-indent="body-start()"><fo:block>w terminie 7 dni od dnia doręczenia zobowiązanemu postanowienia o umorzeniu postępowania egzekucyjnego w całości albo w części.</fo:block></fo:list-item-body>
                                            </fo:list-item>
                                        </fo:list-block>
                                    </fo:block>
                                    <fo:block>
                                        <xsl:text>Zobowiązany ma obowiązek niezwłocznie zawiadomić organ egzekucyjny o zmianie adresu miejsca zamieszkania lub siedziby. W razie niewykonania
                                                    tego obowiązku doręczenie pisma organu egzekucyjnego pod dotychczasowym adresem jest skuteczne (art. 36 § 3 pkt 2 i § 4 ustawy). Na zobowiązanego,
                                                    który nie zawiadomił organu egzekucyjnego o zmianie adresu miejsca zamieszkania lub siedziby, może być nałożona kara pieniężna (art. 168d § 3 pkt 1
                                                    lit. a tiret pierwsze ustawy).
                                                    Jeżeli w części A wpisano jako zobowiązanych dane małżonków, tytuł wykonawczy stanowi podstawę przeprowadzenia egzekucji administracyjnej z ich
                                                    majątku wspólnego i ich majątków osobistych.
                                        </xsl:text>
                                    </fo:block>
                                    <fo:block><xsl:text>Tytuł wykonawczy stanowi podstawę do prowadzenia egzekucji z majątku osobistego zobowiązanego i majątku wspólnego zobowiązanego i jego
małżonka, jeżeli zgodnie z odrębnymi przepisami odpowiedzialność zobowiązanego za należność pieniężną i odsetki z tytułu niezapłacenia jej w terminie
obejmuje majątek osobisty zobowiązanego i majątek wspólny zobowiązanego i jego małżonka. W takim przypadku tytuł wykonawczy jest podstawą do
prowadzenia egzekucji również kosztów upomnienia oraz kosztów egzekucyjnych powstałych w postępowaniu egzekucyjnym prowadzonym na podstawie
tego tytułu wykonawczego (art. 27e § 1 i 2 ustawy).</xsl:text></fo:block>
                                    <fo:block><xsl:text>Małżonkowi zobowiązanego przysługuje prawo wniesienia wniosku do organu egzekucyjnego o udzielenie informacji o aktualnej wysokości egzekwowanej
należności pieniężnej, odsetek z tytułu niezapłacenia jej w terminie, kosztów upomnienia i kosztów egzekucyjnych (art. 27e § 4 ustawy), a także
wniesienia do wierzyciela, za pośrednictwem organu egzekucyjnego, sprzeciwu w sprawie odpowiedzialności majątkiem wspólnym. W sprzeciwie określa
się istotę i zakres żądania oraz dowody uzasadniające to żądanie. W przypadku egzekucji z nieruchomości wchodzącej w skład majątku wspólnego
zobowiązanego i jego małżonka sprzeciw wnosi się nie później niż w terminie 14 dni od dnia doręczenia małżonkowi zobowiązanego wezwania do zapłaty
egzekwowanej należności pieniężnej wraz z odsetkami z tytułu niezapłacenia jej w terminie i kosztami egzekucyjnymi (art. 27f § 2 ustawy).</xsl:text></fo:block>

                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <xsl:template name="field">
        <xsl:param name="title"/>
        <xsl:param name="value"/>
        <fo:block xsl:use-attribute-sets="tytulKomorki">
            <xsl:value-of select="$title"/>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki" padding="0.1cm">
            <xsl:value-of select="$value"/>
        </fo:block>
    </xsl:template>

    <xsl:template name="emptyField">
        <xsl:param name="title"/>
        <fo:block xsl:use-attribute-sets="tytulKomorki">
            <xsl:value-of select="$title"/>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki" padding="0.1cm"> </fo:block>
    </xsl:template>

    <xsl:template name="rodzajDokumentuField">
        <xsl:param name="title"/>
        <xsl:param name="checked" select="0"/>
        <fo:block xsl:use-attribute-sets="tytulKomorki">
            <xsl:value-of select="$title"/>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'a. tytuł wykonawczy'"/>
            </xsl:call-template>
            <xsl:text>1. tytuł wykonawczy</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'b. zmieniony tytuł wykonawczy'"/>
            </xsl:call-template>
            <xsl:text>2. zmieniony tytuł wykonawczy</xsl:text>
        </fo:block>
    </xsl:template>

    <xsl:template name="celWydaniaDalszegoTytuluField">
        <xsl:param name="title"/>
        <xsl:param name="checked" select="0"/>
        <fo:block xsl:use-attribute-sets="tytulKomorki">
            <xsl:value-of select="$title"/>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'a. prowadzenie egzekucji przez inny organ egzekucyjny'"/>
            </xsl:call-template>
            <xsl:text>1. prowadzenie egzekucji przez inny organ egzekucyjny</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'b. zabezpieczenie hipoteką przymusową, w tym hipoteką przymusową morską'"/>
            </xsl:call-template>
            <xsl:text>2. zabezpieczenie hipoteką przymusową, w tym hipoteką przymusową morską</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'c. ponowne wszczęcie egzekucji administracyjnej'"/>
            </xsl:call-template>
            <xsl:text>3. ponowne wszczęcie egzekucji administracyjnej</xsl:text>
        </fo:block>
    </xsl:template>

    <xsl:template name="rodzajZobowiazanegoField">
        <xsl:param name="title"/>
        <xsl:param name="checked" select="0"/>
        <fo:block xsl:use-attribute-sets="tytulKomorki">
            <xsl:value-of select="$title"/>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'a. osoba fizyczna'"/>
            </xsl:call-template>
            <xsl:text>1. osoba fizyczna</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'b. podmiot niebędący osobą fizyczną'"/>
            </xsl:call-template>
            <xsl:text>2. podmiot niebędący osobą fizyczną</xsl:text>
        </fo:block>
    </xsl:template>

    <xsl:template name="rodzajOdpowiedzialnosciZobowiazanegoField">
        <xsl:param name="title"/>
        <xsl:param name="checked" select="0"/>
        <fo:block xsl:use-attribute-sets="tytulKomorki">
            <xsl:value-of select="$title"/>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'a. podmiot, u którego powstał obowiązek'"/>
            </xsl:call-template>
            <xsl:text>1. podmiot, u którego powstał obowiązek</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'b. następca prawny'"/>
            </xsl:call-template>
            <xsl:text>2. następca prawny</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'c. osoba trzecia'"/>
            </xsl:call-template>
            <xsl:text>3. osoba trzecia</xsl:text>
        </fo:block>
    </xsl:template>

    <xsl:template name="podstawaPrawnaObowiazkuField">
        <xsl:param name="title"/>
        <xsl:param name="checked" select="0"/>
        <fo:block xsl:use-attribute-sets="tytulKomorki">
            <xsl:value-of select="$title"/>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'a. z mocy prawa'"/>
            </xsl:call-template>
            <xsl:text>1. z mocy prawa</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'b. dokument, o którym mowa w art. 3a § 1 ustawy'"/>
            </xsl:call-template>
            <xsl:text>2. dokument, o którym mowa w art. 3a § 1 ustawy</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'c. orzeczenie'"/>
            </xsl:call-template>
            <xsl:text>3. orzeczenie</xsl:text>
        </fo:block>
    </xsl:template>

    <xsl:template name="informacjeDotyczaceNaleznosciPienieznejField">
        <xsl:param name="title"/>
        <xsl:param name="checked" select="0"/>
        <fo:block xsl:use-attribute-sets="tytulKomorki">
            <xsl:value-of select="$title"/>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'a. odpowiedzialność za należność pieniężną i odsetki z tytułu niezapłacenia jej w terminie obejmuje również majątek wspólny zobowiązanego i jego małżonka'"/>
            </xsl:call-template>
            <xsl:text>1. odpowiedzialność za należność pieniężną i odsetki z tytułu niezapłacenia jej w terminie obejmuje również majątek wspólny z obowiązanego i jego małżonka</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'b. obowiązek jest ściśle związany ze zobowiązanym'"/>
            </xsl:call-template>
            <xsl:text>2. obowiązek jest ściśle związany ze zobowiązanym</xsl:text>
        </fo:block>
    </xsl:template>

    <xsl:template name="rodzajOdsetekField">
        <xsl:param name="title"/>
        <xsl:param name="checked" select="0"/>
        <fo:block xsl:use-attribute-sets="tytulKomorki">
            <xsl:value-of select="$title"/>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'a. za zwłokę'"/>
            </xsl:call-template>
            <xsl:text>1. za zwłokę</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'b. za zwłokę od należności celnych'"/>
            </xsl:call-template>
            <xsl:text>2. za zwłokę od należności celnych</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'c. ustawowe'"/>
            </xsl:call-template>
            <xsl:text>3. ustawowe</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'd. ustawowe za opóźnienie'"/>
            </xsl:call-template>
            <xsl:text>4. ustawowe za opóźnienie</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'e. ustawowe za opóźnienie w transakcjach handlowych'"/>
            </xsl:call-template>
            <xsl:text>5. ustawowe za opóźnienie w transakcjach handlowych</xsl:text>
        </fo:block>
        <fo:block xsl:use-attribute-sets="wartoscKomorki">
            <xsl:call-template name="checkbox">
                <xsl:with-param name="checkedTest" select="$checked = 'f. nie pobiera się'"/>
            </xsl:call-template>
            <xsl:text>6. nie pobiera się</xsl:text>
        </fo:block>
    </xsl:template>

    <xsl:template name="checkbox">
        <xsl:param name="checkedTest"/>
        <xsl:choose>
            <xsl:when test="$checkedTest">
                &#160;<fo:inline border-style="solid" border-width="1pt">x&#160;</fo:inline>&#160;
                <!--[x]-->
            </xsl:when>
            <xsl:otherwise>
                &#160;<fo:inline border-style="solid" border-width="1pt">&#160;&#160;&#160;</fo:inline>&#160;
                <!--[ ]-->
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>