/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.database.util;

import java.sql.Connection;
import org.apache.commons.dbcp.BasicDataSource;

public class ConnectionUtils {
    private String ip;
    private String path;
    private String user;
    private String password;
    private Connection con;
    private BasicDataSource ds;

    public ConnectionUtils(String ip, String path, String user, String password) throws Exception {
        try {
            if (ip == null || ip.length() == 0) {
                ip = "localhost";
            } else {
                this.ip = ip;
            }
            String connectionUrl = "jdbc:firebirdsql:" + ip + "/3050:" + path;
            this.path = path;
            this.user = user;
            this.password = password;
            this.ds = new BasicDataSource();
            this.ds.setDriverClassName("org.firebirdsql.jdbc.FBDriver");
            this.ds.setUsername(user);
            this.ds.setPassword(password);
            this.ds.setUrl(connectionUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Connection getConnection() throws Exception {
        return this.ds.getConnection();
    }

    public void clear() {
        try {
            if (this.con != null) {
                this.con.close();
            }
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

