/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.database.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import pl.topteam.database.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseUtils {
    private static final Logger log = Logger.getLogger(DatabaseUtils.class);

    public static List<String> getTableNames(Connection con) {
        ArrayList<String> tableNames = new ArrayList<String>();
        DatabaseMetaData dmd = null;
        ResultSet set = null;
        try {
            try {
                dmd = con.getMetaData();
                set = dmd.getTables(null, "%", "%", new String[]{"TABLE"});
                String nazwaTabeli = null;
                while (set.next()) {
                    nazwaTabeli = set.getString("TABLE_NAME");
                    tableNames.add(nazwaTabeli.trim());
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    if (set != null) {
                        set.close();
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (set != null) {
                    set.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return tableNames;
    }

    public static List<String> getForeignKeys(Connection con, String tableName) {
        ArrayList<String> columnNames = new ArrayList<String>();
        DatabaseMetaData dmd = null;
        ResultSet set = null;
        try {
            try {
                dmd = con.getMetaData();
                set = dmd.getCrossReference(null, "%", "%", null, "%", tableName);
                String nazwaKolumny = null;
                while (set.next()) {
                    nazwaKolumny = set.getString("FKCOLUMN_NAME");
                    columnNames.add(nazwaKolumny.trim());
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    if (set != null) {
                        set.close();
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (set != null) {
                    set.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return columnNames;
    }

    public static List<String> getConnectedForeignTablesName(Connection con, String tableName) {
        TreeSet<String> tableNames;
        block17: {
            tableNames = new TreeSet<String>();
            DatabaseMetaData dmd = null;
            ResultSet set = null;
            try {
                try {
                    dmd = con.getMetaData();
                    set = dmd.getCrossReference(null, "%", "%", null, "%", tableName);
                    String nazwaTabeli = null;
                    while (set.next()) {
                        nazwaTabeli = set.getString("PKTABLE_NAME");
                        tableNames.add(nazwaTabeli.trim());
                    }
                    set = dmd.getCrossReference(null, "%", tableName, null, "%", null);
                    while (set.next()) {
                        nazwaTabeli = set.getString("FKTABLE_NAME");
                        tableNames.add(nazwaTabeli.trim());
                    }
                    if (tableNames.contains(tableName)) {
                        tableNames.remove(tableName);
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    try {
                        if (set != null) {
                            set.close();
                        }
                        break block17;
                    }
                    catch (SQLException e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (set != null) {
                        set.close();
                    }
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (set != null) {
                    set.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<String>(tableNames);
    }

    public static List<String> getConnectedForeignTablesNameUsingKey(Connection con, String tableName, String keyName) {
        TreeSet<String> tableNames;
        block16: {
            tableNames = new TreeSet<String>();
            DatabaseMetaData dmd = null;
            ResultSet set = null;
            try {
                try {
                    dmd = con.getMetaData();
                    set = dmd.getCrossReference(null, "%", "%", null, "%", tableName);
                    String nazwaTabeli = null;
                    String nazwaKolumny = null;
                    while (set.next()) {
                        nazwaTabeli = set.getString("PKTABLE_NAME");
                        nazwaKolumny = set.getString("FKCOLUMN_NAME");
                        if (!org.apache.commons.lang.StringUtils.equalsIgnoreCase((String)keyName, (String)nazwaKolumny)) continue;
                        tableNames.add(nazwaTabeli.trim());
                    }
                    set = dmd.getCrossReference(null, "%", tableName, null, "%", "%");
                    while (set.next()) {
                        nazwaTabeli = set.getString("FKTABLE_NAME");
                        nazwaKolumny = set.getString("PKCOLUMN_NAME");
                        if (!org.apache.commons.lang.StringUtils.equalsIgnoreCase((String)keyName, (String)nazwaKolumny)) continue;
                        tableNames.add(nazwaTabeli.trim());
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    try {
                        if (set != null) {
                            set.close();
                        }
                        break block16;
                    }
                    catch (SQLException e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (set != null) {
                        set.close();
                    }
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (set != null) {
                    set.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<String>(tableNames);
    }

    public static List<String> getPrimaryKeys(Connection con, String tableName) {
        ArrayList<String> columnNames = new ArrayList<String>();
        DatabaseMetaData dmd = null;
        ResultSet set = null;
        try {
            try {
                dmd = con.getMetaData();
                set = dmd.getPrimaryKeys(null, null, tableName);
                String nazwaKolumny = null;
                while (set.next()) {
                    nazwaKolumny = set.getString("COLUMN_NAME");
                    columnNames.add(nazwaKolumny.trim());
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    if (set != null) {
                        set.close();
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (set != null) {
                    set.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return columnNames;
    }

    public static Boolean isHierarchicallyConnected(Connection con, String tableName) {
        DatabaseMetaData dmd = null;
        ResultSet set = null;
        try {
            dmd = con.getMetaData();
            set = dmd.getCrossReference(null, "%", tableName, null, "%", tableName);
            Boolean bl = set.next();
            return bl;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        finally {
            try {
                if (set != null) {
                    set.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Map<String, String> getColumNames(String tableName, Connection con) {
        HashMap<String, String> columnTypes = new HashMap<String, String>();
        DatabaseMetaData dmd = null;
        ResultSet set = null;
        try {
            try {
                dmd = con.getMetaData();
                set = dmd.getColumns(null, "%", tableName, "%");
                String columnName = null;
                String columnType = null;
                while (set.next()) {
                    columnName = set.getString("COLUMN_NAME");
                    columnType = set.getString("TYPE_NAME");
                    columnTypes.put(columnName.toUpperCase(), columnType.toUpperCase());
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                System.exit(0);
                try {
                    if (set != null) {
                        set.close();
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (set != null) {
                    set.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return columnTypes;
    }

    public static List<String> getGeneratorList(Connection con) {
        ArrayList<String> list = new ArrayList<String>();
        String query = "select * from rdb$generators where rdb$system_flag is null";
        Statement st = null;
        ResultSet set = null;
        try {
            try {
                st = con.createStatement();
                set = st.executeQuery(query);
                String tableName = null;
                while (set.next()) {
                    tableName = set.getString("rdb$generator_name");
                    list.add(tableName);
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    if (set != null) {
                        set.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (set != null) {
                    set.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public static Map<String, Integer> getGeneratorValues(Connection con, List<String> genNames) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String getGenVal = null;
        Iterator<String> it = genNames.iterator();
        Statement st = null;
        ResultSet set = null;
        try {
            try {
                int genValue = 0;
                String genName = null;
                while (it.hasNext()) {
                    getGenVal = "select gen_id(";
                    genName = it.next();
                    getGenVal = String.valueOf(getGenVal) + genName + ",0) from rdb$database";
                    st = con.createStatement();
                    set = st.executeQuery(getGenVal);
                    while (set.next()) {
                        genValue = set.getInt(1);
                        map.put(genName, new Integer(genValue));
                    }
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    if (set != null) {
                        set.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (set != null) {
                    set.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }

    public static void setGeneratorValues(Connection con, Map<String, Integer> genMap, List<String> genNames) {
        Iterator<String> it = genNames.iterator();
        String genName = null;
        int value = 0;
        String setGenVal = null;
        Statement st = null;
        try {
            try {
                st = con.createStatement();
                while (it.hasNext()) {
                    setGenVal = "set generator";
                    genName = it.next();
                    value = genMap.get(genName);
                    setGenVal = String.valueOf(setGenVal) + " " + genName + " to " + value;
                    st.executeUpdate(setGenVal);
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void clearDatabase(Connection con, List<String> tableList) {
        Iterator<String> it = tableList.iterator();
        Statement st = null;
        try {
            try {
                st = con.createStatement();
                String query = null;
                while (it.hasNext()) {
                    query = "delete from " + it.next();
                    st.executeUpdate(query);
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static boolean equalRowCount(Connection con1, Connection con2, String tableName, JTextArea txtArea, boolean gui) {
        boolean isOk;
        block27: {
            isOk = true;
            if (tableName.equalsIgnoreCase("slowo") || tableName.equalsIgnoreCase("slownik")) {
                return isOk;
            }
            Statement st1 = null;
            Statement st2 = null;
            ResultSet set1 = null;
            ResultSet set2 = null;
            int liczba1 = 0;
            int liczba2 = 0;
            String sql = "select count(*) as liczba from " + tableName;
            try {
                try {
                    st1 = con1.createStatement();
                    st2 = con2.createStatement();
                    set1 = st1.executeQuery(sql);
                    set2 = st2.executeQuery(sql);
                    while (set1.next()) {
                        liczba1 = set1.getInt("liczba");
                    }
                    while (set2.next()) {
                        liczba2 = set2.getInt("liczba");
                    }
                    if (liczba1 != liczba2) {
                        if (gui) {
                            txtArea.append("rekordy z tabeli " + tableName + " nie zost" + "\u0142" + "y poprawnie przeniesione\n");
                        } else {
                            System.out.println("rekordy z tabeli " + tableName + " nie zost" + "\u0142" + "y poprawnie przeniesione\n");
                        }
                        log.info((Object)("liczba rekord\u00f3w wyeksportowanych i zaimportowanych dla tabeli " + tableName + " nie jest r" + "\u00f3" + "wna."));
                        isOk = false;
                        break block27;
                    }
                    if (gui) {
                        txtArea.append("rekordy z tabeli " + tableName + " zost" + "\u0142" + "y poprawnie przeniesione");
                    } else {
                        System.out.println("rekordy z tabeli " + tableName + " zost" + "\u0142" + "y poprawnie przeniesione");
                    }
                    log.info((Object)("liczba rekord\u00f3w wyeksportowanych i zaimportowanych dla tabeli " + tableName + " jest r" + "\u00f3" + "wna."));
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    try {
                        if (set1 != null) {
                            set1.close();
                        }
                        if (set2 != null) {
                            set2.close();
                        }
                        if (st1 != null) {
                            st1.close();
                        }
                        if (st2 != null) {
                            st2.close();
                        }
                    }
                    catch (SQLException e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            finally {
                try {
                    if (set1 != null) {
                        set1.close();
                    }
                    if (set2 != null) {
                        set2.close();
                    }
                    if (st1 != null) {
                        st1.close();
                    }
                    if (st2 != null) {
                        st2.close();
                    }
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return isOk;
    }

    public static String executeScript(String scriptFile, Connection con) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(scriptFile));
        String line = null;
        Statement st = con.createStatement();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            st.addBatch(line);
        }
        int[] s = st.executeBatch();
        log.info((Object)("wstawiono " + s.length + " rekord" + "\u00f3" + "w ze skryptu w pliku " + scriptFile));
        return "wstawiono " + s.length + " rekord" + "\u00f3" + "w ze skryptu w pliku " + scriptFile;
    }

    public static String executeScript(List<String> sqlCmd, Connection con) throws Exception {
        String sql = null;
        Statement st = con.createStatement();
        int i = 0;
        while (i < sqlCmd.size()) {
            sql = sqlCmd.get(i);
            st.addBatch(sql);
            ++i;
        }
        int[] s = st.executeBatch();
        con.commit();
        return "wstawiono " + s.length + " rekord" + "\u00f3" + "w ze skryptu w liscie";
    }

    public static void executeInsert(List<String> nrSlownika, List<String> insertList, Connection con) throws Exception {
        Statement st = null;
        String line = null;
        st = con.createStatement();
        Iterator<String> it = insertList.iterator();
        int i = 0;
        while (it.hasNext()) {
            line = it.next();
            if (line != null && line.length() > 0) {
                try {
                    st.execute(StringUtils.decodeWN1250(line));
                }
                catch (Exception e) {
                    System.out.println("wywalilo sie na: " + line);
                    log.error((Object)e);
                    e.printStackTrace();
                }
            }
            ++i;
        }
        con.commit();
    }
}

