/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.database.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import pl.topteam.database.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private static final Logger log = Logger.getLogger(FileUtils.class);

    public static int checkModifiedDate(String firstFile, String secondFile) {
        File fileOne = null;
        File fileTwo = null;
        int returnValue = 0;
        try {
            try {
                fileOne = new File(firstFile);
                fileTwo = new File(secondFile);
                long modDateFirst = fileOne.lastModified();
                long modDateSecond = fileTwo.lastModified();
                if (modDateFirst == modDateSecond) {
                    returnValue = 0;
                }
                if (modDateFirst > modDateSecond) {
                    returnValue = 1;
                }
                if (modDateFirst < modDateSecond) {
                    returnValue = -1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e.getMessage(), (Throwable)e);
                fileOne = null;
                fileTwo = null;
            }
        }
        finally {
            fileOne = null;
            fileTwo = null;
        }
        return returnValue;
    }

    public static boolean isReadable(String fileName) {
        boolean isOk = false;
        File file = null;
        try {
            try {
                file = new File(fileName);
                if (file != null && file.canRead()) {
                    isOk = true;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (file != null) {
                    file = null;
                }
            }
        }
        finally {
            if (file != null) {
                file = null;
            }
        }
        return isOk;
    }

    public static boolean isWriteable(String fileName) {
        boolean isOk = false;
        File file = null;
        try {
            try {
                file = new File(fileName);
                if (file != null && file.canWrite()) {
                    isOk = true;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (file != null) {
                    file = null;
                }
            }
        }
        finally {
            if (file != null) {
                file = null;
            }
        }
        return isOk;
    }

    public static boolean isDirectory(String fileName) {
        boolean isOk = false;
        File file = null;
        try {
            try {
                file = new File(fileName);
                if (file.isDirectory()) {
                    isOk = true;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (file != null) {
                    file = null;
                }
            }
        }
        finally {
            if (file != null) {
                file = null;
            }
        }
        return isOk;
    }

    public static boolean isFile(String fileName) {
        boolean isOk = false;
        File file = null;
        try {
            try {
                file = new File(fileName);
                if (file.isFile()) {
                    isOk = true;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                if (file != null) {
                    file = null;
                }
            }
        }
        finally {
            if (file != null) {
                file = null;
            }
        }
        return isOk;
    }

    public static List<String> getTablesOrder(String fileName) {
        ArrayList<String> tableOrder = new ArrayList<String>();
        String line = null;
        String token = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        StringTokenizer st = null;
        try {
            try {
                br = new BufferedReader(new FileReader(fileName));
                while ((line = br.readLine()) != null) {
                    st = new StringTokenizer(line);
                    while (st.hasMoreTokens()) {
                        token = st.nextToken();
                        tableOrder.add(token.trim());
                    }
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (IOException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return tableOrder;
    }

    public static void copy(String path, String path2) throws Exception {
        File fileFrom = new File(path);
        File fileTo = new File(path2);
        path2 = String.valueOf(path2) + Constants.FILE_SEPARATOR + fileTo.getName();
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(fileFrom);
                out = new FileOutputStream(fileTo);
                FileUtils.copy(in, out);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
                throw e;
            }
        }
    }

    public static List<String> getLinesFromFile(String path) {
        ArrayList<String> lines = new ArrayList<String>();
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(path);
            br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return lines;
    }

    public static List<String> createSlownikSqlCmd(List<String> slownikiList, String path) {
        ArrayList<String> sqlList = new ArrayList<String>();
        Iterator<String> it = slownikiList.iterator();
        List<String> tmpList = null;
        String p = null;
        String slownikNr = null;
        while (it.hasNext()) {
            slownikNr = it.next();
            p = String.valueOf(path) + Constants.FILE_SEPARATOR + slownikNr + ".txt";
            tmpList = FileUtils.getLinesFromFile(p);
            sqlList.addAll(tmpList);
        }
        return sqlList;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int c;
        while ((c = in.read()) != -1) {
            out.write(c);
        }
    }

    public static void copy(Reader in, Writer out) throws IOException {
        int c;
        while ((c = in.read()) != -1) {
            out.write(c);
        }
    }
}

