/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.aktywacje2_rs_klient;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.util.Objects;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import pl.topteam.aktywacje2_core.SignedProperties;

public final class LicencjeService {
    public static String URI = "https://ttprogramy.pl/aktywacje2_rs";
    private static boolean post = Objects.equals(System.getProperty("pl.topteam.aktywacje2_rs_klient.LicencjeService.post", "true"), "true");

    private LicencjeService() {
    }

    public static SignedProperties get(String login, String haslo, String numer) throws Exception {
        return LicencjeService.get(URI, login, haslo, numer);
    }

    public static SignedProperties get(String uri, String login, String haslo, String numer) throws Exception {
        SignedProperties signedProperties;
        block14: {
            JerseyClient client = JerseyClientBuilder.createClient();
            WebTarget target = client.target(uri);
            if (Strings.isNullOrEmpty((String)login)) {
                throw new IllegalArgumentException("Brak loginu!");
            }
            if (Strings.isNullOrEmpty((String)haslo)) {
                throw new IllegalArgumentException("Brak has\u0142a!");
            }
            if (Strings.isNullOrEmpty((String)numer)) {
                throw new IllegalArgumentException("Brak numeru!");
            }
            InputStream stream = (InputStream)target.path("klienci").path(login).path("licencje").path(numer).queryParam("haslo", new Object[]{haslo}).request(new String[]{"text/plain"}).get(InputStream.class);
            try {
                SignedProperties properties = new SignedProperties();
                properties.loadFromXML(stream);
                signedProperties = properties;
                if (stream == null) break block14;
            }
            catch (Throwable properties) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            properties.addSuppressed(throwable);
                        }
                    }
                    throw properties;
                }
                catch (WebApplicationException e) {
                    Response response = e.getResponse();
                    Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
                    if (status.equals((Object)Response.Status.NOT_FOUND)) {
                        throw new NotFoundException("Brak licencji o podanym numerze.", response);
                    }
                    if (status.equals((Object)Response.Status.FORBIDDEN)) {
                        throw new ForbiddenException("Dane logowania niezgodne z licencj\u0105.", response);
                    }
                    if (status.equals((Object)Response.Status.PRECONDITION_FAILED)) {
                        throw new ClientErrorException("Licencja jest niewa\u017cna.", response);
                    }
                    throw new InternalServerErrorException("Wyst\u0105pi\u0142 wewn\u0119trzny b\u0142\u0105d serwera.", response);
                }
            }
            stream.close();
        }
        return signedProperties;
    }

    public static void post(String login, String haslo, String numer, String kanal, String wersja) throws Exception {
        if (post) {
            LicencjeService.post(URI, login, haslo, numer, kanal, wersja);
        }
    }

    public static void post(String uri, String login, String haslo, String numer, String kanal, String wersja) throws Exception {
        JerseyClient client = JerseyClientBuilder.createClient();
        WebTarget target = client.target(uri);
        if (Strings.isNullOrEmpty((String)login)) {
            throw new IllegalArgumentException("Brak loginu!");
        }
        if (Strings.isNullOrEmpty((String)haslo)) {
            throw new IllegalArgumentException("Brak has\u0142a!");
        }
        if (Strings.isNullOrEmpty((String)numer)) {
            throw new IllegalArgumentException("Brak numeru!");
        }
        if (Strings.isNullOrEmpty((String)kanal)) {
            throw new IllegalArgumentException("Brak kana\u0142u!");
        }
        if (Strings.isNullOrEmpty((String)wersja)) {
            throw new IllegalArgumentException("Brak wersji!");
        }
        try {
            Form form = new Form();
            form.param("kanal", kanal);
            form.param("wersja", wersja);
            Entity entity = Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
            target.path("klienci").path(login).path("licencje").path(numer).queryParam("haslo", new Object[]{haslo}).request(new String[]{"text/plain"}).post(entity, Void.class);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("Brak licencji o podanym numerze.", e.getResponse());
        }
        catch (InternalServerErrorException e) {
            throw new InternalServerErrorException("Wyst\u0105pi\u0142 wewn\u0119trzny b\u0142\u0105d serwera.", e.getResponse());
        }
    }
}

