/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.aktywacje2_rs_klient;

import com.google.common.base.Strings;
import java.util.Objects;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import pl.topteam.aktywacje2_rs_klient.model.Statystyki;

public final class StatystykiService {
    public static String URI = "https://ttprogramy.pl/aktywacje2_rs";
    private static boolean post = Objects.equals(System.getProperty("pl.topteam.aktywacje2_rs_klient.StatystykiService.post", "true"), "true");

    private StatystykiService() {
    }

    public static void post(String login, String haslo, String numer, Statystyki statystyki) throws Exception {
        if (post) {
            StatystykiService.post(URI, login, haslo, numer, statystyki);
        }
    }

    public static void post(String uri, String login, String haslo, String numer, Statystyki statystyki) throws Exception {
        JerseyClient client = JerseyClientBuilder.createClient();
        WebTarget target = client.target(uri);
        if (Strings.isNullOrEmpty((String)login)) {
            throw new IllegalArgumentException("Brak loginu!");
        }
        if (Strings.isNullOrEmpty((String)haslo)) {
            throw new IllegalArgumentException("Brak has\u0142a!");
        }
        if (Strings.isNullOrEmpty((String)numer)) {
            throw new IllegalArgumentException("Brak numeru!");
        }
        try {
            Form form = new Form();
            form.param("generacja", statystyki.generacja().toString());
            form.param("pracownicy", Integer.toString(statystyki.pracownicy()));
            form.param("wnioski", Integer.toString(statystyki.wnioski()));
            Entity entity = Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
            target.path("klienci").path(login).path("statystyki").path(numer).queryParam("haslo", new Object[]{haslo}).request(new String[]{"text/plain"}).post(entity, Void.class);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("Brak licencji o podanym numerze.", e.getResponse());
        }
        catch (InternalServerErrorException e) {
            throw new InternalServerErrorException("Wyst\u0105pi\u0142 wewn\u0119trzny b\u0142\u0105d serwera.", e.getResponse());
        }
    }
}

