/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.base;

import com.google.common.base.CharMatcher;

public final class ExtraCharMatchers {
    private ExtraCharMatchers() {
    }

    public static CharMatcher asciiDigit() {
        return CharMatcher.inRange((char)'0', (char)'9');
    }

    public static CharMatcher asciiLowerCase() {
        return CharMatcher.inRange((char)'a', (char)'z');
    }

    public static CharMatcher asciiUpperCase() {
        return CharMatcher.inRange((char)'A', (char)'Z');
    }

    public static CharMatcher asciiLetter() {
        return ExtraCharMatchers.asciiLowerCase().or(ExtraCharMatchers.asciiUpperCase());
    }

    public static CharMatcher asciiLetterOrDigit() {
        return ExtraCharMatchers.asciiLetter().or(ExtraCharMatchers.asciiDigit());
    }

    public static CharMatcher hyphen() {
        return Hyphen.INSTANCE;
    }

    public static CharMatcher dash() {
        return Dash.INSTANCE;
    }

    private static final class Hyphen
    extends CharMatcher {
        private static final CharMatcher INSTANCE = new Hyphen();

        private Hyphen() {
        }

        public boolean matches(char c) {
            switch (c) {
                case '-': 
                case '\u00ad': 
                case '\u2010': 
                case '\u2011': {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "ExtraCharMatchers.hypen()";
        }
    }

    private static final class Dash
    extends CharMatcher {
        private static final CharMatcher INSTANCE = new Dash();

        private Dash() {
        }

        public boolean matches(char c) {
            switch (c) {
                case '\u2012': 
                case '\u2013': 
                case '\u2014': 
                case '\u2015': 
                case '\u2053': {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "ExtraCharMatchers.dash()";
        }
    }
}

