/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.calc;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import pl.topteam.common.calc.KalkulatorPodzialuLiczbCalkowitych;

@Immutable
@Beta
public final class KalkulatorPodzialuLiczbDziesietnych {
    private final KalkulatorPodzialuLiczbCalkowitych kalkulator;

    public KalkulatorPodzialuLiczbDziesietnych(List<BigDecimal> proporcje) {
        Preconditions.checkNotNull(proporcje);
        int _skala = proporcje.stream().mapToInt(BigDecimal::scale).max().orElse(0);
        List _proporcje = (List)proporcje.stream().map(proporcja -> proporcja.setScale(_skala)).map(proporcja -> proporcja.unscaledValue()).collect(ImmutableList.toImmutableList());
        this.kalkulator = new KalkulatorPodzialuLiczbCalkowitych(_proporcje);
    }

    public List<BigDecimal> podzial(BigDecimal liczba) {
        Preconditions.checkNotNull((Object)liczba);
        Preconditions.checkArgument((liczba.signum() >= 0 ? 1 : 0) != 0);
        int _skala = liczba.scale();
        BigInteger _liczba = liczba.unscaledValue();
        return (List)this.kalkulator.podzial(_liczba).stream().map(skladnik -> new BigDecimal((BigInteger)skladnik, _skala)).collect(ImmutableList.toImmutableList());
    }
}

