/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.common.calc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.Immutable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Immutable
public final class KalkulatorRat {
    public static final int DOMYSLNA_SKALA = 2;
    public static final RoundingMode DOMYSLNY_TRYB = RoundingMode.HALF_UP;
    private final RoundingMode tryb;
    private final int skala;

    public KalkulatorRat() {
        this.skala = 2;
        this.tryb = DOMYSLNY_TRYB;
    }

    public KalkulatorRat(int skala) {
        this.skala = skala;
        this.tryb = DOMYSLNY_TRYB;
    }

    public KalkulatorRat(RoundingMode tryb) {
        this.skala = 2;
        this.tryb = (RoundingMode)((Object)Preconditions.checkNotNull((Object)((Object)tryb)));
    }

    public KalkulatorRat(int skala, RoundingMode tryb) {
        this.skala = skala;
        this.tryb = (RoundingMode)((Object)Preconditions.checkNotNull((Object)((Object)tryb)));
    }

    public List<BigDecimal> raty(BigDecimal kwota, int liczba) {
        Preconditions.checkArgument((kwota.signum() >= 0 ? 1 : 0) != 0, (String)"Kwota musi by\u0107 nieujemna, przekazano: %s", (Object)kwota);
        Preconditions.checkArgument((liczba > 0 ? 1 : 0) != 0, (String)"Liczba rat musi by\u0107 dodatnia, przekazano: %s", (int)liczba);
        Preconditions.checkArgument((kwota.scale() <= this.skala ? 1 : 0) != 0, (String)"Skala kwoty musi by\u0107 mniejsza lub r\u00f3wna skali kalkulatora, przekazano: %s, %s", (Object)kwota, (int)this.skala);
        List splata = IntStream.rangeClosed(0, liczba).mapToObj(indeks -> this.ulamek(kwota, indeks, liczba)).collect(Collectors.toList());
        return Streams.zip(splata.stream().skip(1L), splata.stream().limit(liczba), BigDecimal::subtract).collect(Collectors.toList());
    }

    private BigDecimal ulamek(BigDecimal kwota, int licznik, int mianownik) {
        return kwota.multiply(BigDecimal.valueOf(licznik)).divide(BigDecimal.valueOf(mianownik), this.skala, this.tryb);
    }
}

